/*
 * Decompiled with CFR 0.152.
 */
package js7.journal.log;

import com.typesafe.scalalogging.Logger;
import fs2.Chunk;
import java.io.Serializable;
import java.util.Locale;
import js7.base.log.CorrelId$;
import js7.base.log.LoggingEscapeCodes$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichDuration$;
import js7.base.utils.Classes$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichString$;
import js7.base.utils.ScalaUtils$syntax$RichStringBuilder$;
import js7.data.event.Event;
import js7.data.event.KeyedEvent;
import js7.data.event.KeyedEvent$NoKey$;
import js7.data.event.Stamped;
import js7.journal.configuration.JournalConf;
import js7.journal.log.JournalLogger$;
import js7.journal.log.JournalLogger$PersistFrame$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqView;
import scala.collection.Iterator;
import scala.collection.View;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;

public final class JournalLogger {
    private final String syncOrFlushString;
    private final boolean suppressTiming;
    private final int syncOrFlushWidth;
    private final String ackSyncOrFlushString;
    private final SubclassCache infoLoggableEventClasses;
    private final StringBuilder sb;
    private boolean suppressed;

    public static JournalLogger apply(JournalConf journalConf) {
        return JournalLogger$.MODULE$.apply(journalConf);
    }

    public static void markChunkForLogging(Chunk<LoggablePersist> chunk) {
        JournalLogger$.MODULE$.markChunkForLogging(chunk);
    }

    public static boolean $lessinit$greater$default$3() {
        return JournalLogger$.MODULE$.$lessinit$greater$default$3();
    }

    public JournalLogger(String syncOrFlushString, Set<String> infoLogEvents, boolean suppressTiming) {
        this.syncOrFlushString = syncOrFlushString;
        this.suppressTiming = suppressTiming;
        this.syncOrFlushWidth = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(6), syncOrFlushString.length());
        this.ackSyncOrFlushString = syncOrFlushString.toUpperCase(Locale.ROOT);
        this.infoLoggableEventClasses = new SubclassCache(infoLogEvents);
        this.sb = new StringBuilder();
        this.suppressed = false;
    }

    public void logCommitted(Seq<Stamped<KeyedEvent<Event>>> stampedSeq, long eventNumber, Deadline since, String clusterState, boolean isTransaction, boolean isAcknowledged) {
        SimpleLoggablePersist[] simpleLoggablePersistArray = new SimpleLoggablePersist[1];
        SimpleLoggablePersist persist = new SimpleLoggablePersist(stampedSeq, eventNumber, since, isTransaction, clusterState);
        persist.isAcknowledged_$eq(isAcknowledged);
        simpleLoggablePersistArray[0] = persist;
        Object object = Predef$.MODULE$.refArrayOps((Object[])simpleLoggablePersistArray);
        this.logCommitted((IndexedSeqView<LoggablePersist>)ArrayOps$.MODULE$.view$extension(object));
    }

    public boolean logCommitted$default$5() {
        return false;
    }

    public boolean logCommitted$default$6() {
        return false;
    }

    public void logCommitted(IndexedSeqView<LoggablePersist> persists) {
        if (!this.suppressed) {
            Logger LoggerImpl_this = JournalLogger$.js7$journal$log$JournalLogger$$$logger;
            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                View loggablePersists;
                Deadline committedAt = Deadline$.MODULE$.now();
                IndexedSeqView<LoggablePersist> myPersists = this.dropEmptyPersists(persists);
                Logger LoggerImpl_this2 = JournalLogger$.js7$journal$log$JournalLogger$$$logger;
                if (LoggerImpl_this2.underlying().isTraceEnabled()) {
                    this.logPersists(myPersists, committedAt, this.logPersists$default$3(), (Function2<PersistFrame, Stamped<KeyedEvent<Event>>, BoxedUnit>)(JProcedure2 & Serializable)(frame, stamped) -> this.traceLogPersist((PersistFrame)frame, (Stamped<KeyedEvent<Event>>)stamped));
                }
                if ((loggablePersists = (View)myPersists.filter((Function1 & Serializable)_$1 -> _$1.stampedSeq().exists((Function1 & Serializable)stamped -> this.isLoggable$3((Stamped)stamped)))).nonEmpty()) {
                    this.logPersists((IndexedSeqView<LoggablePersist>)loggablePersists.toVector().view(), committedAt, (Function1<Stamped<KeyedEvent<Event>>, Object>)(Function1 & Serializable)stamped -> this.isLoggable$3((Stamped)stamped), (Function2<PersistFrame, Stamped<KeyedEvent<Event>>, BoxedUnit>)(JProcedure2 & Serializable)(frame, stamped) -> this.infoLogPersist((PersistFrame)frame, (Stamped<KeyedEvent<Event>>)stamped));
                    return;
                }
                return;
            }
            return;
        }
    }

    public void suppress(boolean supressed) {
        this.suppressed = supressed;
    }

    private IndexedSeqView<LoggablePersist> dropEmptyPersists(IndexedSeqView<LoggablePersist> persists) {
        int dropLeft = persists.segmentLength((Function1 & Serializable)_$2 -> _$2.stampedSeq().isEmpty());
        int dropRight = persists.reverse().segmentLength((Function1 & Serializable)_$3 -> _$3.stampedSeq().isEmpty());
        return persists.slice(dropLeft, persists.length() - dropRight);
    }

    private void logPersists(IndexedSeqView<LoggablePersist> persists, Deadline committedAt, Function1<Stamped<KeyedEvent<Event>>, Object> isLoggable, Function2<PersistFrame, Stamped<KeyedEvent<Event>>, BoxedUnit> body) {
        CorrelId$.MODULE$.isolate((JProcedure1 & Serializable)logCorrelId -> persists.foreach((Function1)(JProcedure1 & Serializable)persist -> {
            Seq stampedSeq = (Seq)persist.stampedSeq().filter(isLoggable);
            PersistFrame frame = JournalLogger$PersistFrame$.MODULE$.apply((LoggablePersist)persist, stampedSeq.length(), committedAt);
            Iterator stampedIterator = stampedSeq.iterator();
            boolean hasNext = stampedIterator.hasNext();
            while (hasNext) {
                Stamped stamped = (Stamped)stampedIterator.next();
                hasNext = stampedIterator.hasNext();
                frame.isLastEvent_$eq(!hasNext);
                body.apply((Object)frame, (Object)stamped);
                frame.nr_$eq(frame.nr() + 1L);
                frame.isFirstEvent_$eq(false);
            }
        }));
    }

    private Function1<Stamped<KeyedEvent<Event>>, Object> logPersists$default$3() {
        return (Function1 & Serializable)_$4 -> true;
    }

    private void traceLogPersist(PersistFrame frame, Stamped<KeyedEvent<Event>> stamped) {
        StringBuilder stringBuilder;
        String eventString;
        Event event;
        this.sb.clear();
        this.sb.append(':');
        this.sb.append(frame.persistMarker());
        ScalaUtils$syntax$RichStringBuilder$.MODULE$.fillRight$extension(ScalaUtils$syntax$.MODULE$.RichStringBuilder(this.sb), this.syncOrFlushWidth, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.traceLogPersist$$anonfun$1(frame);
            return BoxedUnit.UNIT;
        });
        if (frame.isLastEvent()) {
            this.sb.append(' ');
            ScalaUtils$syntax$RichStringBuilder$.MODULE$.fillRight$extension(ScalaUtils$syntax$.MODULE$.RichStringBuilder(this.sb), 6, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.traceLogPersist$$anonfun$2(frame);
                return BoxedUnit.UNIT;
            });
            v0 = BoxedUnit.UNIT;
        } else if (frame.nr() == frame.beforeLastEventNr() && frame.beforeLastEventNr() > frame.persist().eventNumber()) {
            ScalaUtils$syntax$RichStringBuilder$.MODULE$.fillLeft$extension(ScalaUtils$syntax$.MODULE$.RichStringBuilder(this.sb), 7, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.traceLogPersist$$anonfun$3(frame);
                return BoxedUnit.UNIT;
            });
            v0 = BoxedUnit.UNIT;
        } else {
            v0 = this.sb.append("       ");
        }
        this.sb.append(frame.transactionMarker(true));
        this.sb.append(stamped.eventId());
        Object object = stamped.value().key();
        KeyedEvent$NoKey$ keyedEvent$NoKey$ = KeyedEvent$NoKey$.MODULE$;
        if (object == null ? keyedEvent$NoKey$ != null : !object.equals(keyedEvent$NoKey$)) {
            this.sb.append(' ');
            this.sb.append(stamped.value().key());
            this.sb.append(JournalLogger$.js7$journal$log$JournalLogger$$$spaceArrow);
        }
        if ((event = stamped.value().event()).hasShortString()) {
            v2 = event.toShortString();
        } else {
            String string = ScalaUtils$syntax$.MODULE$.RichString(event.toShortString());
            v2 = eventString = ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$extension(string, 200, ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$2$extension(string), true, ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$4$extension(string));
        }
        if (LoggingEscapeCodes$.MODULE$.isColorAllowed() && !event.isMinor()) {
            this.sb.append(" \u001b[39m\u001b[1m");
            int i = ScalaUtils$syntax$.MODULE$.indexOfOrLength(eventString, '(');
            this.sb.underlying().append(eventString, 0, i);
            this.sb.append("\u001b[0m");
            this.sb.underlying().append(eventString, i, eventString.length());
            stringBuilder = this.sb.append(LoggingEscapeCodes$.MODULE$.resetColor());
        } else {
            this.sb.append(' ');
            stringBuilder = this.sb.append(eventString);
        }
        Predef$.MODULE$.locally((Object)stringBuilder);
        Logger LoggerImpl_this = JournalLogger$.js7$journal$log$JournalLogger$$$logger;
        if (LoggerImpl_this.underlying().isTraceEnabled()) {
            LoggerImpl_this.underlying().trace(this.sb.toString());
            return;
        }
    }

    private void infoLogPersist(PersistFrame frame, Stamped<KeyedEvent<Event>> stamped) {
        Object object;
        this.sb.clear();
        if (frame.persist().isAcknowledged()) {
            object = "Event \u2714";
        } else {
            String string = frame.persist().clusterState();
            if ("Empty".equals(string)) {
                object = "Event ";
            } else {
                String o = string;
                object = "Event (\u26a0\ufe0f " + o + ") ";
            }
        }
        this.sb.append((String)object);
        this.sb.append(frame.transactionMarker(false));
        Object object2 = stamped.value().key();
        KeyedEvent$NoKey$ keyedEvent$NoKey$ = KeyedEvent$NoKey$.MODULE$;
        if (object2 == null ? keyedEvent$NoKey$ != null : !object2.equals(keyedEvent$NoKey$)) {
            this.sb.append(stamped.value().key());
            this.sb.append(JournalLogger$.js7$journal$log$JournalLogger$$$spaceArrowSpace);
        }
        this.sb.append(stamped.value().event().toShortString());
        Logger LoggerImpl_this = JournalLogger$.js7$journal$log$JournalLogger$$$logger;
        if (LoggerImpl_this.underlying().isInfoEnabled()) {
            LoggerImpl_this.underlying().info(this.sb.toString());
            return;
        }
    }

    private final boolean isLoggable$3(Stamped stamped) {
        Object event = ((KeyedEvent)stamped.value()).event();
        return this.infoLoggableEventClasses.contains(event.getClass()) || !event.isSucceeded();
    }

    private final void traceLogPersist$$anonfun$1(PersistFrame frame$1) {
        if (frame$1.isLastEvent() && frame$1.persist().isLastOfFlushedOrSynced()) {
            this.sb.append(frame$1.persist().isAcknowledged() ? this.ackSyncOrFlushString : this.syncOrFlushString);
            return;
        }
        if (frame$1.isFirstEvent() && frame$1.persist().isFirstPersist() && frame$1.persist().persistCount() >= 2) {
            this.sb.append(frame$1.persist().persistCount());
            return;
        }
        if (frame$1.nr() == frame$1.beforeLastEventNr() && frame$1.persistEventCount() >= 10000) {
            long micros = frame$1.duration().toMicros();
            if (micros != 0L) {
                int k = (int)(1000.0 * (double)frame$1.persistEventCount() / (double)micros);
                if (k < 1000) {
                    this.sb.append(k);
                    this.sb.append("k/s");
                    return;
                }
                this.sb.append(k / 1000);
                this.sb.append("M/s");
                return;
            }
            return;
        }
    }

    private final void traceLogPersist$$anonfun$2(PersistFrame frame$2) {
        if (!this.suppressTiming && frame$2.duration().$greater$eq((Object)JournalLogger$.js7$journal$log$JournalLogger$$$MinimumDuration)) {
            this.sb.append(ScalaTime$RichDuration$.MODULE$.msPretty$extension(ScalaTime$.MODULE$.RichDuration((Duration)frame$2.duration())));
            return;
        }
    }

    private final void traceLogPersist$$anonfun$3(PersistFrame frame$3) {
        this.sb.append(frame$3.persistEventCount());
    }

    public static interface LoggablePersist {
        public static void $init$(LoggablePersist $this) {
            $this.persistIndex_$eq(0);
            $this.persistCount_$eq(0);
            $this.isFirstPersist_$eq(false);
            $this.isLastPersist_$eq(false);
            $this.isLastOfFlushedOrSynced_$eq(false);
            $this.isAcknowledged_$eq(false);
        }

        public long eventNumber();

        public Seq<Stamped<KeyedEvent<Event>>> stampedSeq();

        public boolean isTransaction();

        public Deadline since();

        public String clusterState();

        public int persistIndex();

        public void persistIndex_$eq(int var1);

        public int persistCount();

        public void persistCount_$eq(int var1);

        public boolean isFirstPersist();

        public void isFirstPersist_$eq(boolean var1);

        public boolean isLastPersist();

        public void isLastPersist_$eq(boolean var1);

        public boolean isLastOfFlushedOrSynced();

        public void isLastOfFlushedOrSynced_$eq(boolean var1);

        public boolean isAcknowledged();

        public void isAcknowledged_$eq(boolean var1);
    }

    public static final class PersistFrame
    implements Product,
    Serializable {
        private final LoggablePersist persist;
        private final int persistEventCount;
        private final Deadline committedAt;
        private final long beforeLastEventNr;
        private final FiniteDuration duration;
        private long nr;
        private boolean isFirstEvent;
        private boolean isLastEvent;

        public static PersistFrame apply(LoggablePersist loggablePersist, int n, Deadline deadline) {
            return JournalLogger$PersistFrame$.MODULE$.apply(loggablePersist, n, deadline);
        }

        public static PersistFrame fromProduct(Product product) {
            return JournalLogger$PersistFrame$.MODULE$.fromProduct(product);
        }

        public static PersistFrame unapply(PersistFrame persistFrame) {
            return JournalLogger$PersistFrame$.MODULE$.unapply(persistFrame);
        }

        public PersistFrame(LoggablePersist persist, int persistEventCount, Deadline committedAt) {
            this.persist = persist;
            this.persistEventCount = persistEventCount;
            this.committedAt = committedAt;
            this.beforeLastEventNr = persist.eventNumber() + (long)persistEventCount - 2L;
            this.duration = committedAt.$minus(persist.since());
            this.nr = persist.eventNumber();
            this.isFirstEvent = true;
            this.isLastEvent = false;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)-1308993511);
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.persist()));
            n = Statics.mix((int)n, (int)this.persistEventCount());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.committedAt()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            PersistFrame persistFrame;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PersistFrame)) return false;
            PersistFrame persistFrame2 = persistFrame = (PersistFrame)object;
            if (this.persistEventCount() != persistFrame2.persistEventCount()) return false;
            LoggablePersist loggablePersist = this.persist();
            LoggablePersist loggablePersist2 = persistFrame2.persist();
            if (loggablePersist == null) {
                if (loggablePersist2 != null) {
                    return false;
                }
            } else if (!loggablePersist.equals(loggablePersist2)) return false;
            Deadline deadline = this.committedAt();
            Deadline deadline2 = persistFrame2.committedAt();
            if (deadline == null) {
                if (deadline2 == null) return true;
                return false;
            } else {
                if (!deadline.equals(deadline2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PersistFrame;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "PersistFrame";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "persist";
                }
                case 1: {
                    return "persistEventCount";
                }
                case 2: {
                    return "committedAt";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public LoggablePersist persist() {
            return this.persist;
        }

        public int persistEventCount() {
            return this.persistEventCount;
        }

        public Deadline committedAt() {
            return this.committedAt;
        }

        public long beforeLastEventNr() {
            return this.beforeLastEventNr;
        }

        public FiniteDuration duration() {
            return this.duration;
        }

        public long nr() {
            return this.nr;
        }

        public void nr_$eq(long x$1) {
            this.nr = x$1;
        }

        public boolean isFirstEvent() {
            return this.isFirstEvent;
        }

        public void isFirstEvent_$eq(boolean x$1) {
            this.isFirstEvent = x$1;
        }

        public boolean isLastEvent() {
            return this.isLastEvent;
        }

        public void isLastEvent_$eq(boolean x$1) {
            this.isLastEvent = x$1;
        }

        public char persistMarker() {
            if (this.persist().isFirstPersist() && this.isFirstEvent()) {
                if (this.isLastEvent()) {
                    if (this.persist().isLastPersist()) {
                        return ' ';
                    }
                    return '\u2552';
                }
                return '\u250c';
            }
            if (this.isLastEvent()) {
                if (this.persist().isLastPersist()) {
                    return '\u2514';
                }
                return '\u251c';
            }
            return '\u2502';
        }

        public char transactionMarker(boolean forTrace) {
            if (this.isFirstEvent() && this.isLastEvent()) {
                return ' ';
            }
            if (this.persist().isTransaction()) {
                if (this.isFirstEvent()) {
                    return '\u239b';
                }
                if (this.isLastEvent()) {
                    return '\u239d';
                }
                if (forTrace && this.nr() == this.beforeLastEventNr()) {
                    return '\u23a8';
                }
                return '\u23aa';
            }
            if (!forTrace) {
                return ' ';
            }
            if (this.isFirstEvent()) {
                return '\u250c';
            }
            if (this.isLastEvent()) {
                return '\u2514';
            }
            if (this.persist().isLastPersist() && this.nr() == this.beforeLastEventNr()) {
                return '\u2524';
            }
            return '\u2506';
        }

        public PersistFrame copy(LoggablePersist persist, int persistEventCount, Deadline committedAt) {
            return new PersistFrame(persist, persistEventCount, committedAt);
        }

        public LoggablePersist copy$default$1() {
            return this.persist();
        }

        public int copy$default$2() {
            return this.persistEventCount();
        }

        public Deadline copy$default$3() {
            return this.committedAt();
        }

        public LoggablePersist _1() {
            return this.persist();
        }

        public int _2() {
            return this.persistEventCount();
        }

        public Deadline _3() {
            return this.committedAt();
        }
    }

    public static final class SimpleLoggablePersist
    implements LoggablePersist {
        private int persistIndex;
        private int persistCount;
        private boolean isFirstPersist;
        private boolean isLastPersist;
        private boolean isLastOfFlushedOrSynced;
        private boolean isAcknowledged;
        private final Seq<Stamped<KeyedEvent<Event>>> stampedSeq;
        private final long eventNumber;
        private final Deadline since;
        private final boolean isTransaction;
        private final String clusterState;

        public SimpleLoggablePersist(Seq<Stamped<KeyedEvent<Event>>> stampedSeq, long eventNumber, Deadline since, boolean isTransaction, String clusterState) {
            this.stampedSeq = stampedSeq;
            this.eventNumber = eventNumber;
            this.since = since;
            this.isTransaction = isTransaction;
            this.clusterState = clusterState;
            LoggablePersist.$init$(this);
            this.persistIndex_$eq(0);
            this.persistCount_$eq(1);
            this.isFirstPersist_$eq(true);
            this.isLastPersist_$eq(true);
            this.isLastOfFlushedOrSynced_$eq(true);
            this.isLastOfFlushedOrSynced_$eq(true);
            this.isAcknowledged_$eq(false);
        }

        @Override
        public final int persistIndex() {
            return this.persistIndex;
        }

        @Override
        public final int persistCount() {
            return this.persistCount;
        }

        @Override
        public final boolean isFirstPersist() {
            return this.isFirstPersist;
        }

        @Override
        public final boolean isLastPersist() {
            return this.isLastPersist;
        }

        @Override
        public final boolean isLastOfFlushedOrSynced() {
            return this.isLastOfFlushedOrSynced;
        }

        @Override
        public final boolean isAcknowledged() {
            return this.isAcknowledged;
        }

        @Override
        public final void persistIndex_$eq(int x$1) {
            this.persistIndex = x$1;
        }

        @Override
        public final void persistCount_$eq(int x$1) {
            this.persistCount = x$1;
        }

        @Override
        public final void isFirstPersist_$eq(boolean x$1) {
            this.isFirstPersist = x$1;
        }

        @Override
        public final void isLastPersist_$eq(boolean x$1) {
            this.isLastPersist = x$1;
        }

        @Override
        public final void isLastOfFlushedOrSynced_$eq(boolean x$1) {
            this.isLastOfFlushedOrSynced = x$1;
        }

        @Override
        public final void isAcknowledged_$eq(boolean x$1) {
            this.isAcknowledged = x$1;
        }

        @Override
        public Seq<Stamped<KeyedEvent<Event>>> stampedSeq() {
            return this.stampedSeq;
        }

        @Override
        public long eventNumber() {
            return this.eventNumber;
        }

        @Override
        public Deadline since() {
            return this.since;
        }

        @Override
        public boolean isTransaction() {
            return this.isTransaction;
        }

        @Override
        public String clusterState() {
            return this.clusterState;
        }
    }

    public static final class SubclassCache {
        private final Set<String> superclassNames;
        private final Map<Class<?>, Object> cache;

        public SubclassCache(Set<String> superclassNames) {
            this.superclassNames = superclassNames;
            this.cache = (Map)Map$.MODULE$.empty();
        }

        public boolean contains(Class<? extends Event> cls) {
            return BoxesRunTime.unboxToBoolean((Object)this.cache.getOrElseUpdate(cls, () -> this.contains$$anonfun$1(cls)));
        }

        public String toString() {
            return "SubclassCache(" + this.superclassNames + ")";
        }

        private final boolean contains$$anonfun$1(Class cls$1) {
            return Classes$.MODULE$.superclassesOf(cls$1).iterator().map(JournalLogger$::js7$journal$log$JournalLogger$SubclassCache$$_$contains$$anonfun$1$$anonfun$1).exists((Function1 & Serializable)elem -> this.superclassNames.contains(elem));
        }
    }
}

