/*
 * Decompiled with CFR 0.152.
 */
package js7.journal.recover;

import com.typesafe.scalalogging.Logger;
import io.circe.Json;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$Ops$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichInt$;
import js7.base.time.ScalaTime$RichDeadline$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.time.Stopwatch$;
import js7.base.time.Timestamp;
import js7.base.time.Timestamp$;
import js7.base.utils.ByteUnits$;
import js7.base.utils.ScalaUtils$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichString$;
import js7.data.cluster.ClusterState;
import js7.data.event.Event;
import js7.data.event.EventId$;
import js7.data.event.JournalHeader;
import js7.data.event.JournalHeader$;
import js7.data.event.JournalId;
import js7.data.event.JournalSeparators$;
import js7.data.event.JournalState;
import js7.data.event.KeyedEvent;
import js7.data.event.SnapshotableState;
import js7.data.event.SnapshotableStateRecoverer;
import js7.data.event.Stamped;
import js7.journal.recover.FileSnapshotableStateRecoverer$;
import js7.journal.recover.FileSnapshotableStateRecoverer$AfterHeader$;
import js7.journal.recover.FileSnapshotableStateRecoverer$AfterSnapshotSection$;
import js7.journal.recover.FileSnapshotableStateRecoverer$InCommittedEventsSection$;
import js7.journal.recover.FileSnapshotableStateRecoverer$InSnapshotSection$;
import js7.journal.recover.FileSnapshotableStateRecoverer$InTransaction$;
import js7.journal.recover.FileSnapshotableStateRecoverer$Initial$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.mutable.ArrayBuffer;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.sys.package$;
import scala.util.Either;
import scala.util.Try$;
import scala.util.hashing.MurmurHash3$;

public final class FileSnapshotableStateRecoverer<S extends SnapshotableState<S>> {
    private final Path journalFileForInfo;
    private final Option<JournalId> expectedJournalId;
    private final SnapshotableState.Companion<S> S;
    private final Deadline since;
    private Progress _progress;
    private int _snapshotCount;
    private long _eventCount;
    public final FileSnapshotableStateRecoverer$Initial$ Initial$lzy1;
    public final FileSnapshotableStateRecoverer$AfterHeader$ AfterHeader$lzy1;
    public final FileSnapshotableStateRecoverer$InSnapshotSection$ InSnapshotSection$lzy1;
    public final FileSnapshotableStateRecoverer$AfterSnapshotSection$ AfterSnapshotSection$lzy1;
    public final FileSnapshotableStateRecoverer$InCommittedEventsSection$ InCommittedEventsSection$lzy1;
    public final FileSnapshotableStateRecoverer$InTransaction$ InTransaction$lzy1;

    public FileSnapshotableStateRecoverer(Path journalFileForInfo, Option<JournalId> expectedJournalId, SnapshotableState.Companion<S> S) {
        this.journalFileForInfo = journalFileForInfo;
        this.expectedJournalId = expectedJournalId;
        this.S = S;
        this.Initial$lzy1 = new FileSnapshotableStateRecoverer$Initial$(this);
        this.AfterHeader$lzy1 = new FileSnapshotableStateRecoverer$AfterHeader$(this);
        this.InSnapshotSection$lzy1 = new FileSnapshotableStateRecoverer$InSnapshotSection$(this);
        this.AfterSnapshotSection$lzy1 = new FileSnapshotableStateRecoverer$AfterSnapshotSection$(this);
        this.InCommittedEventsSection$lzy1 = new FileSnapshotableStateRecoverer$InCommittedEventsSection$(this);
        this.InTransaction$lzy1 = new FileSnapshotableStateRecoverer$InTransaction$(this);
        this.since = Deadline$.MODULE$.now();
        this._progress = this.Initial().apply(S.newRecoverer());
        this._snapshotCount = 0;
        this._eventCount = 0L;
    }

    public void startWithState(JournalHeader journalHeader, long eventId, long totalEventCount, S state) {
        this._progress = this.InCommittedEventsSection().apply(journalHeader, state, eventId);
        this._eventCount = totalEventCount - journalHeader.totalEventCount();
    }

    public void put(Object journalRecord) {
        Progress progress = this._progress;
        if (progress instanceof Initial && ((Initial)progress).js7$journal$recover$FileSnapshotableStateRecoverer$Initial$$$outer() == this) {
            SnapshotableStateRecoverer snapshotableStateRecoverer;
            Initial initial = (Initial)progress;
            Initial initial2 = this.Initial().unapply(initial);
            SnapshotableStateRecoverer recoverer = snapshotableStateRecoverer = initial2._1();
            Object object = journalRecord;
            if (object instanceof JournalHeader) {
                JournalHeader journalHeader;
                JournalHeader journalHeader2 = journalHeader = (JournalHeader)object;
                Logger LoggerImpl_this = FileSnapshotableStateRecoverer$.js7$journal$recover$FileSnapshotableStateRecoverer$$$logger;
                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug(journalHeader2.toString());
                }
                Either either = Checked$.MODULE$.Ops(JournalHeader$.MODULE$.checkedHeader(journalHeader2, this.journalFileForInfo, this.expectedJournalId, this.S));
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Checked$Ops$.MODULE$.orThrow$extension(either);
                recoverer.addSnapshotObject(journalHeader2);
                ++this._snapshotCount;
                this._progress = this.AfterHeader().apply(recoverer, journalHeader2);
                return;
            }
            String string = ScalaUtils$syntax$.MODULE$.RichString(journalRecord.toString());
            throw new IllegalArgumentException("Not a valid JS7 journal file: " + this.journalFileForInfo + ". Expected a JournalHeader" + (" instead of " + ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$extension(string, 100, ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$2$extension(string), ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$3$extension(string), ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$4$extension(string)) + ":"));
        }
        if (progress instanceof AfterHeader && ((AfterHeader)progress).js7$journal$recover$FileSnapshotableStateRecoverer$AfterHeader$$$outer() == this) {
            AfterHeader afterHeader = (AfterHeader)progress;
            AfterHeader afterHeader2 = this.AfterHeader().unapply(afterHeader);
            SnapshotableStateRecoverer snapshotableStateRecoverer = afterHeader2._1();
            JournalHeader journalHeader = afterHeader2._2();
            SnapshotableStateRecoverer recoverer = snapshotableStateRecoverer;
            JournalHeader journalHeader3 = journalHeader;
            Object object = journalRecord;
            Json json = JournalSeparators$.MODULE$.SnapshotHeader();
            if (object == null ? json != null : !object.equals(json)) {
                throw new IllegalArgumentException("Missing SnapshotHeader in journal file");
            }
            this._progress = this.InSnapshotSection().apply(recoverer, journalHeader3);
            return;
        }
        if (progress instanceof InSnapshotSection && ((InSnapshotSection)progress).js7$journal$recover$FileSnapshotableStateRecoverer$InSnapshotSection$$$outer() == this) {
            InSnapshotSection inSnapshotSection = (InSnapshotSection)progress;
            InSnapshotSection inSnapshotSection2 = this.InSnapshotSection().unapply(inSnapshotSection);
            SnapshotableStateRecoverer snapshotableStateRecoverer = inSnapshotSection2._1();
            JournalHeader journalHeader = inSnapshotSection2._2();
            SnapshotableStateRecoverer recoverer = snapshotableStateRecoverer;
            JournalHeader journalHeader4 = journalHeader;
            Object object = journalRecord;
            Json json = JournalSeparators$.MODULE$.SnapshotFooter();
            Object object2 = object;
            if (!(json != null ? !json.equals(object2) : object2 != null)) {
                Object aggregate = recoverer.result();
                this._progress = this.AfterSnapshotSection().apply(journalHeader4, aggregate);
                this.S.updateStaticReference(aggregate);
                return;
            }
            recoverer.addSnapshotObject(journalRecord);
            ++this._snapshotCount;
            return;
        }
        if (progress instanceof AfterSnapshotSection && ((AfterSnapshotSection)progress).js7$journal$recover$FileSnapshotableStateRecoverer$AfterSnapshotSection$$$outer() == this) {
            AfterSnapshotSection afterSnapshotSection = (AfterSnapshotSection)progress;
            AfterSnapshotSection afterSnapshotSection2 = this.AfterSnapshotSection().unapply(afterSnapshotSection);
            JournalHeader journalHeader = afterSnapshotSection2._1();
            Object s = afterSnapshotSection2._2();
            JournalHeader journalHeader5 = journalHeader;
            Object state = s;
            Object object = journalRecord;
            Json json = JournalSeparators$.MODULE$.EventHeader();
            if (object == null ? json != null : !object.equals(json)) {
                throw new IllegalArgumentException("Missing EventHeader in journal file");
            }
            this._progress = this.InCommittedEventsSection().apply(journalHeader5, state, state.eventId());
            return;
        }
        if (progress instanceof InCommittedEventsSection && ((InCommittedEventsSection)progress).js7$journal$recover$FileSnapshotableStateRecoverer$InCommittedEventsSection$$$outer() == this) {
            InCommittedEventsSection inCommittedEventsSection;
            InCommittedEventsSection progress2 = inCommittedEventsSection = (InCommittedEventsSection)progress;
            Object object = journalRecord;
            Json json = JournalSeparators$.MODULE$.Transaction();
            Object object3 = object;
            if (!(json != null ? !json.equals(object3) : object3 != null)) {
                this._progress = this.InTransaction().apply(progress2.journalHeader(), progress2.state());
                return;
            }
            Stamped stamped = (Stamped)ScalaUtils$.MODULE$.cast(journalRecord, ClassTag$.MODULE$.apply(Stamped.class));
            progress2.eventId_$eq(stamped.eventId());
            Either either = Checked$.MODULE$.Ops(progress2.rawState().applyKeyedEvent((KeyedEvent)stamped.value()));
            progress2.rawState_$eq((SnapshotableState)Checked$Ops$.MODULE$.orThrow$extension(either));
            this.S.updateStaticReference(progress2.rawState());
            ++this._eventCount;
            return;
        }
        if (progress instanceof InTransaction && ((InTransaction)progress).js7$journal$recover$FileSnapshotableStateRecoverer$InTransaction$$$outer() == this) {
            InTransaction inTransaction;
            InTransaction ta = inTransaction = (InTransaction)progress;
            Object object = journalRecord;
            Json json = JournalSeparators$.MODULE$.Commit();
            Object object4 = object;
            if (!(json != null ? !json.equals(object4) : object4 != null)) {
                ArrayBuffer<Stamped<KeyedEvent<Event>>> events = ta.stampedKeyedEvents();
                Either either = Checked$.MODULE$.Ops(ta.state().applyStampedEvents((Iterable<Stamped<KeyedEvent<Event>>>)events));
                SnapshotableState updated = (SnapshotableState)Checked$Ops$.MODULE$.orThrow$extension(either);
                this._progress = this.InCommittedEventsSection().apply(ta.journalHeader(), updated, updated.eventId());
                this._eventCount += (long)events.size();
                this.S.updateStaticReference(updated);
                return;
            }
            ta.add((Stamped)ScalaUtils$.MODULE$.cast(journalRecord, ClassTag$.MODULE$.apply(Stamped.class)));
            return;
        }
        throw new MatchError((Object)progress);
    }

    public void rollbackToEventSection() {
        Progress progress = this._progress;
        if (progress instanceof InCommittedEventsSection && ((InCommittedEventsSection)progress).js7$journal$recover$FileSnapshotableStateRecoverer$InCommittedEventsSection$$$outer() == this) {
            InCommittedEventsSection inCommittedEventsSection = (InCommittedEventsSection)progress;
            return;
        }
        if (progress instanceof InTransaction && ((InTransaction)progress).js7$journal$recover$FileSnapshotableStateRecoverer$InTransaction$$$outer() == this) {
            InTransaction inTransaction = (InTransaction)progress;
            InTransaction inTransaction2 = this.InTransaction().unapply(inTransaction);
            JournalHeader journalHeader = inTransaction2._1();
            Object s = inTransaction2._2();
            JournalHeader journalHeader2 = journalHeader;
            Object state = s;
            this._progress = this.InCommittedEventsSection().apply(journalHeader2, state, state.eventId());
            return;
        }
        throw new IllegalStateException("rollbackToEventSection() but progress=" + this._progress);
    }

    public boolean isAfterSnapshotSection() {
        return this._progress instanceof AfterSnapshotSection;
    }

    public boolean isInCommittedEventsSection() {
        return this._progress instanceof InCommittedEventsSection;
    }

    public Option<JournalHeader> fileJournalHeader() {
        Progress progress = this._progress;
        if (progress instanceof HasJournalHeader) {
            HasJournalHeader hasJournalHeader;
            HasJournalHeader o = hasJournalHeader = (HasJournalHeader)progress;
            return Some$.MODULE$.apply((Object)o.journalHeader());
        }
        return None$.MODULE$;
    }

    public Option<JournalHeader> nextJournalHeader() {
        return this.fileJournalHeader().map((Function1 & Serializable)header -> {
            if (this._progress.eventId() == header.eventId()) {
                throw package$.MODULE$.error("Journal file contains no event \u2014 it must start with SnapshotTaken: " + this.journalFileForInfo);
            }
            FiniteDuration lastJournalDuration = this.lastEventIdTimestamp().$minus(header.timestamp());
            return header.nextGeneration(this._progress.eventId(), header.totalEventCount() + this._eventCount, ScalaTime$RichFiniteDuration$.MODULE$.roundUpToNext$extension(ScalaTime$.MODULE$.RichFiniteDuration(header.totalRunningTime().$plus(lastJournalDuration)), ScalaTime$DurationRichInt$.MODULE$.ms$extension(ScalaTime$.MODULE$.DurationRichInt(1))), this.lastEventIdTimestamp(), this.S);
        });
    }

    public long totalEventCount() {
        return BoxesRunTime.unboxToLong((Object)this.fileJournalHeader().fold(FileSnapshotableStateRecoverer::totalEventCount$$anonfun$1, (Function1 & Serializable)_$1 -> _$1.totalEventCount())) + this._eventCount;
    }

    private Timestamp lastEventIdTimestamp() {
        if (this.eventId() == EventId$.MODULE$.BeforeFirst()) {
            return Timestamp$.MODULE$.now();
        }
        return EventId$.MODULE$.toTimestamp(this.eventId());
    }

    public long eventId() {
        return this._progress.eventId();
    }

    public JournalState journalState() {
        return this._progress.journalState();
    }

    public ClusterState clusterState() {
        return this._progress.clusterState();
    }

    public S result() {
        Progress progress = this._progress;
        if (progress instanceof HasState && ((HasState)progress).js7$journal$recover$FileSnapshotableStateRecoverer$HasState$$$outer() == this) {
            HasState hasState;
            HasState o = hasState = (HasState)progress;
            return o.state();
        }
        throw new IllegalStateException(this.toString() + " has not yet recovered all snapshot objects for " + this.S);
    }

    public void logStatistics() {
        Logger LoggerImpl_this;
        Option byteCount2 = Try$.MODULE$.apply(this::$anonfun$1).toOption();
        FiniteDuration elapsed = ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(this.since));
        int snapshotCount = this._snapshotCount;
        if (elapsed.$greater$eq((Object)ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(1))) && (LoggerImpl_this = FileSnapshotableStateRecoverer$.js7$journal$recover$FileSnapshotableStateRecoverer$$$logger).underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug(Stopwatch$.MODULE$.itemsPerSecondString(elapsed, (long)snapshotCount + this._eventCount, "snapshots+events") + byteCount2.fold(FileSnapshotableStateRecoverer::logStatistics$$anonfun$1, (Function1 & Serializable)byteCount -> FileSnapshotableStateRecoverer.logStatistics$$anonfun$2(elapsed, BoxesRunTime.unboxToLong((Object)byteCount))) + " read");
        }
        if ((long)snapshotCount + this._eventCount > 0L) {
            String age = ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichFiniteDuration$.MODULE$.withMillis$extension(ScalaTime$.MODULE$.RichFiniteDuration(Timestamp$.MODULE$.now().$minus(EventId$.MODULE$.toTimestamp(this.eventId()))), 0)));
            Logger LoggerImpl_this2 = FileSnapshotableStateRecoverer$.js7$journal$recover$FileSnapshotableStateRecoverer$$$logger;
            if (LoggerImpl_this2.underlying().isInfoEnabled()) {
                LoggerImpl_this2.underlying().info("Recovered " + this.S + ", last EventId is " + EventId$.MODULE$.toString(this.eventId()) + ", emitted " + age + " ago " + ("(" + snapshotCount + " snapshot objects and " + this._eventCount + " events") + byteCount2.fold(FileSnapshotableStateRecoverer::logStatistics$$anonfun$3, (Function1 & Serializable)o -> FileSnapshotableStateRecoverer.logStatistics$$anonfun$4(BoxesRunTime.unboxToLong((Object)o))) + " read" + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(elapsed.$greater$eq((Object)ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(10)))), (Function0<String>)((Function0 & Serializable)() -> FileSnapshotableStateRecoverer.logStatistics$$anonfun$5(elapsed))) + ")");
                return;
            }
            return;
        }
    }

    private final FileSnapshotableStateRecoverer$Initial$ Initial() {
        return this.Initial$lzy1;
    }

    private final FileSnapshotableStateRecoverer$AfterHeader$ AfterHeader() {
        return this.AfterHeader$lzy1;
    }

    private final FileSnapshotableStateRecoverer$InSnapshotSection$ InSnapshotSection() {
        return this.InSnapshotSection$lzy1;
    }

    private final FileSnapshotableStateRecoverer$AfterSnapshotSection$ AfterSnapshotSection() {
        return this.AfterSnapshotSection$lzy1;
    }

    private final FileSnapshotableStateRecoverer$InCommittedEventsSection$ InCommittedEventsSection() {
        return this.InCommittedEventsSection$lzy1;
    }

    private final FileSnapshotableStateRecoverer$InTransaction$ InTransaction() {
        return this.InTransaction$lzy1;
    }

    private static final long totalEventCount$$anonfun$1() {
        return 0L;
    }

    private final long $anonfun$1() {
        return Files.size(this.journalFileForInfo);
    }

    private static final String logStatistics$$anonfun$1() {
        return "";
    }

    private static final /* synthetic */ String logStatistics$$anonfun$2(FiniteDuration elapsed$1, long byteCount) {
        return ", " + Stopwatch$.MODULE$.perSecondStringOnly(elapsed$1, byteCount / 1000000L, "MB", false) + " " + ByteUnits$.MODULE$.toKBGB(byteCount);
    }

    private static final String logStatistics$$anonfun$3() {
        return "";
    }

    private static final /* synthetic */ String logStatistics$$anonfun$4(long o) {
        return ", " + ByteUnits$.MODULE$.toKBGB(o);
    }

    private static final String logStatistics$$anonfun$5(FiniteDuration elapsed$2) {
        return " in " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(elapsed$2));
    }

    public final class AfterHeader
    implements HasRecoverer,
    Product,
    Serializable {
        private final SnapshotableStateRecoverer<S> recoverer;
        private final JournalHeader journalHeader;
        private final /* synthetic */ FileSnapshotableStateRecoverer $outer;

        public AfterHeader(FileSnapshotableStateRecoverer $outer, SnapshotableStateRecoverer<S> recoverer, JournalHeader journalHeader) {
            this.recoverer = recoverer;
            this.journalHeader = journalHeader;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -2138047365, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            AfterHeader afterHeader;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AfterHeader)) return false;
            if (((AfterHeader)object).js7$journal$recover$FileSnapshotableStateRecoverer$AfterHeader$$$outer() != this.$outer) return false;
            AfterHeader afterHeader2 = afterHeader = (AfterHeader)object;
            SnapshotableStateRecoverer snapshotableStateRecoverer = this.recoverer();
            SnapshotableStateRecoverer snapshotableStateRecoverer2 = afterHeader2.recoverer();
            if (snapshotableStateRecoverer == null) {
                if (snapshotableStateRecoverer2 != null) {
                    return false;
                }
            } else if (!snapshotableStateRecoverer.equals(snapshotableStateRecoverer2)) return false;
            JournalHeader journalHeader = this.journalHeader();
            JournalHeader journalHeader2 = afterHeader2.journalHeader();
            if (journalHeader == null) {
                if (journalHeader2 == null) return true;
                return false;
            } else {
                if (!((Object)journalHeader).equals(journalHeader2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AfterHeader;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "AfterHeader";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "recoverer";
            }
            if (1 == n2) {
                return "journalHeader";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public SnapshotableStateRecoverer<S> recoverer() {
            return this.recoverer;
        }

        public JournalHeader journalHeader() {
            return this.journalHeader;
        }

        public AfterHeader copy(SnapshotableStateRecoverer<S> recoverer, JournalHeader journalHeader) {
            return new AfterHeader(this.$outer, recoverer, journalHeader);
        }

        public SnapshotableStateRecoverer<S> copy$default$1() {
            return this.recoverer();
        }

        public JournalHeader copy$default$2() {
            return this.journalHeader();
        }

        public SnapshotableStateRecoverer<S> _1() {
            return this.recoverer();
        }

        public JournalHeader _2() {
            return this.journalHeader();
        }

        public final /* synthetic */ FileSnapshotableStateRecoverer js7$journal$recover$FileSnapshotableStateRecoverer$AfterHeader$$$outer() {
            return this.$outer;
        }

        public final /* synthetic */ FileSnapshotableStateRecoverer js7$journal$recover$FileSnapshotableStateRecoverer$HasRecoverer$$$outer() {
            return this.$outer;
        }
    }

    public final class AfterSnapshotSection
    implements HasState,
    Product,
    Serializable {
        private final JournalHeader journalHeader;
        private final S state;
        private final /* synthetic */ FileSnapshotableStateRecoverer $outer;

        public AfterSnapshotSection(JournalHeader journalHeader, S state) {
            this.journalHeader = journalHeader;
            this.state = state;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 37007936, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            AfterSnapshotSection afterSnapshotSection;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AfterSnapshotSection)) return false;
            if (((AfterSnapshotSection)object).js7$journal$recover$FileSnapshotableStateRecoverer$AfterSnapshotSection$$$outer() != this.$outer) return false;
            AfterSnapshotSection afterSnapshotSection2 = afterSnapshotSection = (AfterSnapshotSection)object;
            JournalHeader journalHeader = this.journalHeader();
            JournalHeader journalHeader2 = afterSnapshotSection2.journalHeader();
            if (journalHeader == null) {
                if (journalHeader2 != null) {
                    return false;
                }
            } else if (!((Object)journalHeader).equals(journalHeader2)) return false;
            Object s = this.state();
            Object s2 = afterSnapshotSection2.state();
            if (s == null) {
                if (s2 == null) return true;
                return false;
            } else {
                if (!s.equals(s2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AfterSnapshotSection;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "AfterSnapshotSection";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "journalHeader";
            }
            if (1 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public JournalHeader journalHeader() {
            return this.journalHeader;
        }

        @Override
        public S state() {
            return this.state;
        }

        @Override
        public long eventId() {
            return this.state().eventId();
        }

        @Override
        public S rawState() {
            return this.state();
        }

        public AfterSnapshotSection copy(JournalHeader journalHeader, S state) {
            return new AfterSnapshotSection(this.$outer, journalHeader, state);
        }

        public JournalHeader copy$default$1() {
            return this.journalHeader();
        }

        public S copy$default$2() {
            return this.state();
        }

        public JournalHeader _1() {
            return this.journalHeader();
        }

        public S _2() {
            return this.state();
        }

        public final /* synthetic */ FileSnapshotableStateRecoverer js7$journal$recover$FileSnapshotableStateRecoverer$AfterSnapshotSection$$$outer() {
            return this.$outer;
        }

        @Override
        public final /* synthetic */ FileSnapshotableStateRecoverer js7$journal$recover$FileSnapshotableStateRecoverer$HasState$$$outer() {
            return this.$outer;
        }
    }

    public interface HasJournalHeader
    extends Progress {
        public JournalHeader journalHeader();
    }

    public interface HasRecoverer
    extends Progress {
        public SnapshotableStateRecoverer<S> recoverer();

        public static long eventId$(HasRecoverer $this) {
            return $this.eventId();
        }

        @Override
        default public long eventId() {
            return this.recoverer().eventId();
        }

        public static JournalState journalState$(HasRecoverer $this) {
            return $this.journalState();
        }

        @Override
        default public JournalState journalState() {
            return this.recoverer().journalState();
        }

        public static ClusterState clusterState$(HasRecoverer $this) {
            return $this.clusterState();
        }

        @Override
        default public ClusterState clusterState() {
            return this.recoverer().clusterState();
        }
    }

    public interface HasState
    extends HasJournalHeader {
        public S rawState();

        public S state();

        public static JournalState journalState$(HasState $this) {
            return $this.journalState();
        }

        @Override
        default public JournalState journalState() {
            return this.state().journalState();
        }

        public static ClusterState clusterState$(HasState $this) {
            return $this.clusterState();
        }

        @Override
        default public ClusterState clusterState() {
            return this.state().clusterState();
        }

        public /* synthetic */ FileSnapshotableStateRecoverer js7$journal$recover$FileSnapshotableStateRecoverer$HasState$$$outer();
    }

    public final class InCommittedEventsSection
    implements HasState,
    Product,
    Serializable {
        private final JournalHeader journalHeader;
        private S rawState;
        private long eventId;
        private final /* synthetic */ FileSnapshotableStateRecoverer $outer;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public InCommittedEventsSection(JournalHeader rawState, S eventId, long l) {
            void journalHeader;
            this.journalHeader = journalHeader;
            this.rawState = rawState;
            this.eventId = (long)eventId;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = (FileSnapshotableStateRecoverer)$outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)-395313899);
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.journalHeader()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.rawState()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.eventId()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            InCommittedEventsSection inCommittedEventsSection;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof InCommittedEventsSection)) return false;
            if (((InCommittedEventsSection)object).js7$journal$recover$FileSnapshotableStateRecoverer$InCommittedEventsSection$$$outer() != this.$outer) return false;
            InCommittedEventsSection inCommittedEventsSection2 = inCommittedEventsSection = (InCommittedEventsSection)object;
            JournalHeader journalHeader = this.journalHeader();
            JournalHeader journalHeader2 = inCommittedEventsSection2.journalHeader();
            if (journalHeader == null) {
                if (journalHeader2 != null) {
                    return false;
                }
            } else if (!((Object)journalHeader).equals(journalHeader2)) return false;
            Object s = this.rawState();
            Object s2 = inCommittedEventsSection2.rawState();
            if (s == null) {
                if (s2 != null) {
                    return false;
                }
            } else if (!s.equals(s2)) return false;
            if (this.eventId() != inCommittedEventsSection2.eventId()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof InCommittedEventsSection;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "InCommittedEventsSection";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "journalHeader";
                }
                case 1: {
                    return "rawState";
                }
                case 2: {
                    return "eventId";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public JournalHeader journalHeader() {
            return this.journalHeader;
        }

        @Override
        public S rawState() {
            return this.rawState;
        }

        public void rawState_$eq(S x$1) {
            this.rawState = x$1;
        }

        @Override
        public long eventId() {
            return this.eventId;
        }

        public void eventId_$eq(long x$1) {
            this.eventId = x$1;
        }

        @Override
        public S state() {
            return (SnapshotableState)this.rawState().withEventId(this.eventId());
        }

        public InCommittedEventsSection copy(JournalHeader journalHeader, S rawState, long eventId) {
            return new InCommittedEventsSection(this.$outer, journalHeader, rawState, eventId);
        }

        public JournalHeader copy$default$1() {
            return this.journalHeader();
        }

        public S copy$default$2() {
            return this.rawState();
        }

        public long copy$default$3() {
            return this.eventId();
        }

        public JournalHeader _1() {
            return this.journalHeader();
        }

        public S _2() {
            return this.rawState();
        }

        public long _3() {
            return this.eventId();
        }

        public final /* synthetic */ FileSnapshotableStateRecoverer js7$journal$recover$FileSnapshotableStateRecoverer$InCommittedEventsSection$$$outer() {
            return this.$outer;
        }

        @Override
        public final /* synthetic */ FileSnapshotableStateRecoverer js7$journal$recover$FileSnapshotableStateRecoverer$HasState$$$outer() {
            return this.$outer;
        }
    }

    public final class InSnapshotSection
    implements HasRecoverer,
    Product,
    Serializable {
        private final SnapshotableStateRecoverer<S> recoverer;
        private final JournalHeader journalHeader;
        private final /* synthetic */ FileSnapshotableStateRecoverer $outer;

        public InSnapshotSection(FileSnapshotableStateRecoverer $outer, SnapshotableStateRecoverer<S> recoverer, JournalHeader journalHeader) {
            this.recoverer = recoverer;
            this.journalHeader = journalHeader;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -856482458, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            InSnapshotSection inSnapshotSection;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof InSnapshotSection)) return false;
            if (((InSnapshotSection)object).js7$journal$recover$FileSnapshotableStateRecoverer$InSnapshotSection$$$outer() != this.$outer) return false;
            InSnapshotSection inSnapshotSection2 = inSnapshotSection = (InSnapshotSection)object;
            SnapshotableStateRecoverer snapshotableStateRecoverer = this.recoverer();
            SnapshotableStateRecoverer snapshotableStateRecoverer2 = inSnapshotSection2.recoverer();
            if (snapshotableStateRecoverer == null) {
                if (snapshotableStateRecoverer2 != null) {
                    return false;
                }
            } else if (!snapshotableStateRecoverer.equals(snapshotableStateRecoverer2)) return false;
            JournalHeader journalHeader = this.journalHeader();
            JournalHeader journalHeader2 = inSnapshotSection2.journalHeader();
            if (journalHeader == null) {
                if (journalHeader2 == null) return true;
                return false;
            } else {
                if (!((Object)journalHeader).equals(journalHeader2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof InSnapshotSection;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "InSnapshotSection";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "recoverer";
            }
            if (1 == n2) {
                return "journalHeader";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public SnapshotableStateRecoverer<S> recoverer() {
            return this.recoverer;
        }

        public JournalHeader journalHeader() {
            return this.journalHeader;
        }

        public InSnapshotSection copy(SnapshotableStateRecoverer<S> recoverer, JournalHeader journalHeader) {
            return new InSnapshotSection(this.$outer, recoverer, journalHeader);
        }

        public SnapshotableStateRecoverer<S> copy$default$1() {
            return this.recoverer();
        }

        public JournalHeader copy$default$2() {
            return this.journalHeader();
        }

        public SnapshotableStateRecoverer<S> _1() {
            return this.recoverer();
        }

        public JournalHeader _2() {
            return this.journalHeader();
        }

        public final /* synthetic */ FileSnapshotableStateRecoverer js7$journal$recover$FileSnapshotableStateRecoverer$InSnapshotSection$$$outer() {
            return this.$outer;
        }

        public final /* synthetic */ FileSnapshotableStateRecoverer js7$journal$recover$FileSnapshotableStateRecoverer$HasRecoverer$$$outer() {
            return this.$outer;
        }
    }

    public final class InTransaction
    implements HasState,
    Product,
    Serializable {
        private final JournalHeader journalHeader;
        private final S state;
        private ArrayBuffer<Stamped<KeyedEvent<Event>>> stampedKeyedEvents;
        private final /* synthetic */ FileSnapshotableStateRecoverer $outer;

        public InTransaction(JournalHeader journalHeader, S state) {
            this.journalHeader = journalHeader;
            this.state = state;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.stampedKeyedEvents = new ArrayBuffer();
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 971381796, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            InTransaction inTransaction;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof InTransaction)) return false;
            if (((InTransaction)object).js7$journal$recover$FileSnapshotableStateRecoverer$InTransaction$$$outer() != this.$outer) return false;
            InTransaction inTransaction2 = inTransaction = (InTransaction)object;
            JournalHeader journalHeader = this.journalHeader();
            JournalHeader journalHeader2 = inTransaction2.journalHeader();
            if (journalHeader == null) {
                if (journalHeader2 != null) {
                    return false;
                }
            } else if (!((Object)journalHeader).equals(journalHeader2)) return false;
            Object s = this.state();
            Object s2 = inTransaction2.state();
            if (s == null) {
                if (s2 == null) return true;
                return false;
            } else {
                if (!s.equals(s2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof InTransaction;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "InTransaction";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "journalHeader";
            }
            if (1 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public JournalHeader journalHeader() {
            return this.journalHeader;
        }

        @Override
        public S state() {
            return this.state;
        }

        @Override
        public long eventId() {
            return this.state().eventId();
        }

        @Override
        public S rawState() {
            return this.state();
        }

        public ArrayBuffer<Stamped<KeyedEvent<Event>>> stampedKeyedEvents() {
            return this.stampedKeyedEvents;
        }

        public void stampedKeyedEvents_$eq(ArrayBuffer<Stamped<KeyedEvent<Event>>> x$1) {
            this.stampedKeyedEvents = x$1;
        }

        public void add(Stamped<KeyedEvent<Event>> stamped) {
            this.stampedKeyedEvents_$eq((ArrayBuffer<Stamped<KeyedEvent<Event>>>)((ArrayBuffer)this.stampedKeyedEvents().$colon$plus(stamped)));
        }

        public InTransaction copy(JournalHeader journalHeader, S state) {
            return new InTransaction(this.$outer, journalHeader, state);
        }

        public JournalHeader copy$default$1() {
            return this.journalHeader();
        }

        public S copy$default$2() {
            return this.state();
        }

        public JournalHeader _1() {
            return this.journalHeader();
        }

        public S _2() {
            return this.state();
        }

        public final /* synthetic */ FileSnapshotableStateRecoverer js7$journal$recover$FileSnapshotableStateRecoverer$InTransaction$$$outer() {
            return this.$outer;
        }

        @Override
        public final /* synthetic */ FileSnapshotableStateRecoverer js7$journal$recover$FileSnapshotableStateRecoverer$HasState$$$outer() {
            return this.$outer;
        }
    }

    public final class Initial
    implements HasRecoverer,
    Product,
    Serializable {
        private final SnapshotableStateRecoverer<S> recoverer;
        private final /* synthetic */ FileSnapshotableStateRecoverer $outer;

        public Initial(FileSnapshotableStateRecoverer $outer, SnapshotableStateRecoverer<S> recoverer) {
            this.recoverer = recoverer;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 572425421, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            Initial initial;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Initial)) return false;
            if (((Initial)object).js7$journal$recover$FileSnapshotableStateRecoverer$Initial$$$outer() != this.$outer) return false;
            Initial initial2 = initial = (Initial)object;
            SnapshotableStateRecoverer snapshotableStateRecoverer = this.recoverer();
            SnapshotableStateRecoverer snapshotableStateRecoverer2 = initial2.recoverer();
            if (snapshotableStateRecoverer != null) {
                if (!snapshotableStateRecoverer.equals(snapshotableStateRecoverer2)) return false;
                return true;
            }
            if (snapshotableStateRecoverer2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Initial;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Initial";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "recoverer";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public SnapshotableStateRecoverer<S> recoverer() {
            return this.recoverer;
        }

        public Initial copy(SnapshotableStateRecoverer<S> recoverer) {
            return new Initial(this.$outer, recoverer);
        }

        public SnapshotableStateRecoverer<S> copy$default$1() {
            return this.recoverer();
        }

        public SnapshotableStateRecoverer<S> _1() {
            return this.recoverer();
        }

        public final /* synthetic */ FileSnapshotableStateRecoverer js7$journal$recover$FileSnapshotableStateRecoverer$Initial$$$outer() {
            return this.$outer;
        }

        public final /* synthetic */ FileSnapshotableStateRecoverer js7$journal$recover$FileSnapshotableStateRecoverer$HasRecoverer$$$outer() {
            return this.$outer;
        }
    }

    public interface Progress {
        public long eventId();

        public JournalState journalState();

        public ClusterState clusterState();
    }
}

