/*
 * Decompiled with CFR 0.152.
 */
package js7.journal.recover;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Sync;
import fs2.Stream;
import fs2.Stream$;
import io.circe.Json;
import java.io.Serializable;
import java.nio.file.Path;
import js7.base.ProvisionalAssumptions$streamChunks$;
import js7.base.circeutils.CirceUtils$;
import js7.base.circeutils.CirceUtils$RichCirceEither$;
import js7.base.circeutils.CirceUtils$RichJson$;
import js7.base.data.ByteArray;
import js7.base.data.ByteArray$;
import js7.base.data.ByteSequence$ops$;
import js7.base.fs2utils.StreamExtensions$;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$Ops$;
import js7.base.utils.AutoClosing$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichString$;
import js7.common.jsonseq.InputStreamJsonSeqReader;
import js7.common.jsonseq.InputStreamJsonSeqReader$;
import js7.common.jsonseq.PositionAnd;
import js7.common.jsonseq.PositionAnd$;
import js7.common.utils.package$;
import js7.data.event.Event;
import js7.data.event.EventId$;
import js7.data.event.JournalHeader;
import js7.data.event.JournalHeader$;
import js7.data.event.JournalId;
import js7.data.event.JournalSeparators$;
import js7.data.event.KeyedEvent;
import js7.data.event.SnapshotableState;
import js7.data.event.Stamped;
import js7.data.event.Stamped$;
import js7.journal.recover.JournalReader$;
import js7.journal.recover.TransactionReader;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterator;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.control.NonFatal$;

public final class JournalReader
implements AutoCloseable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(JournalReader.class.getDeclaredField("firstEventPosition$lzy1"));
    private final SnapshotableState.HasCodec S;
    private final Path journalFile;
    private final InputStreamJsonSeqReader jsonReader;
    private final PositionAnd<ByteArray> rawJournalHeader;
    private final JournalHeader journalHeader;
    private final long fileEventId;
    private long _totalEventCount;
    private boolean snapshotHeaderRead;
    private boolean eventHeaderRead;
    private long _eventId;
    private final TransactionReader transaction;
    private volatile Object firstEventPosition$lzy1;

    public static Stream<IO, ByteArray> rawSnapshot(SnapshotableState.HasCodec hasCodec, Path path, JournalId journalId) {
        return JournalReader$.MODULE$.rawSnapshot(hasCodec, path, journalId);
    }

    public static Stream<IO, Object> snapshot(SnapshotableState.HasCodec hasCodec, Path path, JournalId journalId) {
        return JournalReader$.MODULE$.snapshot(hasCodec, path, journalId);
    }

    public JournalReader(SnapshotableState.HasCodec S, Path journalFile, JournalId expectedJournalId) {
        this.S = S;
        this.journalFile = journalFile;
        this.jsonReader = InputStreamJsonSeqReader$.MODULE$.open(journalFile, InputStreamJsonSeqReader$.MODULE$.open$default$2());
        this.rawJournalHeader = (PositionAnd)AutoClosing$.MODULE$.closeOnError(this.jsonReader, () -> this.$init$$$anonfun$1(journalFile));
        Json json = this.jsonReader.toJson(this.rawJournalHeader).value();
        Either either = Checked$.MODULE$.Ops(JournalHeader$.MODULE$.checkedHeader(json, journalFile, S.name(), expectedJournalId));
        this.journalHeader = (JournalHeader)Checked$Ops$.MODULE$.orThrow$extension(either);
        this.fileEventId = this.journalHeader().eventId();
        this._totalEventCount = this.journalHeader().totalEventCount();
        this.snapshotHeaderRead = false;
        this.eventHeaderRead = false;
        this._eventId = this.fileEventId();
        this.transaction = new TransactionReader();
    }

    public JournalHeader journalHeader() {
        return this.journalHeader;
    }

    public long fileEventId() {
        return this.fileEventId;
    }

    @Override
    public void close() {
        this.jsonReader.close();
    }

    public long firstEventPosition() {
        Object object = this.firstEventPosition$lzy1;
        if (object instanceof Long) {
            return BoxesRunTime.unboxToLong((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToLong(null);
        }
        return BoxesRunTime.unboxToLong((Object)this.firstEventPosition$lzyINIT1());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Object firstEventPosition$lzyINIT1() {
        block15: {
            while (true) {
                block16: {
                    if ((var1_1 = this.firstEventPosition$lzy1) != null) break block16;
                    if (!LazyVals$.MODULE$.objCAS((Object)this, JournalReader.OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    var2_2 /* !! */  = null;
                    var3_3 = null;
                    try {
                        var4_4 = this;
                        synchronized (var4_4) {
                            block17: {
                                if (this.snapshotHeaderRead || this.eventHeaderRead) {
                                    throw new IllegalStateException("JournalReader.firstEventPosition has been called after nextEvent");
                                }
                                while (this.nextSnapshotJson().isDefined()) {
                                }
                                if (this.eventHeaderRead) break block17;
                                var7_5 = this.jsonReader.read();
                                if (!(var7_5 instanceof Some)) ** GOTO lbl-1000
                                var8_6 = (Some)var7_5;
                                var9_7 = PositionAnd$.MODULE$.unapply((PositionAnd)var8_6.value());
                                var10_8 = var9_7._1();
                                var12_9 = (Json)var9_7._2();
                                v0 = JournalSeparators$.MODULE$.EventHeader();
                                var13_10 = var12_9;
                                if (!(v0 != null ? v0.equals(var13_10) == false : var13_10 != null)) {
                                    this.eventHeaderRead = true;
                                } else if (!None$.MODULE$.equals(var7_5)) {
                                    if (var7_5 instanceof Some) {
                                        var14_11 = (Some)var7_5;
                                        positionAndJson = (PositionAnd)var14_11.value();
                                        var16_13 = CirceUtils$RichJson$.MODULE$.toByteArray$extension(CirceUtils$.MODULE$.RichJson((Json)positionAndJson.value()));
                                        var17_14 = positionAndJson.copy$default$1();
                                        throw new CorruptJournalException("Event header is missing", this.journalFile, positionAndJson.copy(var17_14, var16_13));
                                    }
                                    throw new MatchError(var7_5);
                                }
                            }
                            var5_15 = this.jsonReader.position();
                        }
                        var3_3 = BoxesRunTime.boxToLong((long)var5_15);
                        var2_2 /* !! */  = var3_3 == null ? LazyVals.NullValue$.MODULE$ : var3_3;
                    }
                    catch (Throwable var19_16) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, JournalReader.OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, var2_2 /* !! */ )) {
                            var20_17 = (LazyVals.Waiting)this.firstEventPosition$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, JournalReader.OFFSET$0, (Object)var20_17, var2_2 /* !! */ );
                            var20_17.countDown();
                        }
                        throw var19_16;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, JournalReader.OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, (Object)var2_2 /* !! */ )) {
                        var20_18 = (LazyVals.Waiting)this.firstEventPosition$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, JournalReader.OFFSET$0, (Object)var20_18, (Object)var2_2 /* !! */ );
                        var20_18.countDown();
                    }
                    return var3_3;
                }
                if (!(var1_1 instanceof LazyVals.LazyValControlState)) break block15;
                if (var1_1 == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, JournalReader.OFFSET$0, var1_1, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(var1_1 instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)var1_1).await();
            }
            return null;
        }
        return var1_1;
    }

    public Stream<IO, Object> readSnapshot() {
        Stream<IO, JournalHeader> stream;
        JournalReader journalReader = this;
        synchronized (journalReader) {
            boolean bl = Stream$.MODULE$.fromIterator();
            Stream stream2 = Stream.PartiallyAppliedFromIterator$.MODULE$.apply$extension(bl, package$.MODULE$.untilNoneIterator(this::$anonfun$1), ProvisionalAssumptions$streamChunks$.MODULE$.elementsPerChunkLimit(), (Sync)IO$.MODULE$.asyncForIO());
            stream = StreamExtensions$.MODULE$.$plus$colon(StreamExtensions$.MODULE$.mapParallelBatch(stream2, StreamExtensions$.MODULE$.mapParallelBatch$default$2(stream2), StreamExtensions$.MODULE$.mapParallelBatch$default$3(stream2), StreamExtensions$.MODULE$.mapParallelBatch$default$4(stream2), (Function1 & Serializable)json -> {
                Either either = CirceUtils$.MODULE$.RichCirceEither(this.S.snapshotObjectJsonCodec().decodeJson((Json)json));
                Either either2 = Checked$.MODULE$.Ops(CirceUtils$RichCirceEither$.MODULE$.toChecked$extension(either));
                return Checked$Ops$.MODULE$.orThrow$extension(either2);
            }), this.journalHeader());
        }
        return stream;
    }

    public Stream<IO, ByteArray> readSnapshotRaw() {
        Stream stream;
        JournalReader journalReader = this;
        synchronized (journalReader) {
            boolean bl = Stream$.MODULE$.fromIterator();
            stream = StreamExtensions$.MODULE$.$plus$colon(Stream.PartiallyAppliedFromIterator$.MODULE$.apply$extension(bl, package$.MODULE$.untilNoneIterator(this::readSnapshotRaw$$anonfun$1), 1, (Sync)IO$.MODULE$.asyncForIO()), this.rawJournalHeader.value());
        }
        return stream;
    }

    private Option<Json> nextSnapshotJson() {
        return this.nextSnapshotRaw().map((Function1 & Serializable)positionAndRaw -> this.jsonReader.toJson((PositionAnd<ByteArray>)positionAndRaw)).map((Function1 & Serializable)_$2 -> (Json)_$2.value());
    }

    private Option<PositionAnd<ByteArray>> nextSnapshotRaw() {
        ByteArray record;
        PositionAnd positionAndRaw;
        block5: {
            while (true) {
                if (this.eventHeaderRead) {
                    throw new IllegalStateException("nextSnapshotJson has been called after nextEvent");
                }
                positionAndRaw = (PositionAnd)this.jsonReader.readRaw().getOrElse(this::$anonfun$2);
                record = (ByteArray)positionAndRaw.value();
                if (this.snapshotHeaderRead) break block5;
                ByteArray byteArray = record;
                ByteArray byteArray2 = JournalSeparators$.MODULE$.EventHeaderLine();
                ByteArray byteArray3 = byteArray;
                if (!(byteArray2 != null ? !((Object)byteArray2).equals(byteArray3) : byteArray3 != null)) {
                    this.eventHeaderRead = true;
                    return None$.MODULE$;
                }
                ByteArray byteArray4 = JournalSeparators$.MODULE$.SnapshotHeaderLine();
                ByteArray byteArray5 = byteArray;
                if (byteArray4 != null ? !((Object)byteArray4).equals(byteArray5) : byteArray5 != null) break;
                this.snapshotHeaderRead = true;
            }
            throw new CorruptJournalException("Snapshot header is missing", this.journalFile, positionAndRaw);
        }
        if (ByteSequence$ops$.MODULE$.toAllByteSequenceOps(record, ByteArray$.MODULE$.implicitByteSequence()).headOption().contains((Object)BoxesRunTime.boxToByte((byte)((byte)123)))) {
            return Some$.MODULE$.apply((Object)positionAndRaw);
        }
        ByteArray byteArray = record;
        ByteArray byteArray6 = JournalSeparators$.MODULE$.SnapshotFooterLine();
        if (!(byteArray != null ? !((Object)byteArray).equals(byteArray6) : byteArray6 != null)) {
            return None$.MODULE$;
        }
        throw new CorruptJournalException("Snapshot footer is missing", this.journalFile, positionAndRaw);
    }

    public void seekEvent(PositionAnd<Object> positionAndEventId) {
        JournalReader journalReader = this;
        synchronized (journalReader) {
            Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)positionAndEventId.value()) >= this.fileEventId(), () -> this.seekEvent$$anonfun$1(positionAndEventId));
            this.jsonReader.seek(positionAndEventId.position());
            this._eventId = BoxesRunTime.unboxToLong((Object)positionAndEventId.value());
            this.eventHeaderRead = true;
            this._totalEventCount = -1L;
            this.transaction.clear();
        }
    }

    public Iterator<Stamped<KeyedEvent<Event>>> readEvents() {
        return package$.MODULE$.untilNoneIterator(this::readEvents$$anonfun$1);
    }

    /*
     * WARNING - void declaration
     */
    public Option<Stamped<KeyedEvent<Event>>> nextEvent() {
        void var2_3;
        JournalReader journalReader = this;
        synchronized (journalReader) {
            void var3_2;
            Option result = this.transaction.readNext().orElse(this::$anonfun$3);
            result.foreach((Function1)(JProcedure1 & Serializable)stamped -> {
                this._eventId = stamped.eventId();
            });
            var2_3 = var3_2;
        }
        return var2_3;
    }

    private Option<Stamped<KeyedEvent<Event>>> nextEvent2() {
        if (!this.eventHeaderRead) {
            Option<PositionAnd<Json>> option = this.jsonReader.read();
            if (option instanceof Some) {
                Some some = (Some)option;
                PositionAnd positionAnd = (PositionAnd)some.value();
                PositionAnd positionAnd2 = PositionAnd$.MODULE$.unapply(positionAnd);
                long l = positionAnd2._1();
                Json json = (Json)positionAnd2._2();
                Json json2 = JournalSeparators$.MODULE$.EventHeader();
                Json json3 = json;
                if (!(json2 != null ? !json2.equals(json3) : json3 != null)) {
                    this.eventHeaderRead = true;
                    return this.nextEvent3();
                }
                PositionAnd positionAndJson = positionAnd;
                ByteArray byteArray = CirceUtils$RichJson$.MODULE$.toByteArray$extension(CirceUtils$.MODULE$.RichJson((Json)positionAndJson.value()));
                long l2 = positionAndJson.copy$default$1();
                throw new CorruptJournalException("Event header is missing", this.journalFile, positionAndJson.copy(l2, byteArray));
            }
            if (None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            throw new MatchError(option);
        }
        return this.nextEvent3();
    }

    private Option<Stamped<KeyedEvent<Event>>> nextEvent3() {
        Option<PositionAnd<Json>> option;
        block10: {
            PositionAnd positionAndJson;
            while (true) {
                if (None$.MODULE$.equals(option = this.jsonReader.read())) {
                    return None$.MODULE$;
                }
                if (!(option instanceof Some)) break block10;
                Some some = (Some)option;
                positionAndJson = (PositionAnd)some.value();
                Json json = (Json)positionAndJson.value();
                Json json2 = json;
                if (json2.isObject()) {
                    Stamped<KeyedEvent<Event>> stampedEvent = this.deserialize((Json)positionAndJson.value());
                    if (stampedEvent.eventId() <= this._eventId) {
                        ByteArray byteArray = CirceUtils$RichJson$.MODULE$.toByteArray$extension(CirceUtils$.MODULE$.RichJson((Json)positionAndJson.value()));
                        long l = positionAndJson.copy$default$1();
                        throw new CorruptJournalException("Journal is corrupt, EventIds are in wrong order: " + EventId$.MODULE$.toString(stampedEvent.eventId()) + " follows " + EventId$.MODULE$.toString(this._eventId), this.journalFile, positionAndJson.copy(l, byteArray));
                    }
                    if (this._totalEventCount != -1L) {
                        ++this._totalEventCount;
                    }
                    return Some$.MODULE$.apply(stampedEvent);
                }
                Json json3 = JournalSeparators$.MODULE$.Transaction();
                Json json4 = json;
                if (!(json3 != null ? !json3.equals(json4) : json4 != null)) {
                    if (this.transaction.isInTransaction()) {
                        ByteArray byteArray = CirceUtils$RichJson$.MODULE$.toByteArray$extension(CirceUtils$.MODULE$.RichJson((Json)positionAndJson.value()));
                        long l = positionAndJson.copy$default$1();
                        throw new CorruptJournalException("Duplicate/nested transaction", this.journalFile, positionAndJson.copy(l, byteArray));
                    }
                    this.transaction.begin();
                    this.loop$1();
                    Option<Stamped<KeyedEvent<Event>>> option2 = this.transaction.readNext();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        Stamped stamped = (Stamped)some2.value();
                        if (this._totalEventCount != -1L) {
                            this._totalEventCount += (long)this.transaction.length();
                        }
                        return Some$.MODULE$.apply((Object)stamped);
                    }
                    if (None$.MODULE$.equals(option2)) continue;
                    throw new MatchError(option2);
                }
                Json json5 = JournalSeparators$.MODULE$.Commit();
                Json json6 = json;
                if (json5 == null) {
                    if (json6 == null) continue;
                    break;
                }
                if (!json5.equals(json6)) break;
            }
            ByteArray byteArray = CirceUtils$RichJson$.MODULE$.toByteArray$extension(CirceUtils$.MODULE$.RichJson((Json)positionAndJson.value()));
            long l = positionAndJson.copy$default$1();
            throw new CorruptJournalException("Unexpected JSON record", this.journalFile, positionAndJson.copy(l, byteArray));
        }
        throw new MatchError(option);
    }

    private Stamped<KeyedEvent<Event>> deserialize(Json json) {
        Either either = CirceUtils$.MODULE$.RichCirceEither(json.as(Stamped$.MODULE$.jsonDecoder(this.S.keyedEventJsonCodec())));
        Either either2 = Checked$.MODULE$.Ops(CirceUtils$RichCirceEither$.MODULE$.toChecked$extension(either));
        return (Stamped)Checked$Ops$.MODULE$.orThrow$extension(either2);
    }

    public long eventId() {
        return BoxesRunTime.unboxToLong((Object)this.positionAndEventId().value());
    }

    public long position() {
        return this.positionAndEventId().position();
    }

    public PositionAnd<Object> positionAndEventId() {
        PositionAnd positionAnd;
        JournalReader journalReader = this;
        synchronized (journalReader) {
            positionAnd = (PositionAnd)this.transaction.positionAndEventId().getOrElse(this::positionAndEventId$$anonfun$1);
        }
        return positionAnd;
    }

    public long totalEventCount() {
        return this._totalEventCount;
    }

    private static final PositionAnd $init$$$anonfun$1$$anonfun$1(Path journalFile$2) {
        throw scala.sys.package$.MODULE$.error("Journal file '" + journalFile$2 + "' is empty");
    }

    private final PositionAnd $init$$$anonfun$1(Path journalFile$1) {
        return (PositionAnd)this.jsonReader.readRaw().getOrElse(() -> JournalReader.$init$$$anonfun$1$$anonfun$1(journalFile$1));
    }

    private final Option $anonfun$1() {
        return this.nextSnapshotJson();
    }

    private final Option readSnapshotRaw$$anonfun$1() {
        return this.nextSnapshotRaw().map((Function1 & Serializable)_$1 -> (ByteArray)_$1.value());
    }

    private final PositionAnd $anonfun$2() {
        throw scala.sys.package$.MODULE$.error("Journal file '" + this.journalFile + "' is truncated in snapshot section");
    }

    private final Object seekEvent$$anonfun$1(PositionAnd positionAndEventId$1) {
        return "seek(" + positionAndEventId$1 + ") but fileEventId=" + this.fileEventId();
    }

    private final Option readEvents$$anonfun$1() {
        return this.nextEvent();
    }

    private final Option $anonfun$3() {
        return this.nextEvent2();
    }

    private final Option read$1() {
        Option<PositionAnd<Json>> option;
        try {
            option = this.jsonReader.read();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option2 = NonFatal$.MODULE$.unapply(throwable2);
            if (!option2.isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = (Throwable)option2.get();
                this.transaction.clear();
                throw t;
            }
            throw throwable;
        }
        return option;
    }

    private final void loop$1() {
        Option option;
        while (true) {
            if (None$.MODULE$.equals(option = this.read$1())) {
                this.transaction.clear();
                return;
            }
            if (!(option instanceof Some)) break;
            Some some = (Some)option;
            PositionAnd positionAnd = (PositionAnd)some.value();
            PositionAnd positionAnd2 = PositionAnd$.MODULE$.unapply(positionAnd);
            long l = positionAnd2._1();
            Json json = (Json)positionAnd2._2();
            Json json2 = JournalSeparators$.MODULE$.Commit();
            Json json3 = json;
            if (!(json2 != null ? !json2.equals(json3) : json3 != null)) {
                this.transaction.onCommit();
                return;
            }
            PositionAnd o = positionAnd;
            if (!((Json)o.value()).isObject()) {
                throw scala.sys.package$.MODULE$.error("Unexpected JSON value in transaction: " + o);
            }
            Stamped<KeyedEvent<Event>> stamped = this.deserialize((Json)o.value());
            long l2 = o.copy$default$1();
            this.transaction.add(o.copy(l2, stamped));
        }
        throw new MatchError((Object)option);
    }

    private final PositionAnd positionAndEventId$$anonfun$1() {
        return PositionAnd$.MODULE$.apply(this.jsonReader.position(), BoxesRunTime.boxToLong((long)this._eventId));
    }

    public static final class CorruptJournalException
    extends RuntimeException {
        public CorruptJournalException(String message, Path journalFile, PositionAnd<ByteArray> positionAndJson) {
            String string = ScalaUtils$syntax$.MODULE$.RichString(positionAndJson.value().utf8String());
            super("Journal file '" + journalFile + "' has an error at byte position " + positionAndJson.position() + ":" + (" " + message + " - JSON=" + ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$extension(string, 50, ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$2$extension(string), ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$3$extension(string), ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$4$extension(string))));
        }
    }
}

