/*
 * Decompiled with CFR 0.152.
 */
package js7.journal.recover;

import java.io.Serializable;
import java.nio.file.Path;
import js7.base.scalasource.ScalaSourceLocation$;
import js7.base.utils.Assertions$;
import js7.data.event.JournalHeader;
import js7.data.event.JournalId;
import js7.data.event.JournalPosition;
import js7.data.event.JournalPosition$;
import js7.data.event.SnapshotableState;
import js7.journal.recover.RecoveredJournalFile$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import sourcecode.FullName$;
import sourcecode.Text;
import sourcecode.Text$;

public final class RecoveredJournalFile<S extends SnapshotableState<S>>
implements Product,
Serializable {
    private final Path file;
    private final long length;
    private final long lastProperEventPosition;
    private final JournalHeader journalHeader;
    private final JournalHeader nextJournalHeader;
    private final long firstEventPosition;
    private final S state;

    public static <S extends SnapshotableState<S>> RecoveredJournalFile<S> apply(Path path, long l, long l2, JournalHeader journalHeader, JournalHeader journalHeader2, long l3, S s) {
        return RecoveredJournalFile$.MODULE$.apply(path, l, l2, journalHeader, journalHeader2, l3, s);
    }

    public static RecoveredJournalFile<?> fromProduct(Product product) {
        return RecoveredJournalFile$.MODULE$.fromProduct(product);
    }

    public static <S extends SnapshotableState<S>> RecoveredJournalFile<S> unapply(RecoveredJournalFile<S> recoveredJournalFile) {
        return RecoveredJournalFile$.MODULE$.unapply(recoveredJournalFile);
    }

    public RecoveredJournalFile(Path file, long length, long lastProperEventPosition, JournalHeader journalHeader, JournalHeader nextJournalHeader, long firstEventPosition, S state) {
        this.file = file;
        this.length = length;
        this.lastProperEventPosition = lastProperEventPosition;
        this.journalHeader = journalHeader;
        this.nextJournalHeader = nextJournalHeader;
        this.firstEventPosition = firstEventPosition;
        this.state = state;
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)RecoveredJournalFile.v$proxy1$1(journalHeader, nextJournalHeader)), "journalHeader.journalId == nextJournalHeader.journalId"), FullName$.MODULE$.apply("js7.journal.recover.RecoveredJournalFile"), ScalaSourceLocation$.MODULE$.apply("RecoveredJournalFile.scala", 21));
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)RecoveredJournalFile.v$proxy2$1(journalHeader, nextJournalHeader)), "journalHeader.eventId < nextJournalHeader.eventId"), FullName$.MODULE$.apply("js7.journal.recover.RecoveredJournalFile"), ScalaSourceLocation$.MODULE$.apply("RecoveredJournalFile.scala", 22));
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)RecoveredJournalFile.v$proxy3$1(journalHeader, nextJournalHeader)), "journalHeader.totalEventCount < nextJournalHeader.totalEventCount"), FullName$.MODULE$.apply("js7.journal.recover.RecoveredJournalFile"), ScalaSourceLocation$.MODULE$.apply("RecoveredJournalFile.scala", 23));
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)-758161296);
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.file()));
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.length()));
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.lastProperEventPosition()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.journalHeader()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.nextJournalHeader()));
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.firstEventPosition()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.state()));
        return Statics.finalizeHash((int)n, (int)7);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        RecoveredJournalFile recoveredJournalFile;
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof RecoveredJournalFile)) return false;
        RecoveredJournalFile recoveredJournalFile2 = recoveredJournalFile = (RecoveredJournalFile)object;
        if (this.length() != recoveredJournalFile2.length()) return false;
        if (this.lastProperEventPosition() != recoveredJournalFile2.lastProperEventPosition()) return false;
        if (this.firstEventPosition() != recoveredJournalFile2.firstEventPosition()) return false;
        Path path = this.file();
        Path path2 = recoveredJournalFile2.file();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!((Object)path).equals(path2)) return false;
        JournalHeader journalHeader = this.journalHeader();
        JournalHeader journalHeader2 = recoveredJournalFile2.journalHeader();
        if (journalHeader == null) {
            if (journalHeader2 != null) {
                return false;
            }
        } else if (!((Object)journalHeader).equals(journalHeader2)) return false;
        JournalHeader journalHeader3 = this.nextJournalHeader();
        JournalHeader journalHeader4 = recoveredJournalFile2.nextJournalHeader();
        if (journalHeader3 == null) {
            if (journalHeader4 != null) {
                return false;
            }
        } else if (!((Object)journalHeader3).equals(journalHeader4)) return false;
        S s = this.state();
        S s2 = recoveredJournalFile2.state();
        if (s == null) {
            if (s2 == null) return true;
            return false;
        } else {
            if (!s.equals(s2)) return false;
            return true;
        }
    }

    public boolean canEqual(Object that) {
        return that instanceof RecoveredJournalFile;
    }

    public int productArity() {
        return 7;
    }

    public String productPrefix() {
        return "RecoveredJournalFile";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return BoxesRunTime.boxToLong((long)this._2());
            }
            case 2: {
                return BoxesRunTime.boxToLong((long)this._3());
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return BoxesRunTime.boxToLong((long)this._6());
            }
            case 6: {
                return this._7();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "file";
            }
            case 1: {
                return "length";
            }
            case 2: {
                return "lastProperEventPosition";
            }
            case 3: {
                return "journalHeader";
            }
            case 4: {
                return "nextJournalHeader";
            }
            case 5: {
                return "firstEventPosition";
            }
            case 6: {
                return "state";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Path file() {
        return this.file;
    }

    public long length() {
        return this.length;
    }

    public long lastProperEventPosition() {
        return this.lastProperEventPosition;
    }

    public JournalHeader journalHeader() {
        return this.journalHeader;
    }

    public JournalHeader nextJournalHeader() {
        return this.nextJournalHeader;
    }

    public long firstEventPosition() {
        return this.firstEventPosition;
    }

    public S state() {
        return this.state;
    }

    public JournalId journalId() {
        return this.journalHeader().journalId();
    }

    public long fileEventId() {
        return this.journalHeader().eventId();
    }

    public long eventId() {
        return this.nextJournalHeader().eventId();
    }

    public JournalPosition journalPosition() {
        return JournalPosition$.MODULE$.apply(this.fileEventId(), this.length());
    }

    public String toString() {
        return "RecoveredJournalFile(" + this.file() + " (" + this.length() + " bytes)," + this.journalHeader() + "," + this.firstEventPosition() + "," + this.state() + "," + this.nextJournalHeader() + ")";
    }

    public <S extends SnapshotableState<S>> RecoveredJournalFile<S> copy(Path file, long length, long lastProperEventPosition, JournalHeader journalHeader, JournalHeader nextJournalHeader, long firstEventPosition, S state) {
        return new RecoveredJournalFile<S>(file, length, lastProperEventPosition, journalHeader, nextJournalHeader, firstEventPosition, state);
    }

    public <S extends SnapshotableState<S>> Path copy$default$1() {
        return this.file();
    }

    public long copy$default$2() {
        return this.length();
    }

    public long copy$default$3() {
        return this.lastProperEventPosition();
    }

    public <S extends SnapshotableState<S>> JournalHeader copy$default$4() {
        return this.journalHeader();
    }

    public <S extends SnapshotableState<S>> JournalHeader copy$default$5() {
        return this.nextJournalHeader();
    }

    public long copy$default$6() {
        return this.firstEventPosition();
    }

    public <S extends SnapshotableState<S>> S copy$default$7() {
        return this.state();
    }

    public Path _1() {
        return this.file();
    }

    public long _2() {
        return this.length();
    }

    public long _3() {
        return this.lastProperEventPosition();
    }

    public JournalHeader _4() {
        return this.journalHeader();
    }

    public JournalHeader _5() {
        return this.nextJournalHeader();
    }

    public long _6() {
        return this.firstEventPosition();
    }

    public S _7() {
        return this.state();
    }

    private static final boolean v$proxy1$1(JournalHeader journalHeader$2, JournalHeader nextJournalHeader$2) {
        JournalId journalId = journalHeader$2.journalId();
        JournalId journalId2 = nextJournalHeader$2.journalId();
        return !(journalId != null ? !((Object)journalId).equals(journalId2) : journalId2 != null);
    }

    private static final boolean v$proxy2$1(JournalHeader journalHeader$3, JournalHeader nextJournalHeader$3) {
        return journalHeader$3.eventId() < nextJournalHeader$3.eventId();
    }

    private static final boolean v$proxy3$1(JournalHeader journalHeader$4, JournalHeader nextJournalHeader$4) {
        return journalHeader$4.totalEventCount() < nextJournalHeader$4.totalEventCount();
    }
}

