/*
 * Decompiled with CFR 0.152.
 */
package js7.launcher.process;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import js7.base.io.file.FileDeleter$;
import js7.base.io.file.FileUtils$syntax$;
import js7.base.io.file.FileUtils$syntax$RichPath$;
import js7.base.io.process.Processes$;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.base.system.OperatingSystem$;
import js7.base.utils.ScalaUtils$;
import js7.data.job.JobConf;
import js7.data.job.ShellScriptExecutable;
import js7.launcher.configuration.JobLauncherConf;
import js7.launcher.configuration.Problems$SignedInjectionNotAllowed$;
import js7.launcher.forwindows.WindowsProcess$;
import js7.launcher.forwindows.WindowsUserName;
import js7.launcher.process.ShellScriptJobLauncher;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.matching.Regex;

public final class ShellScriptJobLauncher$
implements Serializable {
    private static final Regex crRegex;
    public static final ShellScriptJobLauncher$ MODULE$;

    private ShellScriptJobLauncher$() {
    }

    static {
        MODULE$ = new ShellScriptJobLauncher$();
        crRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\r?\n"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ShellScriptJobLauncher$.class);
    }

    public Either<Problem, ShellScriptJobLauncher> checked(ShellScriptExecutable executable, JobConf jobConf, JobLauncherConf launcherConf) {
        if (!launcherConf.scriptInjectionAllowed()) {
            return package$.MODULE$.Left().apply((Object)Problems$SignedInjectionNotAllowed$.MODULE$);
        }
        return package$.MODULE$.Right().apply((Object)new ShellScriptJobLauncher(executable, jobConf, launcherConf));
    }

    public Either<Problem, Path> writeScriptToFile(String script, Path tmpDir, Charset encoding, Option<WindowsUserName> userName, boolean isWindows) {
        return Checked$.MODULE$.catchNonFatal(() -> ShellScriptJobLauncher$.writeScriptToFile$$anonfun$1(isWindows, tmpDir)).flatMap((Function1 & Serializable)file -> Checked$.MODULE$.catchNonFatal((Function0 & Serializable)() -> {
            ShellScriptJobLauncher$.writeScriptToFile$$anonfun$2$$anonfun$1(isWindows, script, file, encoding);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)_$1 -> MODULE$.makeFileUserAccessible(userName, (Path)file)).left().map((Function1 & Serializable)problem -> {
            FileDeleter$.MODULE$.tryDeleteFile((Path)file);
            return problem;
        }).map((Function1 & Serializable)_$2 -> file));
    }

    public boolean writeScriptToFile$default$5() {
        return OperatingSystem$.MODULE$.isWindows();
    }

    private Either<Problem, BoxedUnit> makeFileUserAccessible(Option<WindowsUserName> userName, Path file) {
        Option<WindowsUserName> option = userName;
        if (option instanceof Some) {
            Some some = (Some)option;
            WindowsUserName userName2 = (WindowsUserName)some.value();
            if (OperatingSystem$.MODULE$.isWindows()) {
                return Checked$.MODULE$.catchNonFatal((Function0 & Serializable)() -> {
                    ShellScriptJobLauncher$.makeFileUserAccessible$$anonfun$1(file, userName2);
                    return BoxedUnit.UNIT;
                });
            }
        }
        return ScalaUtils$.MODULE$.RightUnit();
    }

    private static final Path writeScriptToFile$$anonfun$1(boolean isWindows$1, Path tmpDir$1) {
        String ext = isWindows$1 ? ".cmd" : ".sh";
        return Files.createTempFile(tmpDir$1, "script-", ext, (FileAttribute[])Arrays$.MODULE$.seqToArray(Processes$.MODULE$.ShellFileAttributes(), FileAttribute.class));
    }

    private static final void writeScriptToFile$$anonfun$2$$anonfun$1(boolean isWindows$3, String script$2, Path file$1, Charset encoding$2) {
        String scrpt = isWindows$3 ? crRegex.replaceAllIn((CharSequence)script$2, "\r\n") : script$2;
        Path path = FileUtils$syntax$.MODULE$.RichPath(file$1);
        FileUtils$syntax$RichPath$.MODULE$.write$extension(path, scrpt, encoding$2, FileUtils$syntax$RichPath$.MODULE$.write$default$3$extension(path));
    }

    private static final void makeFileUserAccessible$$anonfun$1(Path file$5, WindowsUserName userName$3) {
        WindowsProcess$.MODULE$.makeFileExecutableForUser(file$5, userName$3);
    }
}

