/*
 * Decompiled with CFR 0.152.
 */
package js7.service.pgp;

import cats.Bifunctor$;
import cats.implicits$;
import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import js7.base.crypt.GenericSignature;
import js7.base.crypt.SignatureVerifier;
import js7.base.crypt.pgp.PgpSignature;
import js7.base.crypt.pgp.PgpSignature$;
import js7.base.data.ByteArray;
import js7.base.log.Logger$package$Logger$;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.scalasource.ScalaSourceLocation$;
import js7.base.utils.Assertions$;
import js7.base.utils.IntelliJUtils$;
import js7.base.utils.Labeled;
import js7.service.pgp.PgpCommons$;
import js7.service.pgp.PgpSignatureVerifier;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import scala.Function0;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import sourcecode.FullName$;
import sourcecode.Text;
import sourcecode.Text$;

public final class PgpSignatureVerifier$
implements SignatureVerifier.Companion,
Serializable {
    private static final String typeName;
    private static final String filenameExtension;
    private static final String recommendedKeyDirectoryName;
    public static final Logger js7$service$pgp$PgpSignatureVerifier$$$logger;
    public static final PgpSignatureVerifier$ MODULE$;

    private PgpSignatureVerifier$() {
    }

    static {
        MODULE$ = new PgpSignatureVerifier$();
        typeName = PgpSignature$.MODULE$.TypeName();
        filenameExtension = ".asc";
        recommendedKeyDirectoryName = "trusted-pgp-keys";
        js7$service$pgp$PgpSignatureVerifier$$$logger = Logger$package$Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(PgpSignatureVerifier$.class));
        IntelliJUtils$.MODULE$.intelliJuseImport((Function0<Object>)((Function0 & Serializable)MODULE$::$init$$$anonfun$1));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PgpSignatureVerifier$.class);
    }

    @Override
    public String typeName() {
        return typeName;
    }

    @Override
    public String filenameExtension() {
        return filenameExtension;
    }

    @Override
    public String recommendedKeyDirectoryName() {
        return recommendedKeyDirectoryName;
    }

    public Either<Problem, PgpSignatureVerifier> checked(Seq<Labeled<ByteArray>> publicKeys, String origin) {
        return PgpCommons$.MODULE$.readPublicKeyRingCollection(publicKeys).map((Function1 & Serializable)_$2 -> new PgpSignatureVerifier((PGPPublicKeyRingCollection)_$2, origin));
    }

    @Override
    public PgpSignatureVerifier ignoreInvalid(Seq<Labeled<ByteArray>> publicKeys, String origin) {
        return new PgpSignatureVerifier(PgpCommons$.MODULE$.readOrIgnorePublicKeyRingCollection(publicKeys), origin);
    }

    public Either<Problem, PgpSignature> genericSignatureToSignature(GenericSignature signature) {
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy1$1(signature)), "signature.typeName == typeName"), FullName$.MODULE$.apply("js7.service.pgp.PgpSignatureVerifier.genericSignatureToSignature"), ScalaSourceLocation$.MODULE$.apply("PgpSignatureVerifier.scala", 99));
        if (signature.signerId().isDefined()) {
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)PgpSignatureVerifier$::genericSignatureToSignature$$anonfun$1), Problem$.MODULE$.apply$default$2()));
        }
        if (signature.algorithm().isDefined()) {
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)PgpSignatureVerifier$::genericSignatureToSignature$$anonfun$2), Problem$.MODULE$.apply$default$2()));
        }
        if (signature.signerCertificate().isDefined()) {
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)PgpSignatureVerifier$::genericSignatureToSignature$$anonfun$3), Problem$.MODULE$.apply$default$2()));
        }
        PgpSignature pgpSignature = PgpSignature$.MODULE$.apply(signature.signatureString());
        return this.toMutablePGPSignature(pgpSignature).map((Function1 & Serializable)x$1 -> {
            PGPSignature pGPSignature = x$1;
            return pgpSignature;
        });
    }

    public Either<Problem, PGPSignature> toMutablePGPSignature(PgpSignature signature) {
        return ((Either)implicits$.MODULE$.toBifunctorOps(Checked$.MODULE$.catchNonFatal(() -> PgpSignatureVerifier$.toMutablePGPSignature$$anonfun$1(signature)), Bifunctor$.MODULE$.catsBifunctorForEither()).leftMap((Function1 & Serializable)_$3 -> _$3.withPrefix("Invalid PGP signature: "))).flatMap((Function1 & Serializable)x$1 -> {
            block3: {
                Object object = x$1;
                if (object instanceof PGPSignatureList) {
                    PGPSignatureList pGPSignatureList = (PGPSignatureList)object;
                    PGPSignatureList o = pGPSignatureList;
                    if (o.size() != 1) {
                        return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> PgpSignatureVerifier$.toMutablePGPSignature$$anonfun$3$$anonfun$1(o)), Problem$.MODULE$.apply$default$2()));
                    }
                    return package$.MODULE$.Right().apply((Object)o.get(0));
                }
                if (object == null) {
                    return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)PgpSignatureVerifier$::toMutablePGPSignature$$anonfun$3$$anonfun$2), Problem$.MODULE$.apply$default$2()));
                }
                Object o = object;
                Logger LoggerImpl_this = js7$service$pgp$PgpSignatureVerifier$$$logger;
                if (!LoggerImpl_this.underlying().isWarnEnabled()) break block3;
                LoggerImpl_this.underlying().warn("Unsupported PGP signature type: {} {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{o.getClass().getName(), o}), Object.class));
            }
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)PgpSignatureVerifier$::toMutablePGPSignature$$anonfun$3$$anonfun$3), Problem$.MODULE$.apply$default$2()));
        });
    }

    private final Object $init$$$anonfun$1() {
        return PgpCommons$.MODULE$.PGPPublicKeyShow();
    }

    private final boolean v$proxy1$1(GenericSignature signature$1) {
        String string = signature$1.typeName();
        String string2 = this.typeName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final String genericSignatureToSignature$$anonfun$1() {
        return "PGP signature does not accept a signerId";
    }

    private static final String genericSignatureToSignature$$anonfun$2() {
        return "PGP signature does not accept a signature algorithm";
    }

    private static final String genericSignatureToSignature$$anonfun$3() {
        return "PGP signature does not accept a signed certificate";
    }

    private static final Object toMutablePGPSignature$$anonfun$1(PgpSignature signature$2) {
        return new JcaPGPObjectFactory(PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(signature$2.string().getBytes(StandardCharsets.UTF_8)))).nextObject();
    }

    private static final String toMutablePGPSignature$$anonfun$3$$anonfun$1(PGPSignatureList o$1) {
        return "Unsupported PGP signature type: exactly one PGPSignature expected, not " + o$1.size();
    }

    private static final String toMutablePGPSignature$$anonfun$3$$anonfun$2() {
        return "Not a valid PGP signature";
    }

    private static final String toMutablePGPSignature$$anonfun$3$$anonfun$3() {
        return "Unsupported PGP signature type";
    }
}

