/*
 * Decompiled with CFR 0.152.
 */
package js7.subagent.director;

import cats.effect.IO;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.utils.Allocated;
import js7.base.utils.Collections$;
import js7.base.utils.Collections$RichMap$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichScalaUtilsMap$;
import js7.data.subagent.SubagentBundle;
import js7.data.subagent.SubagentBundleId;
import js7.data.subagent.SubagentId;
import js7.data.subagent.SubagentItem;
import js7.data.value.NumberValue;
import js7.data.value.Value$package$MissingValue$;
import js7.data.value.expression.Expression;
import js7.data.value.expression.Scope;
import js7.data.value.expression.Scope$;
import js7.subagent.configuration.DirectorConf;
import js7.subagent.director.DirectorState$;
import js7.subagent.director.DirectorState$BundleEntry$;
import js7.subagent.director.DirectorState$SubagentEntry$;
import js7.subagent.director.SubagentDriver;
import js7.subagent.director.priority.Prioritized;
import js7.subagent.director.priority.Prioritized$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.MapOps;
import scala.collection.MapView;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Right$;
import scala.util.hashing.MurmurHash3$;
import sourcecode.FileName$;
import sourcecode.Line$;

public final class DirectorState
implements Product,
Serializable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DirectorState.class.getDeclaredField("bundlelessRoundRobin$lzy1"));
    private final Map<SubagentId, SubagentEntry> subagentToEntry;
    private final Map<SubagentBundleId, BundleEntry> bundleToEntry;
    private final DirectorConf conf;
    private volatile Object bundlelessRoundRobin$lzy1;
    private final MapView<SubagentId, SubagentDriver> idToDriver;

    public static DirectorState fromProduct(Product product) {
        return DirectorState$.MODULE$.fromProduct(product);
    }

    public static DirectorState initial(DirectorConf directorConf) {
        return DirectorState$.MODULE$.initial(directorConf);
    }

    public static DirectorState unapply(DirectorState directorState) {
        return DirectorState$.MODULE$.unapply(directorState);
    }

    public DirectorState(Map<SubagentId, SubagentEntry> subagentToEntry, Map<SubagentBundleId, BundleEntry> bundleToEntry, DirectorConf conf) {
        this.subagentToEntry = subagentToEntry;
        this.bundleToEntry = bundleToEntry;
        this.conf = conf;
        this.idToDriver = subagentToEntry.view().mapValues((Function1 & Serializable)_$1 -> _$1.driver());
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, 1021216343, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        DirectorState directorState;
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof DirectorState)) return false;
        DirectorState directorState2 = directorState = (DirectorState)object;
        Map<SubagentId, SubagentEntry> map = this.subagentToEntry();
        Map<SubagentId, SubagentEntry> map2 = directorState2.subagentToEntry();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Map<SubagentBundleId, BundleEntry> map3 = this.bundleToEntry();
        Map<SubagentBundleId, BundleEntry> map4 = directorState2.bundleToEntry();
        if (map3 == null) {
            if (map4 != null) {
                return false;
            }
        } else if (!map3.equals(map4)) return false;
        DirectorConf directorConf = this.conf();
        DirectorConf directorConf2 = directorState2.conf();
        if (directorConf == null) {
            if (directorConf2 == null) return true;
            return false;
        } else {
            if (!((Object)directorConf).equals(directorConf2)) return false;
            return true;
        }
    }

    public boolean canEqual(Object that) {
        return that instanceof DirectorState;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "DirectorState";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "subagentToEntry";
            }
            case 1: {
                return "bundleToEntry";
            }
            case 2: {
                return "conf";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Map<SubagentId, SubagentEntry> subagentToEntry() {
        return this.subagentToEntry;
    }

    private Map<SubagentBundleId, BundleEntry> bundleToEntry() {
        return this.bundleToEntry;
    }

    public DirectorConf conf() {
        return this.conf;
    }

    private Prioritized<SubagentId> bundlelessRoundRobin() {
        Object object = this.bundlelessRoundRobin$lzy1;
        if (object instanceof Prioritized) {
            return (Prioritized)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Prioritized)this.bundlelessRoundRobin$lzyINIT1();
    }

    private Object bundlelessRoundRobin$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.bundlelessRoundRobin$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Prioritized prioritized = null;
                    try {
                        prioritized = Prioritized$.MODULE$.roundRobin(this.subagentToEntry().keys().toVector());
                        object2 = prioritized == null ? LazyVals.NullValue$.MODULE$ : prioritized;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.bundlelessRoundRobin$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return prioritized;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public MapView<SubagentId, SubagentDriver> idToDriver() {
        return this.idToDriver;
    }

    public MapView<SubagentId, Allocated<IO, SubagentDriver>> idToAllocatedDriver() {
        return this.subagentToEntry().view().mapValues((Function1 & Serializable)_$2 -> _$2.allocatedDriver());
    }

    public Either<Problem, DirectorState> insertSubagentDriver(Allocated<IO, SubagentDriver> allocatedDriver, boolean disabled) {
        Logger LoggerImpl_this = DirectorState$.js7$subagent$director$DirectorState$$$logger;
        if (LoggerImpl_this.underlying().isTraceEnabled()) {
            LoggerImpl_this.underlying().trace("insertSubagentDriver", (Object)(allocatedDriver + ", disabled=" + disabled));
        }
        SubagentDriver driver = allocatedDriver.allocatedThing();
        SubagentId subagentId = driver.subagentId();
        Map map = Collections$.MODULE$.RichMap(this.subagentToEntry());
        SubagentId subagentId2 = (SubagentId)Predef$.MODULE$.ArrowAssoc((Object)subagentId);
        return Collections$RichMap$.MODULE$.insert$extension(map, Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)subagentId2, (Object)DirectorState$SubagentEntry$.MODULE$.apply(allocatedDriver, disabled))).map((Function1 & Serializable)idToE -> this.copy((Map<SubagentId, SubagentEntry>)idToE, this.copy$default$2(), this.copy$default$3()));
    }

    public boolean insertSubagentDriver$default$2() {
        return false;
    }

    public Either<Problem, DirectorState> replaceSubagentDriver(Allocated<IO, SubagentDriver> allocatedDriver, SubagentItem subagentItem) {
        Logger LoggerImpl_this = DirectorState$.js7$subagent$director$DirectorState$$$logger;
        if (LoggerImpl_this.underlying().isTraceEnabled()) {
            LoggerImpl_this.underlying().trace("replaceSubagentDriver", (Object)(allocatedDriver + ", " + subagentItem));
        }
        SubagentDriver driver = allocatedDriver.allocatedThing();
        SubagentId subagentId = driver.subagentId();
        if (!this.subagentToEntry().contains((Object)subagentId)) {
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> DirectorState.replaceSubagentDriver$$anonfun$1(subagentId)), Problem$.MODULE$.apply$default$2()));
        }
        return package$.MODULE$.Right().apply((Object)this.copy((Map<SubagentId, SubagentEntry>)((Map)this.subagentToEntry().updated((Object)subagentId, (Object)DirectorState$SubagentEntry$.MODULE$.apply(allocatedDriver, subagentItem.disabled()))), this.copy$default$2(), this.copy$default$3()));
    }

    public DirectorState removeSubagent(SubagentId subagentId) {
        block0: {
            Logger LoggerImpl_this = DirectorState$.js7$subagent$director$DirectorState$$$logger;
            if (!LoggerImpl_this.underlying().isTraceEnabled()) break block0;
            LoggerImpl_this.underlying().trace("removeSubagent", (Object)subagentId);
        }
        return this.copy((Map<SubagentId, SubagentEntry>)((Map)this.subagentToEntry().removed((Object)subagentId)), this.copy$default$2(), this.copy$default$3());
    }

    public Either<Problem, DirectorState> setDisabled(SubagentId id, boolean disabled) {
        block0: {
            Logger LoggerImpl_this = DirectorState$.js7$subagent$director$DirectorState$$$logger;
            if (!LoggerImpl_this.underlying().isTraceEnabled()) break block0;
            LoggerImpl_this.underlying().trace("setDisabled {}, disabled={}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{id, BoxesRunTime.boxToBoolean((boolean)disabled)}), Object.class));
        }
        return package$.MODULE$.Right().apply(this.subagentToEntry().get((Object)id).filter((Function1 & Serializable)_$3 -> _$3.disabled() != disabled).fold(this::setDisabled$$anonfun$2, (Function1 & Serializable)entry -> this.copy((Map<SubagentId, SubagentEntry>)((Map)this.subagentToEntry().updated((Object)id, (Object)entry.copy(entry.copy$default$1(), disabled))), this.copy$default$2(), this.copy$default$3())));
    }

    public Either<Problem, DirectorState> insertOrReplaceBundle(SubagentBundle bundle) {
        Logger LoggerImpl_this = DirectorState$.js7$subagent$director$DirectorState$$$logger;
        if (LoggerImpl_this.underlying().isTraceEnabled()) {
            LoggerImpl_this.underlying().trace("insertOrReplaceBundle {}", (Object)bundle);
        }
        Map map = (Map)this.bundleToEntry().updated((Object)bundle.id(), (Object)DirectorState$BundleEntry$.MODULE$.apply(bundle, (Map<SubagentId, Expression>)((Map)bundle.subagentToPriority().map((Function1 & Serializable)x$1 -> {
            SubagentId subagentId = (SubagentId)x$1._1();
            Expression expression = (Expression)x$1._2();
            SubagentId subagentId2 = (SubagentId)Predef$.MODULE$.ArrowAssoc((Object)subagentId);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)subagentId2, (Object)expression);
        }))));
        Map<SubagentId, SubagentEntry> map2 = this.copy$default$1();
        DirectorConf directorConf = this.copy$default$3();
        return package$.MODULE$.Right().apply((Object)this.copy(map2, (Map<SubagentBundleId, BundleEntry>)map, directorConf));
    }

    public DirectorState removeBundle(SubagentBundleId bundleId) {
        Logger LoggerImpl_this = DirectorState$.js7$subagent$director$DirectorState$$$logger;
        if (LoggerImpl_this.underlying().isTraceEnabled()) {
            LoggerImpl_this.underlying().trace("removeBundle", (Object)bundleId);
        }
        Map map = (Map)this.bundleToEntry().$minus((Object)bundleId);
        Map<SubagentId, SubagentEntry> map2 = this.copy$default$1();
        DirectorConf directorConf = this.copy$default$3();
        return this.copy(map2, (Map<SubagentBundleId, BundleEntry>)map, directorConf);
    }

    public DirectorState clear() {
        block0: {
            Logger LoggerImpl_this = DirectorState$.js7$subagent$director$DirectorState$$$logger;
            if (!LoggerImpl_this.underlying().isTraceEnabled()) break block0;
            LoggerImpl_this.underlying().trace("clear");
        }
        return this.copy((Map<SubagentId, SubagentEntry>)Predef$.MODULE$.Map().empty(), (Map<SubagentBundleId, BundleEntry>)Predef$.MODULE$.Map().empty(), this.copy$default$3());
    }

    public Either<Problem, Option<SubagentDriver>> selectNext(Option<SubagentBundleId> maybeBundleId, Scope scope) {
        Some some;
        Option<SubagentBundleId> option = maybeBundleId;
        if (option instanceof Some) {
            Some some2 = (Some)option;
            SubagentBundleId bundleId = (SubagentBundleId)some2.value();
            if (!this.bundleToEntry().contains((Object)bundleId)) {
                MapOps mapOps = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(this.subagentToEntry());
                return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(mapOps, bundleId.toSubagentId(), Tag$.MODULE$.apply(SubagentId.class, LightTypeTag$.MODULE$.parse(1047864088, "\u0004\u0000\u0001\u001cjs7.data.subagent.SubagentId\u0001\u0001", "\u0000\b\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.UnsignedItemKey\u0001\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u001cjs7.data.delegate.DelegateId\u0001\u0001\u0007\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u001cjs7.data.item.SimpleItemPath\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.UnsignedItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001$js7.data.item.UnsignedSimpleItemPath\u0001\u0001\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0002\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0006\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u001cjs7.data.subagent.SubagentId\u0001\u0001\f\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\b\u0001\u0001\u0001\u0000\u0001\u0090\f\u0001\u0001\f\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\r\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u000e\u0001\u0002\u0003\u0000\u0000\u0090\b\u0001\u0001", 30)), FileName$.MODULE$.apply("DirectorState.scala"), Line$.MODULE$.apply(104)).map((Function1 & Serializable)o -> Some$.MODULE$.apply((Object)o.driver()));
            }
        }
        Right$ right$ = package$.MODULE$.Right();
        Option<SubagentBundleId> option2 = maybeBundleId;
        if (None$.MODULE$.equals(option2)) {
            some = Some$.MODULE$.apply(this.bundlelessRoundRobin());
        } else if (option2 instanceof Some) {
            Some some3 = (Some)option2;
            SubagentBundleId bundleId = (SubagentBundleId)some3.value();
            some = this.bundleToEntry().get((Object)bundleId).map((Function1 & Serializable)entry -> {
                if (entry.subagentBundle().allPrioritiesArePure()) {
                    return entry.cachedStaticPrioritized(scope);
                }
                return entry.cachedDynamicPrioritized((Function1<SubagentId, Option<Scope>>)(Function1 & Serializable)subagentId -> this.idToDriver().get(subagentId).flatMap((Function1 & Serializable)driver -> driver.serverMeteringScope().map((Function1 & Serializable)_$4 -> (Scope)package.monoid$.MODULE$.catsSyntaxSemigroup(package.monoid$.MODULE$.catsSyntaxSemigroup(_$4, Scope$.MODULE$.given_Monoid_Scope()).$bar$plus$bar((Object)driver.subagentProcessCountScope()), Scope$.MODULE$.given_Monoid_Scope()).$bar$plus$bar((Object)scope))));
            });
        } else {
            throw new MatchError(option2);
        }
        return right$.apply((Object)some.flatMap((Function1 & Serializable)prioritized -> prioritized.selectNext((Function1 & Serializable)subagentId -> this.isAvailable((SubagentId)subagentId)).flatMap((Function1 & Serializable)subagentId -> this.subagentToEntry().get(subagentId).map((Function1 & Serializable)_$5 -> _$5.driver()))));
    }

    private boolean isAvailable(SubagentId subagentId) {
        return BoxesRunTime.unboxToBoolean((Object)this.subagentToEntry().get((Object)subagentId).fold(DirectorState::isAvailable$$anonfun$1, (Function1 & Serializable)_$6 -> _$6.isAvailable()));
    }

    public String toString() {
        return "DirectorState(" + this.subagentToEntry().values().toSeq() + ", " + this.bundleToEntry() + ")";
    }

    private DirectorState copy(Map<SubagentId, SubagentEntry> subagentToEntry, Map<SubagentBundleId, BundleEntry> bundleToEntry, DirectorConf conf) {
        return new DirectorState(subagentToEntry, bundleToEntry, conf);
    }

    private Map<SubagentId, SubagentEntry> copy$default$1() {
        return this.subagentToEntry();
    }

    private Map<SubagentBundleId, BundleEntry> copy$default$2() {
        return this.bundleToEntry();
    }

    private DirectorConf copy$default$3() {
        return this.conf();
    }

    public Map<SubagentId, SubagentEntry> _1() {
        return this.subagentToEntry();
    }

    public Map<SubagentBundleId, BundleEntry> _2() {
        return this.bundleToEntry();
    }

    public DirectorConf _3() {
        return this.conf();
    }

    private static final String replaceSubagentDriver$$anonfun$1(SubagentId subagentId$1) {
        return "Replacing unknown " + subagentId$1 + " SubagentDriver";
    }

    private final DirectorState setDisabled$$anonfun$2() {
        return this;
    }

    private static final boolean isAvailable$$anonfun$1() {
        return false;
    }

    public static final class BundleEntry
    implements Product,
    Serializable {
        private final SubagentBundle subagentBundle;
        private final Map<SubagentId, Expression> subagentToExpr;
        private final AtomicReference<Prioritized> _cachedPrioritized;

        public static BundleEntry apply(SubagentBundle subagentBundle, Map<SubagentId, Expression> map) {
            return DirectorState$BundleEntry$.MODULE$.apply(subagentBundle, map);
        }

        public static BundleEntry fromProduct(Product product) {
            return DirectorState$BundleEntry$.MODULE$.fromProduct(product);
        }

        public static BundleEntry unapply(BundleEntry bundleEntry) {
            return DirectorState$BundleEntry$.MODULE$.unapply(bundleEntry);
        }

        public BundleEntry(SubagentBundle subagentBundle, Map<SubagentId, Expression> subagentToExpr) {
            this.subagentBundle = subagentBundle;
            this.subagentToExpr = subagentToExpr;
            Object initial$proxy1 = null;
            this._cachedPrioritized = new AtomicReference<Object>(initial$proxy1);
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -1401882469, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            BundleEntry bundleEntry;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BundleEntry)) return false;
            BundleEntry bundleEntry2 = bundleEntry = (BundleEntry)object;
            SubagentBundle subagentBundle = this.subagentBundle();
            SubagentBundle subagentBundle2 = bundleEntry2.subagentBundle();
            if (subagentBundle == null) {
                if (subagentBundle2 != null) {
                    return false;
                }
            } else if (!((Object)subagentBundle).equals(subagentBundle2)) return false;
            Map<SubagentId, Expression> map = this.subagentToExpr();
            Map<SubagentId, Expression> map2 = bundleEntry2.subagentToExpr();
            if (map == null) {
                if (map2 == null) return true;
                return false;
            } else {
                if (!map.equals(map2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof BundleEntry;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "BundleEntry";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "subagentBundle";
            }
            if (1 == n2) {
                return "subagentToExpr";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public SubagentBundle subagentBundle() {
            return this.subagentBundle;
        }

        public Map<SubagentId, Expression> subagentToExpr() {
            return this.subagentToExpr;
        }

        public Prioritized<SubagentId> cachedStaticPrioritized(Scope scope) {
            Prioritized prioritized = this._cachedPrioritized.get();
            if (prioritized == null) {
                Prioritized<SubagentId> prioritized2 = this.mkPrioritized((Function1<SubagentId, Option<Scope>>)((Function1 & Serializable)arg_0 -> DirectorState$.js7$subagent$director$DirectorState$BundleEntry$$_$_$$anonfun$2(scope, arg_0)));
                Prioritized<SubagentId> prioritized3 = this._cachedPrioritized.compareAndExchange(null, prioritized2);
                if (prioritized3 == null) {
                    Logger LoggerImpl_this = DirectorState$.js7$subagent$director$DirectorState$$$logger;
                    if (LoggerImpl_this.underlying().isTraceEnabled()) {
                        LoggerImpl_this.underlying().trace("cachedPrioritized: {} new {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.bundleId(), prioritized2}), Object.class));
                    }
                    return prioritized2;
                }
                if (prioritized3 instanceof Prioritized) {
                    Prioritized<SubagentId> prioritized4;
                    Prioritized<SubagentId> cached = prioritized4 = prioritized3;
                    Logger LoggerImpl_this = DirectorState$.js7$subagent$director$DirectorState$$$logger;
                    if (LoggerImpl_this.underlying().isTraceEnabled()) {
                        LoggerImpl_this.underlying().trace("cachedPrioritized: {} reuse {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.bundleId(), cached}), Object.class));
                    }
                    return cached;
                }
                throw new MatchError(prioritized3);
            }
            if (prioritized instanceof Prioritized) {
                Prioritized prioritized5;
                Prioritized cached = prioritized5 = prioritized;
                Logger LoggerImpl_this = DirectorState$.js7$subagent$director$DirectorState$$$logger;
                if (LoggerImpl_this.underlying().isTraceEnabled()) {
                    LoggerImpl_this.underlying().trace("cachedPrioritized: {} reuse {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.bundleId(), cached}), Object.class));
                }
                return cached;
            }
            throw new MatchError((Object)prioritized);
        }

        public Prioritized<SubagentId> cachedDynamicPrioritized(Function1<SubagentId, Option<Scope>> toScope) {
            Prioritized<SubagentId> prioritized = this.mkPrioritized(toScope);
            return this.cache$1(prioritized);
        }

        private Prioritized<SubagentId> mkPrioritized(Function1<SubagentId, Option<Scope>> toScope) {
            return Prioritized$.MODULE$.apply((Vector)this.subagentToExpr().toVector().flatMap((Function1 & Serializable)x$1 -> {
                SubagentId subagentId = (SubagentId)x$1._1();
                Expression expression = (Expression)x$1._2();
                return ((Option)toScope.apply((Object)subagentId)).flatMap((Function1 & Serializable)scope -> {
                    Either either = expression.eval((Scope)scope).flatMap(DirectorState$::js7$subagent$director$DirectorState$BundleEntry$$_$mkPrioritized$$anonfun$1$$anonfun$1$$anonfun$1);
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        Problem problem = (Problem)left.value();
                        Logger LoggerImpl_this = DirectorState$.js7$subagent$director$DirectorState$$$logger;
                        if (LoggerImpl_this.underlying().isErrorEnabled()) {
                            LoggerImpl_this.underlying().error("{}: {} priority expression failed with {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.bundleId(), subagentId, problem}), Object.class));
                        }
                        return None$.MODULE$;
                    }
                    if (either instanceof Right) {
                        Right right = (Right)either;
                        Serializable serializable = (Serializable)right.value();
                        if (Value$package$MissingValue$.MODULE$.equals(serializable)) {
                            Logger LoggerImpl_this = DirectorState$.js7$subagent$director$DirectorState$$$logger;
                            if (LoggerImpl_this.underlying().isTraceEnabled()) {
                                LoggerImpl_this.underlying().trace("{} {} priority expression returns MissingValue", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.bundleId(), subagentId}), Object.class));
                            }
                            return None$.MODULE$;
                        }
                        if (serializable instanceof NumberValue) {
                            NumberValue numberValue;
                            NumberValue o = numberValue = (NumberValue)serializable;
                            SubagentId subagentId = (SubagentId)Predef$.MODULE$.ArrowAssoc((Object)subagentId);
                            return Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)subagentId, (Object)o));
                        }
                    }
                    throw new MatchError((Object)either);
                });
            }));
        }

        private SubagentBundleId bundleId() {
            return this.subagentBundle().id();
        }

        public BundleEntry copy(SubagentBundle subagentBundle, Map<SubagentId, Expression> subagentToExpr) {
            return new BundleEntry(subagentBundle, subagentToExpr);
        }

        public SubagentBundle copy$default$1() {
            return this.subagentBundle();
        }

        public Map<SubagentId, Expression> copy$default$2() {
            return this.subagentToExpr();
        }

        public SubagentBundle _1() {
            return this.subagentBundle();
        }

        public Map<SubagentId, Expression> _2() {
            return this.subagentToExpr();
        }

        private final Prioritized cache$1(Prioritized prioritized$1) {
            Prioritized prioritized;
            Prioritized cached;
            do {
                Prioritized prioritized2;
                Prioritized cached2;
                if (!((prioritized = this._cachedPrioritized.get()) instanceof Prioritized) || !(cached2 = (prioritized2 = prioritized)).isEquivalentTo(prioritized$1)) continue;
                Logger LoggerImpl_this = DirectorState$.js7$subagent$director$DirectorState$$$logger;
                if (LoggerImpl_this.underlying().isTraceEnabled()) {
                    LoggerImpl_this.underlying().trace("cachedPrioritized: {} reuse {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.bundleId(), cached2}), Object.class));
                }
                return cached2;
            } while (!this._cachedPrioritized.compareAndSet(cached = prioritized, prioritized$1));
            Logger LoggerImpl_this = DirectorState$.js7$subagent$director$DirectorState$$$logger;
            if (LoggerImpl_this.underlying().isTraceEnabled()) {
                LoggerImpl_this.underlying().trace("cachedPrioritized: {} new {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.bundleId(), prioritized$1}), Object.class));
            }
            return prioritized$1;
        }
    }

    public static final class SubagentEntry
    implements Product,
    Serializable {
        private final Allocated<IO, SubagentDriver> allocatedDriver;
        private final boolean disabled;
        private final SubagentDriver driver;

        public static SubagentEntry apply(Allocated<IO, SubagentDriver> allocated, boolean bl) {
            return DirectorState$SubagentEntry$.MODULE$.apply(allocated, bl);
        }

        public static SubagentEntry fromProduct(Product product) {
            return DirectorState$SubagentEntry$.MODULE$.fromProduct(product);
        }

        public static SubagentEntry unapply(SubagentEntry subagentEntry) {
            return DirectorState$SubagentEntry$.MODULE$.unapply(subagentEntry);
        }

        public static boolean $lessinit$greater$default$2() {
            return DirectorState$SubagentEntry$.MODULE$.$lessinit$greater$default$2();
        }

        public SubagentEntry(Allocated<IO, SubagentDriver> allocatedDriver, boolean disabled) {
            this.allocatedDriver = allocatedDriver;
            this.disabled = disabled;
            this.driver = allocatedDriver.allocatedThing();
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)-1874129267);
            n = Statics.mix((int)n, (int)Statics.anyHash(this.allocatedDriver()));
            n = Statics.mix((int)n, (int)(this.disabled() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            SubagentEntry subagentEntry;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SubagentEntry)) return false;
            SubagentEntry subagentEntry2 = subagentEntry = (SubagentEntry)object;
            if (this.disabled() != subagentEntry2.disabled()) return false;
            Allocated<IO, SubagentDriver> allocated = this.allocatedDriver();
            Allocated<IO, SubagentDriver> allocated2 = subagentEntry2.allocatedDriver();
            if (allocated != null) {
                if (!allocated.equals(allocated2)) return false;
                return true;
            }
            if (allocated2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof SubagentEntry;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SubagentEntry";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToBoolean((boolean)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "allocatedDriver";
            }
            if (1 == n2) {
                return "disabled";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Allocated<IO, SubagentDriver> allocatedDriver() {
            return this.allocatedDriver;
        }

        public boolean disabled() {
            return this.disabled;
        }

        public SubagentDriver driver() {
            return this.driver;
        }

        public boolean isAvailable() {
            return !this.disabled() && this.driver().isCoupled();
        }

        public String toString() {
            return "DirectorEntry" + this.allocatedDriver().allocatedThing().subagentId() + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(this.disabled()), (Function0<String>)((Function0 & Serializable)DirectorState$::js7$subagent$director$DirectorState$SubagentEntry$$_$toString$$anonfun$1)) + " isAvailable=" + this.isAvailable() + ")";
        }

        public SubagentEntry copy(Allocated<IO, SubagentDriver> allocatedDriver, boolean disabled) {
            return new SubagentEntry(allocatedDriver, disabled);
        }

        public Allocated<IO, SubagentDriver> copy$default$1() {
            return this.allocatedDriver();
        }

        public boolean copy$default$2() {
            return this.disabled();
        }

        public Allocated<IO, SubagentDriver> _1() {
            return this.allocatedDriver();
        }

        public boolean _2() {
            return this.disabled();
        }
    }
}

