/*
 * Decompiled with CFR 0.152.
 */
package js7.subagent.job;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.MonadCancel;
import cats.effect.package$;
import cats.kernel.Monoid;
import cats.kernel.Semigroup$;
import com.typesafe.scalalogging.Logger;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import js7.base.catsutils.CatsExtensions$;
import js7.base.io.process.ProcessSignal;
import js7.base.io.process.ProcessSignal$SIGKILL$;
import js7.base.log.Logger$package$Logger$;
import js7.base.log.Logger$package$Logger$syntax$;
import js7.base.monixutils.AsyncMap;
import js7.base.monixutils.AsyncMap$;
import js7.base.problem.Problem;
import js7.base.time.Timestamp;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.base.utils.SetOnce;
import js7.base.utils.SetOnce$;
import js7.data.job.JobConf;
import js7.data.job.JobResource;
import js7.data.job.JobResourcePath;
import js7.data.order.Order;
import js7.data.order.OrderId;
import js7.data.order.OrderOutcome;
import js7.data.order.OrderOutcome$Disrupted$;
import js7.data.subagent.Problems$ProcessKilledDueToSubagentShutdownProblem$;
import js7.data.value.expression.Expression;
import js7.data.value.expression.scopes.FileValueState;
import js7.launcher.StdObservers;
import js7.launcher.internal.JobLauncher;
import js7.subagent.job.JobDriver$;
import js7.subagent.job.JobDriver$Params$;
import js7.subagent.job.JobDriverForOrder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.hashing.MurmurHash3$;
import sourcecode.Enclosing$;

public final class JobDriver {
    private final Params params;
    private final Logger logger;
    private final AsyncMap<OrderId, JobDriverForOrder> orderToProcess;
    private final SetOnce<Deferred<IO, BoxedUnit>> lastProcessTerminated;

    public static IO<JobDriver> start(Params params) {
        return JobDriver$.MODULE$.start(params);
    }

    public JobDriver(Params params) {
        this.params = params;
        this.logger = Logger$package$Logger$.MODULE$.withPrefix("Job:" + params.jobConf().jobKey().simpleName(), ClassTag$.MODULE$.apply(JobDriver.class));
        this.orderToProcess = AsyncMap$.MODULE$.empty(Tag$.MODULE$.apply(OrderId.class, LightTypeTag$.MODULE$.parse(-414890029, "\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30)), Tag$.MODULE$.apply(JobDriverForOrder.class, LightTypeTag$.MODULE$.parse(-2022688446, "\u0004\u0000\u0001\"js7.subagent.job.JobDriverForOrder\u0001\u0001", "\u0000\u0000\u0000", 30)));
        this.lastProcessTerminated = SetOnce$.MODULE$.apply(Tag$.MODULE$.apply(Deferred.class, LightTypeTag$.MODULE$.parse(233409118, "\u0001\u0001\u0001\u001bcats.effect.kernel.Deferred\u0002\u0000\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u000ecats.effect.IO\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0000\u0000\u0004\u0000\u0001\nscala.Unit\u0001\u0001\u0000\u0001", "\u0000\u0003\u0001\u0001\u0001\u001bcats.effect.kernel.Deferred\u0002\u0000\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u000ecats.effect.IO\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0000\u0000\u0004\u0000\u0001\nscala.Unit\u0001\u0001\u0000\u0001\u0003\u0001\u0001\u0001!cats.effect.kernel.DeferredSource\u0002\u0000\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u0090\u0003\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0000\u0000\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0001\u0001\u001fcats.effect.kernel.DeferredSink\u0002\u0000\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u0090\u0003\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0000\u0000\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u0090\u0003\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0002\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u0016cats.effect.IOPlatform\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0004\u0000\u0001\fscala.AnyVal\u0001\u0001\u0003\u0000\u0001\u0090\u0003\u0001\u0001\u0002\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0003\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001", 30)));
    }

    public String toString() {
        return "JobDriver(" + this.params.jobConf().jobKey() + " " + this.params.jobConf().workflowJob().executable() + ")";
    }

    public IO<BoxedUnit> js7$subagent$job$JobDriver$$precheckAndWarn() {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(IO$.MODULE$.apply(this::precheckAndWarn$$anonfun$1));
        return ((IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$1 -> _$1.precheck(), IO$.MODULE$.asyncForIO())).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                Problem problem = (Problem)left.value();
                return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                    this.precheckAndWarn$$anonfun$3$$anonfun$1(problem);
                    return BoxedUnit.UNIT;
                });
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object = right.value();
                if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                    return IO$.MODULE$.unit();
                }
            }
            throw new MatchError((Object)either);
        });
    }

    public IO<BoxedUnit> stop(ProcessSignal signal) {
        return Logger$package$Logger$syntax$.MODULE$.debugIO(this.logger, "stop", (Function0<Object>)((Function0 & Serializable)() -> JobDriver.stop$$anonfun$1(signal)), IO$.MODULE$.defer(() -> this.stop$$anonfun$2(signal)));
    }

    private IO<BoxedUnit> killAllDueToShutdown(ProcessSignal signal) {
        return this.orderToProcess.toMap().map((Function1 & Serializable)_$3 -> _$3.values()).flatMap((Function1 & Serializable)drivers -> {
            block0: {
                Logger LoggerImpl_this;
                if (!drivers.nonEmpty() || !(LoggerImpl_this = this.logger).underlying().isWarnEnabled()) break block0;
                LoggerImpl_this.underlying().warn("Terminating, sending {} to {} processes", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{signal, BoxesRunTime.boxToInteger((int)this.orderProcessCount())}), Object.class));
            }
            return ((IO)ScalaUtils$syntax$.MODULE$.foldMap(drivers, (Function1 & Serializable)driver -> driver.kill(signal, (Option<Function1<OrderOutcome.Killed, Problem>>)Some$.MODULE$.apply((Function1 & Serializable)_$4 -> Problems$ProcessKilledDueToSubagentShutdownProblem$.MODULE$.apply((OrderOutcome.Killed)_$4))), IO$.MODULE$.monoidForIO((Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit()))).handleError((Function1)(JProcedure1 & Serializable)t -> {
                Logger LoggerImpl_this = this.logger;
                if (LoggerImpl_this.underlying().isErrorEnabled()) {
                    Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                    LoggerImpl_this.underlying().error("killAllDueToShutdown: " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable), t);
                    return;
                }
            });
        });
    }

    public IO<OrderOutcome> runOrderProcess(Order<Order.Processing> order, Map<String, Expression> executeArguments, Option<Timestamp> endOfAdmissionPeriod, StdObservers stdObservers) {
        JobDriverForOrder forOrder = new JobDriverForOrder(order.id(), this.params);
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(IO$.MODULE$.apply(this::runOrderProcess$$anonfun$1));
        return ((IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatTapT$extension(iO, (Function1 & Serializable)_$5 -> this.orderToProcess.insert(order.id(), forOrder, Enclosing$.MODULE$.apply("js7.subagent.job.JobDriver#runOrderProcess")), IO$.MODULE$.asyncForIO())).flatMap((Function1 & Serializable)x$1 -> {
            Right right;
            JobLauncher jobLauncher;
            Either either = x$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                Problem problem = (Problem)left.value();
                return IO$.MODULE$.pure((Object)OrderOutcome$Disrupted$.MODULE$.apply(problem));
            }
            if (either instanceof Right && (jobLauncher = (JobLauncher)(right = (Right)either).value()) != null) {
                JobLauncher jobLauncher2;
                JobLauncher jobLauncher3 = jobLauncher2 = jobLauncher;
                return forOrder.processOrder(order, executeArguments, endOfAdmissionPeriod, stdObservers, jobLauncher3).guarantee(this.removeOrderEntry(forOrder));
            }
            throw new MatchError((Object)either);
        });
    }

    private IO<BoxedUnit> removeOrderEntry(JobDriverForOrder forOrder) {
        return this.orderToProcess.remove(forOrder.orderId(), Enclosing$.MODULE$.apply("js7.subagent.job.JobDriver#removeOrderEntry")).$times$greater((IO)CatsExtensions$.MODULE$.ifTrue(IO$.MODULE$.apply(this::removeOrderEntry$$anonfun$1), (Function0<Object>)((Function0 & Serializable)this::removeOrderEntry$$anonfun$2), IO$.MODULE$.asyncForIO()));
    }

    public IO<BoxedUnit> killProcess(OrderId orderId, ProcessSignal signal) {
        return IO$.MODULE$.defer(() -> this.killProcess$$anonfun$1(orderId, signal));
    }

    private int orderProcessCount() {
        return this.orderToProcess.size();
    }

    private final Either precheckAndWarn$$anonfun$1() {
        return this.params.checkedJobLauncher();
    }

    private final void precheckAndWarn$$anonfun$3$$anonfun$1(Problem problem$1) {
        Logger LoggerImpl_this = this.logger;
        if (LoggerImpl_this.underlying().isWarnEnabled()) {
            LoggerImpl_this.underlying().warn(problem$1.toString());
            return;
        }
    }

    private static final Object stop$$anonfun$1(ProcessSignal signal$1) {
        return signal$1;
    }

    private final IO $anonfun$1() {
        return IO$.MODULE$.sleep(this.params.jobConf().sigkillDelay()).$times$greater(this.killAllDueToShutdown(ProcessSignal$SIGKILL$.MODULE$));
    }

    private final String stop$$anonfun$2$$anonfun$1$$anonfun$1() {
        return "'killing all " + this.params.jobConf().jobKey() + " processes'";
    }

    private final IO stop$$anonfun$2$$anonfun$1(ProcessSignal signal$3, Deferred deferred$1) {
        ProcessSignal processSignal = signal$3;
        ProcessSignal$SIGKILL$ processSignal$SIGKILL$ = ProcessSignal$SIGKILL$.MODULE$;
        IO iO = (IO)IO$.MODULE$.unlessA(!(processSignal != null ? !processSignal.equals(processSignal$SIGKILL$) : processSignal$SIGKILL$ != null), this::$anonfun$1).background().surround(deferred$1.get(), (MonadCancel)IO$.MODULE$.asyncForIO());
        return this.killAllDueToShutdown(signal$3).$times$greater(CatsUtils$syntax$.MODULE$.logWhenItTakesLonger(iO, (Function0<String>)((Function0 & Serializable)this::stop$$anonfun$2$$anonfun$1$$anonfun$1), CatsUtils$syntax$.MODULE$.logWhenItTakesLonger$default$3(iO)));
    }

    private static final IO stop$$anonfun$2$$anonfun$2$$anonfun$1() {
        return IO$.MODULE$.unit();
    }

    private static final String stop$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1() {
        return "jobLauncher.stop";
    }

    private final IO stop$$anonfun$2(ProcessSignal signal$2) {
        Deferred deferred = package$.MODULE$.Deferred().unsafe(IO$.MODULE$.asyncForIO());
        this.lastProcessTerminated.$colon$eq((Deferred<IO, BoxedUnit>)deferred);
        return IO$.MODULE$.unlessA(this.orderToProcess.isEmpty(), () -> this.stop$$anonfun$2$$anonfun$1(signal$2, deferred)).flatMap((Function1 & Serializable)_$2 -> (IO)this.params.checkedJobLauncher().toOption().fold(JobDriver::stop$$anonfun$2$$anonfun$2$$anonfun$1, (Function1 & Serializable)jobLauncher -> {
            IO<BoxedUnit> iO = jobLauncher.stop();
            return Logger$package$Logger$syntax$.MODULE$.traceIO(this.logger, "Stop '" + jobLauncher + "'", Logger$package$Logger$syntax$.MODULE$.traceIO$default$3(this.logger), CatsUtils$syntax$.MODULE$.logWhenItTakesLonger(iO, (Function0<String>)((Function0 & Serializable)JobDriver::stop$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1), CatsUtils$syntax$.MODULE$.logWhenItTakesLonger$default$3(iO)).handleError((Function1)(JProcedure1 & Serializable)throwable -> {
                Logger LoggerImpl_this = this.logger;
                if (LoggerImpl_this.underlying().isErrorEnabled()) {
                    Throwable throwable2 = ScalaUtils$syntax$.MODULE$.RichThrowable(throwable);
                    Throwable throwable3 = ScalaUtils$syntax$.MODULE$.RichThrowable(throwable);
                    LoggerImpl_this.underlying().error("Stop '" + jobLauncher + "' failed: " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable2), (Object)ScalaUtils$syntax$RichThrowable$.MODULE$.nullIfNoStackTrace$extension(throwable3));
                    return;
                }
            }));
        }));
    }

    private final Either runOrderProcess$$anonfun$1() {
        return this.params.checkedJobLauncher();
    }

    private final boolean removeOrderEntry$$anonfun$1() {
        return this.orderToProcess.isEmpty();
    }

    private static final IO removeOrderEntry$$anonfun$2$$anonfun$1() {
        return IO$.MODULE$.unit();
    }

    private final IO removeOrderEntry$$anonfun$2() {
        return (IO)this.lastProcessTerminated.fold(JobDriver::removeOrderEntry$$anonfun$2$$anonfun$1, (Function1 & Serializable)_$6 -> ((IO)_$6.complete((Object)BoxedUnit.UNIT)).void());
    }

    private final void killProcess$$anonfun$1$$anonfun$1$$anonfun$1(OrderId orderId$3) {
        Logger LoggerImpl_this = this.logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("\u26a0\ufe0f killProcess {} => no process for Order", (Object)orderId$3);
            return;
        }
    }

    private final IO killProcess$$anonfun$1$$anonfun$1(OrderId orderId$2) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.killProcess$$anonfun$1$$anonfun$1$$anonfun$1(orderId$2);
            return BoxedUnit.UNIT;
        });
    }

    private final IO killProcess$$anonfun$1(OrderId orderId$1, ProcessSignal signal$6) {
        return (IO)this.orderToProcess.get(orderId$1).fold(() -> this.killProcess$$anonfun$1$$anonfun$1(orderId$1), (Function1 & Serializable)_$7 -> _$7.killWithSigkillDelay(signal$6));
    }

    public static final class Params
    implements Product,
    Serializable {
        private final JobConf jobConf;
        private final Function1<JobResourcePath, Either<Problem, JobResource>> pathToJobResource;
        private final Either<Problem, JobLauncher> checkedJobLauncher;
        private final FileValueState fileValueState;

        public static Params apply(JobConf jobConf, Function1<JobResourcePath, Either<Problem, JobResource>> function1, Either<Problem, JobLauncher> either, FileValueState fileValueState) {
            return JobDriver$Params$.MODULE$.apply(jobConf, function1, either, fileValueState);
        }

        public static Params fromProduct(Product product) {
            return JobDriver$Params$.MODULE$.fromProduct(product);
        }

        public static Params unapply(Params params) {
            return JobDriver$Params$.MODULE$.unapply(params);
        }

        public Params(JobConf jobConf, Function1<JobResourcePath, Either<Problem, JobResource>> pathToJobResource, Either<Problem, JobLauncher> checkedJobLauncher, FileValueState fileValueState) {
            this.jobConf = jobConf;
            this.pathToJobResource = pathToJobResource;
            this.checkedJobLauncher = checkedJobLauncher;
            this.fileValueState = fileValueState;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 1093197581, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            Params params;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Params)) return false;
            Params params2 = params = (Params)object;
            JobConf jobConf = this.jobConf();
            JobConf jobConf2 = params2.jobConf();
            if (jobConf == null) {
                if (jobConf2 != null) {
                    return false;
                }
            } else if (!((Object)jobConf).equals(jobConf2)) return false;
            Function1<JobResourcePath, Either<Problem, JobResource>> function1 = this.pathToJobResource();
            Function1<JobResourcePath, Either<Problem, JobResource>> function12 = params2.pathToJobResource();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            Either<Problem, JobLauncher> either = this.checkedJobLauncher();
            Either<Problem, JobLauncher> either2 = params2.checkedJobLauncher();
            if (either == null) {
                if (either2 != null) {
                    return false;
                }
            } else if (!either.equals(either2)) return false;
            FileValueState fileValueState = this.fileValueState();
            FileValueState fileValueState2 = params2.fileValueState();
            if (fileValueState == null) {
                if (fileValueState2 == null) return true;
                return false;
            } else {
                if (!fileValueState.equals(fileValueState2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Params;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Params";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "jobConf";
                }
                case 1: {
                    return "pathToJobResource";
                }
                case 2: {
                    return "checkedJobLauncher";
                }
                case 3: {
                    return "fileValueState";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public JobConf jobConf() {
            return this.jobConf;
        }

        public Function1<JobResourcePath, Either<Problem, JobResource>> pathToJobResource() {
            return this.pathToJobResource;
        }

        public Either<Problem, JobLauncher> checkedJobLauncher() {
            return this.checkedJobLauncher;
        }

        public FileValueState fileValueState() {
            return this.fileValueState;
        }

        public Params copy(JobConf jobConf, Function1<JobResourcePath, Either<Problem, JobResource>> pathToJobResource, Either<Problem, JobLauncher> checkedJobLauncher, FileValueState fileValueState) {
            return new Params(jobConf, pathToJobResource, checkedJobLauncher, fileValueState);
        }

        public JobConf copy$default$1() {
            return this.jobConf();
        }

        public Function1<JobResourcePath, Either<Problem, JobResource>> copy$default$2() {
            return this.pathToJobResource();
        }

        public Either<Problem, JobLauncher> copy$default$3() {
            return this.checkedJobLauncher();
        }

        public FileValueState copy$default$4() {
            return this.fileValueState();
        }

        public JobConf _1() {
            return this.jobConf();
        }

        public Function1<JobResourcePath, Either<Problem, JobResource>> _2() {
            return this.pathToJobResource();
        }

        public Either<Problem, JobLauncher> _3() {
            return this.checkedJobLauncher();
        }

        public FileValueState _4() {
            return this.fileValueState();
        }
    }
}

