/*
 * Decompiled with CFR 0.152.
 */
package js7.tests.addOrders;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Fiber;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.MonadCancel;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.scalalogging.Logger;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import java.io.Serializable;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.log.Logger$package$Logger$;
import js7.base.problem.Problem;
import js7.base.time.Stopwatch$;
import js7.common.pekkoutils.Pekkos$;
import js7.controller.client.PekkoHttpControllerApi$;
import js7.data.order.OrderId;
import js7.data.order.OrderId$;
import js7.proxy.ControllerApi;
import js7.proxy.ControllerApi$;
import js7.proxy.configuration.ProxyConfs$;
import js7.tests.addOrders.Settings;
import js7.tests.addOrders.Statistics;
import js7.tests.addOrders.TestAddOrders;
import org.apache.pekko.actor.ActorSystem;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class TestAddOrders$
implements Serializable {
    private static final Logger logger;
    private static final String ClearLine;
    public static final TestAddOrders$ MODULE$;

    private TestAddOrders$() {
    }

    static {
        MODULE$ = new TestAddOrders$();
        logger = Logger$package$Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(TestAddOrders$.class));
        ClearLine = "\u001b[K";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TestAddOrders$.class);
    }

    public Logger logger() {
        return logger;
    }

    public IO<Either<Problem, Statistics>> run(Settings settings, boolean logToStdout) {
        return this.run2(settings, (Function1<FiniteDuration, IO<BoxedUnit>>)(Function1 & Serializable)duration -> this.onOrdersAdded$3(settings, logToStdout, (FiniteDuration)duration), (Function1<Statistics, IO<BoxedUnit>>)(Function1 & Serializable)statistics -> this.onStatisticsUpdate$3(logToStdout, (Statistics)statistics)).flatTap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                Problem problem = (Problem)left.value();
                return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                    this.run$$anonfun$4$$anonfun$1(logToStdout);
                    return BoxedUnit.UNIT;
                });
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                Statistics statistics = (Statistics)right.value();
                return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                    this.run$$anonfun$4$$anonfun$2(statistics, logToStdout);
                    return BoxedUnit.UNIT;
                });
            }
            throw new MatchError((Object)either);
        });
    }

    public boolean run$default$2() {
        return false;
    }

    private IO<Either<Problem, Statistics>> run2(Settings settings, Function1<FiniteDuration, IO<BoxedUnit>> onOrdersAdded, Function1<Statistics, IO<BoxedUnit>> onStatisticsUpdate) {
        Config config = ConfigFactory.systemProperties().withFallback((ConfigMergeable)ProxyConfs$.MODULE$.defaultConfig());
        return (IO)Pekkos$.MODULE$.actorSystemResource("TestAddOrders", config).flatMap((Function1 & Serializable)actorSystem -> ControllerApi$.MODULE$.resource(PekkoHttpControllerApi$.MODULE$.admissionsToApiResource(settings.admissions(), PekkoHttpControllerApi$.MODULE$.admissionsToApiResource$default$2(), PekkoHttpControllerApi$.MODULE$.admissionsToApiResource$default$3(), (ActorSystem)actorSystem), ProxyConfs$.MODULE$.fromConfig(config))).use((Function1 & Serializable)controllerApi -> {
            TestAddOrders testAddOrders = new TestAddOrders((ControllerApi)controllerApi, settings);
            return testAddOrders.js7$tests$addOrders$TestAddOrders$$run().flatMap((Function1 & Serializable)x$1 -> {
                IO iO = (IO)x$1._1();
                Stream stream = (Stream)x$1._2();
                Fiber fiber = (Fiber)x$1._3();
                return iO.flatMap(onOrdersAdded).$times$greater((IO)stream.foreach(onStatisticsUpdate).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain()).$times$greater((IO)CatsEffectExtensions$.MODULE$.joinStd(fiber, IO$.MODULE$.asyncForIO()));
            });
        }, (MonadCancel)IO$.MODULE$.asyncForIO());
    }

    public OrderId js7$tests$addOrders$TestAddOrders$$$toOrderId(int i) {
        return (OrderId)OrderId$.MODULE$.apply("TestAddOrders-" + i);
    }

    private final void myPrint$1(boolean logToStdout$1, Function0 line) {
        if (logToStdout$1) {
            Predef$.MODULE$.println(line.apply());
            return;
        }
    }

    private static final String onOrdersAdded$3$$anonfun$1$$anonfun$1(FiniteDuration duration$2, Settings settings$2) {
        return "\r" + ClearLine + Stopwatch$.MODULE$.durationAndPerSecondString(duration$2, Int$.MODULE$.int2long(settings$2.orderCount()), "orders added", Stopwatch$.MODULE$.durationAndPerSecondString$default$4()) + ClearLine + "\n" + ClearLine;
    }

    private final void onOrdersAdded$3$$anonfun$1(FiniteDuration duration$1, Settings settings$1, boolean logToStdout$2) {
        this.myPrint$1(logToStdout$2, () -> TestAddOrders$.onOrdersAdded$3$$anonfun$1$$anonfun$1(duration$1, settings$1));
    }

    private final IO onOrdersAdded$3(Settings settings$3, boolean logToStdout$3, FiniteDuration duration) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.onOrdersAdded$3$$anonfun$1(duration, settings$3, logToStdout$3);
            return BoxedUnit.UNIT;
        });
    }

    private static final void onStatisticsUpdate$3$$anonfun$1$$anonfun$1(boolean logToStdout$6, Statistics statistics$2) {
        if (logToStdout$6) {
            Predef$.MODULE$.print((Object)("\r" + statistics$2.toLine() + "  " + ClearLine));
            return;
        }
        Logger LoggerImpl_this = MODULE$.logger();
        if (LoggerImpl_this.underlying().isInfoEnabled()) {
            LoggerImpl_this.underlying().info("{} orders", (Object)BoxesRunTime.boxToInteger((int)statistics$2.lastOrderCount()));
            return;
        }
    }

    private static final IO onStatisticsUpdate$3$$anonfun$1(boolean logToStdout$5, Statistics statistics$1) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            TestAddOrders$.onStatisticsUpdate$3$$anonfun$1$$anonfun$1(logToStdout$5, statistics$1);
            return BoxedUnit.UNIT;
        });
    }

    private final IO onStatisticsUpdate$3(boolean logToStdout$4, Statistics statistics) {
        return IO$.MODULE$.whenA(statistics.totalOrderCount() > 0, () -> TestAddOrders$.onStatisticsUpdate$3$$anonfun$1(logToStdout$4, statistics));
    }

    private static final String run$$anonfun$4$$anonfun$1$$anonfun$1() {
        return "\r" + ClearLine + "\n";
    }

    private final void run$$anonfun$4$$anonfun$1(boolean logToStdout$13) {
        this.myPrint$1(logToStdout$13, TestAddOrders$::run$$anonfun$4$$anonfun$1$$anonfun$1);
    }

    private static final String run$$anonfun$4$$anonfun$2$$anonfun$1(Statistics statistics$4) {
        return "\r" + ClearLine + "\n" + ((IterableOnceOps)statistics$4.logLines().map((Function1 & Serializable)line -> line + ClearLine + "\n")).mkString();
    }

    private final void run$$anonfun$4$$anonfun$2(Statistics statistics$3, boolean logToStdout$7) {
        this.myPrint$1(logToStdout$7, () -> TestAddOrders$.run$$anonfun$4$$anonfun$2$$anonfun$1(statistics$3));
    }
}

