/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.credentialstore.keepass.db;

import com.sos.commons.credentialstore.keepass.SOSKeePassDatabase;
import com.sos.commons.credentialstore.keepass.SOSKeePassPath;
import com.sos.commons.credentialstore.keepass.db.kdb.SOSKdbHandler;
import com.sos.commons.credentialstore.keepass.db.kdbx.dom.SOSKdbxDOMHandler;
import com.sos.commons.credentialstore.keepass.db.kdbx.jaxb.SOSKdbxJAXBHandler;
import com.sos.commons.credentialstore.keepass.exceptions.SOSKeePassAttachmentException;
import com.sos.commons.credentialstore.keepass.exceptions.SOSKeePassDatabaseException;
import java.nio.file.Path;
import java.util.List;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.Database;
import org.linguafranca.pwdb.Entry;

public abstract class ASOSKeePassHandler {
    public static final int ICON_INDEX_NEW_GROUP = 48;
    public static final int ICON_INDEX_NEW_ENTRY = 0;
    private Path keePassFile;
    private Database<?, ?, ?, ?> database;
    private Credentials credentials;

    public abstract boolean isKdbx();

    public abstract void load(String var1, Path var2) throws SOSKeePassDatabaseException;

    public abstract List<? extends Entry<?, ?, ?, ?>> getEntries();

    public abstract Entry<?, ?, ?, ?> getEntryByPath(String var1);

    public abstract Entry<?, ?, ?, ?> createEntry(String var1) throws SOSKeePassDatabaseException;

    public abstract void saveAs(Path var1) throws SOSKeePassDatabaseException;

    public abstract byte[] getBinaryProperty(Entry<?, ?, ?, ?> var1, String var2) throws SOSKeePassAttachmentException;

    public abstract Entry<?, ?, ?, ?> setBinaryProperty(SOSKeePassPath var1, Entry<?, ?, ?, ?> var2, Path var3) throws SOSKeePassDatabaseException;

    public abstract Entry<?, ?, ?, ?> setProperty(Entry<?, ?, ?, ?> var1, String var2, String var3) throws SOSKeePassDatabaseException;

    public static ASOSKeePassHandler newInstance(Path keePassFile, SOSKeePassDatabase.Module module) {
        ASOSKeePassHandler h = null;
        if (SOSKeePassDatabase.isKdbx(keePassFile)) {
            SOSKeePassDatabase.Module m = module == null ? SOSKeePassDatabase.DEFAULT_MODULE : module;
            switch (m) {
                case JAXB: {
                    h = new SOSKdbxJAXBHandler();
                    break;
                }
                case DOM: {
                    h = new SOSKdbxDOMHandler();
                }
            }
        } else {
            h = new SOSKdbHandler();
        }
        h.keePassFile = keePassFile;
        return h;
    }

    public Path getKeePassFile() {
        return this.keePassFile;
    }

    protected void setDatabase(Database<?, ?, ?, ?> val) {
        this.database = val;
    }

    public Database<?, ?, ?, ?> getDatabase() {
        return this.database;
    }

    protected void setCredentials(Credentials val) {
        this.credentials = val;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public boolean isDirty() {
        return this.database != null && this.database.isDirty();
    }
}

