/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.addons;

import com.sos.commons.util.SOSCLIArgumentsParser;
import com.sos.commons.util.SOSPath;
import com.sos.commons.util.SOSPathUtils;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.vfs.commons.AProviderArguments;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.commons.vfs.exceptions.ProviderException;
import com.sos.commons.vfs.ssh.SSHProvider;
import com.sos.yade.commons.Yade;
import com.sos.yade.engine.commons.YADEProviderFile;
import com.sos.yade.engine.commons.arguments.YADESourceArguments;
import com.sos.yade.engine.commons.arguments.YADETargetArguments;
import com.sos.yade.engine.commons.arguments.loaders.AYADEArgumentsLoader;
import com.sos.yade.engine.commons.arguments.loaders.xml.YADEXMLJumpHostSettingsWriter;
import com.sos.yade.engine.commons.delegators.AYADEProviderDelegator;
import com.sos.yade.engine.commons.delegators.YADESourceProviderDelegator;
import com.sos.yade.engine.commons.delegators.YADETargetProviderDelegator;
import com.sos.yade.engine.exceptions.YADEEngineInitializationException;
import com.sos.yade.engine.exceptions.YADEEngineJumpHostException;
import com.sos.yade.engine.handlers.command.YADECommandExecutor;
import com.sos.yade.engine.handlers.operations.copymove.file.commons.YADETargetProviderFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class YADEEngineJumpHostAddon {
    private static final String JUMP_HOST_TMP_DIRECTORY_PREFIX = "yade-dmz-";
    private static final String SOURCE_TO_JUMP_HOST_COPY_PROFILE_ID = "SOURCE_TO_JUMP_HOST_COPY";
    private static final String SOURCE_TO_JUMP_HOST_GETLIST_PROFILE_ID = "SOURCE_TO_JUMP_HOST_GETLIST";
    private static final String SOURCE_TO_JUMP_HOST_REMOVE_PROFILE_ID = "SOURCE_TO_JUMP_HOST_REMOVE";
    private static final String SOURCE_TO_JUMP_HOST_MOVE_OPERATION_REMOVE_SOURCE_LABEL = "MOVE_OPERATION_REMOVE_SOURCE";
    private static final String JUMP_HOST_TO_TARGET_COPY_PROFILE_ID = "JUMP_HOST_TO_TARGET_COPY";
    private static final String SETTINGS_XML = "settings.xml";
    private static final String SETTINGS_XML_MOVE_REMOVE_SOURCE = "MOVE_OPERATION_REMOVE_SOURCE".toLowerCase() + ".xml";
    private final ISOSLogger logger;
    private final AYADEArgumentsLoader argsLoader;
    private final JumpHostConfig config;
    private boolean isReady;
    private boolean transferToJumpHostAlwaysTransactional = false;

    public static YADEEngineJumpHostAddon initialize(ISOSLogger logger, AYADEArgumentsLoader argsLoader) throws YADEEngineInitializationException {
        if (argsLoader == null || argsLoader.getJumpHostArgs() == null) {
            return null;
        }
        return new YADEEngineJumpHostAddon(logger, argsLoader);
    }

    private YADEEngineJumpHostAddon(ISOSLogger logger, AYADEArgumentsLoader argsLoader) throws YADEEngineInitializationException {
        this.logger = logger;
        this.argsLoader = argsLoader;
        this.config = new JumpHostConfig();
        this.init();
    }

    private void init() throws YADEEngineInitializationException {
        if (this.argsLoader.getJumpHostArgs().isConfiguredOnSource()) {
            this.config.setSourceToJumpHost(switch ((Yade.TransferOperation)this.argsLoader.getArgs().getOperation().getValue()) {
                case Yade.TransferOperation.GETLIST -> SOURCE_TO_JUMP_HOST_GETLIST_PROFILE_ID;
                case Yade.TransferOperation.REMOVE -> SOURCE_TO_JUMP_HOST_REMOVE_PROFILE_ID;
                default -> SOURCE_TO_JUMP_HOST_COPY_PROFILE_ID;
            }, (Yade.TransferOperation)this.argsLoader.getArgs().getOperation().getValue());
            YADESourceArguments newSourceArgs = new YADESourceArguments();
            newSourceArgs.applyDefaultIfNullQuietly();
            newSourceArgs.getLabel().setValue((Object)"Jump");
            newSourceArgs.getDirectory().setValue((Object)this.config.dataDirectory);
            newSourceArgs.getRecursive().setValue((Object)true);
            newSourceArgs.setProvider((AProviderArguments)this.argsLoader.getJumpHostArgs().getProvider());
            newSourceArgs.setCommands(this.argsLoader.getJumpHostArgs().getCommands());
            newSourceArgs.getCommands().addCommandBeforeOperation(this.config.getYADEClientCommand(this.config.settingsXML, this.config.profileId));
            this.argsLoader.setSourceArgs(newSourceArgs);
        } else {
            this.config.setJumpHostToTarget(JUMP_HOST_TO_TARGET_COPY_PROFILE_ID);
            YADETargetArguments newTargetArgs = new YADETargetArguments();
            newTargetArgs.applyDefaultIfNullQuietly();
            newTargetArgs.getLabel().setValue((Object)"Jump");
            newTargetArgs.getDirectory().setValue((Object)this.config.dataDirectory);
            newTargetArgs.getCreateDirectories().setValue((Object)true);
            newTargetArgs.setProvider((AProviderArguments)this.argsLoader.getJumpHostArgs().getProvider());
            newTargetArgs.setCommands(this.argsLoader.getJumpHostArgs().getCommands());
            newTargetArgs.getKeepModificationDate().setValue((Object)((Boolean)this.argsLoader.getTargetArgs().getKeepModificationDate().getValue()));
            newTargetArgs.getCommands().addCommandAfterOperationOnSuccess(this.config.getYADEClientCommand(this.config.settingsXML, this.config.profileId));
            this.argsLoader.setTargetArgs(newTargetArgs);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[%s][init][%s][profileId]%s", new Object[]{"Jump", this.config.dataDirectory, this.config.profileId});
        }
    }

    public void onAfterSourceDelegatorConnected(YADESourceProviderDelegator sourceDelegator) throws YADEEngineJumpHostException {
        if (this.argsLoader.getJumpHostArgs().isConfiguredOnSource()) {
            this.upload(sourceDelegator);
            if (this.config.sourceToJumpHost.deleteSourceFiles) {
                this.uploadMoveRemoveSource(sourceDelegator);
            }
            if (this.config.sourceToJumpHost.fileList != null) {
                try {
                    this.upload(sourceDelegator, this.config.sourceToJumpHost.fileList);
                }
                catch (Exception e) {
                    throw new YADEEngineJumpHostException(String.format("[%s][upload][%s=%s]%s", "Client", this.config.sourceToJumpHost.fileList.configurationName, this.config.sourceToJumpHost.fileList.localFile, e.toString()), e);
                }
            }
            this.isReady = true;
        }
    }

    public void onAfterTargetDelegatorConnected(YADETargetProviderDelegator targetDelegator) throws YADEEngineJumpHostException {
        if (!this.argsLoader.getJumpHostArgs().isConfiguredOnSource()) {
            this.upload(targetDelegator);
        }
        this.isReady = true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onBeforeDelegatorDisconnected(YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, List<ProviderFile> files, boolean isTransferSucceeded, boolean isSourceDisconnectingEnabled) throws YADEEngineJumpHostException {
        if (!this.isReady) {
            return;
        }
        AYADEProviderDelegator jumpHostDelegator = null;
        try {
            block16: {
                block15: {
                    if (!this.argsLoader.getJumpHostArgs().isConfiguredOnSource()) break block15;
                    jumpHostDelegator = sourceDelegator;
                    if (isTransferSucceeded) {
                        if (this.config.sourceToJumpHost.deleteSourceFiles) {
                            YADECommandExecutor.executeJumpHostCommand(this.logger, sourceDelegator, this.config.getYADEClientCommand(this.config.settingsXMLMoveRemoveSource, SOURCE_TO_JUMP_HOST_MOVE_OPERATION_REMOVE_SOURCE_LABEL));
                        }
                        if (this.config.sourceToJumpHost.resultSetFile != null) {
                            try {
                                this.download(sourceDelegator, this.config.sourceToJumpHost.resultSetFile);
                            }
                            catch (Exception e) {
                                throw new YADEEngineJumpHostException(String.format("[%s][download][%s=%s]%s", "Client", this.config.sourceToJumpHost.resultSetFile.configurationName, this.config.sourceToJumpHost.resultSetFile.localFile, e.toString()), e);
                            }
                        }
                        break block16;
                    } else {
                        this.setFailed(files);
                    }
                    break block16;
                }
                jumpHostDelegator = targetDelegator;
                if (isTransferSucceeded) {
                    if (this.config.jumpHostToTarget.deleteSourceFiles) {
                        this.jumpHostToTargetDeleteSourceFiles(sourceDelegator, files);
                    }
                } else {
                    this.setFailed(files);
                }
            }
            this.deleteJumpHostTempDirectory(jumpHostDelegator, isSourceDisconnectingEnabled);
            return;
        }
        catch (YADEEngineJumpHostException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new YADEEngineJumpHostException(e2.toString(), e2);
                }
            }
            catch (Throwable throwable) {
                this.deleteJumpHostTempDirectory(jumpHostDelegator, isSourceDisconnectingEnabled);
                throw throwable;
            }
        }
    }

    public boolean isConfiguredOnSource() {
        return this.argsLoader.getJumpHostArgs().isConfiguredOnSource();
    }

    private void setFailed(List<ProviderFile> sourceFiles) {
        if (sourceFiles == null) {
            return;
        }
        for (ProviderFile pf : sourceFiles) {
            YADEProviderFile sourceFile = (YADEProviderFile)pf;
            YADETargetProviderFile targetFile = sourceFile.getTarget();
            if (targetFile == null) {
                sourceFile.setState(Yade.TransferEntryState.SELECTED);
                sourceFile.setSubState(Yade.TransferEntryState.ABORTED);
                continue;
            }
            targetFile.setSubState(Yade.TransferEntryState.ROLLED_BACK);
        }
    }

    private void deleteJumpHostTempDirectory(AYADEProviderDelegator jumpHostDelegator, boolean isSourceDisconnectingEnabled) {
        if (jumpHostDelegator == null) {
            return;
        }
        String dir = isSourceDisconnectingEnabled ? this.config.directory : this.config.dataDirectory;
        try {
            SSHProvider jumpHostSSH = (SSHProvider)jumpHostDelegator.getProvider();
            boolean deleted = this.argsLoader.getJumpHostArgs().isPlatformEnabled() ? (this.argsLoader.getJumpHostArgs().isWindowsPlatform() ? jumpHostSSH.deleteWindowsDirectory(dir) : jumpHostSSH.deleteUnixDirectory(dir)) : jumpHostSSH.deleteDirectory(dir);
            if (deleted) {
                this.logger.info("[%s][TempDirectory][%s]deleted", new Object[]{"Jump", dir});
            } else {
                this.logger.info("[%s][TempDirectory][%s]not found", new Object[]{"Jump", dir});
            }
        }
        catch (ProviderException e) {
            this.logger.warn("[%s][TempDirectory][%s][delete]%s", new Object[]{"Jump", dir, e.toString(), e});
        }
    }

    private void jumpHostToTargetDeleteSourceFiles(AYADEProviderDelegator delegator, List<ProviderFile> files) throws YADEEngineJumpHostException {
        if (files == null) {
            return;
        }
        delegator.getProvider().enableReusableResource();
        for (ProviderFile f : files) {
            try {
                if (!delegator.getProvider().deleteFileIfExists(f.getFullPath())) continue;
                this.logger.info("[%s][deleteSourceFiles][%s]deleted", new Object[]{delegator.getLabel(), f.getFullPath()});
            }
            catch (Exception e) {
                throw new YADEEngineJumpHostException(String.format("[%s][deleteSourceFiles]%s", delegator.getLabel(), e.toString()), e);
            }
        }
    }

    private void upload(AYADEProviderDelegator delegator) throws YADEEngineJumpHostException {
        String label = "Client";
        try {
            delegator.getProvider().createDirectoriesIfNotExists(this.config.configDirectory);
            this.upload(delegator, this.config.settingsXMLContent, this.config.settingsXML);
            this.logger.info("[%s][upload][Settings][%s=%s]uploaded", new Object[]{label, delegator.getLabel(), this.config.settingsXML});
        }
        catch (Exception e) {
            throw new YADEEngineJumpHostException(String.format("[%s][upload][Settings][%s=%s]%s", label, delegator.getLabel(), this.config.settingsXML, e), e);
        }
    }

    private void uploadMoveRemoveSource(AYADEProviderDelegator delegator) throws YADEEngineJumpHostException {
        String label = "Client";
        try {
            this.upload(delegator, this.config.settingsXMLMoveRemoveSourceContent, this.config.settingsXMLMoveRemoveSource);
            this.logger.info("[%s][upload][Settings][%s=%s]uploaded", new Object[]{label, delegator.getLabel(), this.config.settingsXMLMoveRemoveSource});
        }
        catch (Exception e) {
            throw new YADEEngineJumpHostException(String.format("[%s][upload][Settings][%s=%s]%s", label, delegator.getLabel(), this.config.settingsXMLMoveRemoveSource, e), e);
        }
    }

    private void upload(AYADEProviderDelegator delegator, String content, String targetFileOnJumpHost) throws Exception {
        delegator.getProvider().writeFile(targetFileOnJumpHost, content);
    }

    private void upload(AYADEProviderDelegator delegator, JumpHostConfig.ConfigFile configFile) throws Exception {
        if (configFile.localFile == null) {
            return;
        }
        delegator.getProvider().writeFile(configFile.jumpHostFile, SOSPath.readFile((Path)configFile.localFile));
        this.logger.info("[%s][upload][%s][%s -> %s=%s]uploaded", new Object[]{"Client", configFile.configurationName, configFile.localFile, delegator.getLabel(), configFile.jumpHostFile});
    }

    private void download(AYADEProviderDelegator delegator, JumpHostConfig.ConfigFile configFile) throws Exception {
        if (configFile.localFile == null) {
            return;
        }
        String label = "Client";
        String content = delegator.getProvider().getFileContentIfExists(configFile.jumpHostFile);
        if (content == null) {
            this.logger.info("[%s][download][%s][%s=%s][skip]not found", new Object[]{label, configFile.configurationName, delegator.getLabel(), configFile.jumpHostFile});
        } else {
            SOSPath.overwrite((Path)configFile.localFile, (String)content);
            this.logger.info("[%s][download][%s][%s=%s -> %s]downloaded", new Object[]{label, configFile.configurationName, delegator.getLabel(), configFile.jumpHostFile, configFile.localFile});
        }
    }

    public class JumpHostConfig {
        private final String directory = this.getJumpHostLocalTemporaryDirectory();
        private final String configDirectory = this.directory + "/config";
        private final String dataDirectory = this.directory + "/data";
        private final String settingsXML = this.configDirectory + "/settings.xml";
        private final String settingsXMLMoveRemoveSource = this.configDirectory + "/" + SETTINGS_XML_MOVE_REMOVE_SOURCE;
        private boolean transactional;
        private String atomicPrefix;
        private String atomicSuffix;
        private String profileId;
        private String settingsXMLContent;
        private String settingsXMLMoveRemoveSourceContent;
        private SourceToJumpHost sourceToJumpHost;
        private JumpHostToTarget jumpHostToTarget;

        private JumpHostConfig() {
            if (YADEEngineJumpHostAddon.this.argsLoader.getTargetArgs() != null) {
                if (YADEEngineJumpHostAddon.this.transferToJumpHostAlwaysTransactional) {
                    YADEEngineJumpHostAddon.this.argsLoader.getArgs().getTransactional().setValue((Object)true);
                }
                this.transactional = this.getJumpHostTransactional();
                this.atomicPrefix = this.transactional ? (String)YADEEngineJumpHostAddon.this.argsLoader.getTargetArgs().getAtomicPrefix().getValue() : null;
                this.atomicSuffix = this.transactional ? (String)YADEEngineJumpHostAddon.this.argsLoader.getTargetArgs().getAtomicSuffix().getValue() : null;
            }
        }

        public String getDataDirectory() {
            return this.dataDirectory;
        }

        public boolean isTransactional() {
            return this.transactional;
        }

        public boolean isAtomicEnabled() {
            return this.atomicPrefix != null || this.atomicSuffix != null;
        }

        public String getAtomicPrefix() {
            return this.atomicPrefix;
        }

        public String getAtomicSuffix() {
            return this.atomicSuffix;
        }

        public String getProfileId() {
            return this.profileId;
        }

        public SourceToJumpHost getSourceToJumpHost() {
            return this.sourceToJumpHost;
        }

        private void setSourceToJumpHost(String profileId, Yade.TransferOperation operation) throws YADEEngineInitializationException {
            this.sourceToJumpHost = new SourceToJumpHost();
            this.profileId = profileId;
            if (YADEEngineJumpHostAddon.this.argsLoader.getSourceArgs().isFileListEnabled()) {
                if (!Files.exists((Path)YADEEngineJumpHostAddon.this.argsLoader.getSourceArgs().getFileList().getValue(), new LinkOption[0])) {
                    throw new YADEEngineInitializationException(String.format("[%s][%s]not found", YADEEngineJumpHostAddon.this.argsLoader.getSourceArgs().getFileList().getName(), YADEEngineJumpHostAddon.this.argsLoader.getSourceArgs().getFileList().getValue()));
                }
                this.sourceToJumpHost.setFileList(YADEEngineJumpHostAddon.this.argsLoader.getSourceArgs().getFileList());
                YADEEngineJumpHostAddon.this.argsLoader.getSourceArgs().getFileList().setValue(null);
            }
            if (YADEEngineJumpHostAddon.this.argsLoader.getClientArgs().getResultSetFile().isDirty()) {
                this.sourceToJumpHost.setResultSetFile(YADEEngineJumpHostAddon.this.argsLoader.getClientArgs().getResultSetFile());
                YADEEngineJumpHostAddon.this.argsLoader.getClientArgs().getResultSetFile().setValue(null);
            }
            switch (operation) {
                case GETLIST: {
                    this.settingsXMLContent = YADEXMLJumpHostSettingsWriter.sourceToJumpHostGETLIST(YADEEngineJumpHostAddon.this.argsLoader, this);
                    break;
                }
                case REMOVE: {
                    this.settingsXMLContent = YADEXMLJumpHostSettingsWriter.sourceToJumpHostREMOVE(YADEEngineJumpHostAddon.this.argsLoader, this);
                    break;
                }
                case MOVE: {
                    YADEEngineJumpHostAddon.this.argsLoader.getArgs().getOperation().setValue((Object)Yade.TransferOperation.COPY);
                    this.sourceToJumpHost.deleteSourceFiles = true;
                    if (this.sourceToJumpHost.resultSetFile == null) {
                        this.sourceToJumpHost.setResultSetFile(YADEEngineJumpHostAddon.this.argsLoader.getClientArgs().getResultSetFile(), YADEEngineJumpHostAddon.SOURCE_TO_JUMP_HOST_MOVE_OPERATION_REMOVE_SOURCE_LABEL.toLowerCase() + "_" + new Date().getTime() + ".sos.rs");
                    }
                    this.settingsXMLContent = YADEXMLJumpHostSettingsWriter.sourceToJumpHostCOPY(YADEEngineJumpHostAddon.this.argsLoader, this);
                    this.settingsXMLMoveRemoveSourceContent = YADEXMLJumpHostSettingsWriter.sourceToJumpHostMOVERemove(YADEEngineJumpHostAddon.this.argsLoader, this, YADEEngineJumpHostAddon.SOURCE_TO_JUMP_HOST_MOVE_OPERATION_REMOVE_SOURCE_LABEL);
                    break;
                }
                default: {
                    this.settingsXMLContent = YADEXMLJumpHostSettingsWriter.sourceToJumpHostCOPY(YADEEngineJumpHostAddon.this.argsLoader, this);
                }
            }
        }

        private void setJumpHostToTarget(String profileId) {
            this.jumpHostToTarget = new JumpHostToTarget();
            if (Yade.TransferOperation.MOVE.equals(YADEEngineJumpHostAddon.this.argsLoader.getArgs().getOperation().getValue())) {
                YADEEngineJumpHostAddon.this.argsLoader.getArgs().getOperation().setValue((Object)Yade.TransferOperation.COPY);
                this.jumpHostToTarget.deleteSourceFiles = true;
            }
            this.profileId = profileId;
            this.settingsXMLContent = YADEXMLJumpHostSettingsWriter.jumpHostToTargetCOPY(YADEEngineJumpHostAddon.this.argsLoader, this);
        }

        private String getJumpHostLocalTemporaryDirectory() {
            String configuredParentDirectory;
            String jumpParentDirectory = YADEEngineJumpHostAddon.this.argsLoader.getJumpHostArgs().getTempDirectoryParent().isDirty() ? (SOSString.isEmpty((String)(configuredParentDirectory = SOSPathUtils.toUnixStyle((String)((String)YADEEngineJumpHostAddon.this.argsLoader.getJumpHostArgs().getTempDirectoryParent().getValue())))) ? SOSPathUtils.toUnixStyle((String)SOSPathUtils.getParentPath((String)((String)YADEEngineJumpHostAddon.this.argsLoader.getJumpHostArgs().getYADEClientCommand().getValue()))) : (SOSPathUtils.isAbsoluteWindowsOpenSSHPath((String)configuredParentDirectory) ? configuredParentDirectory.substring(1) : configuredParentDirectory)) : SOSPathUtils.toUnixStyle((String)((String)YADEEngineJumpHostAddon.this.argsLoader.getJumpHostArgs().getTempDirectoryParent().getValue()));
            jumpParentDirectory = SOSPathUtils.getDirectoryWithTrailingSeparator((String)jumpParentDirectory, (String)"/");
            return jumpParentDirectory + YADEEngineJumpHostAddon.JUMP_HOST_TMP_DIRECTORY_PREFIX + UUID.randomUUID().toString();
        }

        private boolean getJumpHostTransactional() {
            Map jumpHostClientArgs = SOSCLIArgumentsParser.parse((String)((String)YADEEngineJumpHostAddon.this.argsLoader.getJumpHostArgs().getYADEClientCommand().getValue()).toLowerCase());
            String transactional = (String)jumpHostClientArgs.get(YADEEngineJumpHostAddon.this.argsLoader.getArgs().getTransactional().getName());
            if (transactional == null) {
                return (Boolean)YADEEngineJumpHostAddon.this.argsLoader.getArgs().getTransactional().getValue();
            }
            return !"false".equals(transactional);
        }

        private String getYADEClientCommand(String settingsXML, String profileId) {
            Object parallelism = "";
            if (YADEEngineJumpHostAddon.this.argsLoader.getArgs().isParallelismEnabled()) {
                SOSArgument<Integer> arg = YADEEngineJumpHostAddon.this.argsLoader.getArgs().getParallelism();
                if (!((String)YADEEngineJumpHostAddon.this.argsLoader.getJumpHostArgs().getYADEClientCommand().getValue()).toLowerCase().contains(arg.getName() + "=")) {
                    parallelism = " --" + arg.getName() + "=" + arg.getValue();
                }
            }
            return String.format("%s -settings=\"%s\" -profile=\"%s\"%s", YADEEngineJumpHostAddon.this.argsLoader.getJumpHostArgs().getYADEClientCommand().getValue(), settingsXML, profileId, parallelism);
        }

        public class SourceToJumpHost {
            private ConfigFile fileList;
            private ConfigFile resultSetFile;
            private boolean deleteSourceFiles;

            public ConfigFile getFileList() {
                return this.fileList;
            }

            public ConfigFile getResultSetFile() {
                return this.resultSetFile;
            }

            private void setFileList(SOSArgument<Path> arg) {
                this.fileList = new ConfigFile(arg.getName(), (Path)arg.getValue());
            }

            private void setResultSetFile(SOSArgument<Path> arg) {
                this.resultSetFile = new ConfigFile(arg.getName(), (Path)arg.getValue());
            }

            private void setResultSetFile(SOSArgument<Path> arg, String jumpHostFileName) {
                this.resultSetFile = new ConfigFile(arg.getName(), jumpHostFileName);
            }
        }

        public class ConfigFile {
            private final String configurationName;
            private final Path localFile;
            private final String jumpHostFile;

            private ConfigFile(String configurationName, Path localFile) {
                this.configurationName = configurationName;
                this.localFile = localFile;
                this.jumpHostFile = JumpHostConfig.this.configDirectory + "/" + localFile.getFileName();
            }

            private ConfigFile(String configurationName, String jumpHostFileName) {
                this.configurationName = configurationName;
                this.localFile = null;
                this.jumpHostFile = JumpHostConfig.this.configDirectory + "/" + jumpHostFileName;
            }

            public String getJumpHostFile() {
                return this.jumpHostFile;
            }
        }

        public class JumpHostToTarget {
            private boolean deleteSourceFiles;
        }
    }
}

