/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.handlers.operations.copymove.file.helpers;

import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.vfs.exceptions.ProviderException;
import com.sos.yade.engine.commons.delegators.YADETargetProviderDelegator;
import com.sos.yade.engine.handlers.operations.copymove.YADECopyMoveOperationsConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class YADETargetCumulativeFileHelper {
    private static final String LABEL = "CumulativeFile";

    public static void tryDeleteFile(ISOSLogger logger, YADECopyMoveOperationsConfig config, YADETargetProviderDelegator targetDelegator) throws Exception {
        if (config.getTarget().getCumulate().getFile().needsRename()) {
            targetDelegator.getProvider().deleteFileIfExists(config.getTarget().getCumulate().getFile().getFullPath());
        }
        if (!config.getTarget().isDeleteCumulativeFileEnabled()) {
            return;
        }
        if (targetDelegator.getProvider().deleteFileIfExists(config.getTarget().getCumulate().getFile().getFinalFullPath())) {
            logger.info("[%s][%s][%s]deleted", new Object[]{targetDelegator.getLabel(), LABEL, config.getTarget().getCumulate().getFile().getFinalFullPath()});
        }
    }

    public static void rollback(ISOSLogger logger, YADECopyMoveOperationsConfig config, YADETargetProviderDelegator targetDelegator) {
        String path = config.getTarget().getCumulate().getFile().getFullPath();
        try {
            if (targetDelegator.getProvider().deleteFileIfExists(path)) {
                logger.info("[%s][rollback][%s]deleted", new Object[]{targetDelegator.getLabel(), path});
            }
        }
        catch (Exception e) {
            logger.info("[%s][rollback][%s]%s", new Object[]{targetDelegator.getLabel(), path, e.toString()});
        }
        if (config.getTarget().getCompress() != null) {
            path = config.getTarget().getCumulate().getTmpFullPathOfExistingFileForDecompress();
            try {
                if (targetDelegator.getProvider().deleteFileIfExists(path)) {
                    logger.info("[%s][rollback][%s]deleted", new Object[]{targetDelegator.getLabel(), path});
                }
            }
            catch (Exception e) {
                logger.info("[%s][rollback][%s]%s", new Object[]{targetDelegator.getLabel(), path, e.toString()});
            }
        }
    }

    public static void onSuccess(ISOSLogger logger, YADECopyMoveOperationsConfig config, YADETargetProviderDelegator targetDelegator) throws Exception {
        String finalPath = config.getTarget().getCumulate().getFile().getFinalFullPath();
        String transferPath = config.getTarget().getCumulate().getFile().getFullPath();
        if (config.getTarget().getCumulate().getFile().needsRename()) {
            if (config.getTarget().isDeleteCumulativeFileEnabled()) {
                if (config.getTarget().getCompress() == null) {
                    targetDelegator.getProvider().renameFileIfSourceExists(transferPath, finalPath);
                } else {
                    YADETargetCumulativeFileHelper.compress(logger, config, targetDelegator, transferPath, finalPath);
                    targetDelegator.getProvider().deleteFileIfExists(transferPath);
                }
                logger.info("[%s][%s][%s]created", new Object[]{targetDelegator.getLabel(), LABEL, finalPath});
            } else if (targetDelegator.getProvider().exists(finalPath)) {
                if (config.getTarget().getCompress() == null) {
                    YADETargetCumulativeFileHelper.merge(logger, config, targetDelegator, transferPath, finalPath);
                    targetDelegator.getProvider().deleteFileIfExists(transferPath);
                } else {
                    String tmpFinalPath = config.getTarget().getCumulate().getTmpFullPathOfExistingFileForDecompress();
                    YADETargetCumulativeFileHelper.decompress(logger, config, targetDelegator, finalPath, tmpFinalPath);
                    YADETargetCumulativeFileHelper.merge(logger, config, targetDelegator, transferPath, tmpFinalPath);
                    targetDelegator.getProvider().deleteFileIfExists(transferPath);
                    targetDelegator.getProvider().deleteFileIfExists(finalPath);
                    YADETargetCumulativeFileHelper.compress(logger, config, targetDelegator, tmpFinalPath, finalPath);
                    targetDelegator.getProvider().deleteFileIfExists(tmpFinalPath);
                }
                logger.info("[%s][%s][%s]updated", new Object[]{targetDelegator.getLabel(), LABEL, finalPath});
            } else {
                if (config.getTarget().getCompress() == null) {
                    targetDelegator.getProvider().renameFileIfSourceExists(transferPath, finalPath);
                } else {
                    YADETargetCumulativeFileHelper.compress(logger, config, targetDelegator, transferPath, finalPath);
                    targetDelegator.getProvider().deleteFileIfExists(transferPath);
                }
                logger.info("[%s][%s][%s]created", new Object[]{targetDelegator.getLabel(), LABEL, finalPath});
            }
        }
    }

    private static void decompress(ISOSLogger logger, YADECopyMoveOperationsConfig config, YADETargetProviderDelegator targetDelegator, String gzipFile, String outputFile) throws ProviderException {
        logger.info("[%s][%s][decompress][%s]->[%s]", new Object[]{targetDelegator.getLabel(), LABEL, gzipFile, outputFile});
        targetDelegator.getProvider().deleteFileIfExists(outputFile);
        try (InputStream is = targetDelegator.getProvider().getInputStream(gzipFile);
             GZIPInputStream gis = new GZIPInputStream(is);
             OutputStream os = targetDelegator.getProvider().getOutputStream(outputFile, false);){
            int len;
            byte[] buffer = new byte[config.getBufferSize()];
            while ((len = gis.read(buffer)) > 0) {
                os.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            new ProviderException("[" + targetDelegator.getLabel() + "][CumulativeFile][decompress][" + gzipFile + "]->[" + outputFile + "]" + e, (Throwable)e);
        }
    }

    private static void merge(ISOSLogger logger, YADECopyMoveOperationsConfig config, YADETargetProviderDelegator targetDelegator, String inputFile, String outputFile) throws ProviderException {
        logger.info("[%s][%s][merge][%s]->[%s]", new Object[]{targetDelegator.getLabel(), LABEL, inputFile, outputFile});
        try (InputStream is = targetDelegator.getProvider().getInputStream(inputFile);
             OutputStream os = targetDelegator.getProvider().getOutputStream(outputFile, true);){
            int len;
            byte[] buffer = new byte[config.getBufferSize()];
            while ((len = is.read(buffer)) > 0) {
                os.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            new ProviderException("[" + targetDelegator.getLabel() + "][CumulativeFile][merge][" + inputFile + "]->[" + outputFile + "]" + e, (Throwable)e);
        }
    }

    private static void compress(ISOSLogger logger, YADECopyMoveOperationsConfig config, YADETargetProviderDelegator targetDelegator, String inputFile, String gzipFile) throws ProviderException {
        if (logger.isDebugEnabled()) {
            logger.debug("[%s][%s][compress][%s]->[%s]", new Object[]{targetDelegator.getLabel(), LABEL, inputFile, gzipFile});
        }
        try (InputStream is = targetDelegator.getProvider().getInputStream(inputFile);
             GZIPOutputStream os = new GZIPOutputStream(targetDelegator.getProvider().getOutputStream(gzipFile, false));){
            int len;
            byte[] buffer = new byte[config.getBufferSize()];
            while ((len = is.read(buffer)) > 0) {
                os.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            new ProviderException("[" + targetDelegator.getLabel() + "][CumulativeFile][compress][" + inputFile + "]->[" + gzipFile + "]" + e, (Throwable)e);
        }
    }
}

