/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.handlers.source;

import com.sos.commons.util.arguments.base.SOSArgumentHelper;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.yade.engine.commons.arguments.YADESourceArguments;
import com.sos.yade.engine.commons.delegators.YADESourceProviderDelegator;
import com.sos.yade.engine.commons.helpers.YADEClientHelper;
import com.sos.yade.engine.commons.helpers.YADEProviderDelegatorHelper;
import com.sos.yade.engine.exceptions.YADEEngineSourcePollingException;
import com.sos.yade.engine.handlers.source.YADESourceFilesSelector;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class YADESourceFilesPolling {
    private static final int POLLING_MAX_RETRIES_ON_CONNECTION_ERROR = 1000;
    private static final int WAIT_SECONDS_ON_CONNECTION_ERROR = 10;
    private YADESourceArguments args;
    private PollingMethod method;
    private String mainLogPrefix;
    private String logPrefix;
    private Instant start;
    private long interval;
    private long timeout;
    private long serverDuration;
    private long totalFilesCount;
    private int cycleCounter;

    public YADESourceFilesPolling(YADESourceProviderDelegator sourceDelegator) {
        this.args = sourceDelegator.getArgs();
        this.initMethod();
        this.mainLogPrefix = "[" + sourceDelegator.getLabel() + "][polling]";
        this.start = Instant.now();
    }

    public void incrementCycleCounter() {
        ++this.cycleCounter;
        this.logPrefix = this.mainLogPrefix + "[cycle=" + this.cycleCounter + "]";
    }

    public List<ProviderFile> selectFiles(ISOSLogger logger, YADESourceProviderDelegator sourceDelegator, String excludedFileExtension) throws YADEEngineSourcePollingException {
        List<ProviderFile> result = new ArrayList<ProviderFile>();
        int currentFilesCount = 0;
        boolean filesCount = false;
        long currentPollingTime = 0L;
        boolean shouldSelectFiles = false;
        while (true) {
            if (currentPollingTime == 0L && logger.isDebugEnabled()) {
                logger.debug("%s[start]%s s...", new Object[]{this.logPrefix, this.timeout});
            }
            if (currentPollingTime > this.timeout) {
                if (!logger.isDebugEnabled()) break;
                logger.debug("%s[end]%s s", new Object[]{logger, this.timeout});
                break;
            }
            if (!shouldSelectFiles && ((Boolean)this.args.getPolling().getPollingWait4SourceFolder().getValue()).booleanValue()) {
                this.ensureConnected(logger, sourceDelegator, currentPollingTime);
                try {
                    if (sourceDelegator.getProvider().exists(sourceDelegator.getDirectory())) {
                        shouldSelectFiles = true;
                    }
                    logger.info("[%s[%s]Source directory not found. Wait for the directory due to polling mode...", new Object[]{this.logPrefix, sourceDelegator.getDirectory()});
                    shouldSelectFiles = false;
                }
                catch (Exception e) {
                    throw new YADEEngineSourcePollingException(e);
                }
            } else {
                shouldSelectFiles = true;
            }
            if (shouldSelectFiles) {
                try {
                    this.ensureConnected(logger, sourceDelegator, currentPollingTime);
                    result = YADESourceFilesSelector.selectFiles(logger, sourceDelegator, excludedFileExtension, true);
                    currentFilesCount = result.size();
                }
                catch (Throwable e) {
                    logger.error("%s[selectFiles]%s", new Object[]{this.logPrefix, e.toString()});
                }
                if (this.args.getPolling().isPollMinFilesEnabled()) {
                    int pollMinFiles = (Integer)this.args.getPolling().getPollMinFiles().getValue();
                    if (logger.isDebugEnabled()) {
                        logger.debug("%s[pollMinFiles=%s][currentFilesCount=%s]", new Object[]{this.logPrefix, pollMinFiles, currentFilesCount});
                    }
                    if (currentFilesCount >= Math.max(1, pollMinFiles)) {
                        logger.debug("%s[pollMinFiles]break", new Object[]{this.logPrefix});
                        break;
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("[wait]%s seconds...", new Object[]{this.interval});
            }
            YADEClientHelper.waitFor(this.interval);
            currentPollingTime += this.interval;
            if (filesCount < currentFilesCount || !filesCount) continue;
            if (!this.args.getPolling().getWaitingForLateComers().isTrue()) break;
            this.args.getPolling().getWaitingForLateComers().setValue((Object)false);
        }
        this.totalFilesCount += (long)result.size();
        return result;
    }

    public boolean startNextPollingCycle(ISOSLogger logger) {
        return this.isPollingServer() && !this.isPollingServerDurationElapsed(logger);
    }

    public void ensureConnected(ISOSLogger logger, YADESourceProviderDelegator sourceDelegator) throws YADEEngineSourcePollingException {
        this.ensureConnected(logger, sourceDelegator, 0L);
    }

    private void ensureConnected(ISOSLogger logger, YADESourceProviderDelegator sourceDelegator, long currentPollingTime) throws YADEEngineSourcePollingException {
        try {
            int count = 0;
            while (true) {
                ++count;
                try {
                    sourceDelegator.getProvider().ensureConnected();
                    return;
                }
                catch (Throwable e) {
                    if (PollingMethod.Forever.equals((Object)this.method)) {
                        if (count >= 1000) {
                            throw new YADEEngineSourcePollingException(String.format("Maximum reconnect retries(%s) reached", 1000), (Throwable)((Object)YADEProviderDelegatorHelper.getConnectionException(sourceDelegator, e)));
                        }
                    } else {
                        long pollingTime;
                        long currentTime = System.currentTimeMillis() / 1000L;
                        long duration = currentTime - (pollingTime = PollingMethod.ServerDuration.equals((Object)this.method) ? this.start.getEpochSecond() : currentPollingTime);
                        if (duration >= this.getPollTimeout()) {
                            throw new YADEEngineSourcePollingException((Throwable)((Object)YADEProviderDelegatorHelper.getConnectionException(sourceDelegator, e)));
                        }
                    }
                    String error = String.format("%s[reconnect][exception occured, wait %ss and try again (%s of %s)]%s", this.logPrefix, 10, count, 1000, e.toString());
                    if (count % 100 == 1) {
                        // empty if block
                    }
                    logger.warn((Object)error);
                    YADEClientHelper.waitFor(10L);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            throw new YADEEngineSourcePollingException((Throwable)((Object)YADEProviderDelegatorHelper.getConnectionException(sourceDelegator, e)));
        }
    }

    private void initMethod() {
        this.interval = SOSArgumentHelper.asSeconds(this.args.getPolling().getPollInterval(), (long)60L);
        this.timeout = this.getPollTimeout();
        if (this.isPollingServer()) {
            if (this.args.getPolling().getPollingServerDuration().getValue() != null && !this.args.getPolling().getPollingServerPollForever().isTrue()) {
                this.method = PollingMethod.ServerDuration;
                this.serverDuration = SOSArgumentHelper.asSeconds(this.args.getPolling().getPollingServerDuration(), (long)60L);
            } else {
                this.method = PollingMethod.Forever;
            }
        } else {
            this.method = PollingMethod.Timeout;
        }
    }

    private long getPollTimeout() {
        if (this.args.getPolling().getPollTimeout().getValue() == null) {
            return 0L;
        }
        return (Integer)this.args.getPolling().getPollTimeout().getValue() * 60;
    }

    public PollingMethod getMethod() {
        return this.method;
    }

    public boolean isPollingServer() {
        return this.args.getPolling().getPollingServer().isTrue();
    }

    private boolean isServerDuration() {
        return PollingMethod.ServerDuration.equals((Object)this.method);
    }

    private boolean isPollingServerDurationElapsed(ISOSLogger logger) {
        if (!this.isServerDuration()) {
            return false;
        }
        long differenceInSeconds = Math.abs(Instant.now().getEpochSecond() - this.start.getEpochSecond());
        if (differenceInSeconds >= this.serverDuration) {
            if (logger.isDebugEnabled()) {
                logger.debug("[%s][PollingServerDuration=%s][duration=%ss]time elapsed. terminate polling server", new Object[]{this.method, this.args.getPolling().getPollingServerDuration().getValue(), differenceInSeconds});
            }
            return true;
        }
        return false;
    }

    private static enum PollingMethod {
        Timeout,
        ServerDuration,
        Forever;

    }
}

