/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.httpclient.azure;

import com.sos.commons.exception.SOSRequiredArgumentMissingException;
import com.sos.commons.httpclient.azure.commons.AzureBlobStorageUploader;
import com.sos.commons.httpclient.azure.commons.auth.AAzureStorageAuthProvider;
import com.sos.commons.httpclient.commons.ABaseHttpClient;
import com.sos.commons.httpclient.commons.ABaseHttpClientBuilder;
import com.sos.commons.httpclient.commons.HttpExecutionResult;
import com.sos.commons.util.SOSClassUtil;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.http.HttpUtils;
import com.sos.commons.util.loggers.base.ISOSLogger;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class AzureBlobStorageClient
extends ABaseHttpClient {
    public static final String HEADER_X_MS_BLOB_TYPE = "x-ms-blob-type";
    private final String serviceEndpoint;
    private final AAzureStorageAuthProvider authProvider;
    private final boolean maskQueryParams;

    protected AzureBlobStorageClient(ISOSLogger logger, HttpClient client, String serviceEndpoint, AAzureStorageAuthProvider authProvider) {
        super(logger, client, false);
        this.serviceEndpoint = serviceEndpoint;
        this.authProvider = authProvider;
        this.maskQueryParams = authProvider != null && authProvider.isSASToken();
    }

    public static Builder withBuilder() {
        return new Builder();
    }

    public static Builder withBuilder(HttpClient.Builder builder) {
        return new Builder(builder);
    }

    public String formatExecutionResultForException(HttpExecutionResult<?> result) {
        result.formatWithResponseBody(true);
        result.formatWithMaskRequestURIQueryParams(this.maskQueryParams);
        return AzureBlobStorageClient.formatExecutionResult(result);
    }

    public HttpExecutionResult<String> executeGETStorage() throws Exception {
        LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
        queryParams.put("comp", "list");
        String canonicalizedQuery = this.toCanonicalizedQuery(queryParams);
        String canonicalizedResource = this.canonicalize(null, null, canonicalizedQuery);
        String path = "?comp=list";
        String rawUrl = this.buildUrl(path);
        String url = this.authProvider.appendToUrl(rawUrl);
        Map<String, String> authHeaders = this.authProvider.createAuthHeaders("GET", url, canonicalizedResource, this.getDefaultHeaders(), 0L);
        return this.executeWithResponseBody(this.createRequestBuilder(URI.create(url), authHeaders).GET().build());
    }

    public HttpExecutionResult<String> executeGETStorageServicePropertiers() throws Exception {
        LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
        queryParams.put("restype", "service");
        queryParams.put("comp", "properties");
        String canonicalizedQuery = this.toCanonicalizedQuery(queryParams);
        String canonicalizedResource = this.canonicalize(null, null, canonicalizedQuery);
        String path = "?restype=service&comp=properties";
        String rawUrl = this.buildUrl(path);
        String url = this.authProvider.appendToUrl(rawUrl);
        Map<String, String> authHeaders = this.authProvider.createAuthHeaders("GET", url, canonicalizedResource, this.getDefaultHeaders(), 0L);
        return this.executeWithResponseBody(this.createRequestBuilder(URI.create(url), authHeaders).GET().build());
    }

    public HttpExecutionResult<Void> executeHEADBlob(String containerName, String blobPath) throws Exception {
        String encodedBlobPath = HttpUtils.normalizeAndEncodeRelativePath((String)blobPath);
        String path = containerName + "/" + encodedBlobPath;
        String rawUrl = this.buildUrl(path);
        String url = this.authProvider.appendToUrl(rawUrl);
        Map<String, String> authHeaders = this.authProvider.createAuthHeaders("HEAD", url, this.canonicalize(containerName, encodedBlobPath, ""), this.getDefaultHeaders(), 0L);
        return this.executeNoResponseBody(this.createHEADRequest(URI.create(url), authHeaders));
    }

    public HttpExecutionResult<InputStream> executeGETBlobInputStream(String containerName, String blobPath) throws Exception {
        String encodedBlobPath = HttpUtils.normalizeAndEncodeRelativePath((String)blobPath);
        String path = containerName + "/" + encodedBlobPath;
        String rawUrl = this.buildUrl(path);
        String url = this.authProvider.appendToUrl(rawUrl);
        Map<String, String> authHeaders = this.authProvider.createAuthHeaders("GET", url, this.canonicalize(containerName, encodedBlobPath, ""), this.getDefaultHeaders(), 0L);
        return this.execute(this.createRequestBuilder(URI.create(url), authHeaders).GET().build(), HttpResponse.BodyHandlers.ofInputStream());
    }

    public HttpExecutionResult<String> executeGETBlobContent(String containerName, String blobPath) throws Exception {
        String encodedBlobPath = HttpUtils.normalizeAndEncodeRelativePath((String)blobPath);
        String path = containerName + "/" + encodedBlobPath;
        String rawUrl = this.buildUrl(path);
        String url = this.authProvider.appendToUrl(rawUrl);
        Map<String, String> authHeaders = this.authProvider.createAuthHeaders("GET", url, this.canonicalize(containerName, encodedBlobPath, ""), this.getDefaultHeaders(), 0L);
        return this.executeWithResponseBody(this.createRequestBuilder(URI.create(url), authHeaders).GET().build());
    }

    public HttpExecutionResult<String> executeDELETEBlob(String containerName, String blobPath) throws Exception {
        String encodedBlobPath = HttpUtils.normalizeAndEncodeRelativePath((String)blobPath);
        String path = containerName + "/" + encodedBlobPath;
        String rawUrl = this.buildUrl(path);
        String url = this.authProvider.appendToUrl(rawUrl);
        Map<String, String> authHeaders = this.authProvider.createAuthHeaders("DELETE", url, this.canonicalize(containerName, encodedBlobPath, ""), this.getDefaultHeaders(), 0L);
        HttpRequest.Builder builder = this.createRequestBuilder(URI.create(url), authHeaders).DELETE();
        return this.executeWithResponseBody(builder.build());
    }

    public HttpExecutionResult<String> executeGETBlobList(String containerName, String blobPath, boolean recursive) throws Exception {
        LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
        queryParams.put("restype", "container");
        queryParams.put("comp", "list");
        if (!SOSString.isEmpty((String)blobPath) && !"/".equals(blobPath)) {
            queryParams.put("prefix", blobPath);
        }
        if (!recursive) {
            queryParams.put("delimiter", "/");
        }
        String canonicalizedQuery = this.toCanonicalizedQuery(queryParams);
        String canonicalizedResource = this.canonicalize(containerName, null, canonicalizedQuery);
        StringBuilder urlBuilder = new StringBuilder(this.buildUrl(containerName)).append("?");
        boolean first = true;
        for (Map.Entry<String, String> entry : queryParams.entrySet()) {
            if (!first) {
                urlBuilder.append("&");
            }
            urlBuilder.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8));
            first = false;
        }
        String rawUrl = urlBuilder.toString();
        String url = this.authProvider.appendToUrl(rawUrl);
        Map<String, String> authHeaders = this.authProvider.createAuthHeaders("GET", url, canonicalizedResource, this.getDefaultHeaders(), 0L);
        HttpRequest.Builder builder = this.createRequestBuilder(URI.create(url), authHeaders).GET();
        return this.executeWithResponseBody(builder.build());
    }

    private HttpExecutionResult<String> executePUTBlobInputStream(String containerName, String blobName, InputStream is, String contentType) throws Exception {
        AzureBlobStorageUploader uploader = new AzureBlobStorageUploader(this);
        return uploader.upload(containerName, blobName, is, contentType);
    }

    public HttpExecutionResult<String> executePUTBlob(String containerName, String blobPath, InputStream is, String contentType) throws Exception {
        String encodedBlobPath = HttpUtils.normalizeAndEncodeRelativePath((String)blobPath);
        String path = containerName + "/" + encodedBlobPath;
        String rawUrl = this.buildUrl(path);
        String url = this.authProvider.appendToUrl(rawUrl);
        HashMap<String, String> existingHeaders = new HashMap<String, String>(this.getDefaultHeaders());
        existingHeaders.put(HEADER_X_MS_BLOB_TYPE, "BlockBlob");
        if (contentType != null) {
            existingHeaders.put("content-type", contentType);
        }
        byte[] data = SOSClassUtil.toByteArray((InputStream)is);
        Map<String, String> authHeaders = this.authProvider.createAuthHeaders("PUT", url, this.canonicalize(containerName, encodedBlobPath, ""), existingHeaders, data.length);
        HttpRequest.Builder builder = this.createRequestBuilder(URI.create(url), authHeaders).PUT(HttpRequest.BodyPublishers.ofByteArray(data));
        return this.executeWithResponseBody(builder.build());
    }

    public HttpExecutionResult<String> executePUTBlob(String containerName, String blobPath, byte[] data, String contentType) throws Exception {
        String encodedBlobPath = HttpUtils.normalizeAndEncodeRelativePath((String)blobPath);
        String path = containerName + "/" + encodedBlobPath;
        String rawUrl = this.buildUrl(path);
        String url = this.authProvider.appendToUrl(rawUrl);
        HashMap<String, String> existingHeaders = new HashMap<String, String>(this.getDefaultHeaders());
        existingHeaders.put(HEADER_X_MS_BLOB_TYPE, "BlockBlob");
        if (contentType != null) {
            existingHeaders.put("content-type", contentType);
        }
        Map<String, String> authHeaders = this.authProvider.createAuthHeaders("PUT", url, this.canonicalize(containerName, encodedBlobPath, ""), existingHeaders, data.length);
        HttpRequest.Builder builder = this.createRequestBuilder(URI.create(url), authHeaders).PUT(HttpRequest.BodyPublishers.ofByteArray(data));
        return this.executeWithResponseBody(builder.build());
    }

    public static String getContentLengthHeaderValue(String contentLength) {
        if ("0".equals(contentLength)) {
            return "";
        }
        return contentLength;
    }

    public static String getContentLengthHeaderValue(int contentLength) {
        return AzureBlobStorageClient.getContentLengthHeaderValue(String.valueOf(contentLength));
    }

    public static String getContentLengthHeaderValue(long contentLength) {
        return AzureBlobStorageClient.getContentLengthHeaderValue(String.valueOf(contentLength));
    }

    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public AAzureStorageAuthProvider getAuthProvider() {
        return this.authProvider;
    }

    public String buildUrl(String path) {
        return this.serviceEndpoint + "/" + path;
    }

    public String canonicalize(String containerName, String blobPath, String canonicalizedHeaders) {
        StringBuilder sb = new StringBuilder();
        sb.append("/").append(this.authProvider.getAccountName()).append("/");
        if (!SOSString.isEmpty((String)containerName)) {
            sb.append(containerName);
        }
        if (!SOSString.isEmpty((String)blobPath)) {
            sb.append("/" + blobPath);
        }
        if (!canonicalizedHeaders.isEmpty()) {
            sb.append("\n").append(canonicalizedHeaders);
        }
        return sb.toString();
    }

    public String toCanonicalizedQuery(LinkedHashMap<String, String> queryParams) {
        return queryParams.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> ((String)e.getKey()).toLowerCase() + ":" + (String)e.getValue()).collect(Collectors.joining("\n"));
    }

    public static class Builder
    extends ABaseHttpClientBuilder<AzureBlobStorageClient, Builder> {
        private String serviceEndpoint;
        private AAzureStorageAuthProvider authProvider;

        public Builder() {
        }

        public Builder(HttpClient.Builder builder) {
            super(builder);
        }

        public Builder withServiceEndpoint(String serviceEndpoint) {
            this.serviceEndpoint = serviceEndpoint;
            return this;
        }

        public Builder withAuthProvider(AAzureStorageAuthProvider authProvider) {
            this.authProvider = authProvider;
            return this;
        }

        @Override
        protected AzureBlobStorageClient createInstance(ISOSLogger logger, HttpClient client) throws Exception {
            if (SOSString.isEmpty((String)this.serviceEndpoint)) {
                throw new SOSRequiredArgumentMissingException("ServiceEndpoint");
            }
            if (this.authProvider == null) {
                throw new SOSRequiredArgumentMissingException("AuthProvider");
            }
            return new AzureBlobStorageClient(logger, client, this.serviceEndpoint, this.authProvider);
        }
    }
}

