/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.httpclient.azure.commons;

import com.sos.commons.httpclient.azure.AzureBlobStorageClient;
import com.sos.commons.httpclient.commons.HttpExecutionResult;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AzureBlobStorageUploader {
    private static final int BLOCK_SIZE = 0x400000;
    private final AzureBlobStorageClient client;

    public AzureBlobStorageUploader(AzureBlobStorageClient client) {
        this.client = client;
    }

    public HttpExecutionResult<String> upload(String containerName, String blobName, InputStream is, String contentType) throws Exception {
        int bytesRead;
        byte[] buffer = new byte[0x400000];
        ArrayList<String> blockIds = new ArrayList<String>();
        int blockIndex = 0;
        while ((bytesRead = is.read(buffer)) != -1) {
            byte[] block = bytesRead == 0x400000 ? buffer : Arrays.copyOf(buffer, bytesRead);
            String blockId = Base64.getEncoder().encodeToString(("block-" + blockIndex).getBytes(StandardCharsets.UTF_8));
            blockIds.add(blockId);
            this.uploadBlock(containerName, blobName, blockId, block);
            ++blockIndex;
        }
        return this.commitBlocks(containerName, blobName, blockIds, contentType);
    }

    private HttpExecutionResult<String> uploadBlock(String containerName, String blobName, String blockId, byte[] blockData) throws Exception {
        LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
        queryParams.put("blockid", blockId);
        queryParams.put("comp", "block");
        String canonicalizedQuery = this.client.toCanonicalizedQuery(queryParams);
        String canonicalizedResource = this.client.canonicalize(containerName, blobName, canonicalizedQuery);
        StringBuilder urlBuilder = new StringBuilder(this.client.buildUrl(containerName)).append("?");
        boolean first = true;
        for (Map.Entry<String, String> entry : queryParams.entrySet()) {
            if (!first) {
                urlBuilder.append("&");
            }
            urlBuilder.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8));
            first = false;
        }
        String rawUrl = urlBuilder.toString();
        String url = this.client.getAuthProvider().appendToUrl(rawUrl);
        HashMap<String, String> existingHeaders = new HashMap<String, String>(this.client.getDefaultHeaders());
        existingHeaders.put("x-ms-blob-type", "BlockBlob");
        Map<String, String> authHeaders = this.client.getAuthProvider().createAuthHeaders("PUT", url, canonicalizedResource, existingHeaders, blockData.length);
        HttpRequest.Builder request = this.client.createRequestBuilder(URI.create(url), authHeaders).PUT(HttpRequest.BodyPublishers.ofByteArray(blockData));
        return this.client.executeWithResponseBody(request.build());
    }

    private HttpExecutionResult<String> commitBlocks(String containerName, String blobName, List<String> blockIds, String contentType) throws Exception {
        LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
        queryParams.put("comp", "blocklist");
        String path = containerName + "/" + blobName + "?" + this.toQueryString(queryParams);
        String rawUrl = this.client.buildUrl(path);
        String url = this.client.getAuthProvider().appendToUrl(rawUrl);
        StringBuilder xml = new StringBuilder("<?xml version=\"1.0\" encoding=\"utf-8\"?><BlockList>");
        for (String id : blockIds) {
            xml.append("<Latest>").append(id).append("</Latest>");
        }
        xml.append("</BlockList>");
        byte[] xmlBytes = xml.toString().getBytes(StandardCharsets.UTF_8);
        HashMap<String, String> existingHeaders = new HashMap<String, String>(this.client.getDefaultHeaders());
        existingHeaders.put("x-ms-blob-content-type", contentType);
        existingHeaders.put("Content-Type", "application/xml");
        String canonicalizedQuery = this.client.toCanonicalizedQuery(queryParams);
        String canonicalizedResource = this.client.canonicalize(containerName, blobName, canonicalizedQuery);
        Map<String, String> authHeaders = this.client.getAuthProvider().createAuthHeaders("PUT", url, canonicalizedResource, existingHeaders, xmlBytes.length);
        HttpRequest.Builder request = this.client.createRequestBuilder(URI.create(url), authHeaders).PUT(HttpRequest.BodyPublishers.ofByteArray(xmlBytes));
        return this.client.executeWithResponseBody(request.build());
    }

    private String toQueryString(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (!first) {
                sb.append("&");
            }
            sb.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8));
            first = false;
        }
        return sb.toString();
    }
}

