/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.httpclient.commons;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sos.commons.exception.SOSInvalidDataException;
import com.sos.commons.exception.SOSNoSuchFileException;
import com.sos.commons.httpclient.commons.HttpExecutionResult;
import com.sos.commons.util.SOSClassUtil;
import com.sos.commons.util.SOSCollection;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.http.HttpUtils;
import com.sos.commons.util.loggers.base.ISOSLogger;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.SSLSession;

public abstract class ABaseHttpClient
implements AutoCloseable {
    private static final Set<String> DEFAULT_SENSITIVE_HEADERS = Set.of("authorization", "proxy-authorization", "cookie", "set-cookie", "x-api-key", "x-auth-token", "authentication-token", "session-id", "x-csrf-token", "x-access-token", "x-id-token");
    private static final String MASKED_VALUE = SOSArgument.DisplayMode.MASKED.getValue();
    private final ISOSLogger logger;
    private final HttpClient client;
    private Map<String, String> defaultHeaders;
    private Set<String> sensitiveHeaders = new LinkedHashSet<String>(DEFAULT_SENSITIVE_HEADERS);
    private Boolean isHEADMethodAllowed;
    private boolean chunkedTransfer = true;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    protected ABaseHttpClient(ISOSLogger logger, HttpClient client) {
        this(logger, client, true);
    }

    protected ABaseHttpClient(ISOSLogger logger, HttpClient client, boolean chunkedTransfer) {
        this.logger = logger;
        this.client = client;
        this.chunkedTransfer = chunkedTransfer;
    }

    @Override
    public void close() throws Exception {
    }

    public String getServerInfo(HttpResponse<?> response) {
        if (response == null) {
            return null;
        }
        Optional<String> info = this.getResponseHeader(response, "server");
        return info.isPresent() ? "Server " + info.get() : null;
    }

    public HttpRequest.Builder createRequestBuilder(URI uri) {
        return this.createRequestBuilder(uri, this.defaultHeaders);
    }

    public HttpRequest.Builder createRequestBuilder(URI uri, Map<String, String> headers) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(uri);
        this.setRequestHeaders(builder, headers);
        return builder;
    }

    public <T> HttpExecutionResult<T> execute(HttpRequest request, HttpResponse.BodyHandler<T> bodyHandler) throws Exception {
        this.debugHeaders("HttpRequest headers", request.headers());
        return new HttpExecutionResult<T>(this, this.client.send(request, bodyHandler));
    }

    public HttpExecutionResult<String> executeWithResponseBody(HttpRequest request) throws Exception {
        return this.execute(request, HttpResponse.BodyHandlers.ofString());
    }

    public HttpExecutionResult<JsonNode> executeWithJsonNodeResponseBody(HttpRequest request) throws Exception {
        HttpExecutionResult<String> r = this.executeWithResponseBody(request);
        this.verifyJsonResponse(r.response());
        return this.wrapHttpExecutionResultJsonNode(r);
    }

    public <T> HttpExecutionResult<T> executeWithJsonResponseBody(HttpRequest request, Class<T> type) throws Exception {
        HttpExecutionResult<String> r = this.executeWithResponseBody(request);
        this.verifyJsonResponse(r.response());
        return this.wrapHttpExecutionResultJson(r, type);
    }

    public <T> HttpExecutionResult<T> executeWithJsonResponseBody(HttpRequest request, TypeReference<T> typeRef) throws Exception {
        HttpExecutionResult<String> r = this.executeWithResponseBody(request);
        this.verifyJsonResponse(r.response());
        return this.wrapHttpExecutionResultJson(r, typeRef);
    }

    public HttpExecutionResult<Map<String, Object>> executeWithJsonAsMapResponseBody(HttpRequest request) throws Exception {
        HttpExecutionResult<String> r = this.executeWithResponseBody(request);
        this.verifyJsonResponse(r.response());
        return this.wrapHttpExecutionResultJson(r, new TypeReference<Map<String, Object>>(){});
    }

    public HttpExecutionResult<Void> executeNoResponseBody(HttpRequest request) throws Exception {
        return this.execute(request, HttpResponse.BodyHandlers.discarding());
    }

    public HttpExecutionResult<Void> executeHEADOrGETNoResponseBody(URI uri) throws Exception {
        HttpRequest request = null;
        boolean isHEAD = false;
        if (this.isHEADMethodAllowed == null || this.isHEADMethodAllowed.booleanValue()) {
            request = this.createHEADRequest(uri);
            isHEAD = true;
        } else {
            request = this.createGETRequest(uri);
        }
        HttpExecutionResult<Void> result = this.executeNoResponseBody(request);
        if (isHEAD) {
            if (HttpUtils.isMethodNotAllowed((int)result.response().statusCode())) {
                this.isHEADMethodAllowed = false;
                result = this.executeNoResponseBody(this.createGETRequest(uri));
            } else {
                this.isHEADMethodAllowed = true;
            }
        }
        return result;
    }

    public <T> HttpExecutionResult<T> executeGET(URI uri, HttpResponse.BodyHandler<T> handler) throws Exception {
        return this.execute(this.createGETRequest(uri), handler);
    }

    public <T> HttpExecutionResult<T> executeGET(URI uri, Map<String, String> headers, HttpResponse.BodyHandler<T> handler) throws Exception {
        return this.execute(this.createGETRequest(uri, headers), handler);
    }

    public HttpExecutionResult<String> executeGET(URI uri) throws Exception {
        return this.executeWithResponseBody(this.createGETRequest(uri));
    }

    public HttpExecutionResult<JsonNode> executeGETJson(URI uri) throws Exception {
        return this.executeWithJsonNodeResponseBody(this.createGETRequest(uri));
    }

    public <T> HttpExecutionResult<T> executeGETJson(URI uri, Class<T> type) throws Exception {
        return this.executeWithJsonResponseBody(this.createGETRequest(uri), type);
    }

    public <T> HttpExecutionResult<T> executeGETJson(URI uri, TypeReference<T> typeRef) throws Exception {
        return this.executeWithJsonResponseBody(this.createGETRequest(uri), typeRef);
    }

    public HttpExecutionResult<Void> executeGETNoResponseBody(URI uri) throws Exception {
        return this.executeNoResponseBody(this.createGETRequest(uri));
    }

    public <T> HttpExecutionResult<T> executePOST(URI uri, HttpResponse.BodyHandler<T> handler) throws Exception {
        return this.execute(this.createPOSTRequest(uri, this.defaultHeaders, HttpRequest.BodyPublishers.noBody()), handler);
    }

    public <T> HttpExecutionResult<T> executePOST(URI uri, HttpRequest.BodyPublisher bodyPublisher, HttpResponse.BodyHandler<T> handler) throws Exception {
        return this.execute(this.createPOSTRequest(uri, this.defaultHeaders, bodyPublisher), handler);
    }

    public <T> HttpExecutionResult<T> executePOST(URI uri, String requestBody, HttpResponse.BodyHandler<T> handler) throws Exception {
        return this.execute(this.createPOSTRequest(uri, this.defaultHeaders, HttpRequest.BodyPublishers.ofString(requestBody)), handler);
    }

    public <T> HttpExecutionResult<T> executePOST(URI uri, Map<String, String> headers, String requestBody, HttpResponse.BodyHandler<T> handler) throws Exception {
        return this.executePOST(uri, headers, Optional.ofNullable(requestBody), handler);
    }

    public <T> HttpExecutionResult<T> executePOST(URI uri, Map<String, String> headers, Optional<String> requestBody, HttpResponse.BodyHandler<T> handler) throws Exception {
        if (requestBody == null) {
            throw new SOSInvalidDataException("The Optional of the request body is null. Cannot execute request!");
        }
        return this.execute(this.createPOSTRequest(uri, headers, requestBody.map(HttpRequest.BodyPublishers::ofString).orElse(HttpRequest.BodyPublishers.noBody())), handler);
    }

    public <T> HttpExecutionResult<T> executePOST(URI uri, Map<String, String> headers, HttpRequest.BodyPublisher requestBody, HttpResponse.BodyHandler<T> handler) throws Exception {
        return this.execute(this.createPOSTRequest(uri, headers, requestBody), handler);
    }

    public HttpExecutionResult<String> executePOST(URI uri) throws Exception {
        return this.executeWithResponseBody(this.createPOSTRequest(uri, this.defaultHeaders, HttpRequest.BodyPublishers.noBody()));
    }

    public HttpExecutionResult<String> executePOST(URI uri, Map<String, String> headers) throws Exception {
        return this.executeWithResponseBody(this.createPOSTRequest(uri, headers, HttpRequest.BodyPublishers.noBody()));
    }

    public HttpExecutionResult<String> executePOST(URI uri, HttpRequest.BodyPublisher bodyPublisher) throws Exception {
        return this.executeWithResponseBody(this.createPOSTRequest(uri, this.defaultHeaders, bodyPublisher));
    }

    public HttpExecutionResult<String> executePOST(URI uri, String requestBody) throws Exception {
        return this.executePOST(uri, this.defaultHeaders, requestBody);
    }

    public HttpExecutionResult<String> executePOST(URI uri, Map<String, String> headers, String requestBody) throws Exception {
        return this.executeWithResponseBody(this.createPOSTRequest(uri, headers, requestBody != null ? HttpRequest.BodyPublishers.ofString(requestBody) : HttpRequest.BodyPublishers.noBody()));
    }

    public HttpExecutionResult<JsonNode> executePOSTJson(URI uri, HttpRequest.BodyPublisher bodyPublisher) throws Exception {
        return this.executeWithJsonNodeResponseBody(this.createPOSTRequest(uri, this.defaultHeaders, bodyPublisher));
    }

    public HttpExecutionResult<JsonNode> executePOSTJson(URI uri, String requestBody) throws Exception {
        return this.executeWithJsonNodeResponseBody(this.createPOSTRequest(uri, this.defaultHeaders, HttpRequest.BodyPublishers.ofString(requestBody)));
    }

    public HttpExecutionResult<JsonNode> executePOSTJson(URI uri) throws Exception {
        return this.executeWithJsonNodeResponseBody(this.createPOSTRequest(uri, this.defaultHeaders, HttpRequest.BodyPublishers.noBody()));
    }

    public <T> HttpExecutionResult<T> executePOSTJson(URI uri, HttpRequest.BodyPublisher bodyPublisher, Class<T> type) throws Exception {
        return this.executeWithJsonResponseBody(this.createPOSTRequest(uri, this.defaultHeaders, bodyPublisher), type);
    }

    public <T> HttpExecutionResult<T> executePOSTJson(URI uri, String requestBody, Class<T> type) throws Exception {
        return this.executeWithJsonResponseBody(this.createPOSTRequest(uri, this.defaultHeaders, HttpRequest.BodyPublishers.ofString(requestBody)), type);
    }

    public <T> HttpExecutionResult<T> executePOSTJson(URI uri, Class<T> type) throws Exception {
        return this.executeWithJsonResponseBody(this.createPOSTRequest(uri, this.defaultHeaders, HttpRequest.BodyPublishers.noBody()), type);
    }

    public <T> HttpExecutionResult<T> executePOSTJson(URI uri, HttpRequest.BodyPublisher bodyPublisher, TypeReference<T> typeRef) throws Exception {
        return this.executeWithJsonResponseBody(this.createPOSTRequest(uri, this.defaultHeaders, bodyPublisher), typeRef);
    }

    public <T> HttpExecutionResult<T> executePOSTJson(URI uri, String requestBody, TypeReference<T> typeRef) throws Exception {
        return this.executeWithJsonResponseBody(this.createPOSTRequest(uri, this.defaultHeaders, HttpRequest.BodyPublishers.ofString(requestBody)), typeRef);
    }

    public <T> HttpExecutionResult<T> executePOSTJson(URI uri, TypeReference<T> typeRef) throws Exception {
        return this.executeWithJsonResponseBody(this.createPOSTRequest(uri, this.defaultHeaders, HttpRequest.BodyPublishers.noBody()), typeRef);
    }

    public HttpExecutionResult<Map<String, Object>> executePOSTJsonAsMap(URI uri, String requestBody) throws Exception {
        return this.executeWithJsonResponseBody(this.createPOSTRequest(uri, this.defaultHeaders, HttpRequest.BodyPublishers.ofString(requestBody)), new TypeReference<Map<String, Object>>(){});
    }

    public HttpExecutionResult<Map<String, Object>> executePOSTJsonAsMap(URI uri) throws Exception {
        return this.executeWithJsonResponseBody(this.createPOSTRequest(uri, this.defaultHeaders, HttpRequest.BodyPublishers.noBody()), new TypeReference<Map<String, Object>>(){});
    }

    public Map<String, Object> parseJsonToMap(HttpResponse<String> response) throws Exception {
        this.verifyJsonResponse(response);
        return (Map)OBJECT_MAPPER.readValue(response.body(), (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public Object getJsonProperty(HttpResponse<String> response, String propertyName) throws Exception {
        Map<String, Object> map = this.parseJsonToMap(response);
        if (map == null) {
            return null;
        }
        return map.get(propertyName);
    }

    public <T> HttpExecutionResult<T> executeDELETE(URI uri, HttpResponse.BodyHandler<T> handler) throws Exception {
        return this.execute(this.createDELETERequest(uri), handler);
    }

    public <T> HttpExecutionResult<T> executeDELETE(URI uri, Map<String, String> headers, HttpResponse.BodyHandler<T> handler) throws Exception {
        return this.execute(this.createDELETERequest(uri, headers), handler);
    }

    public HttpExecutionResult<String> executeDELETE(URI uri) throws Exception {
        return this.executeWithResponseBody(this.createDELETERequest(uri));
    }

    public HttpExecutionResult<Void> executeDELETENoResponseBody(URI uri) throws Exception {
        return this.executeNoResponseBody(this.createDELETERequest(uri));
    }

    public <T> HttpExecutionResult<T> executePUT(URI uri, HttpResponse.BodyHandler<T> handler, String content) throws Exception {
        return this.execute(this.createPUTRequest(uri, content, false), handler);
    }

    public <T> HttpExecutionResult<T> executePUT(URI uri, Map<String, String> headers, HttpRequest.BodyPublisher requestBody, HttpResponse.BodyHandler<T> handler) throws Exception {
        return this.execute(this.createPUTRequest(uri, headers, requestBody), handler);
    }

    public HttpExecutionResult<String> executePUT(URI uri, String content) throws Exception {
        return this.executeWithResponseBody(this.createPUTRequest(uri, content, false));
    }

    public HttpExecutionResult<Void> executePUTNoResponseBody(URI uri, String content) throws Exception {
        return this.executeNoResponseBody(this.createPUTRequest(uri, content, false));
    }

    public HttpExecutionResult<Void> executePUTNoResponseBody(URI uri, String content, boolean isWebDAV) throws Exception {
        return this.executeNoResponseBody(this.createPUTRequest(uri, content, isWebDAV));
    }

    public <T> HttpExecutionResult<T> executePUT(URI uri, HttpResponse.BodyHandler<T> handler, InputStream is, long size) throws Exception {
        return this.execute(this.createPUTInputStreamRequest(uri, is, size, false), handler);
    }

    public HttpExecutionResult<String> executePUT(URI uri, InputStream is, long size) throws Exception {
        return this.executeWithResponseBody(this.createPUTInputStreamRequest(uri, is, size, false));
    }

    public HttpExecutionResult<Void> executePUTNoResponseBody(URI uri, InputStream is, long size) throws Exception {
        return this.executeNoResponseBody(this.createPUTInputStreamRequest(uri, is, size, false));
    }

    public HttpExecutionResult<Void> executePUTNoResponseBody(URI uri, InputStream is, long size, boolean isWebDAV) throws Exception {
        return this.executeNoResponseBody(this.createPUTInputStreamRequest(uri, is, size, isWebDAV));
    }

    public static void withWebDAVOverwrite(HttpRequest.Builder builder, boolean withWebDAVOverwrite) {
        if (withWebDAVOverwrite) {
            builder.header("overwrite", "T");
        }
    }

    public InputStream getHTTPInputStream(URI uri) throws Exception {
        HttpRequest request = this.createGETRequest(uri);
        HttpResponse<InputStream> response = this.client.send(request, HttpResponse.BodyHandlers.ofInputStream());
        int code = response.statusCode();
        if (!HttpUtils.isSuccessful((int)code)) {
            HttpExecutionResult<InputStream> result = new HttpExecutionResult<InputStream>(this, response);
            if (HttpUtils.isNotFound((int)code)) {
                throw new SOSNoSuchFileException(uri.toString(), (Throwable)new Exception(ABaseHttpClient.formatExecutionResult(result)));
            }
            throw new Exception(ABaseHttpClient.formatExecutionResult(result));
        }
        return response.body();
    }

    public long getFileSize(HttpResponse<?> response) throws Exception {
        long size = response.headers().firstValueAsLong("content-length").orElse(-1L);
        if (size < 0L) {
            size = this.getFileSizeIfChunkedTransferEncoding(response.uri());
        }
        return size;
    }

    public long getLastModifiedInMillis(HttpResponse<?> response) {
        if (response == null) {
            return -1L;
        }
        Optional<String> header = response.headers().firstValue("last-modified");
        if (!header.isPresent()) {
            return -1L;
        }
        return HttpUtils.httpDateToMillis((String)header.get());
    }

    public static String maskSensitiveUri(URI uri) {
        if (uri == null) {
            return "";
        }
        if (SOSString.isEmpty((String)uri.getQuery())) {
            return uri.toString();
        }
        String base = uri.getScheme() + "://" + uri.getHost();
        if (uri.getPath() != null) {
            base = base + uri.getPath();
        }
        base = base.endsWith("/") ? base : base + "/";
        return base + MASKED_VALUE;
    }

    public static String formatExecutionResult(HttpExecutionResult<?> result) {
        return ABaseHttpClient.buildExecutionResultSummary(result);
    }

    public boolean isChunkedTransfer() {
        return this.chunkedTransfer;
    }

    public void setSensitiveHeaders(Set<String> val) {
        this.sensitiveHeaders = new LinkedHashSet<String>(val);
    }

    public void addSensitiveHeader(String val) {
        this.sensitiveHeaders.add(val);
    }

    public void addSensitiveHeaders(Set<String> val) {
        this.sensitiveHeaders.addAll(val);
    }

    public boolean isSensitiveHeader(String headerName) {
        return this.sensitiveHeaders.stream().anyMatch(h -> h.equalsIgnoreCase(headerName));
    }

    public Map<String, String> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public Map<String, String> mergeWithDefaultHeaders(Map<String, String> requestHeaders) {
        LinkedHashMap<String, String> merged = new LinkedHashMap<String, String>(this.defaultHeaders);
        merged.putAll(requestHeaders);
        return merged;
    }

    public Optional<String> getRequestHeader(HttpRequest request, String headerName) {
        if (request == null) {
            Optional.empty();
        }
        return request.headers().firstValue(headerName);
    }

    public Optional<String> getResponseHeader(HttpResponse<?> response, String headerName) {
        if (response == null) {
            return Optional.empty();
        }
        return response.headers().firstValue(headerName);
    }

    public Charset extractCharsetFromResponseContentType(HttpResponse<?> response) {
        String contentType = this.getResponseHeader(response, "content-type").orElse(null);
        if (contentType != null) {
            String[] parts;
            for (String part : parts = contentType.split(";")) {
                if (!(part = part.trim()).toLowerCase(Locale.ROOT).startsWith("charset=")) continue;
                String cs = part.substring(8).trim();
                try {
                    return Charset.forName(cs);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return StandardCharsets.UTF_8;
    }

    public Map<String, String> toSingleValueResponseHeaders(HttpResponse<?> response) {
        return response.headers().map().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).isEmpty() ? "" : (String)((List)e.getValue()).get(0)));
    }

    public Map<String, String> toJoinedValueResponseHeaders(HttpResponse<?> response) {
        return response.headers().map().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.join((CharSequence)", ", (Iterable)e.getValue())));
    }

    public HttpRequest createHEADRequest(URI uri) {
        return this.createHEADRequest(uri, this.defaultHeaders);
    }

    public HttpRequest createHEADRequest(URI uri, Map<String, String> headers) {
        return this.createRequestBuilder(uri, headers).method("HEAD", HttpRequest.BodyPublishers.noBody()).build();
    }

    public ISOSLogger getLogger() {
        return this.logger;
    }

    protected void debugHeaders(String title, HttpHeaders httpHeaders) {
        if (!this.logger.isDebugEnabled() || httpHeaders == null) {
            return;
        }
        Map<String, List<String>> headers = httpHeaders.map();
        if (!SOSCollection.isEmpty(headers)) {
            String headerStr = headers.entrySet().stream().map(e -> {
                String val = e.getValue() == null ? "" : (this.isSensitiveHeader((String)e.getKey()) ? MASKED_VALUE : String.join((CharSequence)", ", (Iterable)e.getValue()));
                return (String)e.getKey() + "=" + val;
            }).collect(Collectors.joining("; "));
            this.logger.debug((Object)("[" + title + "]" + headerStr));
        }
    }

    protected void setDefaultRequestHeaders(Map<String, String> headers) {
        this.defaultHeaders = headers;
        if (this.logger.isTraceEnabled() && this.defaultHeaders.size() > 0) {
            String headerStr = this.defaultHeaders.entrySet().stream().map(e -> {
                String val = this.isSensitiveHeader((String)e.getKey()) ? MASKED_VALUE : (String)e.getValue();
                return (String)e.getKey() + "=" + val;
            }).collect(Collectors.joining("; "));
            this.logger.trace((Object)("[Default HttpRequest headers(all requests)]" + headerStr));
        }
    }

    private void setRequestHeaders(HttpRequest.Builder builder, Map<String, String> headers) {
        if (headers == null) {
            return;
        }
        headers.forEach((name, value) -> {
            String nameNormalized = HttpUtils.normalizeHeaderName((String)name);
            if (SOSString.isEmpty((String)value)) {
                builder.header(nameNormalized, "");
            } else {
                builder.header(nameNormalized, (String)value);
            }
        });
    }

    private static String buildExecutionResultSummary(HttpExecutionResult<?> result) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(result.request().method()).append("]");
        if (result.formatWithMaskRequestURIQueryParams()) {
            sb.append("[").append(ABaseHttpClient.maskSensitiveUri(result.request().uri())).append("]");
        } else {
            sb.append("[").append(result.request().uri()).append("]");
        }
        sb.append("[").append(result.response().statusCode()).append("]");
        if (result.formatWithResponseBody()) {
            Object body = result.response().body();
            if (body == null) {
                sb.append(HttpUtils.getReasonPhrase((int)result.response().statusCode()));
            } else {
                sb.append(body);
            }
        } else {
            sb.append(HttpUtils.getReasonPhrase((int)result.response().statusCode()));
        }
        return sb.toString();
    }

    private HttpRequest createGETRequest(URI uri) {
        return this.createRequestBuilder(uri).GET().build();
    }

    private HttpRequest createGETRequest(URI uri, Map<String, String> headers) {
        return this.createRequestBuilder(uri, headers).GET().build();
    }

    private HttpRequest createPOSTRequest(URI uri, Map<String, String> headers, HttpRequest.BodyPublisher bodyPublisher) {
        return this.createRequestBuilder(uri, headers).POST(bodyPublisher == null ? HttpRequest.BodyPublishers.noBody() : bodyPublisher).build();
    }

    private HttpRequest createDELETERequest(URI uri) {
        return this.createRequestBuilder(uri).DELETE().build();
    }

    private HttpRequest createDELETERequest(URI uri, Map<String, String> headers) {
        return this.createRequestBuilder(uri, headers).DELETE().build();
    }

    private HttpRequest createPUTRequest(URI uri, Map<String, String> requestHeaders, HttpRequest.BodyPublisher body) {
        return this.createRequestBuilder(uri, requestHeaders).PUT(body == null ? HttpRequest.BodyPublishers.noBody() : body).build();
    }

    private HttpRequest createPUTRequest(URI uri, String content, boolean isWebDAV) {
        HttpRequest.Builder builder = this.createRequestBuilder(uri);
        builder.header("content-type", "application/octet-stream");
        ABaseHttpClient.withWebDAVOverwrite(builder, isWebDAV);
        byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        if (!this.chunkedTransfer) {
            builder.header("content-length", String.valueOf(bytes.length));
        }
        return builder.PUT(HttpRequest.BodyPublishers.ofByteArray(bytes)).build();
    }

    private HttpRequest createPUTInputStreamRequest(URI uri, InputStream is, long size, boolean isWebDAV) {
        HttpRequest.Builder builder = this.createRequestBuilder(uri);
        builder.header("content-type", "application/octet-stream");
        ABaseHttpClient.withWebDAVOverwrite(builder, isWebDAV);
        if (!this.chunkedTransfer) {
            builder.header("content-length", String.valueOf(size));
        }
        return builder.PUT(HttpRequest.BodyPublishers.ofInputStream(() -> is)).build();
    }

    private long getFileSizeIfChunkedTransferEncoding(URI uri) throws Exception {
        try (InputStream is = this.getHTTPInputStream(uri);){
            long l = SOSClassUtil.countBytes((InputStream)is);
            return l;
        }
    }

    private void verifyJsonResponse(HttpResponse<String> response) throws Exception {
        String contentType = response.headers().firstValue("content-type").orElse("");
        if (!contentType.contains("application/json")) {
            throw new Exception("Expected application/json but got: " + contentType);
        }
    }

    private <T> HttpResponse<T> wrapResponse(final HttpResponse<String> original, final T parsedBody) {
        return new HttpResponse<T>(){

            @Override
            public int statusCode() {
                return original.statusCode();
            }

            @Override
            public HttpRequest request() {
                return original.request();
            }

            @Override
            public Optional<HttpResponse<T>> previousResponse() {
                return Optional.empty();
            }

            @Override
            public HttpHeaders headers() {
                return original.headers();
            }

            @Override
            public T body() {
                return parsedBody;
            }

            @Override
            public Optional<SSLSession> sslSession() {
                return original.sslSession();
            }

            @Override
            public URI uri() {
                return original.uri();
            }

            @Override
            public HttpClient.Version version() {
                return original.version();
            }
        };
    }

    private HttpExecutionResult<JsonNode> wrapHttpExecutionResultJsonNode(HttpExecutionResult<String> original) throws Exception {
        return new HttpExecutionResult<JsonNode>(this, this.wrapResponse(original.response(), OBJECT_MAPPER.readTree(original.response().body())));
    }

    private <T> HttpExecutionResult<T> wrapHttpExecutionResultJson(HttpExecutionResult<String> original, Class<T> type) throws Exception {
        return new HttpExecutionResult<Object>(this, this.wrapResponse(original.response(), OBJECT_MAPPER.readValue(original.response().body(), type)));
    }

    private <T> HttpExecutionResult<T> wrapHttpExecutionResultJson(HttpExecutionResult<String> original, TypeReference<T> typeRef) throws Exception {
        return new HttpExecutionResult<Object>(this, this.wrapResponse(original.response(), OBJECT_MAPPER.readValue(original.response().body(), typeRef)));
    }
}

