/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.httpclient.commons.mulitpart;

import com.sos.commons.httpclient.commons.mulitpart.formdata.FormData;
import com.sos.commons.httpclient.commons.mulitpart.formdata.FormDataIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class HttpFormData
implements Iterable<byte[]> {
    private static final String boundary = "-----SOSFormBoundary" + UUID.randomUUID().toString();
    private final List<FormData> parts = new ArrayList<FormData>();
    public static final String contentType = "multipart/form-data; boundary=" + boundary;
    public static final String CONTENT_TYPE_ZIP = "application/x-zip-compressed";
    public static final String CONTENT_TYPE_GZIP = "application/x-gzip";

    public void addPart(FormData formData) {
        this.parts.add(formData);
    }

    public List<FormData> getParts() {
        return this.parts;
    }

    public String getBoundary() {
        return boundary;
    }

    public String getContentType() {
        return "multipart/form-data; boundary=" + this.getBoundary();
    }

    @Override
    public Iterator<byte[]> iterator() {
        this.parts.forEach(FormData::reset);
        return new FormDataIterator(this.parts, boundary);
    }
}

