/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.httpclient.commons.mulitpart.formdata;

import com.sos.commons.httpclient.commons.mulitpart.formdata.FormData;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class FormDataFile
extends FormData
implements Closeable {
    public static final int BUFFER_SIZE_DEFAULT = 8192;
    private final String fileName;
    private final Path file;
    private final String contenType;
    private final int bufferSize;
    private InputStream in;

    public FormDataFile(String fieldName, String fileName, Path file) {
        this(fieldName, fileName, file, "application/octet-stream");
    }

    public FormDataFile(String fieldName, String fileName, Path file, String contentType) {
        this(fieldName, fileName, file, contentType, 8192);
    }

    public FormDataFile(String fieldName, String fileName, Path file, int bufferSize) {
        this(fieldName, fileName, file, "application/octet-stream", bufferSize);
    }

    public FormDataFile(String fieldName, String fileName, Path file, String contentType, int bufferSize) {
        super(fieldName);
        this.fileName = fileName;
        this.file = file;
        this.bufferSize = bufferSize;
        this.contenType = contentType;
    }

    @Override
    public String getParamDisposition() {
        return super.getParamDisposition() + "; filename=\"" + this.fileName + "\"";
    }

    @Override
    public String getParamType() {
        return this.contenType;
    }

    @Override
    public byte[] getContent() {
        if (this.in == null) {
            try {
                this.in = Files.newInputStream(this.file, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to open file " + this.file, e);
            }
        }
        byte[] buf = new byte[this.bufferSize];
        int l = 0;
        try {
            l = this.in.read(buf);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read contents from file " + this.file, e);
        }
        if (l == this.bufferSize) {
            return buf;
        }
        if (l < 0) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close file " + this.file, e);
            }
            this.in = null;
            return null;
        }
        byte[] content = new byte[l];
        System.arraycopy(buf, 0, content, 0, l);
        return content;
    }

    @Override
    public boolean moreContent() {
        return this.in != null;
    }

    @Override
    public void reset() {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        try {
            this.in.close();
            this.in = null;
        }
        catch (IOException e) {
            this.in = null;
            throw e;
        }
    }
}

