/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.httpclient.commons.mulitpart.formdata;

import com.sos.commons.httpclient.commons.mulitpart.formdata.FormData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class FormDataIterator
implements Iterator<byte[]> {
    public static final String CRLF = "\r\n";
    private static final int PREAMBLE = 10;
    private static final int CONTENT = 20;
    private static final int POSTAMBLE = 30;
    private static final int CLOSURE = 40;
    private final List<FormData> parts;
    private final String boundary;
    private int partIndex;
    private int state = 10;

    public FormDataIterator(List<FormData> parts, String boundary) {
        this.parts = parts;
        this.boundary = boundary;
    }

    @Override
    public boolean hasNext() {
        return this.partIndex <= this.parts.size();
    }

    @Override
    public byte[] next() {
        if (this.state == 10) {
            this.state = 20;
            FormData part = this.parts.get(this.partIndex);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.write(bout, "--" + this.boundary + CRLF);
            this.write(bout, "Content-Disposition: " + part.getParamDisposition() + CRLF);
            this.write(bout, "Content-Type: " + part.getParamType() + CRLF);
            this.write(bout, CRLF);
            return bout.toByteArray();
        }
        if (this.state == 20) {
            FormData part = this.parts.get(this.partIndex);
            byte[] content = part.getContent();
            if (!part.moreContent() || content == null || content.length < 1) {
                this.state = 30;
            }
            if (content != null && content.length > 0) {
                return content;
            }
        }
        if (this.state == 30) {
            ++this.partIndex;
            this.state = this.partIndex == this.parts.size() ? 40 : 10;
            return CRLF.getBytes(StandardCharsets.UTF_8);
        }
        if (this.state == 40 && this.partIndex == this.parts.size()) {
            ++this.partIndex;
            return ("--" + this.boundary + "--\r\n").getBytes(StandardCharsets.UTF_8);
        }
        throw new NoSuchElementException("No more form-data parts available.");
    }

    private void write(ByteArrayOutputStream bout, String s) {
        this.write(bout, s.getBytes(StandardCharsets.UTF_8));
    }

    private void write(ByteArrayOutputStream bout, byte[] data) {
        try {
            bout.write(data);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write to byte-array stream.", e);
        }
    }
}

