/*
 * Decompiled with CFR 0.152.
 */
package izumi.reflect.thirdparty.internal.boopickle;

import java.nio.Buffer;
import java.nio.ByteBuffer;

public abstract class StringCodecFast {
    public String decodeFast(int len, ByteBuffer buf) {
        if (buf.hasArray()) {
            return this.decodeFastArray(len, buf);
        }
        return this.decodeFastBuf(len, buf);
    }

    public void encodeFast(String s, ByteBuffer bb) {
        if (bb.hasArray()) {
            this.encodeFastArray(s, bb);
            return;
        }
        this.encodeFastBuf(s, bb);
    }

    public void encodeFastArray(String s, ByteBuffer bb) {
        int len = s.length();
        byte[] buf = bb.array();
        int dst = bb.arrayOffset() + bb.position();
        int src = 0;
        int c = 32;
        while (src < len && (c = (int)s.charAt(src)) < 128) {
            buf[dst] = (byte)c;
            ++src;
            ++dst;
        }
        while (src < len) {
            c = s.charAt(src);
            if (c < 128) {
                buf[dst] = (byte)c;
                ++dst;
            } else if (c < 16384) {
                buf[dst] = (byte)(0x80 | c & 0x3F);
                buf[dst + 1] = (byte)(c >> 6 & 0xFF);
                dst += 2;
            } else {
                buf[dst] = (byte)(0xC0 | c & 0x3F);
                buf[dst + 1] = (byte)(c >> 6 & 0xFF);
                buf[dst + 2] = (byte)(c >> 14);
                dst += 3;
            }
            ++src;
        }
        ((Buffer)bb).position(dst - bb.arrayOffset());
    }

    public void encodeFastBuf(String s, ByteBuffer bb) {
        int src;
        int len = s.length();
        int c = 32;
        for (src = 0; src < len && (c = (int)s.charAt(src)) < 128; ++src) {
            bb.put((byte)c);
        }
        while (src < len) {
            ByteBuffer byteBuffer;
            c = s.charAt(src);
            if (c < 128) {
                byteBuffer = bb.put((byte)c);
            } else if (c < 16384) {
                bb.put((byte)(0x80 | c & 0x3F));
                byteBuffer = bb.put((byte)(c >> 6 & 0xFF));
            } else {
                bb.put((byte)(0xC0 | c & 0x3F));
                bb.put((byte)(c >> 6 & 0xFF));
                byteBuffer = bb.put((byte)(c >> 14));
            }
            ++src;
        }
    }

    public String decodeFastArray(int len, ByteBuffer buf) {
        char[] cp = new char[len];
        byte[] src = buf.array();
        int offset = buf.arrayOffset() + buf.position();
        for (int dst = 0; dst < len; ++dst) {
            byte b = src[offset];
            ++offset;
            if ((b & 0x80) == 0) {
                cp[dst] = (char)(b & 0x7F);
                continue;
            }
            if ((b & 0xC0) == 128) {
                byte b1 = src[offset];
                ++offset;
                cp[dst] = (char)(b & 0x3F | (b1 & 0xFF) << 6);
                continue;
            }
            byte b1 = src[offset];
            byte b2 = src[offset + 1];
            offset += 2;
            cp[dst] = (char)(b & 0x3F | (b1 & 0xFF) << 6 | b2 << 14);
        }
        ((Buffer)buf).position(offset - buf.arrayOffset());
        return new String(cp);
    }

    public String decodeFastBuf(int len, ByteBuffer buf) {
        char[] cp = new char[len];
        int i = 0;
        for (int dst = 0; dst < len; ++dst) {
            byte b = buf.get();
            if ((b & 0x80) == 0) {
                cp[dst] = (char)(b & 0x7F);
            } else if ((b & 0xC0) == 128) {
                byte b1 = buf.get();
                ++i;
                cp[dst] = (char)(b & 0x3F | (b1 & 0xFF) << 6);
            } else {
                byte b1 = buf.get();
                byte b2 = buf.get();
                i += 2;
                cp[dst] = (char)(b & 0x3F | (b1 & 0xFF) << 6 | b2 << 14);
            }
            ++i;
        }
        return new String(cp);
    }
}

