/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field.file;

import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.panels.userinput.field.file.DirField;
import com.izforge.izpack.panels.userinput.field.file.FileFieldView;
import java.io.File;

public class DirFieldView
extends FileFieldView {
    public DirFieldView(DirField field, Prompt prompt) {
        super(field, prompt);
    }

    @Override
    protected boolean validate(File value) {
        boolean result;
        DirField field = this.getField();
        if (value.isDirectory()) {
            result = true;
        } else if (value.isFile() || field.getMustExist()) {
            this.error(this.getMessage("UserInputPanel.dir.notdirectory.caption"), this.getMessage("UserInputPanel.dir.notdirectory.message"));
            result = false;
        } else {
            result = !field.getCreate() || this.initDir(value);
        }
        return result;
    }

    @Override
    public DirField getField() {
        return (DirField)super.getField();
    }

    @Override
    protected void emptyPathMessage() {
        this.warn(this.getMessage("UserInputPanel.dir.nodirectory.caption"), this.getMessage("UserInputPanel.dir.nodirectory.message"));
    }

    private boolean initDir(File path) {
        DirField field = this.getField();
        Prompt prompt = this.getPrompt();
        if (!path.exists()) {
            String message;
            String title = this.getMessage("installer.Message");
            if (prompt.confirm(Prompt.Type.WARNING, title, message = this.getMessage("UserPathPanel.createdir") + "\n" + path.getAbsolutePath(), Prompt.Options.OK_CANCEL, Prompt.Option.OK) != Prompt.Option.OK) {
                return false;
            }
            if (!path.mkdirs()) {
                this.error(this.getMessage("installer.error"), this.getMessage("UserPathPanel.notwritable"));
                return false;
            }
        }
        if (!field.isWritable(path)) {
            this.error(this.getMessage("installer.error"), this.getMessage("UserPathPanel.notwritable"));
            return false;
        }
        return true;
    }
}

