/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userpath;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.panels.userpath.UserPathSelectionPanel;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.Platform;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UserPathInputPanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = 3257566217698292531L;
    private static final transient Logger logger = Logger.getLogger(UserPathInputPanel.class.getName());
    protected boolean _mustExist = false;
    protected boolean _loadedDefaultDir = false;
    protected String[] _existFiles = null;
    protected UserPathSelectionPanel _pathSelectionPanel;
    protected String _error;
    protected String _warn;
    protected String _emptyTargetMsg;
    protected String _warnMsg;
    protected String _reqMsg;
    protected String _notValidMsg;
    protected String _notWritableMsg;
    protected String _createDirMsg;
    protected String _defaultDir = null;
    protected String _thisPanel = "UserPathInputPanel";
    protected String _defaultPanelName = "TargetPanel";
    protected String _targetPanel = "UserPathPanel";
    protected String _variableName = "pathVariable";

    public UserPathInputPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, String targetPanel, Resources resources, Log log) {
        super(panel, parent, installData, new IzPanelLayout(log), resources);
        this._targetPanel = targetPanel;
        this._variableName = this.getString(targetPanel + ".variableName");
        String mustExist = panel.getConfigurationOptionValue("mustExist", installData.getRules());
        if (mustExist != null) {
            this._mustExist = Boolean.parseBoolean(mustExist);
        }
        this.loadMessages();
        String introText = this.getI18nStringForClass("extendedIntro", this._thisPanel);
        if ((introText == null || introText.endsWith("extendedIntro") || introText.indexOf(36) > -1) && ((introText = this.getI18nStringForClass("intro", this._thisPanel)) == null || introText.endsWith("intro"))) {
            introText = "";
        }
        this.add(this.createMultiLineLabel(introText));
        this.add(IzPanelLayout.createParagraphGap());
        this.add((Component)this.createLabel("info", this._targetPanel, "open", 2, true), "nextLine");
        this._pathSelectionPanel = new UserPathSelectionPanel(this, installData, this._targetPanel, this._variableName, log);
        this.add((Component)this._pathSelectionPanel, "nextLine");
        this.createLayoutBottom();
        this.getLayoutHelper().completeLayout();
    }

    public void createLayoutBottom() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this._pathSelectionPanel.getPathInputField()) {
            this.parent.navigateNext();
        }
    }

    private void loadMessages() {
        this._error = this.getString("installer.error");
        this._warn = this.getString("installer.warning");
        this._reqMsg = this.getMessage("required");
        this._emptyTargetMsg = this.getMessage("empty_target");
        this._warnMsg = this.getMessage("exists_warn");
        this._notValidMsg = this.getMessage("notValid");
        this._notWritableMsg = this.getMessage("notwritable");
        this._createDirMsg = this.getMessage("createdir");
    }

    private String getMessage(String type) {
        String msg = null;
        msg = this.getI18nStringForClass(type, this._targetPanel);
        if (msg == null) {
            msg = this.getI18nStringForClass(type, this._defaultPanelName);
        }
        return msg;
    }

    @Override
    public boolean isValidated() {
        String chosenPath = this._pathSelectionPanel.getPath();
        boolean ok = true;
        if (chosenPath.length() == 0) {
            if (this.isMustExist()) {
                this.emitError(this._error, this._reqMsg);
                return false;
            }
            ok = this.emitWarning(this._warn, this._emptyTargetMsg);
        }
        if (!ok) {
            return ok;
        }
        File path = new File(chosenPath).getAbsoluteFile();
        chosenPath = path.toString();
        this._pathSelectionPanel.setPath(chosenPath);
        if (this.isMustExist()) {
            if (!path.exists()) {
                this.emitError(this._error, this._reqMsg);
                return false;
            }
            if (!this.pathIsValid()) {
                this.emitError(this._error, this._notValidMsg);
                return false;
            }
        } else if (!this.isWriteable()) {
            this.emitError(this._error, this._notWritableMsg);
            return false;
        }
        return ok;
    }

    protected boolean pathIsValid() {
        if (this._existFiles == null) {
            return true;
        }
        for (String _existFile : this._existFiles) {
            File path = new File(this._pathSelectionPanel.getPath(), _existFile).getAbsoluteFile();
            if (path.exists()) continue;
            return false;
        }
        return true;
    }

    public boolean isMustExist() {
        return this._mustExist;
    }

    public void setMustExist(boolean mustExist) {
        this._mustExist = mustExist;
    }

    public String[] getExistFiles() {
        return this._existFiles;
    }

    public void setExistFiles(String[] strings) {
        this._existFiles = strings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaultDir() {
        if (!this._loadedDefaultDir) {
            Resources resources = this.getResources();
            BufferedReader reader = null;
            try {
                InputStream in = null;
                String os = System.getProperty("os.name");
                os = os.replace(' ', '_');
                os = os.toLowerCase();
                try {
                    in = resources.getInputStream(this._targetPanel + ".dir.".concat(os));
                }
                catch (ResourceNotFoundException resourceNotFoundException) {
                    // empty catch block
                }
                if (in == null) {
                    Platform platform = this.installData.getPlatform();
                    if (platform.isA(Platform.Name.WINDOWS)) {
                        try {
                            in = resources.getInputStream(this._targetPanel + ".dir.windows");
                        }
                        catch (ResourceNotFoundException resourceNotFoundException) {}
                    } else if (platform.isA(Platform.Name.MAC_OSX)) {
                        try {
                            in = resources.getInputStream(this._targetPanel + ".dir.mac");
                        }
                        catch (ResourceNotFoundException resourceNotFoundException) {}
                    } else {
                        try {
                            in = resources.getInputStream(this._targetPanel + ".dir.unix");
                        }
                        catch (ResourceNotFoundException resourceNotFoundException) {
                            // empty catch block
                        }
                    }
                }
                if (in == null) {
                    try {
                        in = resources.getInputStream(this._targetPanel + ".dir");
                    }
                    catch (ResourceNotFoundException platform) {
                        // empty catch block
                    }
                }
                if (in != null) {
                    String line;
                    InputStreamReader isr = new InputStreamReader(in);
                    reader = new BufferedReader(isr);
                    while ((line = reader.readLine()) != null && "".equals(line = line.trim())) {
                    }
                    this._defaultDir = line;
                    this._defaultDir = this.installData.getVariables().replace(this._defaultDir);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                this._defaultDir = null;
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        this._loadedDefaultDir = true;
    }

    public boolean isWriteable() {
        File existParent = IoHelper.existingParent(new File(this._pathSelectionPanel.getPath()));
        if (existParent == null) {
            return false;
        }
        if (OsVersion.IS_WINDOWS) {
            try {
                File tmpFile = File.createTempFile("izWrTe", ".tmp", existParent);
                tmpFile.deleteOnExit();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.toString(), e);
                return false;
            }
            return true;
        }
        return existParent.canWrite();
    }

    public String getDefaultDir() {
        if (this._defaultDir == null && !this._loadedDefaultDir) {
            this.loadDefaultDir();
        }
        return this._defaultDir;
    }

    public void setDefaultDir(String defaultDir) {
        this._defaultDir = defaultDir;
    }

    public String getTargetPanel() {
        return this._targetPanel;
    }

    public void setTargetPanel(String targetPanel) {
        this._targetPanel = targetPanel;
    }
}

