/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.process;

import com.sos.izpack.process.ProcessConfigFileHelper;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.ConfigSyntax;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;

public class ConfigurePrivateConf
extends ProcessConfigFileHelper {
    private static final List<String> configDirectoryKeys = Arrays.asList("js7.configuration.trusted-signature-keys", "js7.web.https.keystore", "js7.web.https.truststores");
    private static final ConfigParseOptions parseOpts = ConfigParseOptions.defaults().setSyntax(ConfigSyntax.CONF);
    private static final ConfigRenderOptions renderOpts = ConfigRenderOptions.concise().setComments(true).setOriginComments(false).setFormatted(true).setJson(false);
    private static final ConfigResolveOptions resolveOpts = ConfigResolveOptions.noSystem().setUseSystemEnvironment(false).setAllowUnresolved(true);
    private static final String rootPath = "js7";

    @Override
    protected String getConfigFilename() {
        return "private.conf";
    }

    @Override
    protected String getConfigDir() {
        return this.idata.getVariable("APPDATA_PATH");
    }

    @Override
    protected String getConfigSubDir() {
        return "config" + File.separator + "private";
    }

    @Override
    protected void process(File configTmpFile) throws Exception {
    }

    @Override
    protected void process(File configFile, File configTmpFile) throws Exception {
        Files.write(configFile.toPath(), this.getRenderedConfig(configFile, configTmpFile).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private String getRenderedConfig(File configFile, File configTmpFile) {
        ConfigFactory.invalidateCaches();
        Config userConfig = ConfigFactory.parseFile(configFile, parseOpts);
        Config setupConfig = ConfigFactory.parseFile(configTmpFile, parseOpts);
        for (String configDirectoryKey : configDirectoryKeys) {
            if (!userConfig.hasPath(configDirectoryKey) || !setupConfig.hasPath(configDirectoryKey)) continue;
            setupConfig = setupConfig.withoutPath(configDirectoryKey);
        }
        return userConfig.resolve(resolveOpts).withFallback(setupConfig.resolve(resolveOpts)).withOnlyPath(rootPath).root().render(renderOpts);
    }
}

