/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.process;

import com.sos.izpack.process.ProcessHelper;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class DeactivateJettyModules
extends ProcessHelper {
    private Map<String, Boolean> modules = new HashMap<String, Boolean>();

    @Override
    public boolean run(String[] args) throws Exception {
        try {
            this.modules.put("logging", Boolean.FALSE);
            this.deactivateModules(Paths.get(this.idata.getVariable("APPDATA_PATH"), "start.ini"));
        }
        catch (Exception e) {
            this.log(e);
        }
        return true;
    }

    public void deactivateModules(Path startIni) throws Exception {
        if (Files.exists(startIni, new LinkOption[0])) {
            this.writeHeader("Deactivate old Jetty modules in ./jetty_base/start.ini");
            if (Files.isWritable(startIni) && Files.isReadable(startIni)) {
                StringBuilder writer = new StringBuilder();
                Consumer<String> consumer = line -> {
                    String module;
                    if (line.trim().startsWith("--module=") && this.modules.containsKey(module = line.trim().replaceFirst("^\\s*--module=", ""))) {
                        writer.append("#");
                        this.modules.put(module, Boolean.TRUE);
                    }
                    writer.append((String)line).append(this.newline);
                };
                Files.lines(startIni).forEach(consumer);
                if (this.modules.containsValue(Boolean.TRUE)) {
                    Files.write(startIni, writer.toString().getBytes(), new OpenOption[0]);
                    for (String module : this.modules.keySet()) {
                        if (!this.modules.get(module).booleanValue()) continue;
                        this.log("... module %s is deactivated", module);
                    }
                } else {
                    this.log("... nothing to do", new Object[0]);
                }
            } else {
                throw new Exception(startIni.toString() + " is not readable or writable");
            }
        }
    }
}

