/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.process;

import com.izforge.izpack.util.OsVersion;
import com.sos.izpack.process.ProcessHelper;
import com.sos.izpack.process.SOSCommandResult;
import com.sos.izpack.process.SOSFile;
import com.sos.izpack.process.SOSShell;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class InstallJettyBase
extends ProcessHelper {
    @Override
    public boolean run(String[] args) throws Exception {
        String command = args.length > 0 ? args[0] : "install";
        try {
            Path jettyBase = Paths.get(this.idata.getVariable("APPDATA_PATH"), new String[0]);
            Path jocResources = jettyBase.resolve("resources/joc");
            if ("install".equals(command)) {
                this.writeHeader("Install Jetty base directory");
                this.deleteShiroFiles(jocResources);
                this.copyExampleFile(jocResources.resolve("joc.properties"), jocResources.resolve("joc.properties-example"));
                this.addInitModules(jettyBase);
                this.disableServerVersion(jettyBase);
                this.copyLog4j2Configuration(jocResources);
                if (!OsVersion.IS_WINDOWS) {
                    this.updateJavaOptions();
                }
            } else if ("update".equals(command)) {
                this.writeHeader("Update resources");
                this.deleteShiroFiles(jocResources);
                int nothingToDo = this.copyExampleFile(jocResources.resolve("joc.properties"), jocResources.resolve("joc.properties-example"));
                this.copyLog4j2Configuration(jocResources);
                if (nothingToDo == 0) {
                    this.log("... nothing to do", new Object[0]);
                }
            }
        }
        catch (Throwable e) {
            this.log(e);
        }
        return true;
    }

    private void disableServerVersion(Path jettyBase) {
        Path serverIni = jettyBase.resolve("start.d").resolve("server.ini");
        if (!Files.exists(serverIni, new LinkOption[0])) {
            // empty if block
        }
        if (Files.exists(serverIni, new LinkOption[0])) {
            Predicate<String> isServerversionEntry = Pattern.compile("#?jetty.httpConfig.sendServerVersion.*").asPredicate();
            try {
                Files.write(serverIni, (Iterable<? extends CharSequence>)Files.lines(serverIni).map(l -> isServerversionEntry.test((String)l) ? "jetty.httpConfig.sendServerVersion=false" : l).collect(Collectors.toList()), new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private int copyExampleFile(Path activeFile, Path exampleFile) throws IOException {
        if (!Files.exists(activeFile, new LinkOption[0]) && Files.exists(exampleFile, new LinkOption[0])) {
            Files.copy(exampleFile, activeFile, new CopyOption[0]);
            return 1;
        }
        return 0;
    }

    private void deleteShiroFiles(Path jocResources) {
        try {
            SOSFile.deleteFiles(jocResources, "shiro\\.ini.*", 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateJavaOptions() throws IOException {
        Path envFile = null;
        Path envDir = null;
        String serviceName = this.idata.getVariable("jettyServiceName");
        if ("yes".equals(this.idata.getVariable("withRootPermissions"))) {
            Files.deleteIfExists(Paths.get("/etc/default", new String[0]).resolve(serviceName));
        }
        if (this.idata.getVariable("jettyUserHome") == null || this.idata.getVariable("jettyUserHome").isEmpty()) {
            throw new IOException("The Jetty user '" + this.idata.getVariable("jettyUser") + "' doesn't have a home directory -> Java options and Java location cannot be set in ~/." + serviceName + "rc");
        }
        envDir = Paths.get(this.idata.getVariable("jettyUserHome"), new String[0]);
        envFile = envDir.resolve("." + serviceName + "rc");
        String jettyOptions = this.idata.getVariable("jettyOptions");
        String jettyOptionXms = this.idata.getVariable("jettyOptionXms");
        String jettyOptionXmx = this.idata.getVariable("jettyOptionXmx");
        String jettyOptionXss = this.idata.getVariable("jettyOptionXss");
        if (jettyOptionXms != null && !jettyOptionXms.isEmpty()) {
            jettyOptions = jettyOptions + " -Xms" + jettyOptionXms + "m";
        }
        if (jettyOptionXmx != null && !jettyOptionXmx.isEmpty()) {
            jettyOptions = jettyOptions + " -Xmx" + jettyOptionXmx + "m";
        }
        if (jettyOptionXss != null && !jettyOptionXss.isEmpty()) {
            jettyOptions = jettyOptions + " -Xss" + jettyOptionXss + "k";
        }
        if (!(jettyOptions = jettyOptions.trim()).isEmpty() && envDir != null && envFile != null) {
            if (!Files.exists(envDir, new LinkOption[0])) {
                Files.createDirectories(envDir, new FileAttribute[0]);
            }
            jettyOptions = String.format("JAVA_OPTIONS=\"%1$s ${JAVA_OPTIONS}\"%ntest -z \"$JAVA\" && test -f \"%2$s/bin/java\" && JAVA=\"%2$s/bin/java\"%n", jettyOptions, this.idata.getVariable("JAVA_HOME"));
            if (!"yes".equals(this.idata.getVariable("withRootPermissions")) && !this.idata.getVariable("USER_NAME").equals(this.idata.getVariable("jettyUser"))) {
                this.log("WARNING: \"" + envFile.toString() + "\" couldn't be generated, therefore Java options couldn't be set", new Object[0]);
            } else {
                Path p = Files.write(envFile, jettyOptions.getBytes(), new OpenOption[0]);
                try {
                    if ("yes".equals(this.idata.getVariable("withRootPermissions"))) {
                        UserPrincipalLookupService service = p.getFileSystem().getUserPrincipalLookupService();
                        UserPrincipal userPrincipal = service.lookupPrincipalByName(this.idata.getVariable("jettyUser"));
                        Files.setOwner(p, userPrincipal);
                    }
                }
                catch (IOException service) {
                    // empty catch block
                }
                try {
                    HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ));
                    Files.setPosixFilePermissions(p, perms);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.log("Java options are updated in \"" + envFile.toString() + "\".", new Object[0]);
            }
        }
    }

    private void addInitModules(Path jettyBase) throws Throwable {
        String modules = "deploy,resources,console-capture,http,ext,rewrite,server";
        Path startIni = jettyBase.resolve("start.ini");
        Path startd = jettyBase.resolve("start.d");
        String errMsg = "Failed to add modules " + modules + " to " + startd.toString();
        Map<Object, Object> modulesValues = Collections.emptyMap();
        boolean oldStartIniConf = false;
        if (Files.exists(startIni, new LinkOption[0])) {
            oldStartIniConf = true;
            modulesValues = this.readStartIni(startIni);
            modules = String.join((CharSequence)",", modulesValues.keySet());
            errMsg = "Failed to update modules " + modules + " to " + startd.toString();
            Files.move(startIni, startIni.getParent().resolve("start.in~"), StandardCopyOption.ATOMIC_MOVE);
        } else if (Files.exists(startd, new LinkOption[0])) {
            if (!Files.exists(startd.resolve("http.ini"), new LinkOption[0]) || Files.lines(startd.resolve("http.ini")).noneMatch(line -> line.trim().matches("--module=http"))) {
                modules = "deploy,resources,console-capture,ext,rewrite,server";
            }
            errMsg = "Failed to update modules " + modules + " to " + startd.toString();
        }
        Path jocHome = Paths.get(this.idata.getInstallPath(), new String[0]);
        Path jettyHome = jocHome.resolve("jetty");
        String jettyStartJar = jettyHome.resolve("start.jar").toString();
        Path javaHome = Paths.get(this.idata.getVariable("JAVA_HOME"), new String[0]);
        String javaBin = javaHome.resolve("bin/java").toString();
        if (OsVersion.IS_WINDOWS) {
            javaBin = javaBin + ".exe";
        }
        if (Files.exists(jettyHome, new LinkOption[0])) {
            this.copyRewriteRulesXml(jettyHome, jettyBase);
            SOSCommandResult pr = SOSShell.executeCommand(javaBin, "-jar", jettyStartJar, "-Djetty.home=" + jettyHome.toString(), "-Djetty.base=" + jettyBase.toString(), "--add-module=" + modules);
            if (pr.getExitCode() != 0) {
                this.log(errMsg, new Object[0]);
                if (oldStartIniConf) {
                    Files.move(startIni.getParent().resolve("start.in~"), startIni, StandardCopyOption.ATOMIC_MOVE);
                    SOSFile.deleteFolder(startd);
                }
                if (!pr.getStdErr().trim().isEmpty()) {
                    throw new Exception(pr.getStdErr().trim());
                }
                if (!pr.getStdOut().trim().isEmpty()) {
                    throw new Exception(pr.getStdOut().trim());
                }
                throw new Exception("add init modules returns exit code " + pr.getExitCode());
            }
            if (oldStartIniConf) {
                this.assignFromStartIni(startd, modulesValues);
            }
            if (!pr.getStdOut().trim().isEmpty()) {
                this.log(pr.getStdOut().trim(), new Object[0]);
            }
            if (!pr.getStdErr().trim().isEmpty()) {
                this.log(pr.getStdErr().trim(), new Object[0]);
            }
            this.log("... done", new Object[0]);
        }
    }

    private void copyRewriteRulesXml(Path jettyHome, Path jettyBase) throws IOException {
        String fileName = "rewrite-rules.xml";
        Path source = jettyHome.resolve("modules/rewrite/" + fileName);
        Path target = jettyBase.resolve("etc/" + fileName);
        if (!Files.exists(target, new LinkOption[0])) {
            if (Files.exists(source, new LinkOption[0])) {
                Files.copy(source, target, new CopyOption[0]);
            } else {
                String targetContent = "<?xml version=\"1.0\"?>\n<!DOCTYPE Configure PUBLIC \"-//Jetty//Configure//EN\" \"https://www.eclipse.org/jetty/configure_10_0.dtd\">\n<Configure id=\"Rewrite\" class=\"org.eclipse.jetty.rewrite.handler.RuleContainer\">\n</Configure>\n";
                Files.write(target, targetContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
        }
    }

    private Map<String, Map<String, String>> readStartIni(Path startIni) throws IOException {
        HashMap<String, Map<String, String>> modulesValues = new HashMap<String, Map<String, String>>();
        if (Files.exists(startIni, new LinkOption[0]) && Files.isWritable(startIni) && Files.isReadable(startIni)) {
            Consumer<String> consumeActiveModules = line -> {
                if (line.trim().startsWith("--module=")) {
                    String module = line.trim().replaceFirst("^--module=\\s*", "");
                    modulesValues.put(module, new HashMap());
                }
            };
            Files.lines(startIni).forEach(consumeActiveModules);
            Consumer<String> consumeActiveModuleValues = line -> {
                if (line.trim().startsWith("jetty.")) {
                    String module = line.trim().replaceFirst("^jetty\\.([^.]+)\\..*$", "$1");
                    if ("sslContext".equals(module)) {
                        module = "ssl";
                    }
                    if (modulesValues.containsKey(module)) {
                        String[] keyValue = line.trim().split("=", 2);
                        ((Map)modulesValues.get(module)).put(keyValue[0].trim(), keyValue[1]);
                    }
                }
            };
            Files.lines(startIni).forEach(consumeActiveModuleValues);
        }
        modulesValues.remove("logging");
        return modulesValues;
    }

    private void assignFromStartIni(Path startd, Map<String, Map<String, String>> modulesValues) throws IOException {
        for (Map.Entry<String, Map<String, String>> moduleValues : modulesValues.entrySet()) {
            Path moduleIni;
            if (moduleValues.getValue().isEmpty() || !Files.exists(moduleIni = startd.resolve(moduleValues.getKey() + ".ini"), new LinkOption[0])) continue;
            StringBuilder writer = new StringBuilder();
            Consumer<String> modifyModule = line -> {
                if (!line.trim().startsWith("# jetty.")) {
                    writer.append((String)line);
                } else {
                    String[] keyValue = line.trim().split("=", 2);
                    String key = keyValue[0].trim().replaceFirst("^#\\s*", "");
                    if (((Map)moduleValues.getValue()).containsKey(key)) {
                        writer.append(key).append("=").append((String)((Map)moduleValues.getValue()).get(key));
                    } else {
                        writer.append((String)line);
                    }
                }
                writer.append(this.newline);
            };
            Files.lines(moduleIni).forEach(modifyModule);
            Files.write(moduleIni, writer.toString().getBytes(), new OpenOption[0]);
        }
    }

    private void copyLog4j2Configuration(Path jocResources) {
        try {
            String log4j2baseName = "log4j2.xml";
            Path targetFile = jocResources.resolve(log4j2baseName);
            Path targetExampleFile = jocResources.resolve(log4j2baseName + "-example");
            if (Files.exists(targetExampleFile, new LinkOption[0]) && !Files.exists(targetFile, new LinkOption[0])) {
                Files.move(targetExampleFile, targetFile, StandardCopyOption.ATOMIC_MOVE);
            }
        }
        catch (Exception e) {
            this.log("... error occurred:", new Object[0]);
            this.log(e);
        }
    }
}

