/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.process;

import com.sos.izpack.process.ProcessHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.StringTokenizer;

public abstract class ProcessConfigFileHelper
extends ProcessHelper {
    protected String installMode = "install";

    protected abstract String getConfigFilename();

    protected abstract String getConfigDir();

    protected abstract String getConfigSubDir();

    protected abstract void process(File var1, File var2) throws Exception;

    protected abstract void process(File var1) throws Exception;

    @Override
    public boolean run(String[] args) throws Exception {
        try {
            this.ok = true;
            if (this.idata.getVariable("installMode") != null) {
                this.installMode = this.idata.getVariable("installMode");
            }
            String configFilename = null;
            String configTmpFilename = null;
            String configSubDir = null;
            boolean silent = false;
            boolean test = false;
            int argsLength = args.length;
            for (int i = 0; i < argsLength; ++i) {
                if (args[i].equals("-f") && i + 1 < argsLength) {
                    configFilename = args[i + 1];
                }
                if (args[i].equals("-d") && i + 1 < argsLength) {
                    configSubDir = args[i + 1];
                }
                if (args[i].equals("-s")) {
                    silent = true;
                }
                if (!args[i].equals("-t")) continue;
                test = true;
            }
            boolean bl = this.verbose = !silent;
            if (configFilename == null) {
                configFilename = this.getConfigFilename();
            }
            if (configSubDir == null) {
                configSubDir = this.getConfigSubDir();
            }
            if (configFilename == null || configSubDir == null) {
                throw new IllegalArgumentException("The filename parameter is missing.");
            }
            if (configTmpFilename == null) {
                configTmpFilename = this.getConfigTmpFilename(configFilename);
            }
            File configDir = new File(this.getConfigDir(), configSubDir);
            File configFile = new File(configDir, configFilename);
            File configTmpFile = new File(configDir, configTmpFilename);
            boolean withTmpFile = configTmpFile.exists();
            this.log("", new Object[0]);
            this.log(60, "+" + this.repeat('-', 120), new Object[0]);
            this.log("|   Configuration of ./%2$s/%1$s", configFilename, configSubDir.replace('\\', '/'));
            this.log(60, "+" + this.repeat('-', 120), new Object[0]);
            if (configFile.exists() && configFile.canWrite()) {
                try {
                    if (withTmpFile) {
                        this.log("... %1$s of a previous installation found", configFilename);
                    }
                    this.process(configFile, configTmpFile);
                    this.log("... done", new Object[0]);
                }
                catch (Exception e) {
                    this.log("... error occurred:", new Object[0]);
                    this.log(e);
                    this.log("... configuration failed", new Object[0]);
                    if (withTmpFile) {
                        this.log("... please look at %1$s for new configuration entries", configTmpFile.getAbsolutePath());
                    }
                }
            } else if (configFile.exists()) {
                if (withTmpFile) {
                    this.log("... %1$s of a previous installation found", configFilename);
                } else {
                    this.log("... %1$s found", configFilename);
                }
                this.log("... but it has no write permissions", new Object[0]);
                this.log("... configuration failed", new Object[0]);
                if (withTmpFile) {
                    this.log("... please look at %1$s for new configuration entries", configTmpFile.getAbsolutePath());
                }
            } else if (configTmpFile.canWrite()) {
                if (this.installMode.equals("update")) {
                    this.log("... %1$s of a previous installation not found", configFilename);
                    this.log("... a default %1$s will be used", configFilename);
                }
                this.process(configTmpFile);
                if (this.rename(configTmpFile, configFile)) {
                    this.log("... done", new Object[0]);
                } else {
                    this.log("... configuration failed", new Object[0]);
                    throw new Exception(String.format("%1$s couldn't renamed to %2$s", configTmpFile.getAbsolutePath(), configFile.getAbsolutePath()));
                }
            }
            if (!test && configTmpFile.canWrite()) {
                configTmpFile.delete();
            }
        }
        catch (Exception e) {
            this.log(e);
        }
        return this.ok;
    }

    protected String getConfigTmpFilename(String configFilename) {
        return "tmp_" + configFilename;
    }

    private boolean rename(File src, File dest) {
        String srcName = src.getName().toLowerCase();
        boolean ret = true;
        try {
            if (srcName.endsWith(".sh") || srcName.endsWith(".cmd")) {
                ret = src.renameTo(dest);
            } else {
                BufferedReader in = new BufferedReader(new FileReader(src));
                StringWriter writer = new StringWriter();
                String str = "";
                while ((str = in.readLine()) != null) {
                    writer.append(str + this.newline);
                }
                in.close();
                BufferedWriter out = new BufferedWriter(new FileWriter(dest));
                out.write(writer.toString());
                out.close();
                src.delete();
                ret = true;
            }
        }
        catch (Exception e) {
            this.log(e);
            ret = false;
        }
        return ret;
    }

    protected String normalizeValue(String str) {
        StringTokenizer st = new StringTokenizer(str.trim(), "'", true);
        String s = "";
        String t = "";
        while (st.hasMoreTokens()) {
            t = st.nextToken();
            s = s + (t.equals("'") ? "\"" : t.replace('\"', '\''));
        }
        return s;
    }

    protected String maskPasswordForLog(String key, String val) {
        if (key.indexOf("password") > -1) {
            val = "***";
        } else if (val.indexOf("-password") > -1) {
            val = val.replaceFirst("-password=[^\\p{Blank}]*([\\p{Blank}]*|')", "-password=***$1");
        }
        return val;
    }

    protected String removeComments(BufferedReader in, char ... lineCommentChars) throws IOException {
        StringWriter writer = new StringWriter();
        StringWriter writer2 = new StringWriter();
        String str = "";
        while ((str = in.readLine()) != null) {
            writer.append(str.replaceAll("\\\\(?!['\"])", "\\\\\\\\") + this.newline);
        }
        in.close();
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(writer.toString()));
        tokenizer.resetSyntax();
        tokenizer.slashStarComments(true);
        tokenizer.slashSlashComments(true);
        tokenizer.eolIsSignificant(false);
        tokenizer.whitespaceChars(0, 8);
        tokenizer.whitespaceChars(10, 31);
        tokenizer.wordChars(9, 9);
        tokenizer.wordChars(32, 255);
        tokenizer.commentChar(47);
        if (lineCommentChars != null) {
            for (char c : lineCommentChars) {
                tokenizer.commentChar(c);
            }
        }
        tokenizer.quoteChar(34);
        tokenizer.quoteChar(39);
        int ttype = 0;
        int lastline = -1;
        String s = "";
        while (ttype != -1) {
            ttype = tokenizer.nextToken();
            String sval = "";
            switch (ttype) {
                case -3: {
                    sval = tokenizer.sval.replaceAll("\\\\\\\\", "\\\\");
                    break;
                }
                case -2: {
                    sval = tokenizer.nval + "";
                    break;
                }
                case 39: {
                    sval = "'" + tokenizer.sval.replaceAll("'", "\\\\'") + "'";
                    break;
                }
                case 34: {
                    sval = "\"" + tokenizer.sval.replaceAll("\"", "\\\\\"") + "\"";
                }
            }
            int lineno = tokenizer.lineno();
            if (lineno == lastline) {
                s = s + sval;
            } else {
                if (lastline != -1) {
                    writer2.append(s + this.newline);
                }
                s = sval;
            }
            lastline = lineno;
        }
        return writer2.toString();
    }
}

