/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;

public class JocIdValidator
implements DataValidator {
    private String errorMessageId = "joc.cluster.id.valid";

    @Override
    public DataValidator.Status validateData(InstallData idata) {
        String jocTitle;
        boolean asApiServer = "yes".equals(idata.getVariable("asApiServer"));
        String ordering = idata.getVariable("ordering");
        if (!asApiServer && ((jocTitle = idata.getVariable("jocTitle")) == null || jocTitle.isEmpty())) {
            if ("0".equals(ordering)) {
                idata.setVariable("jocTitle", "Primary");
            } else {
                idata.setVariable("jocTitle", "Secondary");
            }
        }
        if (ordering == null || ordering.isEmpty() || !ordering.matches("[1-9]?[0-9]")) {
            this.errorMessageId = "joc.instance.id.format";
            return DataValidator.Status.ERROR;
        }
        return DataValidator.Status.OK;
    }

    @Override
    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return this.errorMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }
}

