/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.data.PanelAction;
import com.sos.izpack.process.SOSFile;

public class SetJettyBaseDirectory
implements PanelAction {
    @Override
    public void executeAction(InstallData idata, AbstractUIHandler ah) {
        try {
            String jettyBaseDir = SOSFile.cutWorkingDir(SOSFile.normalizePath(idata.getVariable("jettyBaseDir")));
            if (jettyBaseDir == null || jettyBaseDir.isEmpty()) {
                VariableSubstitutorImpl vs = new VariableSubstitutorImpl(idata.getVariables());
                jettyBaseDir = vs.substitute(idata.getVariable("jettyBaseDirDefault"), null);
                idata.setVariable("jettyBaseDirDefault", jettyBaseDir);
            }
            idata.setVariable("jettyBaseDir", jettyBaseDir);
            if ("no".equals(idata.getVariable("withRootPermissions"))) {
                idata.setVariable("withJocInstallAsDaemon", "no");
            }
        }
        catch (Exception e) {
            System.out.println("normalize Jetty base directory: " + e.toString());
        }
    }

    @Override
    public void initialize(PanelActionConfiguration pac) {
    }
}

