/*
 * Decompiled with CFR 0.152.
 */
package com.sos.js7.license.check;

import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Date;

public abstract class ValidityChecker {
    public static boolean checkValidity(X509Certificate cert) {
        try {
            cert.checkValidity();
            return true;
        }
        catch (CertificateExpiredException e) {
            return false;
        }
        catch (CertificateNotYetValidException e) {
            return false;
        }
    }

    public static long getValidDurationInMillis(X509Certificate cert) {
        long validDuration = 0L;
        Date notAfter = cert.getNotAfter();
        if (notAfter != null) {
            validDuration = notAfter.getTime() - Date.from(Instant.now()).getTime();
        }
        return validDuration;
    }
}

