/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function1;
import scala.runtime.BoxedUnit;

public final class WeakList<A>
extends AtomicReference<Node<A>> {
    private final ReferenceQueue<A> queue = new ReferenceQueue();
    private final AtomicBoolean allowedToPack = new AtomicBoolean(true);
    private int gcCount = 0;

    public void prepend(A a) {
        this.packIfNeeded();
        Node<A> newHead = new Node<A>(a, this.queue);
        this.loop$1(newHead);
    }

    public void foreach(Function1<A, BoxedUnit> f) {
        for (Node currentNode = (Node)this.get(); currentNode != null; currentNode = currentNode.getNext()) {
            Object a = currentNode.get();
            if (a == null) continue;
            f.apply(a);
        }
    }

    private void packIfNeeded() {
        if (this.allowedToPack.compareAndSet(true, false)) {
            try {
                int gcCount = this.gcCount;
                boolean shouldPack = false;
                while (this.queue.poll() != null) {
                    if (++gcCount <= 0 || (gcCount & gcCount - 1) != 0) continue;
                    shouldPack = true;
                }
                if (shouldPack) {
                    gcCount -= this.pack(gcCount);
                }
                this.gcCount = gcCount;
            }
            finally {
                this.allowedToPack.set(true);
            }
            return;
        }
    }

    private int pack(int bound) {
        Node got = (Node)this.get();
        if (got != null) {
            return got.packHead(bound, 0, this);
        }
        return 0;
    }

    @Override
    public String toString() {
        return new StringBuilder(10).append("WeakList(").append(this.get()).append(")").toString();
    }

    private final void loop$1(Node newHead$1) {
        Node currentHead;
        do {
            currentHead = (Node)this.get();
            newHead$1.setNext(currentHead);
        } while (!this.compareAndSet(currentHead, newHead$1));
    }

    public static final class Node<A>
    extends WeakReference<A> {
        private Node<A> _next;

        public Node(A a, ReferenceQueue<A> queue) {
            super(a, queue);
        }

        public Node<A> getNext() {
            return this._next;
        }

        public void setNext(Node<A> next) {
            this._next = next;
        }

        public int packHead(int bound, int removed, WeakList<A> root) {
            Node<A> next;
            block6: {
                while (true) {
                    next = this_._next;
                    if (this_.get() != null) break block6;
                    if (!root.compareAndSet(this_, next)) break;
                    if (next == null) {
                        return removed + 1;
                    }
                    Node<A> node = next;
                    int n = bound - 1;
                    int n2 = removed + 1;
                    Node<A> this_ = node;
                    bound = n;
                    removed = n2;
                }
                Node prev = (Node)root.get();
                if (prev != null && prev.getNext() == this_) {
                    return super.packTail(bound, removed, prev);
                }
                if (next != null) {
                    return super.packTail(bound - 1, removed, this_);
                }
                return removed;
            }
            if (next == null) {
                return removed;
            }
            if (bound > 0) {
                return super.packTail(bound - 1, removed, this_);
            }
            return removed;
        }

        private int packTail(int bound, int removed, Node<A> prev) {
            while (true) {
                Node<A> this_;
                Node<A> next = this_._next;
                if (this_.get() == null) {
                    prev.setNext(next);
                    if (next == null) {
                        return removed + 1;
                    }
                    Node<A> node = next;
                    int n = bound - 1;
                    int n2 = removed + 1;
                    this_ = node;
                    bound = n;
                    removed = n2;
                    continue;
                }
                if (next == null) {
                    return removed;
                }
                if (bound <= 0) break;
                Node<A> node = next;
                int n = bound - 1;
                Node<A> node2 = this_;
                this_ = node;
                bound = n;
                prev = node2;
            }
            return removed;
        }

        public String toString() {
            return new StringBuilder(8).append("Node(").append(this.get()).append(", ").append(this._next).append(")").toString();
        }
    }
}

