/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.sign.keys.keyStore;

import com.sos.commons.sign.keys.keyStore.KeystoreType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KeyStoreUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyStoreUtil.class);

    public static KeyStore readKeyStore(String keyStorePath, KeystoreType keyStoreType) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return KeyStoreUtil.readKeyStore(Paths.get(keyStorePath, new String[0]), keyStoreType, null);
    }

    public static KeyStore readKeyStore(Path keyStorePath, KeystoreType keyStoreType) throws Exception {
        return KeyStoreUtil.readKeyStore(keyStorePath, keyStoreType, null);
    }

    public static KeyStore readKeyStore(String keyStorePath, KeystoreType keyStoreType, String keyStorePassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return KeyStoreUtil.readKeyStore(Paths.get(keyStorePath, new String[0]), keyStoreType, keyStorePassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore readKeyStore(Path keyStorePath, KeystoreType keyStoreType, String keyStorePassword) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        try (InputStream keyStoreStream = null;){
            boolean fileAlreadyExist;
            boolean bl = fileAlreadyExist = Files.exists(keyStorePath, new LinkOption[0]) && Files.isRegularFile(keyStorePath, new LinkOption[0]);
            if (!fileAlreadyExist) {
                LOGGER.warn(String.format("KeyStore with path: %1$s does not exist!", keyStorePath.toAbsolutePath()));
            }
            keyStoreStream = Files.newInputStream(keyStorePath, new OpenOption[0]);
            KeyStore keyStore = KeyStore.getInstance(keyStoreType.value());
            if (fileAlreadyExist) {
                if (keyStorePassword == null) {
                    keyStore.load(keyStoreStream, "".toCharArray());
                } else {
                    keyStore.load(keyStoreStream, keyStorePassword.toCharArray());
                }
            } else {
                keyStore.load(null, null);
            }
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
    }

    public static KeyStore readTrustStore(String trustStorePath, KeystoreType trustStoreType) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return KeyStoreUtil.readTrustStore(Paths.get(trustStorePath, new String[0]), trustStoreType, null);
    }

    public static KeyStore readTrustStore(Path trustStorePath, KeystoreType trustStoreType) throws Exception {
        return KeyStoreUtil.readTrustStore(trustStorePath, trustStoreType, null);
    }

    public static KeyStore readTrustStore(String trustStorePath, KeystoreType trustStoreType, String trustStorePassword) throws Exception {
        return KeyStoreUtil.readTrustStore(Paths.get(trustStorePath, new String[0]), trustStoreType, trustStorePassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore readTrustStore(Path trustStorePath, KeystoreType trustStoreType, String trustStorePassword) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        try (InputStream trustStoreStream = null;){
            boolean fileAlreadyExist;
            boolean bl = fileAlreadyExist = Files.exists(trustStorePath, new LinkOption[0]) && Files.isRegularFile(trustStorePath, new LinkOption[0]);
            if (!fileAlreadyExist) {
                LOGGER.warn(String.format("TrustStore with path: %1$s does not exist!", trustStorePath.toAbsolutePath()));
            }
            trustStoreStream = Files.newInputStream(trustStorePath, new OpenOption[0]);
            KeyStore trustStore = KeyStore.getInstance(trustStoreType.value());
            if (fileAlreadyExist) {
                if (trustStorePassword == null || trustStorePassword.isEmpty()) {
                    trustStore.load(trustStoreStream, "".toCharArray());
                } else {
                    trustStore.load(trustStoreStream, trustStorePassword.toCharArray());
                }
            } else {
                trustStore.load(null, null);
            }
            KeyStore keyStore = trustStore;
            return keyStore;
        }
    }

    public static Certificate getCertificateFromKeyStore(KeyStore keyStore, String alias) throws KeyStoreException {
        if (keyStore.containsAlias(alias)) {
            Certificate certificate = keyStore.getCertificate(alias);
            return certificate;
        }
        return null;
    }

    public static X509Certificate getX509CertificateFromKeyStore(KeyStore keyStore, String alias) throws KeyStoreException {
        Certificate certificate = KeyStoreUtil.getCertificateFromKeyStore(keyStore, alias);
        if (certificate != null) {
            try {
                return (X509Certificate)certificate;
            }
            catch (ClassCastException e) {
                return null;
            }
        }
        return null;
    }

    public static Certificate[] getX509CertificateChainFromKeyStore(KeyStore keyStore, String alias) throws KeyStoreException {
        if (keyStore.containsAlias(alias)) {
            Certificate[] certificateChain = keyStore.getCertificateChain(alias);
            return certificateChain;
        }
        return null;
    }
}

