/*
 * Decompiled with CFR 0.152.
 */
package js7.agent.motor;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Resource;
import cats.effect.package$;
import com.typesafe.scalalogging.Logger;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream$;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import js7.agent.CommandHandler;
import js7.agent.DirectorTermination;
import js7.agent.DirectorTermination$;
import js7.agent.configuration.AgentConfiguration;
import js7.agent.data.AgentState;
import js7.agent.data.commands.AgentCommand;
import js7.agent.data.commands.AgentCommand$Batch$;
import js7.agent.data.commands.AgentCommand$Batch$Response$;
import js7.agent.data.commands.AgentCommand$ClusterSwitchOver$;
import js7.agent.data.commands.AgentCommand$CoupleController$;
import js7.agent.data.commands.AgentCommand$CoupleController$Response$;
import js7.agent.data.commands.AgentCommand$DedicateAgentDirector$;
import js7.agent.data.commands.AgentCommand$DedicateAgentDirector$Response$;
import js7.agent.data.commands.AgentCommand$EmergencyStop$;
import js7.agent.data.commands.AgentCommand$NoOperation$;
import js7.agent.data.commands.AgentCommand$Response$Accepted$;
import js7.agent.data.commands.AgentCommand$ShutDown$;
import js7.agent.data.commands.AgentCommand$ShutDown$ClusterAction$Switchover$;
import js7.agent.data.commands.AgentCommand$TakeSnapshot$;
import js7.agent.data.event.AgentEvent;
import js7.agent.data.event.AgentEvent$AgentDedicated$;
import js7.agent.motor.AgentCommandExecutor$;
import js7.agent.motor.AgentCommandExecutor$Dedicated$;
import js7.agent.motor.AgentMotor;
import js7.agent.motor.AgentMotor$;
import js7.base.auth.UserId$;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.catsutils.CatsExtensions$;
import js7.base.catsutils.UnsafeMemoizable$;
import js7.base.io.process.ProcessSignal;
import js7.base.io.process.ProcessSignal$SIGKILL$;
import js7.base.log.CanBindCorrelId$;
import js7.base.log.CorrelId;
import js7.base.log.CorrelId$;
import js7.base.log.CorrelIdWrapped;
import js7.base.log.CorrelIdWrapped$;
import js7.base.log.Log4j$;
import js7.base.log.Logger$package$Logger$syntax$;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.scalasource.ScalaSourceLocation$;
import js7.base.service.MainService;
import js7.base.service.Service;
import js7.base.service.StoppableByRequest;
import js7.base.system.startup.Halt$;
import js7.base.time.AlarmClock;
import js7.base.utils.Allocated;
import js7.base.utils.AsyncLock;
import js7.base.utils.AsyncLock$;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.CatsUtils$syntax$RichResource$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichAny$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichEither$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.base.utils.SetOnce;
import js7.base.utils.SetOnce$;
import js7.cluster.WorkingClusterNode;
import js7.core.command.CommandMeta;
import js7.core.command.CommandRegister;
import js7.core.command.CommandRun;
import js7.data.Problems$ClusterSwitchOverButNotCoupledProblem$;
import js7.data.agent.AgentPath;
import js7.data.agent.AgentRunId;
import js7.data.agent.AgentRunId$;
import js7.data.agent.Problems;
import js7.data.agent.Problems$AgentAlreadyDedicatedProblem$;
import js7.data.agent.Problems$AgentIsShuttingDown$;
import js7.data.agent.Problems$AgentNotDedicatedProblem$;
import js7.data.agent.Problems$AgentPathMismatchProblem$;
import js7.data.agent.Problems$AgentRunIdMismatchProblem$;
import js7.data.agent.Problems$AgentWrongControllerProblem$;
import js7.data.cluster.ClusterEvent$ClusterResetStarted$;
import js7.data.cluster.ClusterState;
import js7.data.controller.ControllerId;
import js7.data.controller.ControllerRunId;
import js7.data.event.KeyedEvent;
import js7.data.event.KeyedEvent$NoKey$;
import js7.data.order.OrderId;
import js7.data.subagent.SubagentId;
import js7.journal.FileJournal;
import js7.journal.Persisted;
import js7.subagent.Subagent;
import org.apache.pekko.actor.ActorSystem;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.hashing.MurmurHash3$;
import sourcecode.Enclosing$;
import sourcecode.Name$;

public final class AgentCommandExecutor
implements Service,
MainService,
StoppableByRequest,
Service.StoppableByRequest,
CommandHandler {
    private AtomicBoolean js7$base$service$Service$$started;
    private Deferred js7$base$service$Service$$stopped;
    private boolean stoppableByCancel;
    private Deferred js7$base$service$StoppableByRequest$$fiber;
    private Deferred js7$base$service$StoppableByRequest$$stopRequested;
    private volatile boolean js7$base$service$StoppableByRequest$$_isStopping;
    private IO js7$base$service$StoppableByRequest$$memoizedStop;
    private final Subagent.ForDirector forDirector;
    private final Option<SubagentId> failedOverSubagentId;
    private final WorkingClusterNode<AgentState> workingClusterNode;
    private final AgentConfiguration agentConf;
    private final ActorSystem actorSystem;
    private final FileJournal<AgentState> journal;
    private final AsyncLock lock;
    private final CommandRegister<AgentCommand> register;
    private final Deferred<IO, Dedicated> _dedicated;
    private final SetOnce<AgentCommand.ShutDown> shutdownOnce;
    private final Deferred<IO, DirectorTermination> terminated;
    private boolean isResetting;

    public static Resource<IO, AgentCommandExecutor> service(Subagent.ForDirector forDirector, WorkingClusterNode<AgentState> workingClusterNode, AlarmClock alarmClock, AgentConfiguration agentConfiguration, ActorSystem actorSystem) {
        return AgentCommandExecutor$.MODULE$.service(forDirector, workingClusterNode, alarmClock, agentConfiguration, actorSystem);
    }

    public AgentCommandExecutor(Subagent.ForDirector forDirector, Option<SubagentId> failedOverSubagentId, WorkingClusterNode<AgentState> workingClusterNode, AlarmClock clock, AgentConfiguration agentConf, ActorSystem actorSystem) {
        this.forDirector = forDirector;
        this.failedOverSubagentId = failedOverSubagentId;
        this.workingClusterNode = workingClusterNode;
        this.agentConf = agentConf;
        this.actorSystem = actorSystem;
        Service.$init$(this);
        StoppableByRequest.$init$(this);
        this.journal = workingClusterNode.journal();
        this.lock = AsyncLock$.MODULE$.apply(Enclosing$.MODULE$.apply("js7.agent.motor.AgentCommandExecutor#lock"));
        this.register = new CommandRegister();
        this._dedicated = package$.MODULE$.Deferred().unsafe(IO$.MODULE$.asyncForIO());
        this.shutdownOnce = SetOnce$.MODULE$.apply(Tag$.MODULE$.apply(AgentCommand.ShutDown.class, LightTypeTag$.MODULE$.parse(-598756534, "\u0004\u0000\u0001.js7.agent.data.commands.AgentCommand$.ShutDown\u0001\u0002\u0003\u0000\u0000$js7.agent.data.commands.AgentCommand\u0001\u0001", "\u0000\u0004\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u00015js7.agent.data.commands.AgentCommand$.ShutdownOrAbort\u0001\u0002\u0003\u0000\u0000$js7.agent.data.commands.AgentCommand\u0001\u0001\u0002\u0004\u0000\u0001\u001ejs7.data.command.CommonCommand\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001.js7.agent.data.commands.AgentCommand$.ShutDown\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0006\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0006\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30)));
        this.terminated = package$.MODULE$.Deferred().unsafe(IO$.MODULE$.asyncForIO());
        this.isResetting = false;
        Statics.releaseFence();
    }

    @Override
    public AtomicBoolean js7$base$service$Service$$started() {
        return this.js7$base$service$Service$$started;
    }

    public Deferred js7$base$service$Service$$stopped() {
        return this.js7$base$service$Service$$stopped;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$started_$eq(AtomicBoolean x$0) {
        this.js7$base$service$Service$$started = x$0;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$stopped_$eq(Deferred x$0) {
        this.js7$base$service$Service$$stopped = x$0;
    }

    @Override
    public boolean stoppableByCancel() {
        return this.stoppableByCancel;
    }

    public final Deferred js7$base$service$StoppableByRequest$$fiber() {
        return this.js7$base$service$StoppableByRequest$$fiber;
    }

    public Deferred js7$base$service$StoppableByRequest$$stopRequested() {
        return this.js7$base$service$StoppableByRequest$$stopRequested;
    }

    @Override
    public boolean js7$base$service$StoppableByRequest$$_isStopping() {
        return this.js7$base$service$StoppableByRequest$$_isStopping;
    }

    public IO js7$base$service$StoppableByRequest$$memoizedStop() {
        return this.js7$base$service$StoppableByRequest$$memoizedStop;
    }

    @Override
    public void js7$base$service$StoppableByRequest$$_isStopping_$eq(boolean x$1) {
        this.js7$base$service$StoppableByRequest$$_isStopping = x$1;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$stoppableByCancel_$eq(boolean x$0) {
        this.stoppableByCancel = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$fiber_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$fiber = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$stopRequested_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$stopRequested = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$memoizedStop_$eq(IO x$0) {
        this.js7$base$service$StoppableByRequest$$memoizedStop = x$0;
    }

    private boolean isShuttingDown() {
        return this.shutdownOnce.isDefined();
    }

    @Override
    public IO<Service.Started> start() {
        return this.journal.aggregate().flatMap((Function1 & Serializable)agentState -> IO$.MODULE$.whenA(agentState.isDedicated(), () -> this.start$$anonfun$1$$anonfun$1(agentState))).$times$greater(this.startService(this.untilStopRequested().$times$greater(this.stopAgentMotor(this.stopAgentMotor$default$1()))));
    }

    public IO<DirectorTermination> untilTerminated() {
        return Logger$package$Logger$syntax$.MODULE$.debugIO(AgentCommandExecutor$.js7$agent$motor$AgentCommandExecutor$$$logger, (IO)this.terminated.get(), Name$.MODULE$.apply("untilTerminated"));
    }

    @Override
    public IO<Either<Problem, AgentCommand.Response>> execute(AgentCommand command, CommandMeta meta) {
        return this.executeCommand(command, meta, this.executeCommand$default$3());
    }

    private IO<Either<Problem, AgentCommand.Response>> executeCommand(AgentCommand command, CommandMeta meta, Option<CorrelId> batchId) {
        return (IO)this.register.resource(command, meta, CorrelId$.MODULE$.current(), batchId, IO$.MODULE$.asyncForIO()).use((Function1 & Serializable)run -> this.logCommand((CommandRun<AgentCommand>)run, (IO)this.executeCommand2(command, run.correlId(), meta, (Option<CorrelId>)None$.MODULE$)), (MonadCancel)IO$.MODULE$.asyncForIO());
    }

    private Option<CorrelId> executeCommand$default$3() {
        return None$.MODULE$;
    }

    private <A> IO<A> logCommand(CommandRun<AgentCommand> run, IO<A> body) {
        AgentCommand agentCommand = run.command();
        if (agentCommand instanceof AgentCommand.Batch) {
            AgentCommand.Batch batch = (AgentCommand.Batch)agentCommand;
            return body;
        }
        return Logger$package$Logger$syntax$.MODULE$.debugIO(AgentCommandExecutor$.js7$agent$motor$AgentCommandExecutor$$$logger, run.toString(), (Function0<Object>)((Function0 & Serializable)AgentCommandExecutor::logCommand$$anonfun$1), body);
    }

    private IO<Either<Problem, AgentCommand.Response>> executeCommand2(AgentCommand command, CorrelId correlId, CommandMeta meta, Option<CorrelId> batchId) {
        AgentCommand agentCommand;
        block19: {
            block15: {
                block18: {
                    block17: {
                        block16: {
                            block14: {
                                agentCommand = command;
                                if (!(agentCommand instanceof AgentCommand.IsOrderCommand)) break block14;
                                AgentCommand.IsOrderCommand isOrderCommand = (AgentCommand.IsOrderCommand)agentCommand;
                                break block15;
                            }
                            if (!(agentCommand instanceof AgentCommand.AttachItem)) break block16;
                            AgentCommand.AttachItem attachItem = (AgentCommand.AttachItem)agentCommand;
                            break block15;
                        }
                        if (!(agentCommand instanceof AgentCommand.AttachSignedItem)) break block17;
                        AgentCommand.AttachSignedItem attachSignedItem = (AgentCommand.AttachSignedItem)agentCommand;
                        break block15;
                    }
                    if (!(agentCommand instanceof AgentCommand.DetachItem)) break block18;
                    AgentCommand.DetachItem detachItem = (AgentCommand.DetachItem)agentCommand;
                    break block15;
                }
                if (!(agentCommand instanceof AgentCommand.ResetSubagent)) break block19;
                AgentCommand.ResetSubagent resetSubagent = (AgentCommand.ResetSubagent)agentCommand;
            }
            AgentCommand cmd = agentCommand;
            IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.checkedAgentMotor());
            return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$2 -> _$2.executeCommand(cmd), IO$.MODULE$.asyncForIO());
        }
        if (agentCommand instanceof AgentCommand.DedicateAgentDirector) {
            AgentCommand.DedicateAgentDirector dedicateAgentDirector = (AgentCommand.DedicateAgentDirector)agentCommand;
            AgentCommand.DedicateAgentDirector dedicateAgentDirector2 = AgentCommand$DedicateAgentDirector$.MODULE$.unapply(dedicateAgentDirector);
            AgentPath agentPath = dedicateAgentDirector2._1();
            Seq<SubagentId> seq = dedicateAgentDirector2._2();
            ControllerId controllerId = dedicateAgentDirector2._3();
            ControllerRunId controllerRunId = dedicateAgentDirector2._4();
            AgentPath agentPath2 = agentPath;
            Seq<SubagentId> directors = seq;
            ControllerId controllerId2 = controllerId;
            ControllerRunId controllerRunId2 = controllerRunId;
            if (this.isShuttingDown()) {
                return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problems$AgentIsShuttingDown$.MODULE$);
            }
            return this.dedicate(agentPath2, directors, controllerId2, controllerRunId2).map((Function1 & Serializable)_$3 -> _$3.map((Function1 & Serializable)x$1 -> {
                AgentRunId agentRunId = (AgentRunId)x$1._1();
                long l = BoxesRunTime.unboxToLong((Object)x$1._2());
                return AgentCommand$DedicateAgentDirector$Response$.MODULE$.apply(agentRunId, l);
            }));
        }
        if (agentCommand instanceof AgentCommand.CoupleController) {
            AgentCommand.CoupleController coupleController = (AgentCommand.CoupleController)agentCommand;
            AgentCommand.CoupleController coupleController2 = AgentCommand$CoupleController$.MODULE$.unapply(coupleController);
            AgentPath agentPath = coupleController2._1();
            AgentRunId agentRunId = coupleController2._2();
            long l = coupleController2._3();
            ControllerRunId controllerRunId = coupleController2._4();
            AgentPath agentPath3 = agentPath;
            AgentRunId agentRunId2 = agentRunId;
            long eventId = l;
            ControllerRunId controllerRunId3 = controllerRunId;
            if (this.isShuttingDown()) {
                return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problems$AgentIsShuttingDown$.MODULE$);
            }
            return IO$.MODULE$.apply(() -> this.executeCommand2$$anonfun$3(controllerRunId3, agentPath3, agentRunId2, eventId));
        }
        if (agentCommand instanceof AgentCommand.Reset) {
            AgentCommand.Reset reset;
            AgentCommand.Reset cmd = reset = (AgentCommand.Reset)agentCommand;
            return this.reset(cmd);
        }
        if (AgentCommand$TakeSnapshot$.MODULE$.equals(agentCommand)) {
            return this.journal.takeSnapshot().as((Object)scala.package$.MODULE$.Right().apply((Object)AgentCommand$Response$Accepted$.MODULE$));
        }
        if (agentCommand == AgentCommand$ClusterSwitchOver$.MODULE$) {
            AgentCommand$ClusterSwitchOver$ agentCommand$ClusterSwitchOver$;
            AgentCommand$ClusterSwitchOver$ cmd = agentCommand$ClusterSwitchOver$ = (AgentCommand$ClusterSwitchOver$)agentCommand;
            return this.switchOver(cmd);
        }
        if (agentCommand instanceof AgentCommand.ShutDown) {
            AgentCommand.ShutDown shutDown;
            AgentCommand.ShutDown cmd = shutDown = (AgentCommand.ShutDown)agentCommand;
            return this.initiateShutdown(cmd, cmd);
        }
        if (AgentCommand$NoOperation$.MODULE$.equals(agentCommand)) {
            return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, AgentCommand$Response$Accepted$.MODULE$);
        }
        if (agentCommand instanceof AgentCommand.EmergencyStop) {
            boolean bl;
            AgentCommand.EmergencyStop emergencyStop = (AgentCommand.EmergencyStop)agentCommand;
            AgentCommand.EmergencyStop emergencyStop2 = AgentCommand$EmergencyStop$.MODULE$.unapply(emergencyStop);
            boolean restart = bl = emergencyStop2._1();
            throw Halt$.MODULE$.haltJava("\ud83d\udfe5 EmergencyStop command received: JS7 AGENT DIRECTOR STOPS NOW", restart, Halt$.MODULE$.haltJava$default$3());
        }
        if (agentCommand instanceof AgentCommand.Batch) {
            Seq<CorrelIdWrapped<AgentCommand>> seq;
            AgentCommand.Batch batch = (AgentCommand.Batch)agentCommand;
            AgentCommand.Batch batch2 = AgentCommand$Batch$.MODULE$.unapply(batch);
            Seq<CorrelIdWrapped<AgentCommand>> wrappedCommands = seq = batch2._1();
            return CatsEffectExtensions$.MODULE$.catchAsChecked(((IO)Stream$.MODULE$.iterable(wrappedCommands).evalMap((Function1 & Serializable)wrapped -> {
                CorrelIdWrapped correlIdWrapped = wrapped;
                CorrelIdWrapped correlIdWrapped2 = CorrelIdWrapped$.MODULE$.unapply(correlIdWrapped);
                CorrelId correlId = correlIdWrapped2._1();
                AgentCommand agentCommand = (AgentCommand)correlIdWrapped2._2();
                CorrelId subcorrelId = correlId;
                AgentCommand cmd = agentCommand;
                Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)subcorrelId, (Object)cmd);
                CorrelId subcorrelId2 = (CorrelId)tuple2._1();
                AgentCommand cmd2 = (AgentCommand)tuple2._2();
                return subcorrelId2.orNew().bind(() -> this.executeCommand2$$anonfun$4$$anonfun$1(cmd2, meta, batchId, correlId), CanBindCorrelId$.MODULE$.io());
            }).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).toVector()).map((Function1 & Serializable)_$4 -> AgentCommand$Batch$Response$.MODULE$.apply((Seq<Either<Problem, AgentCommand.Response>>)_$4)));
        }
        throw new MatchError((Object)agentCommand);
    }

    private IO<Either<Problem, Tuple2<AgentRunId, Object>>> dedicate(AgentPath agentPath, Seq<SubagentId> directors, ControllerId controllerId, ControllerRunId controllerRunId) {
        return IO$.MODULE$.defer(() -> this.dedicate$$anonfun$1(agentPath, directors, controllerId, controllerRunId));
    }

    private IO<Either<Problem, AgentCommand$Response$Accepted$>> reset(AgentCommand.Reset cmd) {
        Either either = (Either)cmd.agentRunId().fold(AgentCommandExecutor::reset$$anonfun$1, (Function1 & Serializable)_$8 -> this.checkAgentRunId((AgentRunId)_$8));
        if (either instanceof Left) {
            Left left = (Left)either;
            Problem problem = (Problem)left.value();
            return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, problem);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Object object = right.value();
            if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                Logger LoggerImpl_this = AgentCommandExecutor$.js7$agent$motor$AgentCommandExecutor$$$logger;
                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("\u2757 {}", (Object)cmd);
                }
                this.isResetting = true;
                if (this.isShuttingDown()) {
                    return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problem$.MODULE$.pure("Director is shutting down"));
                }
                IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(CatsEffectExtensions$.MODULE$.catchIntoChecked(this.journal.persist_rightNoKeys((Function1 & Serializable)_$9 -> {
                    ClusterState a$proxy1 = _$9.clusterState();
                    boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(a$proxy1 instanceof ClusterState.Coupled);
                    return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, AgentCommandExecutor::reset$$anonfun$4$$anonfun$1);
                })));
                IO iO2 = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$10 -> this.initiateShutdown(cmd, AgentCommand$ShutDown$.MODULE$.apply((Option<ProcessSignal>)Some$.MODULE$.apply((Object)ProcessSignal$SIGKILL$.MODULE$), AgentCommand$ShutDown$.MODULE$.$lessinit$greater$default$2(), true, true, AgentCommand$ShutDown$.MODULE$.$lessinit$greater$default$5())), IO$.MODULE$.asyncForIO()));
                return ((IO)CatsExtensions$.MODULE$.flatMapSome(this.agentMotor(), (Function1 & Serializable)agentMotor -> agentMotor.resetAllSubagents(), IO$.MODULE$.asyncForIO())).$times$greater((IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatTapT$extension(iO2, (Function1 & Serializable)_$11 -> this.journal.deleteJournalWhenStopping().as(Checked$.MODULE$.unit()), IO$.MODULE$.asyncForIO()));
            }
        }
        throw new MatchError((Object)either);
    }

    private IO<Either<Problem, AgentCommand.Response>> switchOver(AgentCommand$ClusterSwitchOver$ cmd) {
        Some some = Some$.MODULE$.apply((Object)AgentCommand$ShutDown$ClusterAction$Switchover$.MODULE$);
        Option<ProcessSignal> option = AgentCommand$ShutDown$.MODULE$.$lessinit$greater$default$1();
        boolean bl = AgentCommand$ShutDown$.MODULE$.$lessinit$greater$default$3();
        boolean bl2 = AgentCommand$ShutDown$.MODULE$.$lessinit$greater$default$4();
        return this.initiateShutdown(cmd, AgentCommand$ShutDown$.MODULE$.apply(option, (Option<AgentCommand.ShutDown.ClusterAction>)some, bl, bl2, true));
    }

    private IO<Either<Problem, AgentCommand$Response$Accepted$>> initiateShutdown(AgentCommand originalCmd, AgentCommand.ShutDown cmd) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(Predef$.MODULE$.locally(cmd.isSwitchover() ? this.journal.aggregate().map((Function1 & Serializable)_$12 -> _$12.clusterState()).map((Function1 & Serializable)x$1 -> {
            ClusterState clusterState = x$1;
            if (clusterState instanceof ClusterState.Coupled) {
                ClusterState.Coupled coupled;
                ClusterState.Coupled coupled2 = coupled = (ClusterState.Coupled)clusterState;
                return scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            }
            ClusterState clusterState2 = clusterState;
            return scala.package$.MODULE$.Left().apply((Object)Problems$ClusterSwitchOverButNotCoupledProblem$.MODULE$.apply(clusterState2));
        }) : CatsEffectExtensions$.MODULE$.inline$rightUnitIO()));
        IO iO2 = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$13 -> IO$.MODULE$.apply(() -> this.initiateShutdown$$anonfun$3$$anonfun$1(cmd)), IO$.MODULE$.asyncForIO()));
        return Logger$package$Logger$syntax$.MODULE$.traceIO(AgentCommandExecutor$.js7$agent$motor$AgentCommandExecutor$$$logger, cmd.toString(), Logger$package$Logger$syntax$.MODULE$.traceIO$default$3(AgentCommandExecutor$.js7$agent$motor$AgentCommandExecutor$$$logger), (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO2, (Function1 & Serializable)_$14 -> {
            Logger LoggerImpl_this = AgentCommandExecutor$.js7$agent$motor$AgentCommandExecutor$$$logger;
            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                LoggerImpl_this.underlying().info("\u2757\ufe0f {}", (Object)originalCmd);
            }
            IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichAny(this.shutdown(cmd));
            return ((IO)ScalaUtils$syntax$RichAny$.MODULE$.pipeIf$extension(iO, (Function0<Object>)((Function0 & Serializable)() -> AgentCommandExecutor.initiateShutdown$$anonfun$4$$anonfun$1(cmd)), (Function1 & Serializable)_$15 -> CatsEffectExtensions$.MODULE$.startAndForget(_$15, Enclosing$.MODULE$.apply("js7.agent.motor.AgentCommandExecutor#initiateShutdown")))).as((Object)scala.package$.MODULE$.Right().apply((Object)AgentCommand$Response$Accepted$.MODULE$));
        }, IO$.MODULE$.asyncForIO()));
    }

    private IO<BoxedUnit> shutdown(AgentCommand.ShutDown cmd) {
        return Logger$package$Logger$syntax$.MODULE$.debugIO(AgentCommandExecutor$.js7$agent$motor$AgentCommandExecutor$$$logger, "\u2757shutdown " + cmd, (Function0<Object>)((Function0 & Serializable)AgentCommandExecutor::shutdown$$anonfun$1), ((IO)Predef$.MODULE$.locally(cmd.isFailover() ? ((IO)CatsExtensions$.MODULE$.flatMapSome(this.agentMotor(), (Function1 & Serializable)agentMotor -> agentMotor.kill().$times$greater(this.stopAgentMotor(cmd)), IO$.MODULE$.asyncForIO())).productR(this.journal.kill()) : (cmd.isSwitchover() ? this.stopAgentMotor(cmd).$times$greater(this.workingClusterNode.switchOver().map((Function1)(JProcedure1 & Serializable)_$16 -> {
            Either either = ScalaUtils$syntax$.MODULE$.RichEither(_$16);
            BoxedUnit cfr_ignored_0 = (BoxedUnit)ScalaUtils$syntax$RichEither$.MODULE$.orThrow$extension(either);
        })) : this.stopAgentMotor(cmd)))).productR(this.stop()).productR(((IO)this.terminated.complete((Object)DirectorTermination$.MODULE$.apply(cmd.restart(), cmd.restartDirector()))).void()));
    }

    private IO<Either<Problem, BoxedUnit>> startAgentMotor(AgentPath agentPath, ControllerId controllerId) {
        return this.lock.lock(IO$.MODULE$.defer(() -> this.startAgentMotor$$anonfun$1(agentPath, controllerId)), Enclosing$.MODULE$.apply("js7.agent.motor.AgentCommandExecutor#startAgentMotor"), ScalaSourceLocation$.MODULE$.apply("AgentCommandExecutor.scala", 296));
    }

    private IO<BoxedUnit> stopAgentMotor(AgentCommand.ShutDown cmd) {
        return Logger$package$Logger$syntax$.MODULE$.traceIO(AgentCommandExecutor$.js7$agent$motor$AgentCommandExecutor$$$logger, ((IO)CatsExtensions$.MODULE$.flatMapSome(this.agentMotor(), (Function1 & Serializable)_$17 -> _$17.shutdown(cmd), IO$.MODULE$.asyncForIO())).productR(((IO)CatsExtensions$.MODULE$.flatMapSome(this._dedicated.tryGet(), (Function1 & Serializable)_$18 -> _$18.stopAgentMotor(), IO$.MODULE$.asyncForIO())).void()), Name$.MODULE$.apply("stopAgentMotor"));
    }

    private AgentCommand.ShutDown stopAgentMotor$default$1() {
        return AgentCommand$ShutDown$.MODULE$.apply(AgentCommand$ShutDown$.MODULE$.$lessinit$greater$default$1(), AgentCommand$ShutDown$.MODULE$.$lessinit$greater$default$2(), AgentCommand$ShutDown$.MODULE$.$lessinit$greater$default$3(), AgentCommand$ShutDown$.MODULE$.$lessinit$greater$default$4(), AgentCommand$ShutDown$.MODULE$.$lessinit$greater$default$5());
    }

    private IO<Option<AgentMotor>> agentMotor() {
        return ((IO)this._dedicated.tryGet()).map((Function1 & Serializable)_$19 -> _$19.map((Function1 & Serializable)_$20 -> _$20.agentMotor()));
    }

    private IO<Either<Problem, AgentMotor>> checkedAgentMotor() {
        return ((IO)this._dedicated.tryGet()).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problems$AgentNotDedicatedProblem$.MODULE$);
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                Dedicated dedicated = (Dedicated)some.value();
                return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, dedicated.agentMotor());
            }
            throw new MatchError((Object)option);
        });
    }

    private Either<Problem, BoxedUnit> checkAgentPath(AgentPath requestedAgentPath) {
        AgentState agentState = (AgentState)this.journal.unsafeAggregate();
        if (!agentState.isDedicated()) {
            return scala.package$.MODULE$.Left().apply((Object)Problems$AgentNotDedicatedProblem$.MODULE$);
        }
        AgentPath agentPath = requestedAgentPath;
        AgentPath agentPath2 = agentState.agentPath();
        if (agentPath == null ? agentPath2 != null : !((Object)agentPath).equals(agentPath2)) {
            return scala.package$.MODULE$.Left().apply((Object)Problems$AgentPathMismatchProblem$.MODULE$.apply(requestedAgentPath, agentState.agentPath()));
        }
        return Checked$.MODULE$.unit();
    }

    private Either<Problem, BoxedUnit> checkAgentRunId(AgentRunId requestedAgentRunId) {
        AgentState agentState = (AgentState)this.journal.unsafeAggregate();
        if (!agentState.isDedicated()) {
            return scala.package$.MODULE$.Left().apply((Object)Problems$AgentNotDedicatedProblem$.MODULE$);
        }
        AgentRunId agentRunId = requestedAgentRunId;
        AgentRunId agentRunId2 = agentState.meta().agentRunId();
        if (agentRunId == null ? agentRunId2 != null : !((Object)agentRunId).equals(agentRunId2)) {
            Problems.AgentRunIdMismatchProblem problem = Problems$AgentRunIdMismatchProblem$.MODULE$.apply(agentState.meta().agentPath());
            Logger LoggerImpl_this = AgentCommandExecutor$.js7$agent$motor$AgentCommandExecutor$$$logger;
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("{}, requestedAgentRunId={}, agentRunId={}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{problem, requestedAgentRunId, agentState.meta().agentRunId()}), Object.class));
            }
            return scala.package$.MODULE$.Left().apply((Object)problem);
        }
        return Checked$.MODULE$.unit();
    }

    private Either<Problem, BoxedUnit> checkControllerRunId(ControllerRunId requestedControllerRunId) {
        AgentState agentState = (AgentState)this.journal.unsafeAggregate();
        if (!agentState.isDedicated()) {
            return scala.package$.MODULE$.Left().apply((Object)Problems$AgentNotDedicatedProblem$.MODULE$);
        }
        if (agentState.meta().controllerRunId().exists((Function1 & Serializable)_$21 -> {
            ControllerRunId controllerRunId = _$21;
            ControllerRunId controllerRunId2 = requestedControllerRunId;
            return controllerRunId == null ? controllerRunId2 != null : !((Object)controllerRunId).equals(controllerRunId2);
        })) {
            Problem problem = Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)AgentCommandExecutor::$anonfun$1), Problem$.MODULE$.apply$default$2());
            Logger LoggerImpl_this = AgentCommandExecutor$.js7$agent$motor$AgentCommandExecutor$$$logger;
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("{}, requestedControllerRunId={}, controllerRunId={}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{problem, requestedControllerRunId, agentState.meta().controllerRunId()}), Object.class));
            }
            return scala.package$.MODULE$.Left().apply((Object)problem);
        }
        return Checked$.MODULE$.unit();
    }

    public String toString() {
        return "AgentCommandExecutor";
    }

    private final IO start$$anonfun$1$$anonfun$1(AgentState agentState$1) {
        return this.startAgentMotor(agentState$1.agentPath(), agentState$1.controllerId()).map((Function1)(JProcedure1 & Serializable)_$1 -> {
            Either either = ScalaUtils$syntax$.MODULE$.RichEither(_$1);
            BoxedUnit cfr_ignored_0 = (BoxedUnit)ScalaUtils$syntax$RichEither$.MODULE$.orThrow$extension(either);
        });
    }

    private static final Object logCommand$$anonfun$1() {
        return Logger$package$Logger$syntax$.MODULE$.debugIO$default$3(AgentCommandExecutor$.js7$agent$motor$AgentCommandExecutor$$$logger);
    }

    private final Either executeCommand2$$anonfun$3(ControllerRunId controllerRunId$1, AgentPath agentPath$1, AgentRunId agentRunId$1, long eventId$1) {
        return this.checkControllerRunId(controllerRunId$1).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.checkAgentPath(agentPath$1).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.checkAgentRunId(agentRunId$1).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.journal.eventWatch().checkEventId(eventId$1, this.journal.eventWatch().checkEventId$default$2()).map((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return AgentCommand$CoupleController$Response$.MODULE$.apply((Set<OrderId>)((AgentState)this.journal.unsafeAggregate()).idToOrder().keySet());
                    });
                });
            });
        });
    }

    private static final Option executeCommand2$$anonfun$4$$anonfun$1$$anonfun$1(CorrelId correlId$3) {
        return Some$.MODULE$.apply((Object)correlId$3);
    }

    private final IO executeCommand2$$anonfun$4$$anonfun$1(AgentCommand cmd$2, CommandMeta meta$2, Option batchId$1, CorrelId correlId$1) {
        return this.executeCommand(cmd$2, meta$2, (Option<CorrelId>)batchId$1.orElse(() -> AgentCommandExecutor.executeCommand2$$anonfun$4$$anonfun$1$$anonfun$1(correlId$1)));
    }

    private static final Tuple2 dedicate$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(AgentRunId agentRunId$8, Persisted persisted$2) {
        AgentRunId agentRunId = (AgentRunId)Predef$.MODULE$.ArrowAssoc((Object)agentRunId$8);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)agentRunId, (Object)BoxesRunTime.boxToLong((long)((AgentState)persisted$2.aggregate()).eventId()));
    }

    private final IO dedicate$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1() {
        return this.stopAgentMotor(this.stopAgentMotor$default$1());
    }

    private final IO dedicate$$anonfun$1$$anonfun$2$$anonfun$1(AgentPath agentPath$7, ControllerId controllerId$5, AgentRunId agentRunId$7, Persisted persisted$1) {
        Logger LoggerImpl_this = AgentCommandExecutor$.js7$agent$motor$AgentCommandExecutor$$$logger;
        if (LoggerImpl_this.underlying().isInfoEnabled()) {
            LoggerImpl_this.underlying().info("Dedicating {} to '{}'", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{agentPath$7, controllerId$5}), Object.class));
        }
        Log4j$.MODULE$.set("js7.serverId", agentPath$7.toString());
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.startAgentMotor(agentPath$7, controllerId$5));
        IO iO2 = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(ScalaUtils$syntax$RichEitherF$.MODULE$.rightAs$extension((Object)iO, () -> AgentCommandExecutor.dedicate$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(agentRunId$7, persisted$1), IO$.MODULE$.asyncForIO()));
        return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatTapT$extension(iO2, (Function1 & Serializable)_$6 -> IO$.MODULE$.whenA(this.isStopping(), this::dedicate$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1).map((Function1 & Serializable)_$7 -> scala.package$.MODULE$.Right().apply(_$7)), IO$.MODULE$.asyncForIO());
    }

    private final IO dedicate$$anonfun$1(AgentPath agentPath$3, Seq directors$1, ControllerId controllerId$1, ControllerRunId controllerRunId$2) {
        AgentRunId agentRunId = AgentRunId$.MODULE$.apply(this.journal.journalId());
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.journal.persist((Function1 & Serializable)agentState -> {
            block7: {
                block6: {
                    if (!agentState.isDedicated()) break block6;
                    AgentPath agentPath = agentPath$3;
                    AgentPath agentPath2 = agentState.agentPath();
                    if (agentPath != null ? !((Object)agentPath).equals(agentPath2) : agentPath2 != null) break block7;
                    Seq<SubagentId> seq = agentState.meta().directors();
                    Seq seq2 = directors$1;
                    if (!(seq == null ? seq2 != null : !seq.equals((Object)seq2))) break block7;
                }
                return UserId$.MODULE$.checked(agentPath$3.string()).map((Function1 & Serializable)_$5 -> {
                    AgentEvent.AgentDedicated event = AgentEvent$AgentDedicated$.MODULE$.apply(agentPath$3, (Seq<SubagentId>)directors$1, agentRunId, controllerId$1, (Option<ControllerRunId>)Some$.MODULE$.apply((Object)controllerRunId$2));
                    KeyedEvent$NoKey$ keyedEvent$NoKey$ = KeyedEvent$NoKey$.MODULE$;
                    AgentEvent.AgentDedicated Event_this = event;
                    KeyedEvent<AgentEvent.AgentDedicated> keyedEvent = new KeyedEvent<AgentEvent.AgentDedicated>(Event_this, keyedEvent$NoKey$);
                    return scala.package$.MODULE$.Nil().$colon$colon(keyedEvent);
                });
            }
            AgentPath agentPath = agentPath$3;
            AgentPath agentPath3 = agentState.agentPath();
            if (agentPath == null ? agentPath3 != null : !((Object)agentPath).equals(agentPath3)) {
                return scala.package$.MODULE$.Left().apply((Object)Problems$AgentPathMismatchProblem$.MODULE$.apply(agentPath$3, agentState.agentPath()));
            }
            ControllerId controllerId = controllerId$1;
            ControllerId controllerId2 = agentState.meta().controllerId();
            if (controllerId == null ? controllerId2 != null : !((Object)controllerId).equals(controllerId2)) {
                return scala.package$.MODULE$.Left().apply((Object)Problems$AgentWrongControllerProblem$.MODULE$.apply(controllerId$1, agentState.meta().controllerId()));
            }
            if (!agentState.isFreshlyDedicated() && !agentState.meta().controllerRunId().contains((Object)controllerRunId$2)) {
                return scala.package$.MODULE$.Left().apply((Object)Problems$AgentAlreadyDedicatedProblem$.MODULE$);
            }
            return scala.package$.MODULE$.Right().apply((Object)scala.package$.MODULE$.Nil());
        }));
        return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)persisted -> IO$.MODULE$.defer(() -> this.dedicate$$anonfun$1$$anonfun$2$$anonfun$1(agentPath$3, controllerId$1, agentRunId, persisted)), IO$.MODULE$.asyncForIO());
    }

    private static final Either reset$$anonfun$1() {
        return Checked$.MODULE$.unit();
    }

    private static final ClusterEvent$ClusterResetStarted$ reset$$anonfun$4$$anonfun$1() {
        return ClusterEvent$ClusterResetStarted$.MODULE$;
    }

    private static final Problems$AgentIsShuttingDown$ initiateShutdown$$anonfun$3$$anonfun$1$$anonfun$1() {
        return Problems$AgentIsShuttingDown$.MODULE$;
    }

    private final Either initiateShutdown$$anonfun$3$$anonfun$1(AgentCommand.ShutDown cmd$5) {
        boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(this.shutdownOnce.trySet(cmd$5));
        return ScalaUtils$syntax$RichBoolean$.MODULE$.orLeft$extension(RichBoolean_this, AgentCommandExecutor::initiateShutdown$$anonfun$3$$anonfun$1$$anonfun$1);
    }

    private static final boolean initiateShutdown$$anonfun$4$$anonfun$1(AgentCommand.ShutDown cmd$7) {
        return !cmd$7.restartDirector();
    }

    private static final Object shutdown$$anonfun$1() {
        return Logger$package$Logger$syntax$.MODULE$.debugIO$default$3(AgentCommandExecutor$.js7$agent$motor$AgentCommandExecutor$$$logger);
    }

    private static final String startAgentMotor$$anonfun$1$$anonfun$1$$anonfun$1(AgentMotor agentMotor$1) {
        return "This Agent has already been dedicated as '" + agentMotor$1.agentPath() + "' for '" + agentMotor$1.controllerId() + "'";
    }

    private final IO startAgentMotor$$anonfun$1(AgentPath agentPath$8, ControllerId controllerId$6) {
        if (this.isShuttingDown()) {
            return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problems$AgentIsShuttingDown$.MODULE$);
        }
        return ((IO)this._dedicated.tryGet()).flatMap((Function1 & Serializable)x$1 -> {
            Some some;
            Dedicated dedicated;
            Option option = x$1;
            if (option instanceof Some && (dedicated = (Dedicated)(some = (Some)option).value()) != null) {
                Dedicated dedicated2;
                Dedicated dedicated3 = dedicated2 = dedicated;
                AgentMotor agentMotor = dedicated3.agentMotor();
                AgentPath agentPath = agentMotor.agentPath();
                AgentPath agentPath2 = agentPath$8;
                if (!(agentPath != null ? !((Object)agentPath).equals(agentPath2) : agentPath2 != null)) {
                    ControllerId controllerId = agentMotor.controllerId();
                    ControllerId controllerId2 = controllerId$6;
                    if (!(controllerId != null ? !((Object)controllerId).equals(controllerId2) : controllerId2 != null)) {
                        Logger LoggerImpl_this = AgentCommandExecutor$.js7$agent$motor$AgentCommandExecutor$$$logger;
                        if (LoggerImpl_this.underlying().isDebugEnabled()) {
                            LoggerImpl_this.underlying().debug("\u2753 startAgentMotor: already started");
                        }
                        return CatsEffectExtensions$.MODULE$.inline$rightUnitIO();
                    }
                }
                return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> AgentCommandExecutor.startAgentMotor$$anonfun$1$$anonfun$1$$anonfun$1(agentMotor)), Problem$.MODULE$.apply$default$2()));
            }
            if (None$.MODULE$.equals(option)) {
                Resource resource = CatsUtils$syntax$.MODULE$.RichResource(AgentMotor$.MODULE$.service(this.failedOverSubagentId, this.forDirector, this.workingClusterNode, this.agentConf, this.actorSystem));
                return ((IO)CatsUtils$syntax$RichResource$.MODULE$.toAllocated$extension(resource, IO$.MODULE$.asyncForIO(), UnsafeMemoizable$.MODULE$.given_UnsafeMemoizable_F(IO$.MODULE$.asyncForIO()), Tag$.MODULE$.apply(AgentMotor.class, LightTypeTag$.MODULE$.parse(-70039561, "\u0004\u0000\u0001\u001ajs7.agent.motor.AgentMotor\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\u001ajs7.agent.motor.AgentMotor\u0001\u0001\u0003\u0004\u0000\u0001\u0018js7.base.service.Service\u0001\u0001\u0004\u0000\u0001#js7.base.service.StoppableByRequest\u0001\u0001\u0004\u0000\u0001,js7.base.service.Service$.StoppableByRequest\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0002\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0003\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001", 30)))).flatMap((Function1 & Serializable)allocated -> ((IO)this._dedicated.complete((Object)AgentCommandExecutor$Dedicated$.MODULE$.apply((Allocated<IO, AgentMotor>)allocated))).as(Checked$.MODULE$.unit()));
            }
            throw new MatchError((Object)option);
        });
    }

    private static final String $anonfun$1() {
        return "ControllerRunId does not match";
    }

    public static final class Dedicated
    implements Product,
    Serializable {
        private final Allocated<IO, AgentMotor> allocated;

        public static Dedicated apply(Allocated<IO, AgentMotor> allocated) {
            return AgentCommandExecutor$Dedicated$.MODULE$.apply(allocated);
        }

        public static Dedicated fromProduct(Product product) {
            return AgentCommandExecutor$Dedicated$.MODULE$.fromProduct(product);
        }

        public static Dedicated unapply(Dedicated dedicated) {
            return AgentCommandExecutor$Dedicated$.MODULE$.unapply(dedicated);
        }

        public Dedicated(Allocated<IO, AgentMotor> allocated) {
            this.allocated = allocated;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 538753321, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            Dedicated dedicated;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Dedicated)) return false;
            Dedicated dedicated2 = dedicated = (Dedicated)object;
            Allocated<IO, AgentMotor> allocated = this.allocated();
            Allocated<IO, AgentMotor> allocated2 = dedicated2.allocated();
            if (allocated != null) {
                if (!allocated.equals(allocated2)) return false;
                return true;
            }
            if (allocated2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Dedicated;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Dedicated";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "allocated";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        private Allocated<IO, AgentMotor> allocated() {
            return this.allocated;
        }

        public AgentMotor agentMotor() {
            return this.allocated().allocatedThing();
        }

        public IO<BoxedUnit> stopAgentMotor() {
            return this.allocated().release();
        }

        public Dedicated copy(Allocated<IO, AgentMotor> allocated) {
            return new Dedicated(allocated);
        }

        public Allocated<IO, AgentMotor> copy$default$1() {
            return this.allocated();
        }

        public Allocated<IO, AgentMotor> _1() {
            return this.allocated();
        }
    }
}

