/*
 * Decompiled with CFR 0.152.
 */
package js7.agent.motor;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.effect.package$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.concurrent.atomic.AtomicBoolean;
import js7.agent.configuration.AgentConfiguration;
import js7.agent.data.AgentState;
import js7.agent.data.commands.AgentCommand;
import js7.agent.data.commands.AgentCommand$ResetSubagent$;
import js7.agent.data.commands.AgentCommand$Response$Accepted$;
import js7.agent.data.commands.AgentCommand$ShutDown$;
import js7.agent.data.event.AgentEvent$AgentReady$;
import js7.agent.data.event.AgentEvent$AgentShutDown$;
import js7.agent.motor.AgentMotor$;
import js7.agent.motor.ItemCommandExecutor;
import js7.agent.motor.OrderMotor;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.catsutils.CatsExtensions$;
import js7.base.log.Logger$package$Logger$syntax$;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$Ops$;
import js7.base.problem.Checked$RichCheckedF$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.service.Service;
import js7.base.service.StoppableByRequest;
import js7.base.utils.ScalaUtils;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.cluster.WorkingClusterNode;
import js7.common.system.PlatformInfos$;
import js7.data.agent.AgentPath;
import js7.data.controller.ControllerId;
import js7.data.event.KeyedEvent;
import js7.data.event.NoKeyEvent$;
import js7.data.platform.PlatformInfo;
import js7.data.subagent.SubagentId;
import js7.journal.FileJournal;
import js7.journal.Persisted;
import js7.subagent.Subagent;
import js7.subagent.director.SubagentKeeper;
import org.apache.pekko.actor.ActorSystem;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import sourcecode.Name$;

public final class AgentMotor
implements Service,
StoppableByRequest,
Service.StoppableByRequest {
    private AtomicBoolean js7$base$service$Service$$started;
    private Deferred js7$base$service$Service$$stopped;
    private boolean stoppableByCancel;
    private Deferred js7$base$service$StoppableByRequest$$fiber;
    private Deferred js7$base$service$StoppableByRequest$$stopRequested;
    private volatile boolean js7$base$service$StoppableByRequest$$_isStopping;
    private IO js7$base$service$StoppableByRequest$$memoizedStop;
    private final ItemCommandExecutor itemCommandExecutor;
    private final OrderMotor orderMotor;
    private final ControllerId controllerId;
    private final AgentPath agentPath;
    private final SubagentKeeper<AgentState> subagentKeeper;
    private final FileJournal<AgentState> journal;
    private final Ref<IO, AgentCommand.ShutDown> _shutdown;
    private final Ref<IO, Object> _kill;

    public static Resource<IO, AgentMotor> service(Option<SubagentId> option, Subagent.ForDirector forDirector, WorkingClusterNode<AgentState> workingClusterNode, AgentConfiguration agentConfiguration, ActorSystem actorSystem) {
        return AgentMotor$.MODULE$.service(option, forDirector, workingClusterNode, agentConfiguration, actorSystem);
    }

    public AgentMotor(ItemCommandExecutor itemCommandExecutor, OrderMotor orderMotor, ControllerId controllerId, AgentPath agentPath, SubagentKeeper<AgentState> subagentKeeper, FileJournal<AgentState> journal, AgentConfiguration conf) {
        this.itemCommandExecutor = itemCommandExecutor;
        this.orderMotor = orderMotor;
        this.controllerId = controllerId;
        this.agentPath = agentPath;
        this.subagentKeeper = subagentKeeper;
        this.journal = journal;
        Service.$init$(this);
        StoppableByRequest.$init$(this);
        this._shutdown = package$.MODULE$.Ref().unsafe((Object)AgentCommand$ShutDown$.MODULE$.apply(AgentCommand$ShutDown$.MODULE$.$lessinit$greater$default$1(), AgentCommand$ShutDown$.MODULE$.$lessinit$greater$default$2(), AgentCommand$ShutDown$.MODULE$.$lessinit$greater$default$3(), AgentCommand$ShutDown$.MODULE$.$lessinit$greater$default$4(), AgentCommand$ShutDown$.MODULE$.$lessinit$greater$default$5()), (Sync)IO$.MODULE$.asyncForIO());
        this._kill = package$.MODULE$.Ref().unsafe((Object)BoxesRunTime.boxToBoolean((boolean)false), (Sync)IO$.MODULE$.asyncForIO());
        Statics.releaseFence();
    }

    @Override
    public AtomicBoolean js7$base$service$Service$$started() {
        return this.js7$base$service$Service$$started;
    }

    public Deferred js7$base$service$Service$$stopped() {
        return this.js7$base$service$Service$$stopped;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$started_$eq(AtomicBoolean x$0) {
        this.js7$base$service$Service$$started = x$0;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$stopped_$eq(Deferred x$0) {
        this.js7$base$service$Service$$stopped = x$0;
    }

    @Override
    public boolean stoppableByCancel() {
        return this.stoppableByCancel;
    }

    public final Deferred js7$base$service$StoppableByRequest$$fiber() {
        return this.js7$base$service$StoppableByRequest$$fiber;
    }

    public Deferred js7$base$service$StoppableByRequest$$stopRequested() {
        return this.js7$base$service$StoppableByRequest$$stopRequested;
    }

    @Override
    public boolean js7$base$service$StoppableByRequest$$_isStopping() {
        return this.js7$base$service$StoppableByRequest$$_isStopping;
    }

    public IO js7$base$service$StoppableByRequest$$memoizedStop() {
        return this.js7$base$service$StoppableByRequest$$memoizedStop;
    }

    @Override
    public void js7$base$service$StoppableByRequest$$_isStopping_$eq(boolean x$1) {
        this.js7$base$service$StoppableByRequest$$_isStopping = x$1;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$stoppableByCancel_$eq(boolean x$0) {
        this.stoppableByCancel = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$fiber_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$fiber = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$stopRequested_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$stopRequested = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$memoizedStop_$eq(IO x$0) {
        this.js7$base$service$StoppableByRequest$$memoizedStop = x$0;
    }

    public ControllerId controllerId() {
        return this.controllerId;
    }

    public AgentPath agentPath() {
        return this.agentPath;
    }

    @Override
    public IO<Service.Started> start() {
        return this.journal.aggregate().flatMap((Function1 & Serializable)agentState -> this.journal.persist((KeyedEvent)NoKeyEvent$.MODULE$.toKeyedEvent(AgentEvent$AgentReady$.MODULE$.apply(ZoneId.systemDefault().getId(), this.journal.totalRunningTime(), (Option<PlatformInfo>)Some$.MODULE$.apply((Object)PlatformInfos$.MODULE$.currentPlatformInfo())))).map((Function1 & Serializable)_$1 -> {
            Either either = Checked$.MODULE$.Ops(_$1);
            return (Persisted)Checked$Ops$.MODULE$.orThrow$extension(either);
        }).productR(this.orderMotor.recoverOrders((AgentState)agentState)).productR(this.startService(IO$.MODULE$.defer(this::start$$anonfun$1$$anonfun$2))));
    }

    private IO<BoxedUnit> stopMe() {
        return (IO)CatsExtensions$.MODULE$.ifFalse(this._kill.get(), (Function0<Object>)((Function0 & Serializable)this::stopMe$$anonfun$1), IO$.MODULE$.asyncForIO());
    }

    public IO<BoxedUnit> kill() {
        return Logger$package$Logger$syntax$.MODULE$.debugIO(AgentMotor$.js7$agent$motor$AgentMotor$$$logger, ((IO)this._kill.set((Object)BoxesRunTime.boxToBoolean((boolean)true))).$times$greater(this.stop()).$times$greater(this.subagentKeeper.kill()).$times$greater(this.journal.kill()), Name$.MODULE$.apply("kill"));
    }

    public IO<BoxedUnit> shutdown(AgentCommand.ShutDown cmd) {
        return ((IO)this._shutdown.set((Object)cmd)).$times$greater(this.stop());
    }

    public IO<Either<Problem, AgentCommand.Response>> executeCommand(AgentCommand cmd) {
        AgentCommand agentCommand = cmd;
        if (agentCommand instanceof AgentCommand.IsOrderCommand) {
            AgentCommand.IsOrderCommand isOrderCommand;
            AgentCommand.IsOrderCommand cmd2 = isOrderCommand = (AgentCommand.IsOrderCommand)agentCommand;
            return this.orderMotor.executeOrderCommand(cmd2);
        }
        if (agentCommand instanceof AgentCommand.IsItemCommand) {
            AgentCommand.IsItemCommand isItemCommand;
            AgentCommand.IsItemCommand cmd3 = isItemCommand = (AgentCommand.IsItemCommand)agentCommand;
            return this.itemCommandExecutor.executeItemCommand(cmd3);
        }
        if (agentCommand instanceof AgentCommand.ResetSubagent) {
            AgentCommand.ResetSubagent resetSubagent = (AgentCommand.ResetSubagent)agentCommand;
            AgentCommand.ResetSubagent resetSubagent2 = AgentCommand$ResetSubagent$.MODULE$.unapply(resetSubagent);
            SubagentId subagentId = resetSubagent2._1();
            boolean bl = resetSubagent2._2();
            SubagentId subagentId2 = subagentId;
            boolean force = bl;
            IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.subagentKeeper.startResetSubagent(subagentId2, force));
            return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.rightAs$extension((Object)iO, AgentMotor::executeCommand$$anonfun$1, IO$.MODULE$.asyncForIO());
        }
        return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> AgentMotor.executeCommand$$anonfun$2(cmd)), Problem$.MODULE$.apply$default$2()));
    }

    public IO<BoxedUnit> resetAllSubagents() {
        return this.journal.aggregate().flatMap((Function1 & Serializable)agentState -> this.subagentKeeper.resetAllSubagents((Set<SubagentId>)agentState.meta().directors().toSet()));
    }

    public String toString() {
        return "AgentMotor";
    }

    private final IO start$$anonfun$1$$anonfun$2() {
        block0: {
            Logger LoggerImpl_this = AgentMotor$.js7$agent$motor$AgentMotor$$$logger;
            if (!LoggerImpl_this.underlying().isInfoEnabled()) break block0;
            LoggerImpl_this.underlying().info(this.agentPath() + " is ready\n" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\u2500"), 80));
        }
        return this.untilStopRequested().$times$greater(this.stopMe());
    }

    private final IO stopMe$$anonfun$1$$anonfun$1$$anonfun$1(AgentCommand.ShutDown shutdown$1) {
        return this.subagentKeeper.shutdownLocalSubagent(shutdown$1.processSignal());
    }

    private final IO stopMe$$anonfun$1$$anonfun$1$$anonfun$2() {
        IO iO = (IO)Checked$.MODULE$.RichCheckedF(this.journal.persist((KeyedEvent)NoKeyEvent$.MODULE$.toKeyedEvent(AgentEvent$AgentShutDown$.MODULE$)));
        return ((IO)Checked$RichCheckedF$.MODULE$.handleProblem$extension(iO, (JProcedure1 & Serializable)problem -> {
            Logger LoggerImpl_this = AgentMotor$.js7$agent$motor$AgentMotor$$$logger;
            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                LoggerImpl_this.underlying().error("AgentShutDown: {}", problem);
                return;
            }
        }, IO$.MODULE$.asyncForIO())).void();
    }

    private final IO stopMe$$anonfun$1() {
        return ((IO)this._shutdown.get()).flatMap((Function1 & Serializable)shutdown -> IO$.MODULE$.unlessA(shutdown.restartDirector(), () -> this.stopMe$$anonfun$1$$anonfun$1$$anonfun$1(shutdown)).productR(this.orderMotor.stop()).productR(IO$.MODULE$.unlessA(shutdown.isFailOrSwitchover(), this::stopMe$$anonfun$1$$anonfun$1$$anonfun$2)));
    }

    private static final AgentCommand$Response$Accepted$ executeCommand$$anonfun$1() {
        return AgentCommand$Response$Accepted$.MODULE$;
    }

    private static final String executeCommand$$anonfun$2(AgentCommand cmd$1) {
        ScalaUtils.syntax.RichJavaClass<?> RichJavaClass_this = ScalaUtils$syntax$.MODULE$.RichJavaClass(cmd$1.getClass());
        return "Unknown command: " + RichJavaClass_this.cachedSimpleScalaName();
    }
}

