/*
 * Decompiled with CFR 0.152.
 */
package js7.agent.motor;

import cats.FlatMap;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.Fiber;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Resource;
import cats.effect.std.Dispatcher;
import cats.kernel.Monoid;
import cats.kernel.Semigroup$;
import cats.syntax.FlatMapIdOps$;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.concurrent.Signal;
import fs2.concurrent.SignallingRef;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import js7.agent.data.AgentState;
import js7.agent.motor.JobMotor$;
import js7.agent.motor.JobMotor$OrderWithEndOfAdmission$;
import js7.agent.motor.JobOrderQueue;
import js7.agent.motor.OrderMotor;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.catsutils.CatsEffectUtils$;
import js7.base.fs2utils.StreamExtensions$;
import js7.base.log.Logger$package$Logger$;
import js7.base.metering.CallMeter;
import js7.base.metering.CallMeterMacros$;
import js7.base.monixutils.SimpleLock;
import js7.base.problem.Problem;
import js7.base.problem.Problems;
import js7.base.problem.Problems$UnknownKeyProblem$;
import js7.base.scalasource.ScalaSourceLocation$;
import js7.base.service.Problems$ServiceStoppedProblem$;
import js7.base.service.Service;
import js7.base.service.StoppableByRequest;
import js7.base.time.AlarmClock;
import js7.base.time.TimeInterval;
import js7.base.time.Timestamp;
import js7.base.time.WallClock;
import js7.base.utils.Assertions$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.data.job.JobKey;
import js7.data.order.Order;
import js7.data.order.OrderEvent;
import js7.data.order.OrderId;
import js7.data.workflow.instructions.executable.WorkflowJob;
import js7.subagent.director.SubagentKeeper;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ReusableBuilder;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.hashing.MurmurHash3$;
import sourcecode.Enclosing$;
import sourcecode.FileName$;
import sourcecode.FullName$;
import sourcecode.Line$;
import sourcecode.Text;
import sourcecode.Text$;

public final class JobMotor
implements Service,
StoppableByRequest,
Service.StoppableByRequest {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(JobMotor.class.getDeclaredField("dequeueChunk2$lzy1"));
    private AtomicBoolean js7$base$service$Service$$started;
    private Deferred js7$base$service$Service$$stopped;
    private boolean stoppableByCancel;
    private Deferred js7$base$service$StoppableByRequest$$fiber;
    private Deferred js7$base$service$StoppableByRequest$$stopRequested;
    private volatile boolean js7$base$service$StoppableByRequest$$_isStopping;
    private IO js7$base$service$StoppableByRequest$$memoizedStop;
    private final JobKey jobKey;
    private final WorkflowJob workflowJob;
    private final IO<AgentState> getAgentState;
    private final OrderMotor orderMotor;
    private final SubagentKeeper<AgentState> subagentKeeper;
    private final SignallingRef<IO, Function0<String>> queueSignal;
    private final Signal<IO, Option<TimeInterval>> admissionSignal;
    private final WallClock clock;
    private final Logger logger;
    private final SimpleLock<IO> processCountLock;
    private final AtomicInteger processCount;
    private final JobOrderQueue queue;
    private final IO<Chunk<OrderWithEndOfAdmission>> dequeueChunk;
    private volatile Object dequeueChunk2$lzy1;

    public static Resource<IO, JobMotor> service(JobKey jobKey, WorkflowJob workflowJob, IO<AgentState> iO, OrderMotor orderMotor, SubagentKeeper<AgentState> subagentKeeper, ZoneId zoneId, FiniteDuration finiteDuration, AlarmClock alarmClock, Dispatcher<IO> dispatcher) {
        return JobMotor$.MODULE$.service(jobKey, workflowJob, iO, orderMotor, subagentKeeper, zoneId, finiteDuration, alarmClock, dispatcher);
    }

    public JobMotor(JobKey jobKey, WorkflowJob workflowJob, IO<AgentState> getAgentState, OrderMotor orderMotor, SubagentKeeper<AgentState> subagentKeeper, SignallingRef<IO, Function0<String>> queueSignal, Signal<IO, Option<TimeInterval>> admissionSignal, WallClock clock) {
        this.jobKey = jobKey;
        this.workflowJob = workflowJob;
        this.getAgentState = getAgentState;
        this.orderMotor = orderMotor;
        this.subagentKeeper = subagentKeeper;
        this.queueSignal = queueSignal;
        this.admissionSignal = admissionSignal;
        this.clock = clock;
        Service.$init$(this);
        StoppableByRequest.$init$(this);
        this.logger = Logger$package$Logger$.MODULE$.withPrefix(jobKey.toString(), ClassTag$.MODULE$.apply(JobMotor.class));
        this.processCountLock = new SimpleLock(IO$.MODULE$.asyncForIO());
        this.processCount = new AtomicInteger(0);
        this.queue = new JobOrderQueue();
        this.dequeueChunk = IO$.MODULE$.defer(this::$init$$$anonfun$1);
        Statics.releaseFence();
    }

    @Override
    public AtomicBoolean js7$base$service$Service$$started() {
        return this.js7$base$service$Service$$started;
    }

    public Deferred js7$base$service$Service$$stopped() {
        return this.js7$base$service$Service$$stopped;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$started_$eq(AtomicBoolean x$0) {
        this.js7$base$service$Service$$started = x$0;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$stopped_$eq(Deferred x$0) {
        this.js7$base$service$Service$$stopped = x$0;
    }

    @Override
    public boolean stoppableByCancel() {
        return this.stoppableByCancel;
    }

    public final Deferred js7$base$service$StoppableByRequest$$fiber() {
        return this.js7$base$service$StoppableByRequest$$fiber;
    }

    public Deferred js7$base$service$StoppableByRequest$$stopRequested() {
        return this.js7$base$service$StoppableByRequest$$stopRequested;
    }

    @Override
    public boolean js7$base$service$StoppableByRequest$$_isStopping() {
        return this.js7$base$service$StoppableByRequest$$_isStopping;
    }

    public IO js7$base$service$StoppableByRequest$$memoizedStop() {
        return this.js7$base$service$StoppableByRequest$$memoizedStop;
    }

    @Override
    public void js7$base$service$StoppableByRequest$$_isStopping_$eq(boolean x$1) {
        this.js7$base$service$StoppableByRequest$$_isStopping = x$1;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$stoppableByCancel_$eq(boolean x$0) {
        this.stoppableByCancel = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$fiber_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$fiber = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$stopRequested_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$stopRequested = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$memoizedStop_$eq(IO x$0) {
        this.js7$base$service$StoppableByRequest$$memoizedStop = x$0;
    }

    public JobKey jobKey() {
        return this.jobKey;
    }

    @Override
    public IO<Service.Started> start() {
        return this.startService(((IO)this.pipeline().compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain()).$times$greater(IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.start$$anonfun$1();
            return BoxedUnit.UNIT;
        })));
    }

    public IO<Seq<Tuple2<OrderId, Either<Problem, Fiber<IO, Throwable, OrderEvent.OrderProcessed>>>>> recoverProcessingOrders(Vector<Order<Order.Processing>> orders) {
        return IO$.MODULE$.defer(() -> this.recoverProcessingOrders$$anonfun$1(orders));
    }

    public IO<BoxedUnit> enqueue(Seq<Order<Order.IsFreshOrReady>> orders) {
        return IO$.MODULE$.whenA(orders.nonEmpty(), () -> this.enqueue$$anonfun$1(orders));
    }

    public IO<BoxedUnit> trigger(Function0<Object> reason) {
        return (IO)CatsEffectUtils$.MODULE$.unlessDeferred((Function0<Object>)((Function0 & Serializable)this::trigger$$anonfun$1), (Function0<Object>)((Function0 & Serializable)() -> this.trigger$$anonfun$2(reason)), IO$.MODULE$.asyncForIO());
    }

    public IO<Object> remove(OrderId orderId, String unnecessary) {
        return this.queue.lockForRemoval((Function1 & Serializable)contextual$1 -> this.queue.remove(orderId, (JobOrderQueue.LockedForRemoval)contextual$1)).flatTap((Function1 & Serializable)_$2 -> this.remove$$anonfun$2(unnecessary, orderId, BoxesRunTime.unboxToBoolean((Object)_$2)));
    }

    public String remove$default$2() {
        return "";
    }

    private Stream<IO, BoxedUnit> pipeline() {
        return StreamExtensions$.MODULE$.interruptWhenF(this.queueSignal.discrete().merge(this.admissionSignal.discrete().map((Function1 & Serializable)o -> (Function0 & Serializable)() -> "Admission " + o), (GenConcurrent)IO$.MODULE$.asyncForIO()).evalMap((Function1 & Serializable)signalReason -> this.dequeueChunk.map((Function1 & Serializable)_$3 -> {
            Function0 function0 = (Function0)Predef$.MODULE$.ArrowAssoc(signalReason);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)function0, _$3);
        })).filter((Function1 & Serializable)x$1 -> {
            Function0 function0 = (Function0)x$1._1();
            Chunk chunk = (Chunk)x$1._2();
            if (chunk.nonEmpty()) return true;
            Logger LoggerImpl_this = this.logger;
            if (LoggerImpl_this.underlying().isTraceEnabled()) {
                LoggerImpl_this.underlying().trace("\ud83e\udeb1 pipeline: No Order is processable despite signal \"{}\"", function0.apply());
            }
            if (!BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.locally((Object)BoxesRunTime.boxToBoolean((boolean)false)))) return false;
            return true;
        }).map((Function1 & Serializable)_$4 -> (Chunk)_$4._2()).unchunks((.less.colon.less)$less$colon$less$.MODULE$.refl()).evalMap((Function1 & Serializable)o -> CatsEffectExtensions$.MODULE$.startAndForget(this.startOrderProcess((OrderWithEndOfAdmission)o), Enclosing$.MODULE$.apply("js7.agent.motor.JobMotor#pipeline"))), this.untilStopRequested(), IO$.MODULE$.asyncForIO());
    }

    private IO<Chunk<OrderWithEndOfAdmission>> dequeueChunk2() {
        Object object = this.dequeueChunk2$lzy1;
        if (object instanceof IO) {
            return (IO)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (IO)this.dequeueChunk2$lzyINIT1();
    }

    private Object dequeueChunk2$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.dequeueChunk2$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    IO iO = null;
                    try {
                        iO = this.queue.lockForRemoval((Function1 & Serializable)contextual$2 -> {
                            CallMeter CallMeter_this = JobMotor$.js7$agent$motor$JobMotor$$$meterDequeue;
                            return CallMeterMacros$.MODULE$.inline$meterIO$i1(CallMeter_this, this.currentAdmissionTimeInterval().flatMap((Function1 & Serializable)maybeTimeInterval -> {
                                None$ none$;
                                Some some;
                                TimeInterval timeInterval;
                                Option option = maybeTimeInterval;
                                if (option instanceof Some && (timeInterval = (TimeInterval)(some = (Some)option).value()) instanceof TimeInterval.Standard) {
                                    TimeInterval.Standard standard;
                                    TimeInterval.Standard o = standard = (TimeInterval.Standard)timeInterval;
                                    none$ = Some$.MODULE$.apply((Object)o.end());
                                } else {
                                    none$ = None$.MODULE$;
                                }
                                None$ endOfAdmission = none$;
                                boolean onlyForcedAdmission = maybeTimeInterval.isEmpty();
                                ReusableBuilder reusableBuilder = (ReusableBuilder)package.flatMap$.MODULE$.catsSyntaxFlatMapIdOps((Object)package$.MODULE$.Vector().newBuilder());
                                return ((IO)FlatMapIdOps$.MODULE$.tailRecM$extension((Object)reusableBuilder, arg_0 -> this.dequeueChunk2$lzyINIT1$$anonfun$1$$anonfun$1$$anonfun$1(onlyForcedAdmission, contextual$2, (Option)endOfAdmission, arg_0), (FlatMap)IO$.MODULE$.asyncForIO())).map((Function1 & Serializable)builder -> Chunk$.MODULE$.from((Iterable)builder.result()));
                            }));
                        }).uncancelable();
                        object2 = iO == null ? LazyVals.NullValue$.MODULE$ : iO;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.dequeueChunk2$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return iO;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private IO<Option<TimeInterval>> currentAdmissionTimeInterval() {
        return this.clock.nowIO().flatMap((Function1 & Serializable)now -> ((IO)this.admissionSignal.get()).map((Function1 & Serializable)_$5 -> _$5.filter((Function1 & Serializable)_$6 -> _$6.contains((Timestamp)now))));
    }

    private IO<BoxedUnit> startOrderProcess(OrderWithEndOfAdmission orderWithEndOfAdmission) {
        return CatsEffectExtensions$.MODULE$.catchIntoChecked(this.subagentKeeper.processOrder(orderWithEndOfAdmission.order(), orderWithEndOfAdmission.endOfAdmission())).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Right right = (Right)either;
                Option option = (Option)right.value();
                if (None$.MODULE$.equals(option)) {
                    return this.decrementProcessCount(orderWithEndOfAdmission.order().id(), orderWithEndOfAdmission.order().id() + " is not processable", this.decrementProcessCount$default$3());
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Order order = (Order)some.value();
                    return IO$.MODULE$.unlessA(order.isState(ClassTag$.MODULE$.apply(Order.Processing.class)), () -> this.startOrderProcess$$anonfun$1$$anonfun$1(order));
                }
            }
            if (either instanceof Left) {
                Left left = (Left)either;
                Problem problem = (Problem)left.value();
                return this.handleFailedProcessStart(orderWithEndOfAdmission.order(), problem);
            }
            throw new MatchError((Object)either);
        });
    }

    private IO<BoxedUnit> handleFailedProcessStart(Order<Order.IsFreshOrReady> order, Problem problem) {
        return this.getAgentState.flatMap((Function1 & Serializable)agentState -> {
            Option option = agentState.idToOrder().get((Object)order.id());
            if (None$.MODULE$.equals(option)) {
                Logger LoggerImpl_this;
                Logger LoggerImpl_this2 = this.logger;
                if (LoggerImpl_this2.underlying().isWarnEnabled()) {
                    LoggerImpl_this2.underlying().warn("subagentKeeper.processOrder: " + order.id() + " has been removed concurrently", (Object)problem.throwableIfStackTrace());
                }
                Problem problem = problem;
                Problems.UnknownKeyProblem unknownKeyProblem = Problems$UnknownKeyProblem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)JobMotor::handleFailedProcessStart$$anonfun$1$$anonfun$1), order.id(), FileName$.MODULE$.apply("JobMotor.scala"), Line$.MODULE$.apply(166));
                if ((problem == null ? unknownKeyProblem != null : !((Object)problem).equals(unknownKeyProblem)) && (LoggerImpl_this = this.logger).underlying().isWarnEnabled()) {
                    LoggerImpl_this.underlying().warn(this.msg$1(order, problem));
                }
                return IO$.MODULE$.unit();
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                Order current = (Order)some.value();
                Order order = order;
                Order order2 = current;
                if (!(order != null ? !((Object)order).equals(order2) : order2 != null)) {
                    Logger LoggerImpl_this = this.logger;
                    if (LoggerImpl_this.underlying().isWarnEnabled()) {
                        LoggerImpl_this.underlying().warn(this.msg$1(order, problem), (Object)problem.throwableIfStackTrace());
                    }
                    return this.decrementProcessCount(order.id(), "\u26a0\ufe0f  processOrder failed", this.decrementProcessCount$default$3());
                }
                return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                    this.handleFailedProcessStart$$anonfun$1$$anonfun$2(problem, order, current);
                    return BoxedUnit.UNIT;
                });
            }
            throw new MatchError((Object)option);
        });
    }

    public IO<BoxedUnit> onOrdersProcessed(Iterable<OrderId> orderIds) {
        return (IO)ScalaUtils$syntax$.MODULE$.foldMap(orderIds, (Function1 & Serializable)orderId -> this.remove((OrderId)orderId, "\ud83e\udeb1").$times$greater(this.decrementProcessCount((OrderId)orderId, "OrderProcessed", this.decrementProcessCount$default$3())), IO$.MODULE$.monoidForIO((Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit()));
    }

    private IO<Object> tryIncrementProcessCount() {
        return this.processCountLock.surround(IO$.MODULE$.apply(this::tryIncrementProcessCount$$anonfun$1));
    }

    private IO<BoxedUnit> decrementProcessCount(OrderId orderId, String reason, String unnecessary) {
        return this.processCountLock.surround(IO$.MODULE$.defer(() -> this.decrementProcessCount$$anonfun$1(reason, unnecessary, orderId)));
    }

    private String decrementProcessCount$default$3() {
        return "";
    }

    public int orderQueueLength() {
        return this.queue.length();
    }

    public String toString() {
        return "JobMotor(" + this.jobKey() + ")";
    }

    private final IO $init$$$anonfun$1() {
        if (this.queue.isEmptyUnsafe()) {
            return JobMotor$.js7$agent$motor$JobMotor$$$emptyChunk;
        }
        return this.dequeueChunk2();
    }

    private final void start$$anonfun$1() {
        int n = this.processCount.get();
        if (n > 0) {
            Logger LoggerImpl_this = this.logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("\u2757\ufe0fprocessCount={} when stopping", (Object)BoxesRunTime.boxToInteger((int)n));
                return;
            }
            return;
        }
    }

    private final IO recoverProcessingOrders$$anonfun$1(Vector orders$1) {
        int n$proxy1 = orders$1.size();
        this.processCount.getAndAdd(n$proxy1);
        return this.subagentKeeper.recoverProcessingOrders((Seq<Order<Order.Processing>>)orders$1);
    }

    private final IO enqueue$$anonfun$1(Seq orders$2) {
        return this.queue.enqueue((Seq<Order<Order.IsFreshOrReady>>)orders$2).$times$greater((IO)this.queueSignal.set((Function0 & Serializable)() -> ((IterableOnceOps)orders$2.map((Function1 & Serializable)_$1 -> _$1.id())).mkString(" ")));
    }

    private final boolean trigger$$anonfun$1() {
        return this.queue.isEmptyUnsafe();
    }

    private static final String reason_$lzyINIT1$1(LazyRef reason_$lzy1$1, Function0 reason$1) {
        String string;
        LazyRef lazyRef = reason_$lzy1$1;
        synchronized (lazyRef) {
            string = (String)(reason_$lzy1$1.initialized() ? reason_$lzy1$1.value() : reason_$lzy1$1.initialize((Object)reason$1.apply().toString()));
        }
        return string;
    }

    private static final String reason_$1(LazyRef reason_$lzy1$2, Function0 reason$3) {
        return (String)(reason_$lzy1$2.initialized() ? reason_$lzy1$2.value() : JobMotor.reason_$lzyINIT1$1(reason_$lzy1$2, reason$3));
    }

    private final IO trigger$$anonfun$2(Function0 reason$2) {
        LazyRef lazyRef;
        block0: {
            lazyRef = new LazyRef();
            Logger LoggerImpl_this = this.logger;
            if (!LoggerImpl_this.underlying().isTraceEnabled()) break block0;
            LoggerImpl_this.underlying().trace("trigger({})", (Object)JobMotor.reason_$1(lazyRef, reason$2));
        }
        return (IO)this.queueSignal.set((Function0 & Serializable)() -> JobMotor.reason_$1(lazyRef, reason$2));
    }

    private final void remove$$anonfun$2$$anonfun$1$$anonfun$1(String unnecessary$3, OrderId orderId$4) {
        Logger LoggerImpl_this = this.logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("{}{} removed from queue", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{unnecessary$3, orderId$4}), Object.class));
            return;
        }
    }

    private final IO remove$$anonfun$2$$anonfun$1(String unnecessary$2, OrderId orderId$3) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.remove$$anonfun$2$$anonfun$1$$anonfun$1(unnecessary$2, orderId$3);
            return BoxedUnit.UNIT;
        });
    }

    private final /* synthetic */ IO remove$$anonfun$2(String unnecessary$1, OrderId orderId$2, boolean _$2) {
        return IO$.MODULE$.whenA(_$2, () -> this.remove$$anonfun$2$$anonfun$1(unnecessary$1, orderId$2));
    }

    private final /* synthetic */ Either dequeueChunk2$lzyINIT1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(boolean onlyForcedAdmission$2, JobOrderQueue.LockedForRemoval contextual$2$3, ReusableBuilder builder$1, Option endOfAdmission$3, boolean ok) {
        if (ok) {
            Order<Order.IsFreshOrReady> order = this.queue.dequeueNextOrder(onlyForcedAdmission$2, contextual$2$3);
            return package$.MODULE$.Left().apply((Object)builder$1.$plus$eq((Object)JobMotor$OrderWithEndOfAdmission$.MODULE$.apply(order, (Option<Timestamp>)endOfAdmission$3)));
        }
        return package$.MODULE$.Right().apply((Object)builder$1);
    }

    private final /* synthetic */ IO dequeueChunk2$lzyINIT1$$anonfun$1$$anonfun$1$$anonfun$1(boolean onlyForcedAdmission$1, JobOrderQueue.LockedForRemoval contextual$2$1, Option endOfAdmission$2, ReusableBuilder builder) {
        if (this.queue.isEmpty(onlyForcedAdmission$1, contextual$2$1)) {
            return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, builder);
        }
        return this.tryIncrementProcessCount().map((Function1 & Serializable)ok -> this.dequeueChunk2$lzyINIT1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(onlyForcedAdmission$1, contextual$2$1, builder, endOfAdmission$2, BoxesRunTime.unboxToBoolean((Object)ok)));
    }

    private final IO startOrderProcess$$anonfun$1$$anonfun$1(Order order$2) {
        block0: {
            Logger LoggerImpl_this = this.logger;
            if (!LoggerImpl_this.underlying().isTraceEnabled()) break block0;
            LoggerImpl_this.underlying().trace("subagentKeeper.processOrder: {} status is not Processing, decrementing processCount", (Object)order$2.id());
        }
        return this.decrementProcessCount(order$2.id(), "Order's status is not Processing but " + order$2.workflowPosition() + " " + order$2.state(), "\ud83e\udeb1");
    }

    private final String msg$1(Order order$4, Problem problem$2) {
        return "subagentKeeper.processOrder(" + order$4.id() + ") " + this.jobKey() + ": " + problem$2 + " \u2022 " + order$4;
    }

    private static final String handleFailedProcessStart$$anonfun$1$$anonfun$1() {
        return "OrderId";
    }

    private final void handleFailedProcessStart$$anonfun$1$$anonfun$2(Problem problem$3, Order order$5, Order current$1) {
        if (!problem$3.is(Problems$ServiceStoppedProblem$.MODULE$)) {
            Logger LoggerImpl_this;
            Logger LoggerImpl_this2;
            Logger LoggerImpl_this3 = this.logger;
            if (LoggerImpl_this3.underlying().isWarnEnabled()) {
                LoggerImpl_this3.underlying().warn(this.msg$1(order$5, problem$3), (Object)problem$3.throwableIfStackTrace());
            }
            if ((LoggerImpl_this2 = this.logger).underlying().isWarnEnabled()) {
                LoggerImpl_this2.underlying().warn("{} has been changed concurrently, failed  : {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{order$5.id(), order$5}), Object.class));
            }
            if ((LoggerImpl_this = this.logger).underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("{} has been changed concurrently, existing: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{order$5.id(), current$1}), Object.class));
                return;
            }
            return;
        }
    }

    private final boolean tryIncrementProcessCount$$anonfun$1() {
        return this.orderMotor.jobMotorKeeper().processLimits().tryIncrementProcessCount(this.processCount, this.workflowJob.processLimit());
    }

    private static final boolean v$proxy1$1(int n$1) {
        return n$1 >= 0;
    }

    private static final String decrementProcessCount$$anonfun$1$$anonfun$1(int n$2) {
        return "processCount=" + n$2 + " is below zero";
    }

    private final Object decrementProcessCount$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(int n$5) {
        return "processCount=" + n$5 + " is below Job's processLimit=" + this.workflowJob.processLimit();
    }

    private final IO decrementProcessCount$$anonfun$1$$anonfun$2$$anonfun$1(int n$4) {
        return this.trigger((Function0<Object>)((Function0 & Serializable)() -> this.decrementProcessCount$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(n$4)));
    }

    private final /* synthetic */ IO decrementProcessCount$$anonfun$1$$anonfun$2(int n$3, boolean triggered) {
        return IO$.MODULE$.whenA(!triggered && n$3 == this.workflowJob.processLimit() - 1, () -> this.decrementProcessCount$$anonfun$1$$anonfun$2$$anonfun$1(n$3));
    }

    private final IO decrementProcessCount$$anonfun$1(String reason$4, String unnecessary$4, OrderId orderId$5) {
        Logger LoggerImpl_this;
        String string = reason$4;
        String string2 = "OrderProcessed";
        if ((string == null ? string2 != null : !string.equals(string2)) && (LoggerImpl_this = this.logger).underlying().isTraceEnabled()) {
            LoggerImpl_this.underlying().trace("{}decrementProcessCount: processCount={} {} ({})", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{unnecessary$4, this.processCount, orderId$5, reason$4}), Object.class));
        }
        int n = this.processCount.decrementAndGet();
        Assertions$.MODULE$.assertIfStrict((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)JobMotor.v$proxy1$1(n)), "n >= 0"), (Function0<String>)((Function0 & Serializable)() -> JobMotor.decrementProcessCount$$anonfun$1$$anonfun$1(n)), FullName$.MODULE$.apply("js7.agent.motor.JobMotor.decrementProcessCount"), ScalaSourceLocation$.MODULE$.apply("JobMotor.scala", 203));
        return this.orderMotor.jobMotorKeeper().processLimits().decrementProcessCount().flatMap((Function1 & Serializable)triggered -> this.decrementProcessCount$$anonfun$1$$anonfun$2(n, BoxesRunTime.unboxToBoolean((Object)triggered)));
    }

    public static final class OrderWithEndOfAdmission
    implements Product,
    Serializable {
        private final Order<Order.IsFreshOrReady> order;
        private final Option<Timestamp> endOfAdmission;

        public static OrderWithEndOfAdmission apply(Order<Order.IsFreshOrReady> order, Option<Timestamp> option) {
            return JobMotor$OrderWithEndOfAdmission$.MODULE$.apply(order, option);
        }

        public static OrderWithEndOfAdmission fromProduct(Product product) {
            return JobMotor$OrderWithEndOfAdmission$.MODULE$.fromProduct(product);
        }

        public static OrderWithEndOfAdmission unapply(OrderWithEndOfAdmission orderWithEndOfAdmission) {
            return JobMotor$OrderWithEndOfAdmission$.MODULE$.unapply(orderWithEndOfAdmission);
        }

        public OrderWithEndOfAdmission(Order<Order.IsFreshOrReady> order, Option<Timestamp> endOfAdmission) {
            this.order = order;
            this.endOfAdmission = endOfAdmission;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -1601667428, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            OrderWithEndOfAdmission orderWithEndOfAdmission;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof OrderWithEndOfAdmission)) return false;
            OrderWithEndOfAdmission orderWithEndOfAdmission2 = orderWithEndOfAdmission = (OrderWithEndOfAdmission)object;
            Order<Order.IsFreshOrReady> order = this.order();
            Order<Order.IsFreshOrReady> order2 = orderWithEndOfAdmission2.order();
            if (order == null) {
                if (order2 != null) {
                    return false;
                }
            } else if (!((Object)order).equals(order2)) return false;
            Option<Timestamp> option = this.endOfAdmission();
            Option<Timestamp> option2 = orderWithEndOfAdmission2.endOfAdmission();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof OrderWithEndOfAdmission;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "OrderWithEndOfAdmission";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "order";
            }
            if (1 == n2) {
                return "endOfAdmission";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Order<Order.IsFreshOrReady> order() {
            return this.order;
        }

        public Option<Timestamp> endOfAdmission() {
            return this.endOfAdmission;
        }

        public String toString() {
            return "OrderWithEndOfAdmission(" + this.order().id() + ", " + this.endOfAdmission() + ")";
        }

        public OrderWithEndOfAdmission copy(Order<Order.IsFreshOrReady> order, Option<Timestamp> endOfAdmission) {
            return new OrderWithEndOfAdmission(order, endOfAdmission);
        }

        public Order<Order.IsFreshOrReady> copy$default$1() {
            return this.order();
        }

        public Option<Timestamp> copy$default$2() {
            return this.endOfAdmission();
        }

        public Order<Order.IsFreshOrReady> _1() {
            return this.order();
        }

        public Option<Timestamp> _2() {
            return this.endOfAdmission();
        }
    }
}

