/*
 * Decompiled with CFR 0.152.
 */
package js7.base.auth;

import cats.Applicative;
import cats.Invariant$;
import cats.Traverse;
import cats.instances.package;
import cats.syntax.package;
import java.io.Serializable;
import js7.base.auth.HashedPassword;
import js7.base.auth.Permission;
import js7.base.auth.SuperPermission$;
import js7.base.auth.User$UserDoesNotHavePermissionProblem$;
import js7.base.auth.UserId;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.base.problem.ProblemCode;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;

public interface User {
    public UserId id();

    public HashedPassword hashedPassword();

    public Set<Permission> grantedPermissions();

    public static Either checkPermissions$(User $this, Seq requiredPermissions) {
        return $this.checkPermissions((Seq<Permission>)requiredPermissions);
    }

    default public Either<Problem, BoxedUnit> checkPermissions(Seq<Permission> requiredPermissions) {
        return this.checkPermissions((Set<Permission>)requiredPermissions.toSet());
    }

    public static Either checkPermissions$(User $this, Set requiredPermissions) {
        return $this.checkPermissions((Set<Permission>)requiredPermissions);
    }

    default public Either<Problem, BoxedUnit> checkPermissions(Set<Permission> requiredPermissions) {
        return ((Either)package.traverse$.MODULE$.toTraverseOps((Object)requiredPermissions.toVector(), (Traverse)package.vector$.MODULE$.catsStdInstancesForVector()).traverse((Function1 & Serializable)requiredPermission -> this.checkPermission((Permission)requiredPermission), (Applicative)Invariant$.MODULE$.catsMonadErrorForEither())).map((Function1)(JProcedure1 & Serializable)_$1 -> {});
    }

    public static Either checkPermission$(User $this, Permission requiredPermission) {
        return $this.checkPermission(requiredPermission);
    }

    default public Either<Problem, BoxedUnit> checkPermission(Permission requiredPermission) {
        if (!this.hasPermission(requiredPermission)) {
            return package$.MODULE$.Left().apply((Object)User$UserDoesNotHavePermissionProblem$.MODULE$.apply(this.id(), requiredPermission));
        }
        return Checked$.MODULE$.unit();
    }

    public static boolean hasPermissions$(User $this, Set requiredPermissions) {
        return $this.hasPermissions((Set<Permission>)requiredPermissions);
    }

    default public boolean hasPermissions(Set<Permission> requiredPermissions) {
        return requiredPermissions.forall((Function1 & Serializable)requiredPermission -> this.hasPermission((Permission)requiredPermission));
    }

    public static boolean hasPermission$(User $this, Permission requiredPermission) {
        return $this.hasPermission(requiredPermission);
    }

    default public boolean hasPermission(Permission requiredPermission) {
        return this.grantedPermissions().contains((Object)requiredPermission) || this.grantedPermissions().contains((Object)SuperPermission$.MODULE$);
    }

    public static boolean isAnonymous$(User $this) {
        return $this.isAnonymous();
    }

    default public boolean isAnonymous() {
        return this.id().isAnonymous();
    }

    public static interface Companion<U extends User> {
        public U addPermissions(U var1, Set<Permission> var2);
    }

    public static final class UserDoesNotHavePermissionProblem
    implements Problem,
    Problem.Simple,
    Problem.HasCode,
    Problem.Coded,
    Product,
    Serializable {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(UserDoesNotHavePermissionProblem.class.getDeclaredField("message$lzy1"));
        private volatile Object message$lzy1;
        private ProblemCode code;
        private final UserId userId;
        private final Permission permission;

        public static UserDoesNotHavePermissionProblem apply(UserId userId, Permission permission) {
            return User$UserDoesNotHavePermissionProblem$.MODULE$.apply(userId, permission);
        }

        public static UserDoesNotHavePermissionProblem fromProduct(Product product) {
            return User$UserDoesNotHavePermissionProblem$.MODULE$.fromProduct(product);
        }

        public static UserDoesNotHavePermissionProblem unapply(UserDoesNotHavePermissionProblem userDoesNotHavePermissionProblem) {
            return User$UserDoesNotHavePermissionProblem$.MODULE$.unapply(userDoesNotHavePermissionProblem);
        }

        public UserDoesNotHavePermissionProblem(UserId userId, Permission permission) {
            this.userId = userId;
            this.permission = permission;
            Problem.Simple.$init$(this);
            Problem.Coded.$init$(this);
            Statics.releaseFence();
        }

        @Override
        public final String message() {
            Object object = this.message$lzy1;
            if (object instanceof String) {
                return (String)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (String)this.message$lzyINIT1();
        }

        private Object message$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.message$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        String string = null;
                        try {
                            string = Problem.Simple.message$(this);
                            object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.message$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return string;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public ProblemCode code() {
            return this.code;
        }

        @Override
        public void js7$base$problem$Problem$Coded$_setter_$code_$eq(ProblemCode x$0) {
            this.code = x$0;
        }

        public boolean canEqual(Object that) {
            return that instanceof UserDoesNotHavePermissionProblem;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "UserDoesNotHavePermissionProblem";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "userId";
            }
            if (1 == n2) {
                return "permission";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public UserId userId() {
            return this.userId;
        }

        public Permission permission() {
            return this.permission;
        }

        @Override
        public Map<String, String> arguments() {
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"userId");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.userId().string());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"permission");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.permission().name());
            return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }

        public UserDoesNotHavePermissionProblem copy(UserId userId, Permission permission) {
            return new UserDoesNotHavePermissionProblem(userId, permission);
        }

        public UserId copy$default$1() {
            return this.userId();
        }

        public Permission copy$default$2() {
            return this.permission();
        }

        public UserId _1() {
            return this.userId();
        }

        public Permission _2() {
            return this.permission();
        }
    }
}

