/*
 * Decompiled with CFR 0.152.
 */
package js7.base.crypt.generic;

import cats.Applicative;
import cats.Traverse;
import cats.instances.package;
import cats.syntax.package;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.stream.Stream;
import js7.base.Problems$UnknownSignatureTypeProblem$;
import js7.base.crypt.GenericSignature;
import js7.base.crypt.SignatureVerifier;
import js7.base.crypt.generic.GenericSignatureVerifier;
import js7.base.crypt.generic.GenericSignatureVerifier$ConfigStringExpectedProblem$;
import js7.base.crypt.generic.SignatureServices$;
import js7.base.data.ByteArray;
import js7.base.io.file.FileUtils$syntax$;
import js7.base.io.file.FileUtils$syntax$RichPath$;
import js7.base.log.Logger$package$Logger$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.utils.AutoClosing$;
import js7.base.utils.JavaCollections$syntax$;
import js7.base.utils.JavaCollections$syntax$JavaStreamToScala$;
import js7.base.utils.Labeled;
import js7.base.utils.ScalaUtils$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichPartialFunction$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.NotImplementedError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class GenericSignatureVerifier$
implements SignatureVerifier.Companion,
Serializable {
    private static final String configPath;
    private static final Logger logger;
    private static final GenericSignatureVerifier$ConfigStringExpectedProblem$ ConfigStringExpectedProblem;
    public static final GenericSignatureVerifier$ MODULE$;

    private GenericSignatureVerifier$() {
    }

    static {
        MODULE$ = new GenericSignatureVerifier$();
        configPath = "js7.configuration.trusted-signature-keys";
        logger = Logger$package$Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(GenericSignatureVerifier$.class));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GenericSignatureVerifier$.class);
    }

    @Override
    public String typeName() {
        return "(generic)";
    }

    @Override
    public String filenameExtension() {
        throw new NotImplementedError();
    }

    @Override
    public String recommendedKeyDirectoryName() {
        throw new NotImplementedError("GenericSignatureVerifier recommendedKeyDirectoryName");
    }

    public Either<Problem, GenericSignatureVerifier> checked(Config config) {
        return ((Either)package.traverse$.MODULE$.toTraverseOps((Object)CollectionConverters$.MODULE$.MapHasAsScala((Map)config.getObject(configPath)).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x$1 -> {
            String string = (String)x$1._1();
            ConfigValue configValue = (ConfigValue)x$1._2();
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)string);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)ScalaUtils$.MODULE$.checkedCast(configValue.unwrapped(), (Function0<Problem>)((Function0 & Serializable)() -> GenericSignatureVerifier$.checked$$anonfun$1$$anonfun$1(string)), ClassTag$.MODULE$.apply(String.class)).map((Function1 & Serializable)_$2 -> Paths.get(_$2, new String[0])).flatMap((Function1 & Serializable)directory -> {
                PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(SignatureServices$.MODULE$.nameToSignatureVerifierCompanion());
                return ScalaUtils$syntax$RichPartialFunction$.MODULE$.rightOr$extension(partialFunction, string, (Function0<Problem>)((Function0 & Serializable)() -> GenericSignatureVerifier$.checked$$anonfun$1$$anonfun$3$$anonfun$1(string))).flatMap((Function1 & Serializable)companion -> {
                    Vector files;
                    block1: {
                        Logger LoggerImpl_this;
                        if (!Files.exists(directory, new LinkOption[0])) {
                            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.pure("Signature key directory '" + directory + "' for '" + string + "' does not exist"));
                        }
                        files = (Vector)AutoClosing$.MODULE$.autoClosing(Files.list(directory), (Function1 & Serializable)_$3 -> {
                            Stream stream = JavaCollections$syntax$.MODULE$.JavaStreamToScala(_$3);
                            return JavaCollections$syntax$JavaStreamToScala$.MODULE$.asScala$extension(stream).filterNot((Function1 & Serializable)_$4 -> _$4.getFileName().toString().startsWith(".")).toVector();
                        });
                        if (!files.isEmpty() || !(LoggerImpl_this = logger).underlying().isWarnEnabled()) break block1;
                        LoggerImpl_this.underlying().warn("No public key files for signature verifier '{}' in directory '{}'", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{companion.typeName(), directory}), Object.class));
                    }
                    return companion.checked((Seq<Labeled<ByteArray>>)((Seq)files.map((Function1 & Serializable)_$5 -> FileUtils$syntax$RichPath$.MODULE$.labeledByteArray$extension(FileUtils$syntax$.MODULE$.RichPath((Path)_$5)))), directory.toString());
                });
            }));
        }).toVector(), (Traverse)package.vector$.MODULE$.catsStdInstancesForVector()).traverse((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            Either either = (Either)tuple2._2();
            if (either instanceof Left) {
                Left left = (Left)either;
                Problem p = (Problem)left.value();
                return package$.MODULE$.Left().apply((Object)p);
            }
            String k = (String)tuple2._1();
            if (either instanceof Right) {
                Right right = (Right)either;
                SignatureVerifier v = (SignatureVerifier)right.value();
                return package$.MODULE$.Right().apply((Object)v);
            }
            throw new MatchError((Object)tuple2);
        }, (Applicative)package.either$.MODULE$.catsStdInstancesForEither())).flatMap((Function1 & Serializable)verifiers -> {
            if (verifiers.isEmpty()) {
                return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.pure("No trusted signature keys - Configure one with " + configPath + "!"));
            }
            MODULE$.logVerifiers((Seq<SignatureVerifier>)verifiers);
            return package$.MODULE$.Right().apply((Object)new GenericSignatureVerifier((Iterable<SignatureVerifier>)verifiers));
        });
    }

    public Either<Problem, GenericSignatureVerifier> checked(Seq<Labeled<ByteArray>> publicKeys, String origin) {
        throw new NotImplementedError("GenericSignatureVerifier.checked?");
    }

    @Override
    public GenericSignatureVerifier ignoreInvalid(Seq<Labeled<ByteArray>> publicKeys, String origin) {
        throw new NotImplementedError("GenericSignatureVerifier.ignoreInvalid?");
    }

    public Either<Problem, GenericSignature> genericSignatureToSignature(GenericSignature signature) {
        return package$.MODULE$.Right().apply((Object)signature);
    }

    private void logVerifiers(Seq<SignatureVerifier> verifiers) {
        if (verifiers.isEmpty()) {
            Logger LoggerImpl_this = logger;
            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                LoggerImpl_this.underlying().info("Trusting NO public signature keys");
                return;
            }
            return;
        }
        Logger LoggerImpl_this = logger;
        if (LoggerImpl_this.underlying().isInfoEnabled()) {
            LoggerImpl_this.underlying().info(((IterableOnceOps)((SeqOps)new .colon.colon((Object)"Trusting public signature keys:", (List)Nil$.MODULE$)).concat((IterableOnce)((IterableOps)verifiers.sortBy((Function1 & Serializable)_$6 -> _$6.companion().typeName(), (Ordering)Ordering.String$.MODULE$)).flatMap((Function1 & Serializable)_$7 -> _$7.publicKeysToStrings()))).mkString("\n  "));
            return;
        }
    }

    public Function0<String> js7$base$crypt$generic$GenericSignatureVerifier$$$ConfigStringExpectedProblem$superArg$1(String configKey) {
        return () -> GenericSignatureVerifier$.ConfigStringExpectedProblem$superArg$1$$anonfun$1(configKey);
    }

    private static final Problem checked$$anonfun$1$$anonfun$1(String typeName$1) {
        return GenericSignatureVerifier$ConfigStringExpectedProblem$.MODULE$.apply(configPath + "." + typeName$1);
    }

    private static final Problem checked$$anonfun$1$$anonfun$3$$anonfun$1(String typeName$3) {
        return Problems$UnknownSignatureTypeProblem$.MODULE$.apply(typeName$3);
    }

    private static final String ConfigStringExpectedProblem$superArg$1$$anonfun$1(String configKey$2) {
        return "String expected as value of configuration key " + configKey$2;
    }
}

