/*
 * Decompiled with CFR 0.152.
 */
package js7.base.crypt.x509;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Set;
import js7.base.auth.DistinguishedName;
import js7.base.auth.Pem;
import js7.base.crypt.SignerId;
import js7.base.crypt.SignerId$;
import js7.base.crypt.x509.X509Cert$;
import js7.base.crypt.x509.X509CertInterface;
import js7.base.data.ByteArray;
import js7.base.data.ByteArray$;
import js7.base.data.ByteSequence$ops$;
import js7.base.problem.Problem;
import js7.base.time.JavaTimestamp$specific$;
import js7.base.time.JavaTimestamp$specific$RichJavaTimestampCompanion$;
import js7.base.time.Timestamp;
import js7.base.time.Timestamp$;
import js7.base.utils.Nulls$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import scala.Function0;
import scala.Function1;
import scala.Product;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Either;
import scala.util.hashing.MurmurHash3$;

public final class X509Cert
implements X509CertInterface,
Product,
Serializable {
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(X509Cert.class.getDeclaredField("isCA$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(X509Cert.class.getDeclaredField("fingerprint$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(X509Cert.class.getDeclaredField("signerId$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(X509Cert.class.getDeclaredField("signersDistinguishedName$lzy1"));
    private final X509Certificate x509Certificate;
    private volatile Object signersDistinguishedName$lzy1;
    private volatile Object signerId$lzy1;
    private volatile Object fingerprint$lzy1;
    private volatile Object isCA$lzy1;
    private final Timestamp notBefore;
    private final Timestamp notAfter;

    public static Pem CertificatePem() {
        return X509Cert$.MODULE$.CertificatePem();
    }

    public static Pem PrivateKeyPem() {
        return X509Cert$.MODULE$.PrivateKeyPem();
    }

    public static X509Cert apply(X509Certificate x509Certificate) {
        return X509Cert$.MODULE$.apply(x509Certificate);
    }

    public static Either<Problem, X509Cert> fromByteArray(ByteArray byteArray) {
        return X509Cert$.MODULE$.fromByteArray(byteArray);
    }

    public static Either<Problem, X509Cert> fromPem(String string) {
        return X509Cert$.MODULE$.fromPem(string);
    }

    public static X509Cert fromProduct(Product product) {
        return X509Cert$.MODULE$.fromProduct(product);
    }

    public static <A extends X509CertInterface> Seq<A> removeDuplicates(Seq<A> seq, Timestamp timestamp) {
        return X509Cert$.MODULE$.removeDuplicates(seq, timestamp);
    }

    public static X509Cert unapply(X509Cert x509Cert) {
        return X509Cert$.MODULE$.unapply(x509Cert);
    }

    public X509Cert(X509Certificate x509Certificate) {
        this.x509Certificate = x509Certificate;
        this.notBefore = JavaTimestamp$specific$RichJavaTimestampCompanion$.MODULE$.fromJavaUtilDate$extension(JavaTimestamp$specific$.MODULE$.RichJavaTimestampCompanion(Timestamp$.MODULE$), x509Certificate.getNotBefore());
        this.notAfter = JavaTimestamp$specific$RichJavaTimestampCompanion$.MODULE$.fromJavaUtilDate$extension(JavaTimestamp$specific$.MODULE$.RichJavaTimestampCompanion(Timestamp$.MODULE$), x509Certificate.getNotAfter());
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, 65191331, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        X509Cert x509Cert;
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof X509Cert)) return false;
        X509Cert x509Cert2 = x509Cert = (X509Cert)object;
        X509Certificate x509Certificate = this.x509Certificate();
        X509Certificate x509Certificate2 = x509Cert2.x509Certificate();
        if (x509Certificate != null) {
            if (!((Object)x509Certificate).equals(x509Certificate2)) return false;
            return true;
        }
        if (x509Certificate2 == null) return true;
        return false;
    }

    public boolean canEqual(Object that) {
        return that instanceof X509Cert;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "X509Cert";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "x509Certificate";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public X509Certificate x509Certificate() {
        return this.x509Certificate;
    }

    @Override
    public DistinguishedName signersDistinguishedName() {
        Object object = this.signersDistinguishedName$lzy1;
        if (object instanceof DistinguishedName) {
            return (DistinguishedName)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DistinguishedName)this.signersDistinguishedName$lzyINIT1();
    }

    private Object signersDistinguishedName$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.signersDistinguishedName$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DistinguishedName distinguishedName = null;
                    try {
                        distinguishedName = new DistinguishedName(this.x509Certificate().getSubjectX500Principal());
                        object2 = distinguishedName == null ? LazyVals.NullValue$.MODULE$ : distinguishedName;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.signersDistinguishedName$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return distinguishedName;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public SignerId signerId() {
        Object object = this.signerId$lzy1;
        if (object instanceof SignerId) {
            return (SignerId)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (SignerId)this.signerId$lzyINIT1();
    }

    private Object signerId$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.signerId$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    SignerId signerId = null;
                    try {
                        signerId = (SignerId)SignerId$.MODULE$.apply(this.signersDistinguishedName().toString());
                        object2 = signerId == null ? LazyVals.NullValue$.MODULE$ : signerId;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.signerId$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return signerId;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ByteArray fingerprint() {
        Object object = this.fingerprint$lzy1;
        if (object instanceof ByteArray) {
            return (ByteArray)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ByteArray)this.fingerprint$lzyINIT1();
    }

    private Object fingerprint$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.fingerprint$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ByteArray byteArray = null;
                    try {
                        MessageDigest md = MessageDigest.getInstance("SHA-1");
                        md.update(this.x509Certificate().getEncoded());
                        byteArray = (ByteArray)ByteArray$.MODULE$.apply(md.digest());
                        object2 = byteArray == null ? LazyVals.NullValue$.MODULE$ : byteArray;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.fingerprint$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return byteArray;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean isCA() {
        Object object = this.isCA$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.isCA$lzyINIT1());
    }

    private Object isCA$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.isCA$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        bl = BoxesRunTime.boxToBoolean((this.containsCA(this.x509Certificate().getCriticalExtensionOIDs()) || this.containsCA(this.x509Certificate().getNonCriticalExtensionOIDs()) ? 1 : 0) != 0);
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.isCA$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Timestamp notBefore() {
        return this.notBefore;
    }

    @Override
    public Timestamp notAfter() {
        return this.notAfter;
    }

    private boolean containsCA(Set strings) {
        return BoxesRunTime.unboxToBoolean((Object)Nulls$.MODULE$.nullToNone(strings).fold(X509Cert::containsCA$$anonfun$1, (Function1 & Serializable)_$1 -> _$1.contains(X509Cert$.js7$base$crypt$x509$X509Cert$$$MayActAsCA)));
    }

    public String toLongString() {
        return "X.509 certificate " + this.x509Certificate().getSubjectX500Principal() + " \u00b7 " + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(this.isCA()), (Function0<String>)((Function0 & Serializable)X509Cert::toLongString$$anonfun$1)) + "fingerprint=" + ByteSequence$ops$.MODULE$.toAllByteSequenceOps(this.fingerprint(), ByteArray$.MODULE$.implicitByteSequence()).toHexRaw() + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(this.x509Certificate().getKeyUsage() != null), (Function0<String>)((Function0 & Serializable)this::toLongString$$anonfun$2)) + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(this.x509Certificate().getExtendedKeyUsage() != null), (Function0<String>)((Function0 & Serializable)this::toLongString$$anonfun$3)) + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(this.x509Certificate().getSubjectAlternativeNames() != null), (Function0<String>)((Function0 & Serializable)this::toLongString$$anonfun$4));
    }

    public String toString() {
        return "X.509Certificate(" + this.x509Certificate().getSubjectX500Principal() + ")";
    }

    public X509Cert copy(X509Certificate x509Certificate) {
        return new X509Cert(x509Certificate);
    }

    public X509Certificate copy$default$1() {
        return this.x509Certificate();
    }

    public X509Certificate _1() {
        return this.x509Certificate();
    }

    private static final boolean containsCA$$anonfun$1() {
        return false;
    }

    private static final String toLongString$$anonfun$1() {
        return "CA, ";
    }

    private final String toLongString$$anonfun$2() {
        return " keyUsage=" + X509Cert$.MODULE$.js7$base$crypt$x509$X509Cert$$$keyUsageToString(this.x509Certificate().getKeyUsage());
    }

    private static final String toLongString$$anonfun$3$$anonfun$1$$anonfun$1(String o$1) {
        return o$1;
    }

    private final String toLongString$$anonfun$3() {
        return " extendedKeyUsage=" + ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.x509Certificate().getExtendedKeyUsage()).asScala().map((Function1 & Serializable)o -> (String)X509Cert$.js7$base$crypt$x509$X509Cert$$$oidToString.getOrElse(o, () -> X509Cert.toLongString$$anonfun$3$$anonfun$1$$anonfun$1(o)))).mkString(",");
    }

    private final String toLongString$$anonfun$4() {
        return " subjectAlternativeNames=" + X509Cert$.MODULE$.js7$base$crypt$x509$X509Cert$$$subjectAlternativeNamesToString(this.x509Certificate().getSubjectAlternativeNames());
    }
}

