/*
 * Decompiled with CFR 0.152.
 */
package js7.base.crypt.x509;

import cats.Applicative;
import cats.Invariant$;
import cats.Show;
import cats.Traverse;
import cats.instances.package;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import js7.base.auth.DistinguishedName;
import js7.base.crypt.GenericSignature;
import js7.base.crypt.SignatureVerifier;
import js7.base.crypt.x509.X509Cert;
import js7.base.crypt.x509.X509Cert$;
import js7.base.crypt.x509.X509Signature;
import js7.base.crypt.x509.X509Signature$;
import js7.base.crypt.x509.X509SignatureVerifier;
import js7.base.data.ByteArray;
import js7.base.log.Logger$package$Logger$;
import js7.base.problem.Problem;
import js7.base.scalasource.ScalaSourceLocation$;
import js7.base.time.Timestamp$;
import js7.base.utils.Assertions$;
import js7.base.utils.Collections$;
import js7.base.utils.Collections$implicits$;
import js7.base.utils.Collections$implicits$RichIterable$;
import js7.base.utils.Labeled;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Text;
import sourcecode.Text$;

public final class X509SignatureVerifier$
implements SignatureVerifier.Companion,
Serializable {
    public static final Logger js7$base$crypt$x509$X509SignatureVerifier$$$logger;
    private static final String typeName;
    private static final String filenameExtension;
    private static final String recommendedKeyDirectoryName;
    private static final Show<X509Certificate> x509CertificateShow;
    public static final X509SignatureVerifier$ MODULE$;

    private X509SignatureVerifier$() {
    }

    static {
        MODULE$ = new X509SignatureVerifier$();
        js7$base$crypt$x509$X509SignatureVerifier$$$logger = Logger$package$Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(X509SignatureVerifier$.class));
        typeName = X509Signature$.MODULE$.TypeName();
        filenameExtension = ".pem";
        recommendedKeyDirectoryName = "trusted-x509-keys";
        x509CertificateShow = (Show & Serializable)_$15 -> _$15.getIssuerX500Principal().toString();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(X509SignatureVerifier$.class);
    }

    @Override
    public String typeName() {
        return typeName;
    }

    @Override
    public String filenameExtension() {
        return filenameExtension;
    }

    @Override
    public String recommendedKeyDirectoryName() {
        return recommendedKeyDirectoryName;
    }

    public Show<X509Certificate> x509CertificateShow() {
        return x509CertificateShow;
    }

    public Either<Problem, X509SignatureVerifier> checked(Seq<Labeled<ByteArray>> pems, String origin) {
        return ((Either)package.traverse$.MODULE$.toTraverseOps((Object)pems.toVector(), (Traverse)package.vector$.MODULE$.catsStdInstancesForVector()).traverse((Function1 & Serializable)labeledPem -> X509Cert$.MODULE$.fromPem(((ByteArray)labeledPem.value()).utf8String()), (Applicative)Invariant$.MODULE$.catsMonadErrorForEither())).flatMap((Function1 & Serializable)_$16 -> {
            Vector vector = (Vector)Collections$implicits$.MODULE$.RichIterable(_$16);
            return Collections$implicits$RichIterable$.MODULE$.toCheckedKeyedMap$extension((Iterable)vector, (Function1 & Serializable)_$17 -> _$17.signersDistinguishedName(), (Function1 & Serializable)duplicates -> MODULE$.duplicateDNsToProblem((Map<DistinguishedName, Iterable<?>>)duplicates)).map((Function1 & Serializable)_$18 -> MODULE$.toVerifier((Map<DistinguishedName, X509Cert>)_$18, origin));
        });
    }

    @Override
    public X509SignatureVerifier ignoreInvalid(Seq<Labeled<ByteArray>> pems, String origin) {
        Seq certs = (Seq)pems.flatMap((Function1 & Serializable)labeledPem -> {
            Either<Problem, X509Cert> either = X509Cert$.MODULE$.fromPem(((ByteArray)labeledPem.value()).utf8String());
            if (either instanceof Left) {
                Left left = (Left)either;
                Problem problem = (Problem)left.value();
                Logger LoggerImpl_this = js7$base$crypt$x509$X509SignatureVerifier$$$logger;
                if (LoggerImpl_this.underlying().isErrorEnabled()) {
                    LoggerImpl_this.underlying().error("Ignoring X.509 certificate '{}' due to: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{labeledPem.label(), problem}), Object.class));
                }
                return None$.MODULE$;
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                X509Cert o = (X509Cert)right.value();
                return Some$.MODULE$.apply((Object)o);
            }
            throw new MatchError(either);
        });
        Seq seq = (Seq)Collections$implicits$.MODULE$.RichIterable(X509Cert$.MODULE$.removeDuplicates(certs, Timestamp$.MODULE$.now()));
        return this.toVerifier(Collections$implicits$RichIterable$.MODULE$.toKeyedMap$extension((Iterable)seq, (Function1 & Serializable)_$19 -> _$19.signersDistinguishedName()), origin);
    }

    private X509SignatureVerifier toVerifier(Map<DistinguishedName, X509Cert> signerDNToTrustedCertificate, String origin) {
        Vector trustedCertificates = signerDNToTrustedCertificate.values().toVector();
        Vector rootCertificates = (Vector)trustedCertificates.filter((Function1 & Serializable)_$20 -> _$20.isCA());
        rootCertificates.foreach((Function1)(JProcedure1 & Serializable)o -> {
            Logger LoggerImpl_this = js7$base$crypt$x509$X509SignatureVerifier$$$logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("Trusting signatures signed with a certificate which is signed with root {}", o);
                return;
            }
        });
        signerDNToTrustedCertificate.values().foreach((Function1)(JProcedure1 & Serializable)o -> {
            Logger LoggerImpl_this = js7$base$crypt$x509$X509SignatureVerifier$$$logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("Trusting signatures signed with {}", o);
                return;
            }
        });
        return new X509SignatureVerifier((Seq<X509Cert>)trustedCertificates, (Seq<X509Cert>)rootCertificates, signerDNToTrustedCertificate, origin);
    }

    private Problem duplicateDNsToProblem(Map<DistinguishedName, Iterable<?>> duplicates) {
        return Collections$.MODULE$.duplicatesToProblem("Duplicate X.509 certificates", duplicates);
    }

    public Either<Problem, X509Signature> genericSignatureToSignature(GenericSignature signature) {
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy2$1(signature)), "signature.typeName == typeName"), FullName$.MODULE$.apply("js7.base.crypt.x509.X509SignatureVerifier.genericSignatureToSignature"), ScalaSourceLocation$.MODULE$.apply("X509SignatureVerifier.scala", 154));
        return X509Signature$.MODULE$.fromGenericSignature(signature);
    }

    private final boolean v$proxy2$1(GenericSignature signature$5) {
        String string = signature$5.typeName();
        String string2 = this.typeName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }
}

