/*
 * Decompiled with CFR 0.152.
 */
package js7.base.crypt.x509;

import java.io.Serializable;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import js7.base.crypt.DocumentSigner;
import js7.base.crypt.SignerId;
import js7.base.crypt.SignerId$;
import js7.base.crypt.x509.Openssl;
import js7.base.crypt.x509.X509Algorithm;
import js7.base.crypt.x509.X509Algorithm$;
import js7.base.crypt.x509.X509Signature$;
import js7.base.crypt.x509.X509SignatureVerifier;
import js7.base.crypt.x509.X509SignatureVerifier$;
import js7.base.crypt.x509.X509Signer;
import js7.base.data.ByteArray;
import js7.base.generic.SecretString;
import js7.base.generic.SecretString$;
import js7.base.io.file.FileUtils$;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$Ops$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.utils.Labeled;
import js7.base.utils.Labeled$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;

public final class X509Signer$
implements DocumentSigner.Companion,
Serializable {
    private volatile Object forTest$lzy1;
    public static final X509Signer$ MODULE$ = new X509Signer$();

    private X509Signer$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(X509Signer$.class);
    }

    @Override
    public String typeName() {
        return X509Signature$.MODULE$.TypeName();
    }

    public Either<Problem, X509Signer> checked(ByteArray privateKey, SecretString password) {
        return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.pure("X509Signer requirers a SignerId which the current API does not provide"));
    }

    public SecretString checked$default$2() {
        return SecretString$.MODULE$.apply("");
    }

    public Either<Problem, X509Signer> checked(ByteArray privateKey, X509Algorithm algorithm, SignerId signerId) {
        return Checked$.MODULE$.catchNonFatal(() -> X509Signer$.checked$$anonfun$1(privateKey)).map((Function1 & Serializable)_$1 -> new X509Signer((PrivateKey)_$1, algorithm, signerId));
    }

    public Tuple2<X509Signer, X509SignatureVerifier> forTest() {
        Object object = this.forTest$lzy1;
        if (object instanceof Tuple2) {
            return (Tuple2)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Tuple2)this.forTest$lzyINIT1();
    }

    private Object forTest$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.forTest$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, X509Signer.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Tuple2 tuple2 = null;
                    try {
                        Either either = Checked$.MODULE$.Ops(this.newSignerAndVerifier((SignerId)SignerId$.MODULE$.apply("CN=SIGNER"), "forTest"));
                        tuple2 = (Tuple2)Checked$Ops$.MODULE$.orThrow$extension(either);
                        object2 = tuple2 == null ? LazyVals.NullValue$.MODULE$ : tuple2;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, X509Signer.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.forTest$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, X509Signer.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return tuple2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, X509Signer.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Either<Problem, Tuple2<X509Signer, X509SignatureVerifier>> newSignerAndVerifier(SignerId signerId, String origin) {
        return (Either)FileUtils$.MODULE$.withTemporaryDirectory("X509Signer", (Function1 & Serializable)dir -> {
            Openssl openssl = new Openssl((Path)dir);
            return openssl.generateCertWithPrivateKey("X509Signer", "/" + signerId.string()).flatMap((Function1 & Serializable)certWithPrivateKey -> MODULE$.checked(certWithPrivateKey.privateKey(), X509Algorithm$.MODULE$.SHA512withRSA(), signerId).flatMap((Function1 & Serializable)signer -> X509SignatureVerifier$.MODULE$.checked((Seq<Labeled<ByteArray>>)((Seq)((SeqOps)new .colon.colon(Labeled$.MODULE$.apply(certWithPrivateKey.certificate(), "signer=" + signerId), (List)Nil$.MODULE$))), origin).map((Function1 & Serializable)verifier -> {
                X509Signer x509Signer = (X509Signer)Predef$.MODULE$.ArrowAssoc(signer);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)x509Signer, verifier);
            })));
        });
    }

    private static final PrivateKey checked$$anonfun$1(ByteArray privateKey$1) {
        return KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(privateKey$1.toArray()));
    }
}

