/*
 * Decompiled with CFR 0.152.
 */
package js7.base.fs2utils;

import cats.MonadError;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.MonadCancel;
import cats.effect.std.Mutex;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import fs2.concurrent.SignallingRef;
import java.io.Serializable;
import js7.base.fs2utils.StreamExtensions$;
import js7.base.fs2utils.StreamQueue$;
import js7.base.fs2utils.StreamQueue$End$;
import js7.base.fs2utils.StreamQueue$NoValue$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class StreamQueue<K, V> {
    private final Function1<V, K> toKey;
    private final Mutex<IO> mutex;
    private final SignallingRef<IO, Object> stopSignal;
    private final SignallingRef<IO, BoxedUnit> availableSignal;
    private final ListBuffer<Object> queue;
    private final Set<K> isQueued;

    public static <K, V> IO<StreamQueue<K, V>> apply(Function1<V, K> function1) {
        return StreamQueue$.MODULE$.apply(function1);
    }

    public StreamQueue(Function1<V, K> toKey, Mutex<IO> mutex, SignallingRef<IO, Object> stopSignal, SignallingRef<IO, BoxedUnit> availableSignal) {
        this.toKey = toKey;
        this.mutex = mutex;
        this.stopSignal = stopSignal;
        this.availableSignal = availableSignal;
        this.queue = ListBuffer$.MODULE$.empty();
        this.isQueued = (Set)Set$.MODULE$.empty();
    }

    public IO<Object> nonEmpty() {
        return (IO)this.mutex.lock().surround((Object)IO$.MODULE$.apply(this::nonEmpty$$anonfun$1), (MonadCancel)IO$.MODULE$.asyncForIO());
    }

    public IO<BoxedUnit> stop() {
        return (IO)this.stopSignal.set((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public IO<BoxedUnit> close() {
        return ((IO)this.mutex.lock().surround((Object)IO$.MODULE$.apply(this::close$$anonfun$1), (MonadCancel)IO$.MODULE$.asyncForIO())).$times$greater((IO)this.availableSignal.set((Object)BoxedUnit.UNIT));
    }

    public Stream<IO, V> stream() {
        Stream stream = Stream$.MODULE$.eval(this.dequeueNext()).repeat();
        return StreamExtensions$.MODULE$.interruptUpstreamWhen(stream.takeWhile((Function1 & Serializable)_$1 -> {
            Object object = _$1;
            StreamQueue$End$ streamQueue$End$ = StreamQueue$End$.MODULE$;
            return object == null ? streamQueue$End$ != null : !object.equals(streamQueue$End$);
        }, stream.takeWhile$default$2()), this.stopSignal, IO$.MODULE$.asyncForIO());
    }

    private IO<Object> dequeueNext() {
        return (IO)this.availableSignal.discrete().evalMap((Function1 & Serializable)_$2 -> this.tryDequeueNext()).filter((Function1 & Serializable)_$3 -> {
            Object object = _$3;
            StreamQueue$NoValue$ streamQueue$NoValue$ = StreamQueue$NoValue$.MODULE$;
            return object == null ? streamQueue$NoValue$ != null : !object.equals(streamQueue$NoValue$);
        }).head().compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).lastOrError((MonadError)IO$.MODULE$.asyncForIO());
    }

    private IO<Object> tryDequeueNext() {
        return (IO)this.mutex.lock().surround((Object)IO$.MODULE$.apply(this::tryDequeueNext$$anonfun$1), (MonadCancel)IO$.MODULE$.asyncForIO());
    }

    public IO<Object> enqueue(V value) {
        return (IO)this.mutex.lock().surround((Object)IO$.MODULE$.apply(() -> this.enqueue$$anonfun$1(value)).$times$greater(((IO)this.availableSignal.set((Object)BoxedUnit.UNIT)).as((Object)BoxesRunTime.boxToBoolean((boolean)true))), (MonadCancel)IO$.MODULE$.asyncForIO());
    }

    private IO<Object> withdraw(K key) {
        return (IO)this.mutex.lock().surround((Object)IO$.MODULE$.apply(() -> this.withdraw$$anonfun$1(key)), (MonadCancel)IO$.MODULE$.asyncForIO());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean removeLocked(K key) {
        boolean bl;
        if (!this.isQueued.remove(key)) return false;
        int n = this.queue.indexWhere((Function1 & Serializable)x$1 -> {
            Object object = x$1;
            if (StreamQueue$End$.MODULE$.equals(object)) {
                return false;
            }
            if (object instanceof Object) {
                Object object2 = object;
                Object v = object2;
                return BoxesRunTime.equals((Object)this.toKey.apply(v), (Object)key);
            }
            throw new MatchError(object);
        });
        if (-1 == n) {
            bl = false;
        } else {
            int i = n;
            this.queue.remove(i);
            bl = true;
        }
        if (!BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.locally((Object)BoxesRunTime.boxToBoolean((boolean)bl)))) return false;
        return true;
    }

    public String toString() {
        return "StreamQueue";
    }

    private final boolean nonEmpty$$anonfun$1() {
        return this.queue.nonEmpty();
    }

    private final ListBuffer close$$anonfun$1() {
        return (ListBuffer)this.queue.$plus$eq((Object)StreamQueue$End$.MODULE$);
    }

    private final Object tryDequeueNext$$anonfun$1() {
        if (this.queue.isEmpty()) {
            return StreamQueue$NoValue$.MODULE$;
        }
        Object v = this.queue.remove(0);
        Object object = v;
        if (StreamQueue$End$.MODULE$.equals(object)) {
            v0 = BoxedUnit.UNIT;
        } else if (object instanceof Object) {
            Object object2;
            Object v2 = object2 = object;
            v0 = this.isQueued.$minus$eq(this.toKey.apply(v2));
        } else {
            throw new MatchError(object);
        }
        return v;
    }

    private final Set enqueue$$anonfun$1(Object value$1) {
        this.removeLocked(this.toKey.apply(value$1));
        this.queue.$plus$eq(value$1);
        return (Set)this.isQueued.$plus$eq(this.toKey.apply(value$1));
    }

    private final boolean withdraw$$anonfun$1(Object key$1) {
        return this.removeLocked(key$1);
    }
}

