/*
 * Decompiled with CFR 0.152.
 */
package js7.base.metering;

import cats.effect.IO;
import cats.effect.IO$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import js7.base.metering.CallMeter$;
import js7.base.metering.CallMeter$MeteringN$;
import js7.base.metering.CallMeterMacros$;
import js7.base.metering.Measurement;
import js7.base.metering.Measurement$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichLong$;
import js7.base.time.ScalaTime$RichDeadline$;
import scala.Function0;
import scala.Function1;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.Deadline$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals$;
import sourcecode.Enclosing;

public final class CallMeter
implements CallMeterMXBean {
    private final String name;
    private final long _sinceNano;
    private final AtomicInteger _running;
    private final AtomicLong _total;
    private final AtomicLong _nanos;
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(CallMeter$.class.getDeclaredField("given_Ordering_CallMeter$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(CallMeter$.class.getDeclaredField("logger$lzy1"));

    public static CallMeter apply(Enclosing enclosing) {
        return CallMeter$.MODULE$.apply(enclosing);
    }

    public static CallMeter apply(String string) {
        return CallMeter$.MODULE$.apply(string);
    }

    public static Vector<CallMeter> callMeters() {
        return CallMeter$.MODULE$.callMeters();
    }

    public static Ordering<CallMeter> given_Ordering_CallMeter() {
        return CallMeter$.MODULE$.given_Ordering_CallMeter();
    }

    public static void log(Function1<Measurement, Measurement> function1) {
        CallMeter$.MODULE$.log(function1);
    }

    public static void logAll() {
        CallMeter$.MODULE$.logAll();
    }

    public static Function1<Measurement, Measurement> log$default$1() {
        return CallMeter$.MODULE$.log$default$1();
    }

    public CallMeter(String name) {
        this.name = name;
        this._sinceNano = System.nanoTime();
        this._running = new AtomicInteger(0);
        this._total = new AtomicLong(0L);
        this._nanos = new AtomicLong(0L);
        CallMeter$.MODULE$.js7$base$metering$CallMeter$$$register(this);
        CallMeter$.MODULE$.js7$base$metering$CallMeter$$$registerAsMBean(this);
    }

    public String name() {
        return this.name;
    }

    public <A> A meterCall(Function0<A> body) {
        Object object;
        this._running.getAndIncrement();
        long t = this.startMetering_();
        try {
            object = body.apply();
        }
        finally {
            this.stopMetering_(t);
        }
        return (A)object;
    }

    public <A> IO<A> meterIO(IO<A> io) {
        return IO$.MODULE$.defer(() -> this.meterIO$$anonfun$1(io));
    }

    public long startMetering() {
        this._running.getAndIncrement();
        return System.nanoTime();
    }

    public MeteringN startMetering(int n) {
        this._running.getAndAdd(n);
        return new MeteringN(this, System.nanoTime(), n);
    }

    public void stopMetering(long metering) {
        this.addNanos(System.nanoTime() - metering);
        this._running.getAndDecrement();
    }

    public void stopMetering(MeteringN metering) {
        this.addNanos(metering.elapsedNanos());
        this._running.getAndAdd(-metering.n());
    }

    private long startMetering_() {
        this._running.getAndIncrement();
        return System.nanoTime();
    }

    private void stopMetering_(long sinceNano) {
        this.addNanos(System.nanoTime() - sinceNano);
        this._running.getAndDecrement();
    }

    public void addNanos(long nanos) {
        AtomicLong atomic$proxy1 = this.inline$_total();
        atomic$proxy1.getAndIncrement();
        AtomicLong atomic$proxy2 = this.inline$_nanos();
        atomic$proxy2.getAndAdd(nanos);
    }

    public Measurement measurement() {
        return Measurement$.MODULE$.apply(this, this.total(), this._running.get(), this._nanos.get(), System.nanoTime() - this._sinceNano);
    }

    public long total() {
        return this._total.get();
    }

    @Override
    public int getRunning() {
        return this._running.get();
    }

    @Override
    public long getTotal() {
        return this._total.get();
    }

    @Override
    public double getSeconds() {
        return (double)this._nanos.get() / 1.0E9;
    }

    public String toString() {
        return "CallMeter(" + this.measurement().asString() + ")";
    }

    public CallMeterMacros$ inline$CallMeterMacros() {
        return CallMeterMacros$.MODULE$;
    }

    public final AtomicLong inline$_total() {
        return this._total;
    }

    public final AtomicLong inline$_nanos() {
        return this._nanos;
    }

    private final void meterIO$$anonfun$1$$anonfun$1(long t$1) {
        this.stopMetering_(t$1);
    }

    private final IO meterIO$$anonfun$1(IO io$1) {
        long t = this.startMetering_();
        return io$1.guarantee(IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.meterIO$$anonfun$1$$anonfun$1(t);
            return BoxedUnit.UNIT;
        }));
    }

    public static interface CallMeterMXBean {
        public int getRunning();

        public long getTotal();

        public double getSeconds();
    }

    public static final class MeteringN
    extends AtomicBoolean
    implements AutoCloseable {
        private final CallMeter callMeter;
        private final long sinceNano;
        private final int n;

        public static MeteringN Dummy() {
            return CallMeter$MeteringN$.MODULE$.Dummy();
        }

        public MeteringN(CallMeter callMeter, long sinceNano, int n) {
            this.callMeter = callMeter;
            this.sinceNano = sinceNano;
            this.n = n;
            super(false);
        }

        public int n() {
            return this.n;
        }

        @Override
        public void close() {
            if (this.compareAndSet(false, true)) {
                this.callMeter.stopMetering(this);
                return;
            }
        }

        public long elapsedNanos() {
            return System.nanoTime() - this.sinceNano;
        }

        @Override
        public String toString() {
            return this.callMeter + " " + this.n() + "\u00d7 " + ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(Deadline$.MODULE$.apply(ScalaTime$DurationRichLong$.MODULE$.ns$extension(ScalaTime$.MODULE$.DurationRichLong(this.sinceNano)))));
        }
    }
}

