/*
 * Decompiled with CFR 0.152.
 */
package js7.base.system;

import java.io.Serializable;
import java.lang.management.ThreadInfo;
import js7.base.system.ThreadsMXBean$;
import js7.base.system.ThreadsMXBean$Bean$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.runtime.RichChar$;

public interface ThreadsMXBean {
    public static int getFileSystemWatchThreads$(ThreadsMXBean $this) {
        return $this.getFileSystemWatchThreads();
    }

    default public int getFileSystemWatchThreads() {
        return ((ThreadsMXBean$Bean$)this).computed().fileSystemWatchThreads();
    }

    public static int getCommonPoolThreads$(ThreadsMXBean $this) {
        return $this.getCommonPoolThreads();
    }

    default public int getCommonPoolThreads() {
        return ((ThreadsMXBean$Bean$)this).computed().commonPoolThreads();
    }

    public static int getPekkoThreads$(ThreadsMXBean $this) {
        return $this.getPekkoThreads();
    }

    default public int getPekkoThreads() {
        return ((ThreadsMXBean$Bean$)this).computed().pekkoThreads();
    }

    public static int getCatsEffectComputeThreads$(ThreadsMXBean $this) {
        return $this.getCatsEffectComputeThreads();
    }

    default public int getCatsEffectComputeThreads() {
        return ((ThreadsMXBean$Bean$)this).computed().catsEffectComputeThreads();
    }

    public static int getCatsEffectBlockingThreads$(ThreadsMXBean $this) {
        return $this.getCatsEffectBlockingThreads();
    }

    default public int getCatsEffectBlockingThreads() {
        return ((ThreadsMXBean$Bean$)this).computed().catsEffectBlockingThreads();
    }

    public static int getProcessReaperThreads$(ThreadsMXBean $this) {
        return $this.getProcessReaperThreads();
    }

    default public int getProcessReaperThreads() {
        return ((ThreadsMXBean$Bean$)this).computed().processReaperThreads();
    }

    public static int getOtherThreads$(ThreadsMXBean $this) {
        return $this.getOtherThreads();
    }

    default public int getOtherThreads() {
        return ((ThreadsMXBean$Bean$)this).computed().otherThreads();
    }

    public static final class Computed {
        private final int fileSystemWatchThreads;
        private final int commonPoolThreads;
        private final int pekkoThreads;
        private final int catsEffectComputeThreads;
        private final int catsEffectBlockingThreads;
        private final int processReaperThreads;
        private final int otherThreads;

        public Computed(ThreadInfo[] threads) {
            this.fileSystemWatchThreads = this.countThreads(threads, (Function1<String, Object>)(Function1 & Serializable)name -> name.startsWith("FileSystemWatchService"));
            this.commonPoolThreads = this.countThreads(threads, (Function1<String, Object>)(Function1 & Serializable)name -> name.startsWith("ForkJoinPool.commonPool"));
            this.pekkoThreads = this.countThreads(threads, (Function1<String, Object>)(Function1 & Serializable)name -> name.startsWith("pekko-"));
            this.catsEffectComputeThreads = this.countThreads(threads, (Function1<String, Object>)(Function1 & Serializable)name -> name.startsWith("js7-") && name.length() > 4 && RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(name), 4))));
            this.catsEffectBlockingThreads = this.countThreads(threads, (Function1<String, Object>)(Function1 & Serializable)name -> name.startsWith("js7-blocker-") || name.startsWith("js7-blocking-"));
            this.processReaperThreads = this.countThreads(threads, (Function1<String, Object>)(Function1 & Serializable)name -> name.startsWith("process reaper"));
            this.otherThreads = threads.length - this.fileSystemWatchThreads() - this.commonPoolThreads() - this.pekkoThreads() - this.catsEffectComputeThreads() - this.catsEffectBlockingThreads() - this.processReaperThreads();
        }

        public int fileSystemWatchThreads() {
            return this.fileSystemWatchThreads;
        }

        public int commonPoolThreads() {
            return this.commonPoolThreads;
        }

        public int pekkoThreads() {
            return this.pekkoThreads;
        }

        public int catsEffectComputeThreads() {
            return this.catsEffectComputeThreads;
        }

        public int catsEffectBlockingThreads() {
            return this.catsEffectBlockingThreads;
        }

        public int processReaperThreads() {
            return this.processReaperThreads;
        }

        public int otherThreads() {
            return this.otherThreads;
        }

        private <A> int countThreads(ThreadInfo[] threads, Function1<String, Object> predicate) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])threads);
            return ArrayOps$.MODULE$.count$extension(object, arg_0 -> ThreadsMXBean$.js7$base$system$ThreadsMXBean$Computed$$_$countThreads$$anonfun$1(predicate, arg_0));
        }
    }
}

