/*
 * Decompiled with CFR 0.152.
 */
package js7.base.time;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import js7.base.time.JavaTime$extensions$;
import js7.base.time.JavaTimestamp$;
import js7.base.time.LocalInterval$;
import js7.base.time.LocalInterval$Never$;
import js7.base.time.LocalInterval$Standard$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.time.SchemeRestriction;
import js7.base.time.TimeInterval;
import js7.base.time.TimeInterval$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordered;
import scala.math.Ordered$;
import scala.math.Ordering$;
import scala.runtime.BoxesRunTime;
import scala.util.hashing.MurmurHash3$;

public interface LocalInterval
extends Ordered<LocalInterval> {
    public static LocalInterval apply(LocalDateTime localDateTime, FiniteDuration finiteDuration) {
        return LocalInterval$.MODULE$.apply(localDateTime, finiteDuration);
    }

    public static int ordinal(LocalInterval localInterval) {
        return LocalInterval$.MODULE$.ordinal(localInterval);
    }

    public boolean contains(LocalDateTime var1, ZoneId var2);

    public boolean contains(LocalDateTime var1, LocalDateTime var2, ZoneId var3);

    public boolean startsBefore(LocalDateTime var1, ZoneId var2);

    public boolean endsAfter(LocalDateTime var1, ZoneId var2);

    public Option<LocalInterval> clip(SchemeRestriction var1, Duration var2);

    public TimeInterval toTimeInterval(ZoneId var1);

    public static final class Standard
    implements Ordered,
    LocalInterval,
    Product,
    Serializable {
        private final LocalDateTime start;
        private final FiniteDuration duration;

        public static Standard apply(LocalDateTime localDateTime, FiniteDuration finiteDuration) {
            return LocalInterval$Standard$.MODULE$.apply(localDateTime, finiteDuration);
        }

        public static Standard fromProduct(Product product) {
            return LocalInterval$Standard$.MODULE$.fromProduct(product);
        }

        public static Standard unapply(Standard standard) {
            return LocalInterval$Standard$.MODULE$.unapply(standard);
        }

        public Standard(LocalDateTime start, FiniteDuration duration) {
            this.start = start;
            this.duration = duration;
            Ordered.$init$((Ordered)this);
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -414826243, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            Standard standard;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Standard)) return false;
            Standard standard2 = standard = (Standard)object;
            LocalDateTime localDateTime = this.start();
            LocalDateTime localDateTime2 = standard2.start();
            if (localDateTime == null) {
                if (localDateTime2 != null) {
                    return false;
                }
            } else if (!((Object)localDateTime).equals(localDateTime2)) return false;
            FiniteDuration finiteDuration = this.duration();
            FiniteDuration finiteDuration2 = standard2.duration();
            if (finiteDuration == null) {
                if (finiteDuration2 == null) return true;
                return false;
            } else {
                if (!finiteDuration.equals(finiteDuration2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof Standard;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Standard";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "start";
            }
            if (1 == n2) {
                return "duration";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public LocalDateTime start() {
            return this.start;
        }

        public FiniteDuration duration() {
            return this.duration;
        }

        public LocalDateTime end() {
            return this.start().plusNanos(this.duration().toNanos());
        }

        @Override
        public boolean contains(LocalDateTime local, ZoneId x$2) {
            LocalDateTime normalizedLocal = JavaTime$extensions$.MODULE$.normalize(local, x$2);
            LocalDateTime normalizedStart = JavaTime$extensions$.MODULE$.normalize(this.start(), x$2);
            return !normalizedStart.isAfter(normalizedLocal) && JavaTime$extensions$.MODULE$.$plus(normalizedStart, this.duration()).isAfter(normalizedLocal);
        }

        @Override
        public boolean contains(LocalDateTime start, LocalDateTime end, ZoneId x$3) {
            LocalDateTime normalizedStart = JavaTime$extensions$.MODULE$.normalize(start, x$3);
            LocalDateTime normalizedEnd = JavaTime$extensions$.MODULE$.normalize(end, x$3);
            LocalDateTime normalizedThisStart = JavaTime$extensions$.MODULE$.normalize(this.start(), x$3);
            return Ordered$.MODULE$.orderingToOrdered((Object)normalizedThisStart, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())).$less((Object)normalizedEnd) && Ordered$.MODULE$.orderingToOrdered((Object)normalizedStart, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())).$less((Object)JavaTime$extensions$.MODULE$.$plus(normalizedThisStart, this.duration()));
        }

        @Override
        public boolean startsBefore(LocalDateTime local, ZoneId x$2) {
            return Ordered$.MODULE$.orderingToOrdered((Object)JavaTime$extensions$.MODULE$.normalize(this.start(), x$2), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())).$less((Object)JavaTime$extensions$.MODULE$.normalize(local, x$2));
        }

        @Override
        public boolean endsAfter(LocalDateTime local, ZoneId x$2) {
            return Ordered$.MODULE$.orderingToOrdered((Object)JavaTime$extensions$.MODULE$.normalize(local, x$2), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())).$less((Object)JavaTime$extensions$.MODULE$.$plus(JavaTime$extensions$.MODULE$.normalize(this.start(), x$2), this.duration()));
        }

        public Option<Standard> clip(SchemeRestriction restriction, Duration dateOffset) {
            return restriction.clipLocalInterval(this, dateOffset);
        }

        @Override
        public TimeInterval toTimeInterval(ZoneId zoneId) {
            return TimeInterval$.MODULE$.apply(JavaTimestamp$.MODULE$.ofZoned(ZonedDateTime.of(this.start(), zoneId)), this.duration());
        }

        public int compare(LocalInterval o) {
            LocalInterval localInterval = o;
            if (LocalInterval$Never$.MODULE$.equals(localInterval)) {
                return -1;
            }
            if (localInterval instanceof Standard) {
                Standard standard;
                Standard o2 = standard = (Standard)localInterval;
                return Ordered$.MODULE$.orderingToOrdered((Object)this.start(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())).compare((Object)o2.start());
            }
            throw new MatchError((Object)localInterval);
        }

        public String toString() {
            return "LocalInterval(" + this.start() + ", " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(this.duration())) + ")";
        }

        public Standard copy(LocalDateTime start, FiniteDuration duration) {
            return new Standard(start, duration);
        }

        public LocalDateTime copy$default$1() {
            return this.start();
        }

        public FiniteDuration copy$default$2() {
            return this.duration();
        }

        public LocalDateTime _1() {
            return this.start();
        }

        public FiniteDuration _2() {
            return this.duration();
        }
    }
}

