/*
 * Decompiled with CFR 0.152.
 */
package js7.base.time;

import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalTime;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.time.AdmissionPeriod;
import js7.base.time.AdmissionPeriod$;
import js7.base.time.MonthlyWeekdayPeriod$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.ScalaUtils$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichSeq$;
import scala.Function0;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.util.Either;
import sourcecode.FileName$;
import sourcecode.Line$;

public final class MonthlyWeekdayPeriod
implements AdmissionPeriod,
Product,
Serializable {
    private final int secondOfWeeks;
    private final FiniteDuration duration;

    public static MonthlyWeekdayPeriod apply(int n, DayOfWeek dayOfWeek, LocalTime localTime, FiniteDuration finiteDuration) {
        return MonthlyWeekdayPeriod$.MODULE$.apply(n, dayOfWeek, localTime, finiteDuration);
    }

    public static MonthlyWeekdayPeriod apply(int n, FiniteDuration finiteDuration) {
        return MonthlyWeekdayPeriod$.MODULE$.apply(n, finiteDuration);
    }

    public static MonthlyWeekdayPeriod fromProduct(Product product) {
        return MonthlyWeekdayPeriod$.MODULE$.fromProduct(product);
    }

    public static MonthlyWeekdayPeriod unapply(MonthlyWeekdayPeriod monthlyWeekdayPeriod) {
        return MonthlyWeekdayPeriod$.MODULE$.unapply(monthlyWeekdayPeriod);
    }

    public MonthlyWeekdayPeriod(int secondOfWeeks, FiniteDuration duration) {
        this.secondOfWeeks = secondOfWeeks;
        this.duration = duration;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)-259070948);
        n = Statics.mix((int)n, (int)this.secondOfWeeks());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.duration()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        MonthlyWeekdayPeriod monthlyWeekdayPeriod;
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof MonthlyWeekdayPeriod)) return false;
        MonthlyWeekdayPeriod monthlyWeekdayPeriod2 = monthlyWeekdayPeriod = (MonthlyWeekdayPeriod)object;
        if (this.secondOfWeeks() != monthlyWeekdayPeriod2.secondOfWeeks()) return false;
        FiniteDuration finiteDuration = this.duration();
        FiniteDuration finiteDuration2 = monthlyWeekdayPeriod2.duration();
        if (finiteDuration != null) {
            if (!finiteDuration.equals(finiteDuration2)) return false;
            return true;
        }
        if (finiteDuration2 == null) return true;
        return false;
    }

    public boolean canEqual(Object that) {
        return that instanceof MonthlyWeekdayPeriod;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "MonthlyWeekdayPeriod";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return BoxesRunTime.boxToInteger((int)this._1());
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "secondOfWeeks";
        }
        if (1 == n2) {
            return "duration";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public int secondOfWeeks() {
        return this.secondOfWeeks;
    }

    public FiniteDuration duration() {
        return this.duration;
    }

    public Either<Problem, MonthlyWeekdayPeriod> checked() {
        if (this.secondOfWeeks() < 0 || this.secondOfWeeks() >= 4 * AdmissionPeriod$.MODULE$.WeekSeconds()) {
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::checked$$anonfun$9), Problem$.MODULE$.apply$default$2()));
        }
        if (!ScalaTime$RichFiniteDuration$.MODULE$.isPositive$extension(ScalaTime$.MODULE$.RichFiniteDuration(this.duration()))) {
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::checked$$anonfun$10), Problem$.MODULE$.apply$default$2()));
        }
        return package$.MODULE$.Right().apply((Object)this);
    }

    public int shiftWeeks() {
        return this.secondOfWeeks() / AdmissionPeriod$.MODULE$.WeekSeconds();
    }

    public int dayOfWeek() {
        return this.secondOfWeeks() / AdmissionPeriod$.MODULE$.DaySeconds() % 7;
    }

    public int secondOfDay() {
        return this.secondOfWeeks() % AdmissionPeriod$.MODULE$.DaySeconds();
    }

    @Override
    public String pretty() {
        Seq seq = ScalaUtils$syntax$.MODULE$.RichSeq(AdmissionPeriod$.MODULE$.WeekdaysNames());
        return ScalaUtils$.MODULE$.ordinalToString(this.shiftWeeks() + 1) + " " + ScalaUtils$syntax$RichSeq$.MODULE$.checked$extension(seq, this.dayOfWeek(), FileName$.MODULE$.apply("AdmissionPeriod.scala"), Line$.MODULE$.apply(183)).getOrElse(MonthlyWeekdayPeriod::pretty$$anonfun$1) + " " + AdmissionPeriod$.MODULE$.secondsOfDayToString(this.secondOfDay()) + ", " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(this.duration()));
    }

    private MonthlyWeekdayPeriod copy(int secondOfWeeks, FiniteDuration duration) {
        return new MonthlyWeekdayPeriod(secondOfWeeks, duration);
    }

    private int copy$default$1() {
        return this.secondOfWeeks();
    }

    private FiniteDuration copy$default$2() {
        return this.duration();
    }

    public int _1() {
        return this.secondOfWeeks();
    }

    public FiniteDuration _2() {
        return this.duration();
    }

    private final String checked$$anonfun$9() {
        return "Invalid time in a month: " + this.secondOfWeeks() + " " + this.toString();
    }

    private final String checked$$anonfun$10() {
        return "Duration must be positive: " + this.toString();
    }

    private static final String pretty$$anonfun$1() {
        return "?";
    }
}

