/*
 * Decompiled with CFR 0.152.
 */
package js7.base.time;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.unsafe.IORuntime;
import cats.effect.unsafe.Scheduler;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import js7.base.scalasource.ScalaSourceLocation$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichLong$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.time.TestScheduler$;
import js7.base.time.TestScheduler$State$;
import js7.base.time.TestScheduler$Task$;
import js7.base.time.Timestamp;
import js7.base.time.Timestamp$;
import js7.base.utils.AsyncLock;
import js7.base.utils.AsyncLock$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.BuildFrom$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.immutable.VectorBuilder;
import scala.collection.mutable.SortedSet;
import scala.collection.mutable.SortedSet$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordered;
import scala.math.Ordering$;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven;
import scala.util.Random$;
import sourcecode.Enclosing;
import sourcecode.Enclosing$;

public final class TestScheduler
implements Scheduler {
    private final IORuntime ioRuntime;
    private final AsyncLock clockLock;
    private final SortedSet<Task> queue;
    public volatile State js7$base$time$TestScheduler$$_state;
    private final AtomicLong nextId;
    public final TestScheduler$Task$ Task$lzy1;

    public TestScheduler(Timestamp start, IORuntime ioRuntime) {
        block0: {
            this.ioRuntime = ioRuntime;
            this.Task$lzy1 = new TestScheduler$Task$(this);
            this.clockLock = AsyncLock$.MODULE$.apply(Enclosing$.MODULE$.apply("js7.base.time.TestScheduler#clockLock"));
            this.queue = (SortedSet)SortedSet$.MODULE$.empty((Object)Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            this.js7$base$time$TestScheduler$$_state = TestScheduler$State$.MODULE$.apply(0L, start.toEpochMilli());
            this.nextId = new AtomicLong(1L);
            Logger LoggerImpl_this = TestScheduler$.js7$base$time$TestScheduler$$$logger;
            if (!LoggerImpl_this.underlying().isInfoEnabled()) break block0;
            LoggerImpl_this.underlying().info("new \u23f0 {} _monotonicNanos={}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.now(), BoxesRunTime.boxToLong((long)this.js7$base$time$TestScheduler$$_state.monotonicNanos())}), Object.class));
        }
    }

    private final IORuntime given_IORuntime() {
        return this.ioRuntime;
    }

    public Runnable sleep(FiniteDuration delay, Runnable runnable) {
        long id = this.nextId.getAndIncrement();
        Task task = this.Task().apply(this.js7$base$time$TestScheduler$$_state.monotonicNanos() + delay.toNanos(), id, runnable);
        Logger LoggerImpl_this = TestScheduler$.js7$base$time$TestScheduler$$$logger;
        if (LoggerImpl_this.underlying().isTraceEnabled()) {
            LoggerImpl_this.underlying().trace("\u23f0 sleep {}", (Object)task);
        }
        TestScheduler testScheduler = this;
        synchronized (testScheduler) {
            SortedSet cfr_ignored_0 = (SortedSet)this.queue.$plus$eq((Object)task);
        }
        this.logTasks(true);
        return () -> {
            TestScheduler testScheduler = this;
            synchronized (testScheduler) {
                SortedSet cfr_ignored_0 = (SortedSet)this.queue.$minus$eq((Object)task);
            }
        };
    }

    public long monotonicNanos() {
        return this.js7$base$time$TestScheduler$$_state.monotonicNanos();
    }

    public long nowMillis() {
        return this.js7$base$time$TestScheduler$$_state.nowMillis();
    }

    public Timestamp now() {
        return Timestamp$.MODULE$.ofEpochMilli(this.nowMillis());
    }

    public <A> A lock(Function0<A> body, NotGiven<.less.colon.less<A, IO<?>>> x2) {
        return this.syncLockClock(body);
    }

    public <A> IO<A> lockIO(Function1<Timestamp, IO<A>> body, Enclosing x$2) {
        return this.clockLock.lock(IO$.MODULE$.defer(() -> this.lockIO$$anonfun$1(body)), x$2, ScalaSourceLocation$.MODULE$.apply("TestScheduler.scala", 58));
    }

    public void resetNow(Timestamp timestamp) {
        this.syncLockClock((Function0 & Serializable)() -> {
            this.resetNow$$anonfun$1(timestamp);
            return BoxedUnit.UNIT;
        });
    }

    public void tick(FiniteDuration duration) {
        this.syncLockClock((Function0 & Serializable)() -> {
            this.tick$$anonfun$1(duration);
            return BoxedUnit.UNIT;
        });
    }

    private Vector<Task> awokenTasks() {
        Task task;
        this.logTasks(true);
        VectorBuilder tasks = new VectorBuilder();
        long now = this.js7$base$time$TestScheduler$$_state.monotonicNanos();
        while (this.queue.nonEmpty() && now >= (task = (Task)this.queue.head()).at()) {
            tasks.$plus$eq((Object)task);
            this.queue.remove((Object)task);
        }
        return tasks.result();
    }

    private <A> A syncLockClock(Function0<A> body) {
        return (A)this.clockLock.lock(IO$.MODULE$.apply(body), Enclosing$.MODULE$.apply("js7.base.time.TestScheduler#syncLockClock"), ScalaSourceLocation$.MODULE$.apply("TestScheduler.scala", 100)).unsafeRunSync(this.given_IORuntime());
    }

    private void logTasks(boolean indent) {
        Logger LoggerImpl_this = TestScheduler$.js7$base$time$TestScheduler$$$logger;
        if (LoggerImpl_this.underlying().isTraceEnabled()) {
            Vector vector;
            TestScheduler testScheduler = this;
            synchronized (testScheduler) {
                vector = package$.MODULE$.Vector().from(this.queue);
            }
            Vector tasks = vector;
            if (tasks.nonEmpty()) {
                ObjectRef prefix = ObjectRef.create((Object)"");
                ObjectRef lastPrefix = ObjectRef.create((Object)"");
                if (indent) {
                    prefix.elem = "\u2502 ";
                    lastPrefix.elem = "\u2514\u2574";
                }
                Task last = (Task)tasks.last();
                tasks.foreach((Function1)(JProcedure1 & Serializable)task -> {
                    String prfx = task == last ? (String)lastPrefix$1.elem : (String)prefix$1.elem;
                    Logger LoggerImpl_this = TestScheduler$.js7$base$time$TestScheduler$$$logger;
                    if (LoggerImpl_this.underlying().isTraceEnabled()) {
                        LoggerImpl_this.underlying().trace(" {}Task queue: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{prfx, task}), Object.class));
                        return;
                    }
                });
                return;
            }
            return;
        }
    }

    private boolean logTasks$default$1() {
        return false;
    }

    private final TestScheduler$Task$ Task() {
        return this.Task$lzy1;
    }

    private final IO lockIO$$anonfun$1(Function1 body$1) {
        return (IO)body$1.apply((Object)this.now());
    }

    private final void resetNow$$anonfun$1(Timestamp timestamp$1) {
        TestScheduler testScheduler = this;
        synchronized (testScheduler) {
            State state = this.js7$base$time$TestScheduler$$_state;
            long l = this.js7$base$time$TestScheduler$$_state.wallTimeShift() + timestamp$1.$minus(this.now()).toMillis();
            long l2 = state.copy$default$1();
            this.js7$base$time$TestScheduler$$_state = state.copy(l2, l);
            Logger LoggerImpl_this = TestScheduler$.js7$base$time$TestScheduler$$$logger;
            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                LoggerImpl_this.underlying().info("resetNow \u23f0 := {}", (Object)this.now());
            }
        }
        this.logTasks(true);
    }

    private static final String $anonfun$1() {
        return "+";
    }

    private final void tick$$anonfun$1(FiniteDuration duration$1) {
        Vector<Task> vector;
        TestScheduler testScheduler = this;
        synchronized (testScheduler) {
            if (ScalaTime$RichFiniteDuration$.MODULE$.isZero$extension(ScalaTime$.MODULE$.RichFiniteDuration(duration$1))) {
                Logger LoggerImpl_this = TestScheduler$.js7$base$time$TestScheduler$$$logger;
                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("\u23f0 tick {}", (Object)this.now());
                }
            } else {
                State state = this.js7$base$time$TestScheduler$$_state;
                this.js7$base$time$TestScheduler$$_state = state.copy(this.js7$base$time$TestScheduler$$_state.monotonicNanos() + duration$1.toNanos(), state.copy$default$2());
                String plus = ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(ScalaTime$RichFiniteDuration$.MODULE$.isPositive$extension(ScalaTime$.MODULE$.RichFiniteDuration(duration$1))), (Function0<String>)((Function0 & Serializable)TestScheduler::$anonfun$1));
                Logger LoggerImpl_this = TestScheduler$.js7$base$time$TestScheduler$$$logger;
                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("\u23f0 tick {} {}{}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.now(), plus, ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(duration$1))}), Object.class));
                }
            }
            vector = this.awokenTasks();
        }
        Vector<Task> tasks = vector;
        ((Vector)Random$.MODULE$.shuffle(tasks, BuildFrom$.MODULE$.buildFromIterableOps())).foreach((Function1)(JProcedure1 & Serializable)task -> {
            Logger LoggerImpl_this = TestScheduler$.js7$base$time$TestScheduler$$$logger;
            if (LoggerImpl_this.underlying().isTraceEnabled()) {
                LoggerImpl_this.underlying().trace("\ud83d\udd14 tick: run {}", task);
            }
            task.runnable().run();
        });
    }

    public static final String js7$base$time$TestScheduler$Task$$_$_$$anonfun$2() {
        return "+";
    }

    public static class State
    implements Product,
    Serializable {
        private final long monotonicNanos;
        private final long wallTimeShift;

        public static State apply(long l, long l2) {
            return TestScheduler$State$.MODULE$.apply(l, l2);
        }

        public static State fromProduct(Product product) {
            return TestScheduler$State$.MODULE$.fromProduct(product);
        }

        public static State unapply(State state) {
            return TestScheduler$State$.MODULE$.unapply(state);
        }

        public State(long monotonicNanos, long wallTimeShift) {
            this.monotonicNanos = monotonicNanos;
            this.wallTimeShift = wallTimeShift;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)80204913);
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.monotonicNanos()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.wallTimeShift()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            State state;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state2 = state = (State)object;
            if (this.monotonicNanos() != state2.monotonicNanos()) return false;
            if (this.wallTimeShift() != state2.wallTimeShift()) return false;
            if (!state2.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            long l;
            int n2 = n;
            if (0 == n2) {
                l = this._1();
            } else if (1 == n2) {
                l = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToLong((long)l);
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "monotonicNanos";
            }
            if (1 == n2) {
                return "wallTimeShift";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long monotonicNanos() {
            return this.monotonicNanos;
        }

        public long wallTimeShift() {
            return this.wallTimeShift;
        }

        public long nowMillis() {
            return this.wallTimeShift() + this.monotonicNanos() / 1000000L;
        }

        public State copy(long monotonicNanos, long wallTimeShift) {
            return new State(monotonicNanos, wallTimeShift);
        }

        public long copy$default$1() {
            return this.monotonicNanos();
        }

        public long copy$default$2() {
            return this.wallTimeShift();
        }

        public long _1() {
            return this.monotonicNanos();
        }

        public long _2() {
            return this.wallTimeShift();
        }
    }

    public final class Task
    implements Ordered<Task>,
    Product,
    Serializable {
        private final long at;
        private final long id;
        private final Runnable runnable;
        private final /* synthetic */ TestScheduler $outer;

        public Task(TestScheduler $outer, long at, long id, Runnable runnable) {
            this.at = at;
            this.id = id;
            this.runnable = runnable;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Ordered.$init$((Ordered)this);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)2599333);
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.at()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.id()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.runnable()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            Task task;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Task)) return false;
            if (((Task)object).js7$base$time$TestScheduler$Task$$$outer() != this.$outer) return false;
            Task task2 = task = (Task)object;
            if (this.at() != task2.at()) return false;
            if (this.id() != task2.id()) return false;
            Runnable runnable = this.runnable();
            Runnable runnable2 = task2.runnable();
            if (runnable != null) {
                if (!runnable.equals(runnable2)) return false;
                return true;
            }
            if (runnable2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Task;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Task";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "at";
                }
                case 1: {
                    return "id";
                }
                case 2: {
                    return "runnable";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long at() {
            return this.at;
        }

        public long id() {
            return this.id;
        }

        public Runnable runnable() {
            return this.runnable;
        }

        public int compare(Task that) {
            int n = new RichLong(Predef$.MODULE$.longWrapper(this.at())).compare((Object)BoxesRunTime.boxToLong((long)that.at()));
            if (0 == n) {
                return Long.compare(this.id(), that.id());
            }
            int i = n;
            return i;
        }

        public String toString() {
            State state = this.$outer.js7$base$time$TestScheduler$$_state;
            long current = state.monotonicNanos();
            String plus = ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(this.at() <= state.monotonicNanos()), (Function0<String>)((Function0 & Serializable)TestScheduler::js7$base$time$TestScheduler$Task$$_$_$$anonfun$2));
            return Timestamp$.MODULE$.ofEpochMilli(state.wallTimeShift() + this.at() / 1000000L) + (" due=" + plus + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$DurationRichLong$.MODULE$.ns$extension(ScalaTime$.MODULE$.DurationRichLong(state.monotonicNanos() - this.at())))) + " " + this.runnable());
        }

        public Task copy(long at, long id, Runnable runnable) {
            return new Task(this.$outer, at, id, runnable);
        }

        public long copy$default$1() {
            return this.at();
        }

        public long copy$default$2() {
            return this.id();
        }

        public Runnable copy$default$3() {
            return this.runnable();
        }

        public long _1() {
            return this.at();
        }

        public long _2() {
            return this.id();
        }

        public Runnable _3() {
            return this.runnable();
        }

        public final /* synthetic */ TestScheduler js7$base$time$TestScheduler$Task$$$outer() {
            return this.$outer;
        }
    }
}

