/*
 * Decompiled with CFR 0.152.
 */
package js7.base.utils;

import cats.Applicative;
import cats.Functor;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Fiber;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Resource;
import cats.effect.package$;
import cats.effect.std.Mutex;
import cats.effect.std.Mutex$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.catsutils.UnsafeMemoizable$;
import js7.base.log.BlockingSymbol;
import js7.base.log.LogLevel;
import js7.base.log.LogLevel$;
import js7.base.log.Slf4jUtils$syntax$;
import js7.base.log.Slf4jUtils$syntax$LevelLogger$;
import js7.base.monixutils.SimpleLock;
import js7.base.scalasource.ScalaSourceLocation;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichDeadline$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.AsyncLock$;
import js7.base.utils.AsyncLock$AsyncLockMXBean$;
import js7.base.utils.AsyncLock$WithLogging$EmptyState$;
import js7.base.utils.AsyncLock$WithLogging$NotQueueingState$;
import js7.base.utils.AsyncLock$WithLogging$QueueingState$;
import js7.base.utils.Atomic$package$Atomic$extensions$;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.View$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.Arrays$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ObjectRef;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import sourcecode.Enclosing;
import sourcecode.Enclosing$;

public interface AsyncLock {
    public static AsyncLock apply(boolean bl, Enclosing enclosing) {
        return AsyncLock$.MODULE$.apply(bl, enclosing);
    }

    public static AsyncLock apply(Enclosing enclosing) {
        return AsyncLock$.MODULE$.apply(enclosing);
    }

    public static AsyncLock apply(String string, IterableOnce<FiniteDuration> iterableOnce, boolean bl, boolean bl2) {
        return AsyncLock$.MODULE$.apply(string, iterableOnce, bl, bl2);
    }

    public static AsyncLock dontLog() {
        return AsyncLock$.MODULE$.dontLog();
    }

    public static AsyncLock supressLog(Enclosing enclosing) {
        return AsyncLock$.MODULE$.supressLog(enclosing);
    }

    public static IterableOnce<FiniteDuration> apply$default$2() {
        return AsyncLock$.MODULE$.apply$default$2();
    }

    public static boolean apply$default$3() {
        return AsyncLock$.MODULE$.apply$default$3();
    }

    public static boolean apply$default$4() {
        return AsyncLock$.MODULE$.apply$default$4();
    }

    public Resource<IO, BoxedUnit> resource(Function0<String> var1);

    public static Resource resource$(AsyncLock $this, Enclosing src, ScalaSourceLocation loc) {
        return $this.resource(src, loc);
    }

    default public Resource<IO, BoxedUnit> resource(Enclosing src, ScalaSourceLocation loc) {
        return this.resource((Function0<String>)((Function0 & Serializable)() -> this.resource$$anonfun$1(src, loc)));
    }

    public static IO lock$(AsyncLock $this, IO io, Enclosing src, ScalaSourceLocation loc) {
        return $this.lock(io, src, loc);
    }

    default public <A> IO<A> lock(IO<A> io, Enclosing src, ScalaSourceLocation loc) {
        return this.lock((Function0<String>)((Function0 & Serializable)() -> AsyncLock.lock$$anonfun$1(src)), io, loc);
    }

    public static IO lock$(AsyncLock $this, Function0 acquirer, IO body, ScalaSourceLocation loc) {
        return $this.lock((Function0<String>)acquirer, body, loc);
    }

    default public <A> IO<A> lock(Function0<String> acquirer, IO<A> body, ScalaSourceLocation loc) {
        return (IO)this.resource((Function0<String>)((Function0 & Serializable)() -> this.lock$$anonfun$2(acquirer, loc))).surround(body, (MonadCancel)IO$.MODULE$.asyncForIO());
    }

    private String toAcquirerLabel(String acquirer, ScalaSourceLocation loc) {
        return acquirer + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(acquirer))), (Function0<String>)((Function0 & Serializable)AsyncLock::toAcquirerLabel$$anonfun$1)) + "at " + loc;
    }

    private String resource$$anonfun$1(Enclosing src$1, ScalaSourceLocation loc$1) {
        return this.toAcquirerLabel(src$1.value(), loc$1);
    }

    private static String lock$$anonfun$1(Enclosing src$2) {
        return src$2.value();
    }

    private String lock$$anonfun$2(Function0 acquirer$1, ScalaSourceLocation loc$2) {
        return this.toAcquirerLabel((String)acquirer$1.apply(), loc$2);
    }

    private static String toAcquirerLabel$$anonfun$1() {
        return " ";
    }

    public static interface AsyncLockMXBean {
        public static AtomicInteger locked() {
            return AsyncLock$AsyncLockMXBean$.MODULE$.locked();
        }

        public static int ordinal(AsyncLockMXBean asyncLockMXBean) {
            return AsyncLock$AsyncLockMXBean$.MODULE$.ordinal(asyncLockMXBean);
        }

        public static AtomicInteger queued() {
            return AsyncLock$AsyncLockMXBean$.MODULE$.queued();
        }

        public static AtomicLong usedTotal() {
            return AsyncLock$AsyncLockMXBean$.MODULE$.usedTotal();
        }

        public int getLockedCount();

        public int getQueuedCount();

        public long getUsedTotal();
    }

    public static final class NoLogging
    implements AsyncLock {
        private final String name;
        private final IO<Mutex<IO>> mutex;

        public NoLogging(String name) {
            this.name = name;
            this.mutex = (IO)UnsafeMemoizable$.MODULE$.memoize(Mutex$.MODULE$.apply((GenConcurrent)IO$.MODULE$.asyncForIO()), IO$.MODULE$.asyncForIO());
        }

        @Override
        public Resource<IO, BoxedUnit> resource(Function0<String> acquirer) {
            return package$.MODULE$.Resource().eval(this.mutex).flatMap(AsyncLock$::js7$base$utils$AsyncLock$NoLogging$$_$resource$$anonfun$2);
        }

        public String toString() {
            return "AsyncLock:" + this.name;
        }
    }

    public static final class WithLogging
    implements AsyncLock {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(WithLogging.class.getDeclaredField("EmptyState$lzy1"));
        private final String name;
        private final IterableOnce<FiniteDuration> logWorryDurations;
        private final boolean logMinor;
        private final SimpleLock<IO> mutex;
        private final SimpleLock<IO> stateMutex;
        private final AtomicReference<State> stateVar;
        private volatile Object EmptyState$lzy1;
        public final AsyncLock$WithLogging$NotQueueingState$ NotQueueingState$lzy1;
        public final AsyncLock$WithLogging$QueueingState$ QueueingState$lzy1;

        public WithLogging(String name, IterableOnce<FiniteDuration> logWorryDurations, boolean logMinor) {
            this.name = name;
            this.logWorryDurations = logWorryDurations;
            this.logMinor = logMinor;
            this.NotQueueingState$lzy1 = new AsyncLock$WithLogging$NotQueueingState$(this);
            this.QueueingState$lzy1 = new AsyncLock$WithLogging$QueueingState$(this);
            this.mutex = new SimpleLock(IO$.MODULE$.asyncForIO());
            this.stateMutex = new SimpleLock(IO$.MODULE$.asyncForIO());
            this.stateVar = new AtomicReference<AsyncLock$WithLogging$EmptyState$>(this.EmptyState());
        }

        public boolean isLocked() {
            return this.stateVar.get() instanceof LockedState;
        }

        private long queueLength() {
            return this.stateVar.get().queueLength();
        }

        @Override
        public Resource<IO, BoxedUnit> resource(Function0<String> acquirer) {
            return this.logAcquisition(acquirer).flatMap((Function1 & Serializable)onAcquired -> this.mutex.resource().flatMap(arg_0 -> AsyncLock$.js7$base$utils$AsyncLock$WithLogging$$_$resource$$anonfun$3$$anonfun$1(onAcquired, arg_0)));
        }

        private Resource<IO, IO<BoxedUnit>> logAcquisition(Function0<String> acquirer) {
            return CatsEffectExtensions$.MODULE$.defer(package$.MODULE$.Resource(), () -> this.logAcquisition$$anonfun$1(acquirer), IO$.MODULE$.asyncForIO());
        }

        private Resource<IO, BoxedUnit> logWaitingResource(String acquirer, long nr) {
            return package$.MODULE$.Resource().makeCase((Object)this.stateMutex.surround(IO$.MODULE$.defer(() -> this.logWaitingResource$$anonfun$1(acquirer, nr))), (Function2 & Serializable)(_$4, exitCase) -> this.stateMutex.surround(IO$.MODULE$.defer(this::logWaitingResource$$anonfun$2$$anonfun$1)), (Functor)IO$.MODULE$.asyncForIO());
        }

        public String toString() {
            return "AsyncLock:" + this.name;
        }

        private final AsyncLock$WithLogging$EmptyState$ EmptyState() {
            Object object = this.EmptyState$lzy1;
            if (object instanceof AsyncLock$WithLogging$EmptyState$) {
                return (AsyncLock$WithLogging$EmptyState$)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (AsyncLock$WithLogging$EmptyState$)this.EmptyState$lzyINIT1();
        }

        private Object EmptyState$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.EmptyState$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        AsyncLock$WithLogging$EmptyState$ asyncLock$WithLogging$EmptyState$ = null;
                        try {
                            asyncLock$WithLogging$EmptyState$ = new AsyncLock$WithLogging$EmptyState$();
                            object2 = asyncLock$WithLogging$EmptyState$ == null ? LazyVals.NullValue$.MODULE$ : asyncLock$WithLogging$EmptyState$;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.EmptyState$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return asyncLock$WithLogging$EmptyState$;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public final AsyncLock$WithLogging$NotQueueingState$ js7$base$utils$AsyncLock$WithLogging$$NotQueueingState() {
            return this.NotQueueingState$lzy1;
        }

        public final AsyncLock$WithLogging$QueueingState$ js7$base$utils$AsyncLock$WithLogging$$QueueingState() {
            return this.QueueingState$lzy1;
        }

        private final String nrString$lzyINIT1$1(LazyRef nrString$lzy1$1, int nr$1) {
            String string;
            LazyRef lazyRef = nrString$lzy1$1;
            synchronized (lazyRef) {
                string = (String)(nrString$lzy1$1.initialized() ? nrString$lzy1$1.value() : nrString$lzy1$1.initialize((Object)("\u2020" + nr$1)));
            }
            return string;
        }

        private final String nrString$1(LazyRef nrString$lzy1$2, int nr$2) {
            return (String)(nrString$lzy1$2.initialized() ? nrString$lzy1$2.value() : this.nrString$lzyINIT1$1(nrString$lzy1$2, nr$2));
        }

        private final String acquirer_$lzyINIT1$1(LazyRef acquirer_$lzy1$1, Function0 acquirer$2) {
            String string;
            LazyRef lazyRef = acquirer_$lzy1$1;
            synchronized (lazyRef) {
                string = (String)(acquirer_$lzy1$1.initialized() ? acquirer_$lzy1$1.value() : acquirer_$lzy1$1.initialize((Object)((String)acquirer$2.apply())));
            }
            return string;
        }

        private final String acquirer_$1(LazyRef acquirer_$lzy1$2, Function0 acquirer$4) {
            return (String)(acquirer_$lzy1$2.initialized() ? acquirer_$lzy1$2.value() : this.acquirer_$lzyINIT1$1(acquirer_$lzy1$2, acquirer$4));
        }

        private final void logBeforeAcquire$1$$anonfun$1$$anonfun$1(BooleanRef firstLogged$3, BlockingSymbol sym$3, Deadline since$3, LazyRef nrString$lzy1$5, int nr$5, LazyRef acquirer_$lzy1$5, Function0 acquirer$7) {
            if (!firstLogged$3.elem) {
                Logger LoggerImpl_this = AsyncLock$.js7$base$utils$AsyncLock$$$logger;
                if (LoggerImpl_this.underlying().isTraceEnabled()) {
                    LoggerImpl_this.underlying().trace("\u26aa\ufe0f{} {} is being acquired by {} ...", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.nrString$1(nrString$lzy1$5, nr$5), this.name, this.acquirer_$1(acquirer_$lzy1$5, acquirer$7)}), Object.class));
                }
                firstLogged$3.elem = true;
                return;
            }
            sym$3.onInfo();
            Logger LoggerImpl_this = AsyncLock$.js7$base$utils$AsyncLock$$$logger;
            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                LoggerImpl_this.underlying().info("{}{} {}: {} is still waiting for {} ({} queuing)...", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{sym$3, this.nrString$1(nrString$lzy1$5, nr$5), this.name, this.acquirer_$1(acquirer_$lzy1$5, acquirer$7), ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(since$3)))), BoxesRunTime.boxToLong((long)this.queueLength())}), Object.class));
                return;
            }
        }

        private final String message$proxy3$1(Deadline since$5, LazyRef nrString$lzy1$7, int nr$7) {
            return "\u25fc\ufe0f " + this.nrString$1(nrString$lzy1$7, nr$7) + " " + this.name + " acquisition canceled after " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(since$5)))) + " \u2199";
        }

        private final String logBeforeAcquire$1$$anonfun$2$$anonfun$1(Deadline since$25, LazyRef nrString$lzy1$22, int nr$26) {
            return this.message$proxy3$1(since$25, nrString$lzy1$22, nr$26);
        }

        private final void logBeforeAcquire$1$$anonfun$2(BooleanRef acquired$2, BlockingSymbol sym$4, Deadline since$4, LazyRef nrString$lzy1$6, int nr$6) {
            if (!acquired$2.elem && sym$4.used()) {
                LogLevel level$proxy1 = sym$4.logLevel();
                Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(AsyncLock$.js7$base$utils$AsyncLock$$$logger.underlying()), level$proxy1, (Function0<String>)((Function0 & Serializable)() -> this.logBeforeAcquire$1$$anonfun$2$$anonfun$1(since$4, nrString$lzy1$6, nr$6)));
                return;
            }
        }

        private final IO logBeforeAcquire$1(BooleanRef firstLogged$1, BlockingSymbol sym$1, Deadline since$1, BooleanRef acquired$1, LazyRef nrString$lzy1$3, int nr$3, LazyRef acquirer_$lzy1$3, Function0 acquirer$5) {
            return CatsUtils$syntax$.MODULE$.whenItTakesLonger(IO$.MODULE$.never(), (IterableOnce<FiniteDuration>)((IterableOnce)View$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FiniteDuration[]{ScalaTime$.MODULE$.ZeroDuration()})).$plus$plus(this.logWorryDurations)), (Function1<FiniteDuration, IO<BoxedUnit>>)(Function1 & Serializable)_$2 -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
                this.logBeforeAcquire$1$$anonfun$1$$anonfun$1(firstLogged$1, sym$1, since$1, nrString$lzy1$3, nr$3, acquirer_$lzy1$3, acquirer$5);
                return BoxedUnit.UNIT;
            })).onCancel(IO$.MODULE$.apply((Function0 & Serializable)() -> {
                this.logBeforeAcquire$1$$anonfun$2(acquired$1, sym$1, since$1, nrString$lzy1$3, nr$3);
                return BoxedUnit.UNIT;
            }));
        }

        private final String message$proxy4$1(Deadline since$8, LazyRef nrString$lzy1$10, int nr$10, LazyRef acquirer_$lzy1$8, Function0 acquirer$10) {
            return "\u2198 \ud83d\udfe2" + this.nrString$1(nrString$lzy1$10, nr$10) + " " + this.name + " acquired by " + this.acquirer_$1(acquirer_$lzy1$8, acquirer$10) + " \u00b7 " + this.queueLength() + " queuing \u00b7 " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(since$8)))) + " \u2198";
        }

        private final String logAfterAcquire$1$$anonfun$1$$anonfun$1(Deadline since$27, LazyRef nrString$lzy1$24, int nr$28, LazyRef acquirer_$lzy1$20, Function0 acquirer$24) {
            return this.message$proxy4$1(since$27, nrString$lzy1$24, nr$28, acquirer_$lzy1$20, acquirer$24);
        }

        private final void logAfterAcquire$1$$anonfun$1(BlockingSymbol sym$6, Deadline since$7, LazyRef nrString$lzy1$9, int nr$9, LazyRef acquirer_$lzy1$7, Function0 acquirer$9) {
            if (sym$6.used()) {
                LogLevel level$proxy2 = sym$6.relievedLogLevel();
                Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(AsyncLock$.js7$base$utils$AsyncLock$$$logger.underlying()), level$proxy2, (Function0<String>)((Function0 & Serializable)() -> this.logAfterAcquire$1$$anonfun$1$$anonfun$1(since$7, nrString$lzy1$9, nr$9, acquirer_$lzy1$7, acquirer$9)));
                return;
            }
        }

        private final IO logAfterAcquire$1(BlockingSymbol sym$5, Deadline since$6, LazyRef nrString$lzy1$8, int nr$8, LazyRef acquirer_$lzy1$6, Function0 acquirer$8) {
            return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                this.logAfterAcquire$1$$anonfun$1(sym$5, since$6, nrString$lzy1$8, nr$8, acquirer_$lzy1$6, acquirer$8);
                return BoxedUnit.UNIT;
            });
        }

        private final String message$proxy5$1(Deadline since$11, LazyRef nrString$lzy1$13, int nr$13, LazyRef acquirer_$lzy1$11, Function0 acquirer$13) {
            return "\u2199 \u26aa\ufe0f" + this.nrString$1(nrString$lzy1$13, nr$13) + " " + this.name + " released by " + this.acquirer_$1(acquirer_$lzy1$11, acquirer$13) + " \u00b7 " + this.queueLength() + " queuing \u00b7 " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(since$11)))) + " \u2199";
        }

        private final String logRelease$1$$anonfun$1$$anonfun$1(Deadline since$29, LazyRef nrString$lzy1$26, int nr$30, LazyRef acquirer_$lzy1$22, Function0 acquirer$26) {
            return this.message$proxy5$1(since$29, nrString$lzy1$26, nr$30, acquirer_$lzy1$22, acquirer$26);
        }

        private final String message$proxy6$1(Deadline since$12, LazyRef nrString$lzy1$14, int nr$14, LazyRef acquirer_$lzy1$12, Function0 acquirer$14) {
            return "\u2199 \u25fc\ufe0f " + this.nrString$1(nrString$lzy1$14, nr$14) + " " + this.name + " released by " + this.acquirer_$1(acquirer_$lzy1$12, acquirer$14) + " \u00b7 Canceled \u00b7 " + this.queueLength() + " queuing \u00b7 " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(since$12)))) + " \u2199";
        }

        private final String logRelease$1$$anonfun$1$$anonfun$2(Deadline since$30, LazyRef nrString$lzy1$27, int nr$31, LazyRef acquirer_$lzy1$23, Function0 acquirer$27) {
            return this.message$proxy6$1(since$30, nrString$lzy1$27, nr$31, acquirer_$lzy1$23, acquirer$27);
        }

        private final String message$proxy7$1(Deadline since$13, Throwable t$1, LazyRef nrString$lzy1$15, int nr$15, LazyRef acquirer_$lzy1$13, Function0 acquirer$15) {
            Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t$1);
            return "\u2199 \ud83d\udca5" + this.nrString$1(nrString$lzy1$15, nr$15) + " " + this.name + " released by " + this.acquirer_$1(acquirer_$lzy1$13, acquirer$15) + " \u00b7 " + this.queueLength() + " queuing \u00b7 " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(since$13)))) + " \u00b7 " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable) + " \u2199";
        }

        private final String logRelease$1$$anonfun$1$$anonfun$3(Deadline since$31, Throwable t$2, LazyRef nrString$lzy1$28, int nr$32, LazyRef acquirer_$lzy1$24, Function0 acquirer$28) {
            return this.message$proxy7$1(since$31, t$2, nrString$lzy1$28, nr$32, acquirer_$lzy1$24, acquirer$28);
        }

        private final void logRelease$1$$anonfun$1(BooleanRef acquisitionMinorLogged$2, BlockingSymbol sym$8, Resource.ExitCase exitCase$1, Deadline since$10, LazyRef nrString$lzy1$12, int nr$12, LazyRef acquirer_$lzy1$10, Function0 acquirer$12) {
            if (acquisitionMinorLogged$2.elem || sym$8.used()) {
                LogLevel logLevel = sym$8.used() ? sym$8.logLevel() : LogLevel$.Trace;
                Resource.ExitCase exitCase = exitCase$1;
                package$.MODULE$.Resource();
                if (Resource.ExitCase$.Succeeded$.MODULE$.equals(exitCase)) {
                    Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(AsyncLock$.js7$base$utils$AsyncLock$$$logger.underlying()), logLevel, (Function0<String>)((Function0 & Serializable)() -> this.logRelease$1$$anonfun$1$$anonfun$1(since$10, nrString$lzy1$12, nr$12, acquirer_$lzy1$10, acquirer$12)));
                    return;
                }
                package$.MODULE$.Resource();
                if (Resource.ExitCase$.Canceled$.MODULE$.equals(exitCase)) {
                    Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(AsyncLock$.js7$base$utils$AsyncLock$$$logger.underlying()), logLevel, (Function0<String>)((Function0 & Serializable)() -> this.logRelease$1$$anonfun$1$$anonfun$2(since$10, nrString$lzy1$12, nr$12, acquirer_$lzy1$10, acquirer$12)));
                    return;
                }
                if (exitCase instanceof Resource.ExitCase$.Errored) {
                    Throwable throwable;
                    Resource.ExitCase$.Errored errored = (Resource.ExitCase$.Errored)exitCase;
                    package$.MODULE$.Resource();
                    Resource.ExitCase$.Errored errored2 = Resource.ExitCase$.Errored$.MODULE$.unapply(errored);
                    Throwable t = throwable = errored2._1();
                    LogLevel level$proxy3 = sym$8.logLevel();
                    Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(AsyncLock$.js7$base$utils$AsyncLock$$$logger.underlying()), level$proxy3, (Function0<String>)((Function0 & Serializable)() -> this.logRelease$1$$anonfun$1$$anonfun$3(since$10, t, nrString$lzy1$12, nr$12, acquirer_$lzy1$10, acquirer$12)));
                    return;
                }
                throw new MatchError((Object)exitCase);
            }
        }

        private final IO logRelease$1(BooleanRef acquisitionMinorLogged$1, BlockingSymbol sym$7, Deadline since$9, LazyRef nrString$lzy1$11, int nr$11, LazyRef acquirer_$lzy1$9, Function0 acquirer$11, Resource.ExitCase exitCase) {
            return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                this.logRelease$1$$anonfun$1(acquisitionMinorLogged$1, sym$7, exitCase, since$9, nrString$lzy1$11, nr$11, acquirer_$lzy1$9, acquirer$11);
                return BoxedUnit.UNIT;
            });
        }

        private final Resource logAcquisitionResource$1(BooleanRef acquired$3, BooleanRef firstLogged$4, BlockingSymbol sym$9, Deadline since$14, LazyRef nrString$lzy1$16, int nr$16, LazyRef acquirer_$lzy1$14, Function0 acquirer$16, BooleanRef acquisitionMinorLogged$3) {
            return package$.MODULE$.Resource().makeCase(CatsEffectExtensions$.MODULE$.startAndCatchError(this.logBeforeAcquire$1(firstLogged$4, sym$9, since$14, acquired$3, nrString$lzy1$16, nr$16, acquirer_$lzy1$14, acquirer$16), Enclosing$.MODULE$.apply("js7.base.utils.AsyncLock.WithLogging#logAcquisition logAcquisitionResource")), (Function2 & Serializable)(fiber, exitCase) -> ((IO)fiber.cancel()).$times$greater(this.logRelease$1(acquisitionMinorLogged$3, sym$9, since$14, nrString$lzy1$16, nr$16, acquirer_$lzy1$14, acquirer$16, (Resource.ExitCase)exitCase)), (Functor)IO$.MODULE$.asyncForIO()).evalMap(arg_0 -> AsyncLock$.js7$base$utils$AsyncLock$WithLogging$$_$logAcquisitionResource$1$$anonfun$2(acquired$3, arg_0));
        }

        private final Resource logAcquisition$$anonfun$1(Function0 acquirer$3) {
            LazyRef lazyRef = new LazyRef();
            LazyRef lazyRef2 = new LazyRef();
            BlockingSymbol sym = new BlockingSymbol();
            Deadline since = Deadline$.MODULE$.now();
            int nr = AsyncLock$.js7$base$utils$AsyncLock$$$counter.incrementAndGet();
            BooleanRef acquisitionMinorLogged = BooleanRef.create((boolean)false);
            BooleanRef acquired = BooleanRef.create((boolean)false);
            BooleanRef firstLogged = BooleanRef.create((!this.logMinor ? 1 : 0) != 0);
            return Atomic$package$Atomic$extensions$.MODULE$.countConcurrency(AsyncLock$AsyncLockMXBean$.MODULE$.queued(), IO$.MODULE$.asyncForIO()).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.logWaitingResource(this.acquirer_$1(lazyRef2, acquirer$3), Int$.MODULE$.int2long(nr)).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return (this.logMinor ? this.logAcquisitionResource$1(acquired, firstLogged, sym, since, lazyRef, nr, lazyRef2, acquirer$3, acquisitionMinorLogged) : package$.MODULE$.Resource().unit()).flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return package$.MODULE$.Resource().onFinalize((Object)IO$.MODULE$.apply(AsyncLock$::js7$base$utils$AsyncLock$WithLogging$$_$logAcquisition$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$adapted$1), (Applicative)IO$.MODULE$.asyncForIO()).map((Function1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            acquired$8.elem = true;
                            return this.logAfterAcquire$1(sym, since, lazyRef, nr, lazyRef2, acquirer$3);
                        });
                    });
                });
            });
        }

        private final void logWaitingResource$$anonfun$1$$anonfun$1(String acquirer$22, long nr$22, Deadline since$19) {
            NotQueueingState a$proxy1 = this.js7$base$utils$AsyncLock$WithLogging$$NotQueueingState().apply(acquirer$22, nr$22, since$19);
            this.stateVar.set(a$proxy1);
        }

        private final String message$proxy8$1(BlockingSymbol sym$16, Deadline since$22, String currentAcquirer$5, long currentNr$5, Deadline acquiredSince$5, long queueLength$4) {
            return sym$16 + " " + this.name + " is continuously acquired since " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(since$22)))) + ", currently by " + currentAcquirer$5 + " \u2020" + currentNr$5 + " since " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(acquiredSince$5)))) + " \u00b7 " + queueLength$4 + " queuing";
        }

        private final String logWaitingResource$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(BlockingSymbol sym$22, Deadline since$35, String currentAcquirer$8, long currentNr$6, Deadline acquiredSince$8, long queueLength$6) {
            return this.message$proxy8$1(sym$22, since$35, currentAcquirer$8, currentNr$6, acquiredSince$8, queueLength$6);
        }

        private final void logWaitingResource$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(BlockingSymbol sym$15, ObjectRef relieveLogLevel$2, Deadline since$21) {
            State state = this.stateVar.get();
            if (this.EmptyState().equals(state)) {
                return;
            }
            if (state instanceof NotQueueingState && ((NotQueueingState)state).js7$base$utils$AsyncLock$WithLogging$NotQueueingState$$$outer() == this) {
                NotQueueingState notQueueingState = (NotQueueingState)state;
                return;
            }
            if (state instanceof QueueingState && ((QueueingState)state).js7$base$utils$AsyncLock$WithLogging$QueueingState$$$outer() == this) {
                QueueingState queueingState = (QueueingState)state;
                QueueingState queueingState2 = this.js7$base$utils$AsyncLock$WithLogging$$QueueingState().unapply(queueingState);
                String string = queueingState2._1();
                long l = queueingState2._2();
                Deadline deadline = queueingState2._3();
                long l2 = queueingState2._4();
                Fiber<IO, Throwable, BoxedUnit> fiber = queueingState2._5();
                String currentAcquirer = string;
                long currentNr = l;
                Deadline acquiredSince = deadline;
                long queueLength = l2;
                sym$15.escalateUpTo(2);
                relieveLogLevel$2.elem = sym$15.relievedLogLevel();
                LogLevel level$proxy4 = sym$15.logLevel();
                Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(AsyncLock$.js7$base$utils$AsyncLock$$$logger.underlying()), level$proxy4, (Function0<String>)((Function0 & Serializable)() -> this.logWaitingResource$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(sym$15, since$21, currentAcquirer, currentNr, acquiredSince, queueLength)));
                return;
            }
            throw new MatchError((Object)state);
        }

        private final String message$proxy9$1(String currentAcquirer$6, long nr$23, Deadline acquiredSince$6) {
            return "\ud83d\udfe2 " + this.name + " released by " + currentAcquirer$6 + " \u2020" + nr$23 + " after " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(acquiredSince$6))));
        }

        private final String logWaitingResource$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(String currentAcquirer$9, long nr$36, Deadline acquiredSince$9) {
            return this.message$proxy9$1(currentAcquirer$9, nr$36, acquiredSince$9);
        }

        private final String message$proxy10$1(String currentAcquirer$7, long nr$24, Deadline acquiredSince$7, long queueLength$5) {
            return "\ud83d\udfe2 " + this.name + " released by " + currentAcquirer$7 + " \u2020" + nr$24 + " after " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(acquiredSince$7)))) + ", " + queueLength$5 + " queuing";
        }

        private final String logWaitingResource$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2(String currentAcquirer$10, long nr$37, Deadline acquiredSince$10, long queueLength$7) {
            return this.message$proxy10$1(currentAcquirer$10, nr$37, acquiredSince$10, queueLength$7);
        }

        private final void logWaitingResource$$anonfun$1$$anonfun$2$$anonfun$2(ObjectRef relieveLogLevel$3) {
            State state = this.stateVar.get();
            if (this.EmptyState().equals(state)) {
                return;
            }
            if (state instanceof NotQueueingState && ((NotQueueingState)state).js7$base$utils$AsyncLock$WithLogging$NotQueueingState$$$outer() == this) {
                NotQueueingState notQueueingState = (NotQueueingState)state;
                NotQueueingState notQueueingState2 = this.js7$base$utils$AsyncLock$WithLogging$$NotQueueingState().unapply(notQueueingState);
                String string = notQueueingState2._1();
                long l = notQueueingState2._2();
                Deadline deadline = notQueueingState2._3();
                String currentAcquirer = string;
                long nr = l;
                Deadline acquiredSince = deadline;
                LogLevel level$proxy5 = (LogLevel)relieveLogLevel$3.elem;
                Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(AsyncLock$.js7$base$utils$AsyncLock$$$logger.underlying()), level$proxy5, (Function0<String>)((Function0 & Serializable)() -> this.logWaitingResource$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(currentAcquirer, nr, acquiredSince)));
                return;
            }
            if (state instanceof QueueingState && ((QueueingState)state).js7$base$utils$AsyncLock$WithLogging$QueueingState$$$outer() == this) {
                QueueingState queueingState = (QueueingState)state;
                QueueingState queueingState2 = this.js7$base$utils$AsyncLock$WithLogging$$QueueingState().unapply(queueingState);
                String string = queueingState2._1();
                long l = queueingState2._2();
                Deadline deadline = queueingState2._3();
                long l2 = queueingState2._4();
                Fiber<IO, Throwable, BoxedUnit> fiber = queueingState2._5();
                String currentAcquirer = string;
                long nr = l;
                Deadline acquiredSince = deadline;
                long queueLength = l2;
                LogLevel level$proxy6 = (LogLevel)relieveLogLevel$3.elem;
                Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(AsyncLock$.js7$base$utils$AsyncLock$$$logger.underlying()), level$proxy6, (Function0<String>)((Function0 & Serializable)() -> this.logWaitingResource$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2(currentAcquirer, nr, acquiredSince, queueLength)));
                return;
            }
            throw new MatchError((Object)state);
        }

        private final IO logWaitingResource$$anonfun$1$$anonfun$2(Deadline since$23) {
            ObjectRef relieveLogLevel = ObjectRef.create((Object)LogLevel$.None);
            BlockingSymbol sym = new BlockingSymbol();
            return CatsUtils$syntax$.MODULE$.whenItTakesLonger(IO$.MODULE$.never(), this.logWorryDurations, (Function1<FiniteDuration, IO<BoxedUnit>>)(Function1 & Serializable)_$3 -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
                this.logWaitingResource$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(sym, relieveLogLevel, since$23);
                return BoxedUnit.UNIT;
            })).guarantee(IO$.MODULE$.apply((Function0 & Serializable)() -> {
                this.logWaitingResource$$anonfun$1$$anonfun$2$$anonfun$2(relieveLogLevel);
                return BoxedUnit.UNIT;
            }));
        }

        private final void logWaitingResource$$anonfun$1$$anonfun$4(QueueingState state$2) {
            QueueingState a$proxy3 = state$2.incrementQueue();
            this.stateVar.set(a$proxy3);
        }

        private final IO logWaitingResource$$anonfun$1(String acquirer$21, long nr$21) {
            Deadline since = Deadline$.MODULE$.now();
            State state = this.stateVar.get();
            if (this.EmptyState().equals(state)) {
                return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                    this.logWaitingResource$$anonfun$1$$anonfun$1(acquirer$21, nr$21, since);
                    return BoxedUnit.UNIT;
                });
            }
            if (state instanceof NotQueueingState && ((NotQueueingState)state).js7$base$utils$AsyncLock$WithLogging$NotQueueingState$$$outer() == this) {
                NotQueueingState notQueueingState;
                NotQueueingState state2 = notQueueingState = (NotQueueingState)state;
                return CatsEffectExtensions$.MODULE$.startAndCatchError(IO$.MODULE$.defer(() -> this.logWaitingResource$$anonfun$1$$anonfun$2(since)), Enclosing$.MODULE$.apply("js7.base.utils.AsyncLock.WithLogging#logWaitingResource")).map((Function1)(JProcedure1 & Serializable)fiber -> {
                    QueueingState a$proxy2 = state2.toQueueingState((Fiber<IO, Throwable, BoxedUnit>)fiber);
                    this.stateVar.set(a$proxy2);
                });
            }
            if (state instanceof QueueingState && ((QueueingState)state).js7$base$utils$AsyncLock$WithLogging$QueueingState$$$outer() == this) {
                QueueingState queueingState;
                QueueingState state3 = queueingState = (QueueingState)state;
                return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                    this.logWaitingResource$$anonfun$1$$anonfun$4(state3);
                    return BoxedUnit.UNIT;
                });
            }
            throw new MatchError((Object)state);
        }

        private final void logWaitingResource$$anonfun$2$$anonfun$1$$anonfun$1() {
            this.stateVar.set(this.EmptyState());
        }

        private final void logWaitingResource$$anonfun$2$$anonfun$1$$anonfun$2(QueueingState state$3) {
            QueueingState a$proxy4 = state$3.decrementQueue();
            this.stateVar.set(a$proxy4);
        }

        private final void logWaitingResource$$anonfun$2$$anonfun$1$$anonfun$3(QueueingState state$4) {
            NotQueueingState a$proxy5 = state$4.toNotQueueingState();
            this.stateVar.set(a$proxy5);
        }

        private final IO logWaitingResource$$anonfun$2$$anonfun$1() {
            State state = this.stateVar.get();
            if (this.EmptyState().equals(state)) {
                this.EmptyState();
                return IO$.MODULE$.pure((Object)BoxedUnit.UNIT);
            }
            if (state instanceof NotQueueingState && ((NotQueueingState)state).js7$base$utils$AsyncLock$WithLogging$NotQueueingState$$$outer() == this) {
                NotQueueingState notQueueingState;
                NotQueueingState state2 = notQueueingState = (NotQueueingState)state;
                return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                    this.logWaitingResource$$anonfun$2$$anonfun$1$$anonfun$1();
                    return BoxedUnit.UNIT;
                });
            }
            if (state instanceof QueueingState && ((QueueingState)state).js7$base$utils$AsyncLock$WithLogging$QueueingState$$$outer() == this) {
                QueueingState queueingState = (QueueingState)state;
                QueueingState state3 = queueingState;
                if (state3.queueLength() > 1L) {
                    return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                        this.logWaitingResource$$anonfun$2$$anonfun$1$$anonfun$2(state3);
                        return BoxedUnit.UNIT;
                    });
                }
                return ((IO)state3.loggingFiber().cancel()).$times$greater(IO$.MODULE$.apply((Function0 & Serializable)() -> {
                    this.logWaitingResource$$anonfun$2$$anonfun$1$$anonfun$3(state3);
                    return BoxedUnit.UNIT;
                }));
            }
            throw new MatchError((Object)state);
        }

        public interface LockedState
        extends State {
        }

        public final class NotQueueingState
        implements LockedState,
        Product,
        Serializable {
            private final String currentAcquirer;
            private final long currentNr;
            private final Deadline acquiredSince;
            private final /* synthetic */ WithLogging $outer;

            public NotQueueingState(WithLogging $outer, String currentAcquirer, long currentNr, Deadline acquiredSince) {
                this.currentAcquirer = currentAcquirer;
                this.currentNr = currentNr;
                this.acquiredSince = acquiredSince;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)-229078547);
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.currentAcquirer()));
                n = Statics.mix((int)n, (int)Statics.longHash((long)this.currentNr()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.acquiredSince()));
                return Statics.finalizeHash((int)n, (int)3);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                NotQueueingState notQueueingState;
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof NotQueueingState)) return false;
                if (((NotQueueingState)object).js7$base$utils$AsyncLock$WithLogging$NotQueueingState$$$outer() != this.$outer) return false;
                NotQueueingState notQueueingState2 = notQueueingState = (NotQueueingState)object;
                if (this.currentNr() != notQueueingState2.currentNr()) return false;
                String string = this.currentAcquirer();
                String string2 = notQueueingState2.currentAcquirer();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                Deadline deadline = this.acquiredSince();
                Deadline deadline2 = notQueueingState2.acquiredSince();
                if (deadline == null) {
                    if (deadline2 == null) return true;
                    return false;
                } else {
                    if (!deadline.equals(deadline2)) return false;
                    return true;
                }
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof NotQueueingState;
            }

            public int productArity() {
                return 3;
            }

            public String productPrefix() {
                return "NotQueueingState";
            }

            public Object productElement(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return this._1();
                    }
                    case 1: {
                        return BoxesRunTime.boxToLong((long)this._2());
                    }
                    case 2: {
                        return this._3();
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return "currentAcquirer";
                    }
                    case 1: {
                        return "currentNr";
                    }
                    case 2: {
                        return "acquiredSince";
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String currentAcquirer() {
                return this.currentAcquirer;
            }

            public long currentNr() {
                return this.currentNr;
            }

            public Deadline acquiredSince() {
                return this.acquiredSince;
            }

            @Override
            public long queueLength() {
                return 0L;
            }

            public QueueingState toQueueingState(Fiber<IO, Throwable, BoxedUnit> loggingFiber) {
                return this.$outer.js7$base$utils$AsyncLock$WithLogging$$QueueingState().apply(this.currentAcquirer(), this.currentNr(), this.acquiredSince(), 1L, loggingFiber);
            }

            public NotQueueingState copy(String currentAcquirer, long currentNr, Deadline acquiredSince) {
                return new NotQueueingState(this.$outer, currentAcquirer, currentNr, acquiredSince);
            }

            public String copy$default$1() {
                return this.currentAcquirer();
            }

            public long copy$default$2() {
                return this.currentNr();
            }

            public Deadline copy$default$3() {
                return this.acquiredSince();
            }

            public String _1() {
                return this.currentAcquirer();
            }

            public long _2() {
                return this.currentNr();
            }

            public Deadline _3() {
                return this.acquiredSince();
            }

            public final /* synthetic */ WithLogging js7$base$utils$AsyncLock$WithLogging$NotQueueingState$$$outer() {
                return this.$outer;
            }
        }

        public final class QueueingState
        implements LockedState,
        Product,
        Serializable {
            private final String currentAcquirer;
            private final long currentNr;
            private final Deadline acquiredSince;
            private final long queueLength;
            private final Fiber<IO, Throwable, BoxedUnit> loggingFiber;
            private final /* synthetic */ WithLogging $outer;

            public QueueingState(WithLogging $outer, String currentAcquirer, long currentNr, Deadline acquiredSince, long queueLength, Fiber<IO, Throwable, BoxedUnit> loggingFiber) {
                this.currentAcquirer = currentAcquirer;
                this.currentNr = currentNr;
                this.acquiredSince = acquiredSince;
                this.queueLength = queueLength;
                this.loggingFiber = loggingFiber;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)-381386304);
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.currentAcquirer()));
                n = Statics.mix((int)n, (int)Statics.longHash((long)this.currentNr()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.acquiredSince()));
                n = Statics.mix((int)n, (int)Statics.longHash((long)this.queueLength()));
                n = Statics.mix((int)n, (int)Statics.anyHash(this.loggingFiber()));
                return Statics.finalizeHash((int)n, (int)5);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                QueueingState queueingState;
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof QueueingState)) return false;
                if (((QueueingState)object).js7$base$utils$AsyncLock$WithLogging$QueueingState$$$outer() != this.$outer) return false;
                QueueingState queueingState2 = queueingState = (QueueingState)object;
                if (this.currentNr() != queueingState2.currentNr()) return false;
                if (this.queueLength() != queueingState2.queueLength()) return false;
                String string = this.currentAcquirer();
                String string2 = queueingState2.currentAcquirer();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                Deadline deadline = this.acquiredSince();
                Deadline deadline2 = queueingState2.acquiredSince();
                if (deadline == null) {
                    if (deadline2 != null) {
                        return false;
                    }
                } else if (!deadline.equals(deadline2)) return false;
                Fiber<IO, Throwable, BoxedUnit> fiber = this.loggingFiber();
                Fiber<IO, Throwable, BoxedUnit> fiber2 = queueingState2.loggingFiber();
                if (fiber == null) {
                    if (fiber2 == null) return true;
                    return false;
                } else {
                    if (!fiber.equals(fiber2)) return false;
                    return true;
                }
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof QueueingState;
            }

            public int productArity() {
                return 5;
            }

            public String productPrefix() {
                return "QueueingState";
            }

            public Object productElement(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return this._1();
                    }
                    case 1: {
                        return BoxesRunTime.boxToLong((long)this._2());
                    }
                    case 2: {
                        return this._3();
                    }
                    case 3: {
                        return BoxesRunTime.boxToLong((long)this._4());
                    }
                    case 4: {
                        return this._5();
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return "currentAcquirer";
                    }
                    case 1: {
                        return "currentNr";
                    }
                    case 2: {
                        return "acquiredSince";
                    }
                    case 3: {
                        return "queueLength";
                    }
                    case 4: {
                        return "loggingFiber";
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String currentAcquirer() {
                return this.currentAcquirer;
            }

            public long currentNr() {
                return this.currentNr;
            }

            public Deadline acquiredSince() {
                return this.acquiredSince;
            }

            @Override
            public long queueLength() {
                return this.queueLength;
            }

            public Fiber<IO, Throwable, BoxedUnit> loggingFiber() {
                return this.loggingFiber;
            }

            public QueueingState incrementQueue() {
                long l = this.queueLength() + 1L;
                String string = this.copy$default$1();
                long l2 = this.copy$default$2();
                Deadline deadline = this.copy$default$3();
                Fiber<IO, Throwable, BoxedUnit> fiber = this.copy$default$5();
                return this.copy(string, l2, deadline, l, fiber);
            }

            public QueueingState decrementQueue() {
                if (this.queueLength() <= 1L) {
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
                long l = this.queueLength() - 1L;
                String string = this.copy$default$1();
                long l2 = this.copy$default$2();
                Deadline deadline = this.copy$default$3();
                Fiber<IO, Throwable, BoxedUnit> fiber = this.copy$default$5();
                return this.copy(string, l2, deadline, l, fiber);
            }

            public NotQueueingState toNotQueueingState() {
                if (this.queueLength() != 1L) {
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
                return this.$outer.js7$base$utils$AsyncLock$WithLogging$$NotQueueingState().apply(this.currentAcquirer(), this.currentNr(), this.acquiredSince());
            }

            public QueueingState copy(String currentAcquirer, long currentNr, Deadline acquiredSince, long queueLength, Fiber<IO, Throwable, BoxedUnit> loggingFiber) {
                return new QueueingState(this.$outer, currentAcquirer, currentNr, acquiredSince, queueLength, loggingFiber);
            }

            public String copy$default$1() {
                return this.currentAcquirer();
            }

            public long copy$default$2() {
                return this.currentNr();
            }

            public Deadline copy$default$3() {
                return this.acquiredSince();
            }

            public long copy$default$4() {
                return this.queueLength();
            }

            public Fiber<IO, Throwable, BoxedUnit> copy$default$5() {
                return this.loggingFiber();
            }

            public String _1() {
                return this.currentAcquirer();
            }

            public long _2() {
                return this.currentNr();
            }

            public Deadline _3() {
                return this.acquiredSince();
            }

            public long _4() {
                return this.queueLength();
            }

            public Fiber<IO, Throwable, BoxedUnit> _5() {
                return this.loggingFiber();
            }

            public final /* synthetic */ WithLogging js7$base$utils$AsyncLock$WithLogging$QueueingState$$$outer() {
                return this.$outer;
            }
        }

        public interface State {
            public long queueLength();
        }
    }
}

