/*
 * Decompiled with CFR 0.152.
 */
package js7.cluster;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Resource;
import cats.effect.std.Supervisor;
import com.typesafe.scalalogging.Logger;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import js7.base.auth.Admission;
import js7.base.auth.UserAndPassword;
import js7.base.log.Logger$package$Logger$syntax$;
import js7.base.monixutils.AsyncVariable;
import js7.base.monixutils.AsyncVariable$;
import js7.base.problem.Problem;
import js7.base.scalasource.ScalaSourceLocation$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichInt$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.Assertions$;
import js7.cluster.ActivationInhibitor$;
import js7.cluster.ActivationInhibitor$Active$;
import js7.cluster.ActivationInhibitor$Inhibited$;
import js7.cluster.ActivationInhibitor$Initial$;
import js7.cluster.ActivationInhibitor$Passive$;
import js7.data.cluster.ClusterNodeApi;
import js7.data.cluster.ClusterSetting;
import js7.data.cluster.ClusterState;
import js7.data.cluster.ClusterTiming;
import js7.data.node.NodeId;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NoStackTrace;
import sourcecode.Enclosing$;
import sourcecode.FullName$;
import sourcecode.Name$;
import sourcecode.Text;
import sourcecode.Text$;

public final class ActivationInhibitor {
    private final Supervisor<IO> supervisor;
    private final Option<String> testFailInhibitActivationWhileTrying;
    private final AsyncVariable<State> _state;

    public static IO<Option<ClusterState>> inhibitActivationOfPassiveNode(ClusterSetting clusterSetting, Option<UserAndPassword> option, Function2<Admission, String, Resource<IO, ClusterNodeApi>> function2) {
        return ActivationInhibitor$.MODULE$.inhibitActivationOfPassiveNode(clusterSetting, option, function2);
    }

    public static Resource<IO, ActivationInhibitor> resource(Option<String> option) {
        return ActivationInhibitor$.MODULE$.resource(option);
    }

    public static IO<Either<Problem, BoxedUnit>> tryInhibitActivationOfPeer(NodeId nodeId, NodeId nodeId2, Admission admission, Function2<Admission, String, Resource<IO, ClusterNodeApi>> function2, ClusterTiming clusterTiming) {
        return ActivationInhibitor$.MODULE$.tryInhibitActivationOfPeer(nodeId, nodeId2, admission, function2, clusterTiming);
    }

    public static Option<String> resource$default$1() {
        return ActivationInhibitor$.MODULE$.resource$default$1();
    }

    public ActivationInhibitor(Supervisor<IO> supervisor, Option<String> testFailInhibitActivationWhileTrying) {
        this.supervisor = supervisor;
        this.testFailInhibitActivationWhileTrying = testFailInhibitActivationWhileTrying;
        this._state = AsyncVariable$.MODULE$.apply(ActivationInhibitor$Initial$.MODULE$, AsyncVariable$.MODULE$.apply$default$2(), AsyncVariable$.MODULE$.apply$default$3(), Enclosing$.MODULE$.apply("js7.cluster.ActivationInhibitor#_state"), Tag$.MODULE$.apply(State.class, LightTypeTag$.MODULE$.parse(1451739854, "\u0004\u0000\u0001&js7.cluster.ActivationInhibitor$.State\u0001\u0002\u0003\u0000\u0000\u001fjs7.cluster.ActivationInhibitor\u0001\u0001", "\u0000\u0000\u0000", 30)));
    }

    public IO<BoxedUnit> startActive() {
        return this.startAs(ActivationInhibitor$Active$.MODULE$);
    }

    public IO<BoxedUnit> startPassive() {
        return this.startAs(ActivationInhibitor$Passive$.MODULE$);
    }

    private IO<BoxedUnit> startAs(State state) {
        return IO$.MODULE$.defer(() -> this.startAs$$anonfun$1(state));
    }

    public IO<Either<Problem, Object>> tryToActivate(IO<Either<Problem, Object>> activate) {
        return Logger$package$Logger$syntax$.MODULE$.debugIOWithResult(ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger, this._state.updateCheckedWithResult((Function1 & Serializable)x$12 -> {
            State state = x$12;
            if (ActivationInhibitor$Initial$.MODULE$.equals(state) || ActivationInhibitor$Active$.MODULE$.equals(state) || ActivationInhibitor$Passive$.MODULE$.equals(state)) {
                return activate.flatMap((Function1 & Serializable)x$1 -> {
                    Right right;
                    Either either;
                    block6: {
                        block5: {
                            Right right2;
                            block4: {
                                either = x$1;
                                if (!(either instanceof Left)) break block4;
                                Left left = (Left)either;
                                break block5;
                            }
                            if (!(either instanceof Right) || BoxesRunTime.unboxToBoolean((Object)(right2 = (Right)either).value())) break block6;
                        }
                        Either o = either;
                        return IO$.MODULE$.apply(() -> ActivationInhibitor.tryToActivate$$anonfun$1$$anonfun$1$$anonfun$1(o));
                    }
                    if (either instanceof Right && BoxesRunTime.unboxToBoolean((Object)(right = (Right)either).value())) {
                        return IO$.MODULE$.apply(ActivationInhibitor::tryToActivate$$anonfun$1$$anonfun$1$$anonfun$2);
                    }
                    throw new MatchError((Object)either);
                });
            }
            if (state instanceof Inhibited) {
                Inhibited inhibited;
                Inhibited inhibited2 = inhibited = (Inhibited)state;
                return IO$.MODULE$.apply(() -> ActivationInhibitor.tryToActivate$$anonfun$1$$anonfun$2(inhibited2));
            }
            throw new MatchError((Object)state);
        }, Enclosing$.MODULE$.apply("js7.cluster.ActivationInhibitor#tryToActivate")), Name$.MODULE$.apply("tryToActivate"));
    }

    public IO<Object> inhibitActivation(FiniteDuration duration) {
        return Logger$package$Logger$syntax$.MODULE$.debugIOWithResult(ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger, this._state.updateWithResult((Function1 & Serializable)x$1 -> {
            State state;
            block9: {
                int n;
                block8: {
                    state = x$1;
                    if (ActivationInhibitor$Active$.MODULE$.equals(state)) {
                        Logger LoggerImpl_this = ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger;
                        if (LoggerImpl_this.underlying().isDebugEnabled()) {
                            LoggerImpl_this.underlying().debug("This node is already active, \u2757\ufe0f THE PEER MUST NOT ACTIVATE \u2757\ufe0f");
                        }
                        ActivationInhibitor$Active$ activationInhibitor$Active$ = (ActivationInhibitor$Active$)Predef$.MODULE$.ArrowAssoc((Object)ActivationInhibitor$Active$.MODULE$);
                        return IO$.MODULE$.pure((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)activationInhibitor$Active$, (Object)BoxesRunTime.boxToBoolean((boolean)false)));
                    }
                    if (ActivationInhibitor$Initial$.MODULE$.equals(state) || ActivationInhibitor$Passive$.MODULE$.equals(state)) break block8;
                    if (!(state instanceof Inhibited)) break block9;
                    Inhibited inhibited = (Inhibited)state;
                }
                State state2 = state;
                IO<BoxedUnit> iO = this.setInhibitionTimer(duration);
                State state3 = state2;
                if (state3 instanceof Inhibited) {
                    int n2;
                    Inhibited inhibited = (Inhibited)state3;
                    Inhibited inhibited2 = ActivationInhibitor$Inhibited$.MODULE$.unapply(inhibited);
                    int n3 = n2 = inhibited2._1();
                    n = n3 + 1;
                } else {
                    n = 1;
                }
                int depth = n;
                Inhibited updated = ActivationInhibitor$Inhibited$.MODULE$.apply(depth);
                Logger LoggerImpl_this = ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger;
                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("Inhibit activation for {}: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(duration)), updated}), Object.class));
                }
                Inhibited inhibited = (Inhibited)Predef$.MODULE$.ArrowAssoc((Object)updated);
                return iO.as((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)inhibited, (Object)BoxesRunTime.boxToBoolean((boolean)true)));
            }
            throw new MatchError((Object)state);
        }, Enclosing$.MODULE$.apply("js7.cluster.ActivationInhibitor#inhibitActivation")).timeoutTo((Duration)ScalaTime$DurationRichInt$.MODULE$.ms$extension(ScalaTime$.MODULE$.DurationRichInt(500)), IO$.MODULE$.apply(this::inhibitActivation$$anonfun$2)), Name$.MODULE$.apply("inhibitActivation"));
    }

    private IO<BoxedUnit> setInhibitionTimer(FiniteDuration duration) {
        return ((IO)this.supervisor.supervise((Object)IO$.MODULE$.sleep(duration).$times$greater(this._state.update((Function1<State, IO<State>>)(Function1 & Serializable)x$1 -> {
            State state = x$1;
            if (state instanceof Inhibited) {
                Inhibited inhibited = (Inhibited)state;
                Inhibited inhibited2 = ActivationInhibitor$Inhibited$.MODULE$.unapply(inhibited);
                int n = inhibited2._1();
                if (1 == n) {
                    return IO$.MODULE$.apply(ActivationInhibitor::setInhibitionTimer$$anonfun$1$$anonfun$1);
                }
                int n2 = n;
                return IO$.MODULE$.apply(() -> ActivationInhibitor.setInhibitionTimer$$anonfun$1$$anonfun$2(n2));
            }
            State state2 = state;
            return IO$.MODULE$.apply(() -> ActivationInhibitor.setInhibitionTimer$$anonfun$1$$anonfun$3(duration, state2));
        }, Enclosing$.MODULE$.apply("js7.cluster.ActivationInhibitor#setInhibitionTimer"))))).void();
    }

    public IO<Option<State>> state() {
        return this._state.lockedValue().map((Function1 & Serializable)_$2 -> Some$.MODULE$.apply(_$2)).timeoutTo((Duration)ScalaTime$DurationRichInt$.MODULE$.ms$extension(ScalaTime$.MODULE$.DurationRichInt(100)), IO$.MODULE$.none());
    }

    private final IO startAs$$anonfun$1(State state$1) {
        block0: {
            Logger LoggerImpl_this = ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger;
            if (!LoggerImpl_this.underlying().isDebugEnabled()) break block0;
            LoggerImpl_this.underlying().debug("startAs {}", (Object)state$1);
        }
        return this._state.update((Function1<State, IO<State>>)(Function1 & Serializable)x$1 -> {
            State state = x$1;
            if (ActivationInhibitor$Initial$.MODULE$.equals(state)) {
                return IO$.MODULE$.pure((Object)state$1);
            }
            State s = state;
            return IO$.MODULE$.raiseError((Throwable)new IllegalStateException("ActivationInhibitor startAs(" + state$1 + "): Already '" + s + "''"));
        }, Enclosing$.MODULE$.apply("js7.cluster.ActivationInhibitor#startAs")).void();
    }

    private static final /* synthetic */ Tuple2 tryToActivate$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(boolean _$1) {
        ActivationInhibitor$Passive$ activationInhibitor$Passive$ = (ActivationInhibitor$Passive$)Predef$.MODULE$.ArrowAssoc((Object)ActivationInhibitor$Passive$.MODULE$);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)activationInhibitor$Passive$, (Object)BoxesRunTime.boxToBoolean((boolean)_$1));
    }

    private static final Either tryToActivate$$anonfun$1$$anonfun$1$$anonfun$1(Either o$1) {
        block0: {
            Logger LoggerImpl_this = ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger;
            if (!LoggerImpl_this.underlying().isDebugEnabled()) break block0;
            LoggerImpl_this.underlying().debug("\u26d4 tryToActivate: Passive \u2014 because activation function returned {}", (Object)o$1);
        }
        return o$1.map((Function1 & Serializable)_$1 -> ActivationInhibitor.tryToActivate$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)_$1)));
    }

    private static final Right tryToActivate$$anonfun$1$$anonfun$1$$anonfun$2() {
        Logger LoggerImpl_this = ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("\u2714\ufe0e tryToActivate: Active \u2014 because activation function succeeded");
        }
        ActivationInhibitor$Active$ activationInhibitor$Active$ = (ActivationInhibitor$Active$)Predef$.MODULE$.ArrowAssoc((Object)ActivationInhibitor$Active$.MODULE$);
        return package$.MODULE$.Right().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)activationInhibitor$Active$, (Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    private static final Right tryToActivate$$anonfun$1$$anonfun$2(Inhibited inhibited$1) {
        Logger LoggerImpl_this = ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger;
        if (LoggerImpl_this.underlying().isInfoEnabled()) {
            LoggerImpl_this.underlying().info("\u26d4 Activation of this cluster node has been inhibited by the peer \u26d4");
        }
        Inhibited inhibited = (Inhibited)Predef$.MODULE$.ArrowAssoc((Object)inhibited$1);
        return package$.MODULE$.Right().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)inhibited, (Object)BoxesRunTime.boxToBoolean((boolean)false)));
    }

    private static final boolean inhibitActivation$$anonfun$2$$anonfun$1() {
        return false;
    }

    private final boolean inhibitActivation$$anonfun$2() {
        block0: {
            Logger LoggerImpl_this = ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger;
            if (!LoggerImpl_this.underlying().isInfoEnabled()) break block0;
            LoggerImpl_this.underlying().info("\u26a0\ufe0f  inhibitActivation: This cluster node seems to be trying to activate, so we reject the request");
        }
        return BoxesRunTime.unboxToBoolean((Object)this.testFailInhibitActivationWhileTrying.fold(ActivationInhibitor::inhibitActivation$$anonfun$2$$anonfun$1, (Function1 & Serializable)key -> {
            throw new InhibitActivationFailsForTestingException();
        }));
    }

    private static final ActivationInhibitor$Passive$ setInhibitionTimer$$anonfun$1$$anonfun$1() {
        block0: {
            Logger LoggerImpl_this = ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger;
            if (!LoggerImpl_this.underlying().isDebugEnabled()) break block0;
            LoggerImpl_this.underlying().debug("Inhibition timer expired, becoming Passive");
        }
        return ActivationInhibitor$Passive$.MODULE$;
    }

    private static final Inhibited setInhibitionTimer$$anonfun$1$$anonfun$2(int n$1) {
        Inhibited updated;
        block0: {
            updated = ActivationInhibitor$Inhibited$.MODULE$.apply(n$1 - 1);
            Logger LoggerImpl_this = ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger;
            if (!LoggerImpl_this.underlying().isDebugEnabled()) break block0;
            LoggerImpl_this.underlying().debug("Inhibition timer expired, becoming {}", (Object)updated);
        }
        return updated;
    }

    private static final State setInhibitionTimer$$anonfun$1$$anonfun$3(FiniteDuration duration$3, State state$3) {
        block0: {
            Logger LoggerImpl_this = ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger;
            if (!LoggerImpl_this.underlying().isErrorEnabled()) break block0;
            LoggerImpl_this.underlying().error("inhibitActivation timeout after {}: expected Inhibited but got '{}'", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(duration$3)), state$3}), Object.class));
        }
        return state$3;
    }

    public static final class InhibitActivationFailsForTestingException
    extends RuntimeException
    implements NoStackTrace {
        public InhibitActivationFailsForTestingException() {
            super("\ud83d\udfea inhibitActivation fails due to testFailInhibitActivationWhileTrying");
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }
    }

    public static class Inhibited
    implements State,
    Product,
    Serializable {
        private final int depth;

        public static Inhibited apply(int n) {
            return ActivationInhibitor$Inhibited$.MODULE$.apply(n);
        }

        public static Inhibited fromProduct(Product product) {
            return ActivationInhibitor$Inhibited$.MODULE$.fromProduct(product);
        }

        public static Inhibited unapply(Inhibited inhibited) {
            return ActivationInhibitor$Inhibited$.MODULE$.unapply(inhibited);
        }

        public Inhibited(int depth) {
            this.depth = depth;
            Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy1$1(depth)), "depth >= 1"), FullName$.MODULE$.apply("js7.cluster.ActivationInhibitor.Inhibited"), ScalaSourceLocation$.MODULE$.apply("ActivationInhibitor.scala", 193));
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)546329894);
            n = Statics.mix((int)n, (int)this.depth());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            Inhibited inhibited;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Inhibited)) return false;
            Inhibited inhibited2 = inhibited = (Inhibited)object;
            if (this.depth() != inhibited2.depth()) return false;
            if (!inhibited2.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Inhibited;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Inhibited";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "depth";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int depth() {
            return this.depth;
        }

        public Inhibited copy(int depth) {
            return new Inhibited(depth);
        }

        public int copy$default$1() {
            return this.depth();
        }

        public int _1() {
            return this.depth();
        }

        private final boolean v$proxy1$1(int depth$2) {
            return depth$2 >= 1;
        }
    }

    public static final class Result {
        private final Option<ClusterState> peerClusterState;

        public Result(Option<ClusterState> peerClusterState) {
            this.peerClusterState = peerClusterState;
        }

        public Option<ClusterState> peerClusterState() {
            return this.peerClusterState;
        }

        public String toString() {
            Option<ClusterState> option = this.peerClusterState();
            if (None$.MODULE$.equals(option)) {
                return "\u2714\ufe0e Activation allowed";
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                ClusterState clusterState = (ClusterState)some.value();
                return "\u26d4\ufe0f Activation inhibited due to peer clusterState=" + clusterState.toShortString();
            }
            throw new MatchError(option);
        }
    }

    public static interface State {
    }
}

