/*
 * Decompiled with CFR 0.152.
 */
package js7.cluster;

import cats.Applicative;
import cats.UnorderedFoldable$;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Outcome;
import cats.effect.kernel.Resource;
import cats.effect.package$;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.net.SocketException;
import js7.base.auth.Admission;
import js7.base.auth.Admission$;
import js7.base.auth.UserAndPassword;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.eventbus.EventPublisher;
import js7.base.generic.SecretString;
import js7.base.log.LogLevel;
import js7.base.log.Logger$package$Logger$syntax$;
import js7.base.log.Slf4jUtils$syntax$;
import js7.base.log.Slf4jUtils$syntax$LevelLogger$;
import js7.base.monixlike.MonixLikeExtensions$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.scalasource.ScalaSourceLocation$;
import js7.base.system.startup.Halt$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichDeadline$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.Assertions$;
import js7.base.utils.Delayer;
import js7.base.utils.OneTimeToken;
import js7.base.utils.OneTimeToken$;
import js7.base.utils.OneTimeTokenProvider;
import js7.base.utils.OneTimeTokenProvider$;
import js7.base.utils.ScalaUtils;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.base.utils.ScalaUtils$syntax$RichOrNull$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.base.utils.SetOnce;
import js7.base.utils.SetOnce$;
import js7.base.web.Uri;
import js7.cluster.ActivationInhibitor;
import js7.cluster.ActivationInhibitor$;
import js7.cluster.ClusterCommon$;
import js7.cluster.ClusterCommon$ClusterWatchAgreedToActivation$;
import js7.cluster.ClusterCommon$ClusterWatchDisagreedToActivation$;
import js7.cluster.ClusterConf;
import js7.cluster.ClusterConf$;
import js7.cluster.ClusterWatchCounterpart;
import js7.cluster.ClusterWatchSynchronizer;
import js7.cluster.watch.api.ClusterWatchConfirmation;
import js7.core.license.LicenseChecker;
import js7.data.cluster.ClusterCommand;
import js7.data.cluster.ClusterEvent;
import js7.data.cluster.ClusterNodeApi;
import js7.data.cluster.ClusterState;
import js7.data.cluster.ClusterState$Empty$;
import js7.data.cluster.ClusterWatchProblems$ClusterNodeLossNotConfirmedProblem$;
import js7.data.cluster.ClusterWatchProblems$ClusterPassiveLostWhileFailedOverTestingProblem$;
import js7.data.cluster.ClusterWatchProblems$ClusterWatchInactiveNodeProblem$;
import js7.data.command.CommonCommand;
import js7.data.event.ClusterableState;
import js7.data.node.NodeId;
import js7.data.node.NodeName;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.Enclosing$;
import sourcecode.FullName$;
import sourcecode.Name$;
import sourcecode.Text;
import sourcecode.Text$;

public final class ClusterCommon {
    private final ClusterWatchCounterpart clusterWatchCounterpart;
    private final Function2<Admission, String, Resource<IO, ClusterNodeApi>> clusterNodeApi;
    private final ClusterConf clusterConf;
    private final LicenseChecker licenseChecker;
    private final EventPublisher<Object> testEventBus;
    private final ActivationInhibitor activationInhibitor;
    private final SetOnce<ClusterWatchSynchronizer> _clusterWatchSynchronizer;
    private final OneTimeTokenProvider couplingTokenProvider;

    public static String clusterEventAndStateToString(ClusterEvent clusterEvent, ClusterState clusterState) {
        return ClusterCommon$.MODULE$.clusterEventAndStateToString(clusterEvent, clusterState);
    }

    public static Resource<IO, ClusterCommon> resource(ClusterWatchCounterpart clusterWatchCounterpart, Function2<Admission, String, Resource<IO, ClusterNodeApi>> function2, ClusterConf clusterConf, LicenseChecker licenseChecker, EventPublisher<Object> eventPublisher) {
        return ClusterCommon$.MODULE$.resource(clusterWatchCounterpart, function2, clusterConf, licenseChecker, eventPublisher);
    }

    public ClusterCommon(ClusterWatchCounterpart clusterWatchCounterpart, Function2<Admission, String, Resource<IO, ClusterNodeApi>> clusterNodeApi, ClusterConf clusterConf, LicenseChecker licenseChecker, EventPublisher<Object> testEventBus, ActivationInhibitor activationInhibitor) {
        this.clusterWatchCounterpart = clusterWatchCounterpart;
        this.clusterNodeApi = clusterNodeApi;
        this.clusterConf = clusterConf;
        this.licenseChecker = licenseChecker;
        this.testEventBus = testEventBus;
        this.activationInhibitor = activationInhibitor;
        this._clusterWatchSynchronizer = SetOnce$.MODULE$.apply(Tag$.MODULE$.apply(ClusterWatchSynchronizer.class, LightTypeTag$.MODULE$.parse(-636438082, "\u0004\u0000\u0001$js7.cluster.ClusterWatchSynchronizer\u0001\u0001", "\u0000\u0000\u0000", 30)));
        this.couplingTokenProvider = OneTimeTokenProvider$.MODULE$.unsafe();
    }

    public ClusterWatchCounterpart clusterWatchCounterpart() {
        return this.clusterWatchCounterpart;
    }

    public Function2<Admission, String, Resource<IO, ClusterNodeApi>> clusterNodeApi() {
        return this.clusterNodeApi;
    }

    public EventPublisher<Object> testEventBus() {
        return this.testEventBus;
    }

    public ActivationInhibitor activationInhibitor() {
        return this.activationInhibitor;
    }

    public OneTimeTokenProvider couplingTokenProvider() {
        return this.couplingTokenProvider;
    }

    public IO<BoxedUnit> stop() {
        return IO$.MODULE$.defer(this::stop$$anonfun$1);
    }

    public IO<Either<Problem, BoxedUnit>> requireValidLicense() {
        return IO$.MODULE$.apply(this::requireValidLicense$$anonfun$1);
    }

    public IO<ClusterWatchSynchronizer> clusterWatchSynchronizer(ClusterState.HasNodes clusterState) {
        return IO$.MODULE$.apply(() -> this.clusterWatchSynchronizer$$anonfun$1(clusterState));
    }

    public ClusterWatchSynchronizer initialClusterWatchSynchronizer(ClusterState.HasNodes clusterState) {
        Option<ClusterWatchSynchronizer> option = this._clusterWatchSynchronizer.toOption();
        if (option instanceof Some) {
            Some some = (Some)option;
            ClusterWatchSynchronizer o = (ClusterWatchSynchronizer)some.value();
            Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)ClusterCommon.v$proxy1$1(clusterState)), "clusterState.isInstanceOf[FailedOver] || clusterState.isInstanceOf[SwitchedOver]"), FullName$.MODULE$.apply("js7.cluster.ClusterCommon.initialClusterWatchSynchronizer"), ScalaSourceLocation$.MODULE$.apply("ClusterCommon.scala", 60));
            return o;
        }
        if (None$.MODULE$.equals(option)) {
            ClusterWatchSynchronizer result = new ClusterWatchSynchronizer(this.clusterConf.ownId(), this.clusterWatchCounterpart(), clusterState.setting().timing());
            this._clusterWatchSynchronizer.$colon$eq(result);
            return result;
        }
        throw new MatchError(option);
    }

    public IO<BoxedUnit> tryEndlesslyToSendCommand(Admission admission, ClusterCommand command) {
        ScalaUtils.syntax.RichJavaClass<?> RichJavaClass_this = ScalaUtils$syntax$.MODULE$.RichJavaClass(command.getClass());
        String name = RichJavaClass_this.cachedSimpleScalaName();
        return this.tryEndlesslyToSendCommand((Resource<IO, ClusterNodeApi>)((Resource)this.clusterNodeApi().apply((Object)admission, (Object)name)), (Function1 & Serializable)_$2 -> command);
    }

    public <C extends ClusterCommand> IO<BoxedUnit> tryEndlesslyToSendCommand(Resource<IO, ClusterNodeApi> apiResource, Function1<OneTimeToken, C> toCommand) {
        return this.clusterConf.delayConf().runIO((Function1 & Serializable)delayer -> {
            String name = ((CommonCommand)toCommand.apply((Object)OneTimeToken$.MODULE$.apply("TOKEN"))).toShortString();
            Deadline since = Deadline$.MODULE$.now();
            return (IO)apiResource.use((Function1 & Serializable)api -> ((IO)MonixLikeExtensions$.MODULE$.onErrorRestartLoop(api.retryIfSessionLost(api.loginUntilReachable(api.loginUntilReachable$default$1(), api.loginUntilReachable$default$2(), true).$times$greater((IO)this.couplingTokenProvider().resource().use((Function1 & Serializable)token -> api.executeClusterCommand((ClusterCommand)toCommand.apply(token)), (MonadCancel)IO$.MODULE$.asyncForIO()))).map((Function1)(JProcedure1 & Serializable)_$3 -> {}), BoxedUnit.UNIT, (Function3 & Serializable)(throwable, _$4, retry) -> {
                block0: {
                    Logger LoggerImpl_this;
                    Object object;
                    LogLevel level$proxy1 = delayer.logLevel();
                    Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(ClusterCommon$.js7$cluster$ClusterCommon$$$logger.underlying()), level$proxy1, (Function0<String>)((Function0 & Serializable)() -> ClusterCommon.tryEndlesslyToSendCommand$$anonfun$2$$anonfun$1$$anonfun$3$$anonfun$1(delayer, name, throwable)));
                    if (throwable instanceof SocketException || !ArrayOps$.MODULE$.nonEmpty$extension(object = Predef$.MODULE$.refArrayOps((Object[])throwable.getStackTrace())) || !(LoggerImpl_this = ClusterCommon$.js7$cluster$ClusterCommon$$$logger).underlying().isDebugEnabled()) break block0;
                    LoggerImpl_this.underlying().debug(throwable.toString(), throwable);
                }
                return ((IO)delayer.sleep(Enclosing$.MODULE$.apply("js7.cluster.ClusterCommon#tryEndlesslyToSendCommand"))).$times$greater((IO)retry.apply((Object)BoxedUnit.UNIT));
            }, IO$.MODULE$.asyncForIO())).guaranteeCase((Function1 & Serializable)x$1 -> {
                Outcome outcome = x$1;
                if (outcome instanceof Outcome.Succeeded) {
                    Outcome.Succeeded succeeded = (Outcome.Succeeded)outcome;
                    package$.MODULE$.Outcome();
                    Outcome.Succeeded succeeded2 = Outcome.Succeeded$.MODULE$.unapply(succeeded);
                    IO iO = (IO)succeeded2._1();
                    return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                        ClusterCommon.tryEndlesslyToSendCommand$$anonfun$2$$anonfun$1$$anonfun$4$$anonfun$1(delayer, name, since);
                        return BoxedUnit.UNIT;
                    });
                }
                if (outcome instanceof Outcome.Canceled) {
                    Outcome.Canceled canceled = (Outcome.Canceled)outcome;
                    package$.MODULE$.Outcome();
                    if (Outcome.Canceled$.MODULE$.unapply(canceled)) {
                        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                            ClusterCommon.tryEndlesslyToSendCommand$$anonfun$2$$anonfun$1$$anonfun$4$$anonfun$2(delayer, name, since);
                            return BoxedUnit.UNIT;
                        });
                    }
                }
                return IO$.MODULE$.unit();
            }), (MonadCancel)IO$.MODULE$.asyncForIO());
        });
    }

    public <S extends ClusterableState<S>> IO<Either<Problem, Option<ClusterState>>> inhibitActivationOfPeer(S aggregate, Function1<NodeName, Either<Problem, Option<SecretString>>> x$2) {
        ClusterState clusterState2 = (ClusterState)ScalaUtils$syntax$.MODULE$.RichOrNull(aggregate.clusterState());
        return (IO)package.all$.MODULE$.toTraverseOps(Predef$.MODULE$.locally((Object)ScalaUtils$syntax$RichOrNull$.MODULE$.checkedCast$extension(clusterState2, ClassTag$.MODULE$.apply(ClusterState.Coupled.class)).flatMap((Function1 & Serializable)clusterState -> aggregate.clusterNodeToUserAndPassword(clusterState.activeId(), x$2).map((Function1 & Serializable)maybeUserAndPassword -> this.inhibitActivationOfPeer((ClusterState.HasNodes)clusterState, (Option<UserAndPassword>)maybeUserAndPassword)))), UnorderedFoldable$.MODULE$.catsTraverseForEither()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)IO$.MODULE$.asyncForIO());
    }

    public IO<Option<ClusterState>> inhibitActivationOfPeer(ClusterState.HasNodes clusterState, Option<UserAndPassword> peersUserAndPassword) {
        return ActivationInhibitor$.MODULE$.inhibitActivationOfPassiveNode(clusterState.setting(), peersUserAndPassword, this.clusterNodeApi());
    }

    public <S extends ClusterableState<S>> IO<Either<Problem, Object>> ifClusterWatchAllowsActivation(NodeId ownId, ClusterEvent.ClusterNodeLostEvent event, S aggregate, IO<Either<Problem, Object>> body, Function1<NodeName, Either<Problem, Option<SecretString>>> x$5) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(IO$.MODULE$.apply(() -> ClusterCommon.ifClusterWatchAllowsActivation$$anonfun$1(aggregate)));
        return Logger$package$Logger$syntax$.MODULE$.traceIOWithResult(ClusterCommon$.js7$cluster$ClusterCommon$$$logger, (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)clusterState -> {
            NodeId peerId = clusterState.setting().other(ownId);
            IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(IO$.MODULE$.apply(() -> ClusterCommon.ifClusterWatchAllowsActivation$$anonfun$2$$anonfun$1(aggregate, ownId, x$5)));
            return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)peersUserAndPassword -> {
                Admission admission = Admission$.MODULE$.apply((Uri)clusterState.setting().idToUri().apply((Object)peerId), (Option<UserAndPassword>)peersUserAndPassword);
                return ActivationInhibitor$.MODULE$.tryInhibitActivationOfPeer(ownId, peerId, admission, this.clusterNodeApi(), clusterState.setting().timing()).flatMap((Function1 & Serializable)x$1 -> {
                    Either either = x$1;
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        Problem problem = (Problem)left.value();
                        Logger LoggerImpl_this = ClusterCommon$.js7$cluster$ClusterCommon$$$logger;
                        if (LoggerImpl_this.underlying().isDebugEnabled()) {
                            LoggerImpl_this.underlying().debug("\u26d4\ufe0f {}", (Object)problem);
                        }
                        return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, BoxesRunTime.boxToBoolean((boolean)false));
                    }
                    if (either instanceof Right) {
                        Right right = (Right)either;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        Object object = right.value();
                        if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                            return this.activationInhibitor().tryToActivate(this.activate((ClusterState.HasNodes)clusterState, event, body));
                        }
                    }
                    throw new MatchError((Object)either);
                });
            }, IO$.MODULE$.asyncForIO());
        }, IO$.MODULE$.asyncForIO()), Name$.MODULE$.apply("ifClusterWatchAllowsActivation"));
    }

    private IO<Either<Problem, Object>> activate(ClusterState.HasNodes clusterState, ClusterEvent.ClusterNodeLostEvent event, IO<Either<Problem, Object>> body) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(IO$.MODULE$.pure(clusterState.applyEvent(event)));
        return Logger$package$Logger$syntax$.MODULE$.traceIOWithResult(ClusterCommon$.js7$cluster$ClusterCommon$$$logger, (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)x$12 -> {
            ClusterState clusterState = x$12;
            if (clusterState instanceof ClusterState.HasNodes) {
                ClusterState.HasNodes hasNodes;
                ClusterState.HasNodes updatedClusterState = hasNodes = (ClusterState.HasNodes)clusterState;
                return this.clusterWatchSynchronizer(clusterState).flatMap((Function1 & Serializable)_$5 -> _$5.applyEvent(event, updatedClusterState, event instanceof ClusterEvent.ClusterFailedOver, _$5.applyEvent$default$4())).flatMap((Function1 & Serializable)x$1 -> {
                    Either either = x$1;
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        Problem problem = (Problem)left.value();
                        if (problem.is(ClusterWatchProblems$ClusterNodeLossNotConfirmedProblem$.MODULE$) || problem.is(ClusterWatchProblems$ClusterWatchInactiveNodeProblem$.MODULE$)) {
                            Logger LoggerImpl_this = ClusterCommon$.js7$cluster$ClusterCommon$$$logger;
                            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                                Object[] objectArray = new Object[2];
                                ScalaUtils.syntax.RichJavaClass<?> RichJavaClass_this = ScalaUtils$syntax$.MODULE$.RichJavaClass(event.getClass());
                                objectArray[0] = RichJavaClass_this.cachedSimpleScalaName();
                                objectArray[1] = problem;
                                LoggerImpl_this.underlying().warn("\u26d4 ClusterWatch did not agree to '{}' event: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
                            }
                            this.testEventBus().publish(ClusterCommon$ClusterWatchDisagreedToActivation$.MODULE$);
                            if (event instanceof ClusterEvent.ClusterPassiveLost) {
                                String msg = "\ud83d\udfe5 While this node has lost the passive node and is waiting for ClusterWatch's agreement, the passive node failed over";
                                if (this.clusterConf.testDontHaltWhenPassiveLostRejected()) {
                                    return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, ClusterWatchProblems$ClusterPassiveLostWhileFailedOverTestingProblem$.MODULE$);
                                }
                                throw Halt$.MODULE$.haltJava(msg, true, true);
                            }
                            return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, BoxesRunTime.boxToBoolean((boolean)false));
                        }
                        return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, problem);
                    }
                    if (either instanceof Right) {
                        Right right = (Right)either;
                        Option option = (Option)right.value();
                        if (None$.MODULE$.equals(option)) {
                            Logger LoggerImpl_this = ClusterCommon$.js7$cluster$ClusterCommon$$$logger;
                            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                                ScalaUtils.syntax.RichJavaClass<?> RichJavaClass_this = ScalaUtils$syntax$.MODULE$.RichJavaClass(event.getClass());
                                LoggerImpl_this.underlying().debug("No ClusterWatch confirmation required for '{}' event", (Object)RichJavaClass_this.cachedSimpleScalaName());
                            }
                            return body;
                        }
                        Option maybeConfirm = option;
                        Option option2 = maybeConfirm;
                        if (None$.MODULE$.equals(option2)) {
                            Logger LoggerImpl_this = ClusterCommon$.js7$cluster$ClusterCommon$$$logger;
                            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                                ScalaUtils.syntax.RichJavaClass<?> RichJavaClass_this = ScalaUtils$syntax$.MODULE$.RichJavaClass(event.getClass());
                                LoggerImpl_this.underlying().info("ClusterWatch agreed to '{}' event", (Object)RichJavaClass_this.cachedSimpleScalaName());
                            }
                        } else if (option2 instanceof Some) {
                            Some some = (Some)option2;
                            ClusterWatchConfirmation confirm = (ClusterWatchConfirmation)some.value();
                            Logger LoggerImpl_this = ClusterCommon$.js7$cluster$ClusterCommon$$$logger;
                            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                                Object[] objectArray = new Object[2];
                                objectArray[0] = confirm.confirmer();
                                ScalaUtils.syntax.RichJavaClass<?> RichJavaClass_this = ScalaUtils$syntax$.MODULE$.RichJavaClass(event.getClass());
                                objectArray[1] = RichJavaClass_this.cachedSimpleScalaName();
                                LoggerImpl_this.underlying().info("{} agreed to '{}' event", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
                            }
                        } else {
                            throw new MatchError((Object)option2);
                        }
                        this.testEventBus().publish(ClusterCommon$ClusterWatchAgreedToActivation$.MODULE$);
                        return body;
                    }
                    throw new MatchError((Object)either);
                });
            }
            if (ClusterState$Empty$.MODULE$.equals(clusterState)) {
                return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problem$.MODULE$.pure("ClusterState:Empty in ifClusterWatchAllowsActivation ??"));
            }
            throw new MatchError((Object)clusterState);
        }, IO$.MODULE$.asyncForIO()), Name$.MODULE$.apply("activate"));
    }

    private static final IO stop$$anonfun$1$$anonfun$1() {
        return IO$.MODULE$.unit();
    }

    private final IO stop$$anonfun$1() {
        return (IO)this._clusterWatchSynchronizer.toOption().fold(ClusterCommon::stop$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$1 -> _$1.stop());
    }

    private final Either requireValidLicense$$anonfun$1() {
        return this.licenseChecker.checkLicense(ClusterConf$.MODULE$.ClusterProductName());
    }

    private final ClusterWatchSynchronizer clusterWatchSynchronizer$$anonfun$1$$anonfun$1(ClusterState.HasNodes clusterState$2) {
        return this.initialClusterWatchSynchronizer(clusterState$2);
    }

    private final ClusterWatchSynchronizer clusterWatchSynchronizer$$anonfun$1(ClusterState.HasNodes clusterState$1) {
        return (ClusterWatchSynchronizer)this._clusterWatchSynchronizer.toOption().getOrElse(() -> this.clusterWatchSynchronizer$$anonfun$1$$anonfun$1(clusterState$1));
    }

    private static final boolean v$proxy1$1(ClusterState.HasNodes clusterState$3) {
        return clusterState$3 instanceof ClusterState.FailedOver || clusterState$3 instanceof ClusterState.SwitchedOver;
    }

    private static final String message$proxy1$1(Delayer delayer$3, String name$3, Throwable throwable$1) {
        Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(throwable$1);
        return delayer$3.symbol() + " " + name$3 + " command failed with " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable);
    }

    private static final String tryEndlesslyToSendCommand$$anonfun$2$$anonfun$1$$anonfun$3$$anonfun$1(Delayer delayer$7, String name$9, Throwable throwable$2) {
        return ClusterCommon.message$proxy1$1(delayer$7, name$9, throwable$2);
    }

    private static final String message$proxy3$1(String name$6, Deadline since$4) {
        return "\ud83d\udfe2 " + name$6 + " command succeeded after " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(since$4))));
    }

    private static final String tryEndlesslyToSendCommand$$anonfun$2$$anonfun$1$$anonfun$4$$anonfun$1$$anonfun$1(String name$10, Deadline since$7) {
        return ClusterCommon.message$proxy3$1(name$10, since$7);
    }

    private static final void tryEndlesslyToSendCommand$$anonfun$2$$anonfun$1$$anonfun$4$$anonfun$1(Delayer delayer$5, String name$5, Deadline since$3) {
        LogLevel level$proxy2 = delayer$5.relievedLogLevel();
        Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(ClusterCommon$.js7$cluster$ClusterCommon$$$logger.underlying()), level$proxy2, (Function0<String>)((Function0 & Serializable)() -> ClusterCommon.tryEndlesslyToSendCommand$$anonfun$2$$anonfun$1$$anonfun$4$$anonfun$1$$anonfun$1(name$5, since$3)));
    }

    private static final String message$proxy4$1(String name$8, Deadline since$6) {
        return "\u25fc\ufe0f " + name$8 + " command canceled after " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(since$6))));
    }

    private static final String tryEndlesslyToSendCommand$$anonfun$2$$anonfun$1$$anonfun$4$$anonfun$2$$anonfun$1(String name$12, Deadline since$9) {
        return ClusterCommon.message$proxy4$1(name$12, since$9);
    }

    private static final void tryEndlesslyToSendCommand$$anonfun$2$$anonfun$1$$anonfun$4$$anonfun$2(Delayer delayer$6, String name$7, Deadline since$5) {
        LogLevel level$proxy3 = delayer$6.relievedLogLevel();
        Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(ClusterCommon$.js7$cluster$ClusterCommon$$$logger.underlying()), level$proxy3, (Function0<String>)((Function0 & Serializable)() -> ClusterCommon.tryEndlesslyToSendCommand$$anonfun$2$$anonfun$1$$anonfun$4$$anonfun$2$$anonfun$1(name$7, since$5)));
    }

    private static final Either ifClusterWatchAllowsActivation$$anonfun$1(ClusterableState aggregate$2) {
        ClusterState clusterState = (ClusterState)ScalaUtils$syntax$.MODULE$.RichOrNull(aggregate$2.clusterState());
        return ScalaUtils$syntax$RichOrNull$.MODULE$.checkedCast$extension(clusterState, ClassTag$.MODULE$.apply(ClusterState.HasNodes.class));
    }

    private static final Either ifClusterWatchAllowsActivation$$anonfun$2$$anonfun$1(ClusterableState aggregate$4, NodeId ownId$2, Function1 x$5$2) {
        return aggregate$4.clusterNodeToUserAndPassword(ownId$2, (Function1<NodeName, Either<Problem, Option<SecretString>>>)x$5$2);
    }
}

