/*
 * Decompiled with CFR 0.152.
 */
package js7.cluster;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.DeferredSource;
import cats.effect.kernel.Outcome;
import cats.effect.kernel.Resource;
import cats.effect.package$;
import cats.effect.unsafe.IORuntime;
import com.typesafe.scalalogging.Logger;
import fs2.Stream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.catsutils.SyncDeadline;
import js7.base.catsutils.SyncDeadline$;
import js7.base.catsutils.SyncDeadline$Now$;
import js7.base.eventbus.EventPublisher;
import js7.base.fs2utils.Fs2PubSub;
import js7.base.log.BlockingSymbol;
import js7.base.log.CorrelId;
import js7.base.log.CorrelId$;
import js7.base.log.LogLevel;
import js7.base.log.LogLevel$;
import js7.base.log.Logger$package$Logger$syntax$;
import js7.base.log.Slf4jUtils$syntax$;
import js7.base.log.Slf4jUtils$syntax$LevelLogger$;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.base.scalasource.ScalaSourceLocation$;
import js7.base.service.Service;
import js7.base.service.StoppableByRequest;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.AsyncLock;
import js7.base.utils.AsyncLock$;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.ScalaUtils;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.base.utils.Tests$;
import js7.cluster.ClusterConf;
import js7.cluster.ClusterWatchCounterpart$;
import js7.cluster.ClusterWatchCounterpart$CurrentClusterWatchId$;
import js7.cluster.ClusterWatchCounterpart$TestConfirmed$;
import js7.cluster.ClusterWatchCounterpart$TestWaitingForConfirmation$;
import js7.cluster.ClusterWatchUniquenessChecker;
import js7.cluster.watch.api.ClusterWatchConfirmation;
import js7.cluster.watch.api.ClusterWatchConfirmation$;
import js7.common.http.PekkoHttpClient$;
import js7.data.Problems$ClusterModuleShuttingDownProblem$;
import js7.data.cluster.ClusterEvent;
import js7.data.cluster.ClusterState;
import js7.data.cluster.ClusterTiming;
import js7.data.cluster.ClusterWatchCheckEvent$;
import js7.data.cluster.ClusterWatchCheckState$;
import js7.data.cluster.ClusterWatchId;
import js7.data.cluster.ClusterWatchProblems;
import js7.data.cluster.ClusterWatchProblems$ClusterNodeLossNotConfirmedProblem$;
import js7.data.cluster.ClusterWatchProblems$ClusterWatchIdDoesNotMatchProblem$;
import js7.data.cluster.ClusterWatchProblems$ClusterWatchRequestDoesNotMatchProblem$;
import js7.data.cluster.ClusterWatchProblems$NoClusterWatchProblem$;
import js7.data.cluster.ClusterWatchProblems$OtherClusterWatchStillAliveProblem$;
import js7.data.cluster.ClusterWatchRequest;
import js7.data.cluster.ClusterWatchRequest$RequestId$;
import js7.data.cluster.ClusterWatchingCommand;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Random$;
import scala.util.Right;
import scala.util.hashing.MurmurHash3$;
import sourcecode.Enclosing$;

public final class ClusterWatchCounterpart
implements Service,
StoppableByRequest,
Service.StoppableByRequest {
    private AtomicBoolean js7$base$service$Service$$started;
    private Deferred js7$base$service$Service$$stopped;
    private boolean stoppableByCancel;
    private Deferred js7$base$service$StoppableByRequest$$fiber;
    private Deferred js7$base$service$StoppableByRequest$$stopRequested;
    private volatile boolean js7$base$service$StoppableByRequest$$_isStopping;
    private IO js7$base$service$StoppableByRequest$$memoizedStop;
    private final Fs2PubSub<IO, ClusterWatchRequest> pubsub;
    private final ClusterConf clusterConf;
    public final ClusterTiming js7$cluster$ClusterWatchCounterpart$$timing;
    public final DeferredSource<IO, BoxedUnit> js7$cluster$ClusterWatchCounterpart$$shuttingDown;
    private final EventPublisher<Object> testEventPublisher;
    private final IORuntime ioRuntime;
    private final AtomicLong nextRequestId;
    private final AsyncLock lock;
    public final AtomicBoolean js7$cluster$ClusterWatchCounterpart$$hasConfirmedSomething;
    private final AtomicReference<Option<Requested>> _requested;
    private final ClusterWatchUniquenessChecker clusterWatchUniquenessChecker;
    private volatile Option<CurrentClusterWatchId> currentClusterWatchId;
    public final ClusterWatchCounterpart$CurrentClusterWatchId$ CurrentClusterWatchId$lzy1;

    public static Resource<IO, ClusterWatchCounterpart> resource(ClusterConf clusterConf, ClusterTiming clusterTiming, DeferredSource<IO, BoxedUnit> deferredSource, EventPublisher<Object> eventPublisher, IORuntime iORuntime) {
        return ClusterWatchCounterpart$.MODULE$.resource(clusterConf, clusterTiming, deferredSource, eventPublisher, iORuntime);
    }

    public ClusterWatchCounterpart(Fs2PubSub<IO, ClusterWatchRequest> pubsub, ClusterConf clusterConf, ClusterTiming timing, DeferredSource<IO, BoxedUnit> shuttingDown, EventPublisher<Object> testEventPublisher, IORuntime ioRuntime) {
        this.pubsub = pubsub;
        this.clusterConf = clusterConf;
        this.js7$cluster$ClusterWatchCounterpart$$timing = timing;
        this.js7$cluster$ClusterWatchCounterpart$$shuttingDown = shuttingDown;
        this.testEventPublisher = testEventPublisher;
        this.ioRuntime = ioRuntime;
        this.CurrentClusterWatchId$lzy1 = new ClusterWatchCounterpart$CurrentClusterWatchId$(this);
        Service.$init$(this);
        StoppableByRequest.$init$(this);
        long initial$proxy1 = Tests$.MODULE$.isTest() ? 1L : Random$.MODULE$.nextLong(Long.MAX_VALUE - 96000000L / timing.heartbeat().toSeconds()) / 1000000L * 1000000L;
        this.nextRequestId = new AtomicLong(initial$proxy1);
        this.lock = AsyncLock$.MODULE$.apply(Enclosing$.MODULE$.apply("js7.cluster.ClusterWatchCounterpart#lock"));
        this.js7$cluster$ClusterWatchCounterpart$$hasConfirmedSomething = new AtomicBoolean(false);
        None$ initial$proxy2 = None$.MODULE$;
        this._requested = new AtomicReference<None$>(initial$proxy2);
        this.clusterWatchUniquenessChecker = new ClusterWatchUniquenessChecker(clusterConf.clusterWatchUniquenessMemorySize());
        this.currentClusterWatchId = None$.MODULE$;
        Statics.releaseFence();
    }

    @Override
    public AtomicBoolean js7$base$service$Service$$started() {
        return this.js7$base$service$Service$$started;
    }

    public Deferred js7$base$service$Service$$stopped() {
        return this.js7$base$service$Service$$stopped;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$started_$eq(AtomicBoolean x$0) {
        this.js7$base$service$Service$$started = x$0;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$stopped_$eq(Deferred x$0) {
        this.js7$base$service$Service$$stopped = x$0;
    }

    @Override
    public boolean stoppableByCancel() {
        return this.stoppableByCancel;
    }

    public final Deferred js7$base$service$StoppableByRequest$$fiber() {
        return this.js7$base$service$StoppableByRequest$$fiber;
    }

    public Deferred js7$base$service$StoppableByRequest$$stopRequested() {
        return this.js7$base$service$StoppableByRequest$$stopRequested;
    }

    @Override
    public boolean js7$base$service$StoppableByRequest$$_isStopping() {
        return this.js7$base$service$StoppableByRequest$$_isStopping;
    }

    public IO js7$base$service$StoppableByRequest$$memoizedStop() {
        return this.js7$base$service$StoppableByRequest$$memoizedStop;
    }

    @Override
    public void js7$base$service$StoppableByRequest$$_isStopping_$eq(boolean x$1) {
        this.js7$base$service$StoppableByRequest$$_isStopping = x$1;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$stoppableByCancel_$eq(boolean x$0) {
        this.stoppableByCancel = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$fiber_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$fiber = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$stopRequested_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$stopRequested = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$memoizedStop_$eq(IO x$0) {
        this.js7$base$service$StoppableByRequest$$memoizedStop = x$0;
    }

    @Override
    public IO<Service.Started> start() {
        return this.startService(this.untilStopRequested());
    }

    public IO<Either<Problem, Option<ClusterWatchConfirmation>>> checkClusterState(ClusterState.HasNodes clusterState, boolean clusterWatchIdChangeAllowed) {
        if (!(clusterState.setting().clusterWatchId().isDefined() || clusterWatchIdChangeAllowed || clusterState instanceof ClusterState.Coupled || clusterState instanceof ClusterState.PassiveLost || clusterState instanceof ClusterState.FailedOver)) {
            return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, None$.MODULE$);
        }
        return this.initializeCurrentClusterWatchId(clusterState).flatMap((Function1 & Serializable)_$1 -> (IO)CorrelId$.MODULE$.use((Function1<CorrelId, Object>)(Function1 & Serializable)correlId -> this.check(clusterState.setting().clusterWatchId(), (Function1<ClusterWatchRequest.RequestId, ClusterWatchRequest>)(Function1 & Serializable)_$2 -> ClusterWatchCheckState$.MODULE$.apply((ClusterWatchRequest.RequestId)_$2, (CorrelId)correlId, this.clusterConf.ownId(), clusterState), clusterWatchIdChangeAllowed, true).map((Function1 & Serializable)_$3 -> _$3.map((Function1 & Serializable)_$4 -> Some$.MODULE$.apply(_$4))), IO$.MODULE$.asyncForIO()));
    }

    private IO<BoxedUnit> initializeCurrentClusterWatchId(ClusterState.HasNodes clusterState) {
        return SyncDeadline$.MODULE$.usingNow((JProcedure1 & Serializable)now -> {
            if (this.currentClusterWatchId.isEmpty()) {
                clusterState.setting().clusterWatchId().foreach((Function1)(JProcedure1 & Serializable)clusterWatchId -> {
                    Logger LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger;
                    if (LoggerImpl_this.underlying().isTraceEnabled()) {
                        LoggerImpl_this.underlying().trace("initializeCurrentClusterWatchId {}", clusterWatchId);
                    }
                    this.currentClusterWatchId = Some$.MODULE$.apply((Object)this.CurrentClusterWatchId().apply((ClusterWatchId)clusterWatchId, (SyncDeadline.Now)now));
                });
                return;
            }
        });
    }

    public IO<Either<Problem, Option<ClusterWatchConfirmation>>> applyEvent(ClusterEvent event, ClusterState.HasNodes clusterState, boolean clusterWatchIdChangeAllowed, boolean forceWhenUntaught) {
        return (IO)CorrelId$.MODULE$.use((Function1<CorrelId, Object>)(Function1 & Serializable)correlId -> {
            block6: {
                block5: {
                    ClusterEvent clusterEvent;
                    block4: {
                        clusterEvent = event;
                        if (!(clusterEvent instanceof ClusterEvent.ClusterNodesAppointed)) break block4;
                        ClusterEvent.ClusterNodesAppointed clusterNodesAppointed = (ClusterEvent.ClusterNodesAppointed)clusterEvent;
                        break block5;
                    }
                    if (!(clusterEvent instanceof ClusterEvent.ClusterCouplingPrepared)) break block6;
                    ClusterEvent.ClusterCouplingPrepared clusterCouplingPrepared = (ClusterEvent.ClusterCouplingPrepared)clusterEvent;
                }
                if (!clusterState.setting().clusterWatchId().isDefined()) {
                    return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, None$.MODULE$);
                }
            }
            return this.check(clusterState.setting().clusterWatchId(), (Function1<ClusterWatchRequest.RequestId, ClusterWatchRequest>)(Function1 & Serializable)_$5 -> ClusterWatchCheckEvent$.MODULE$.apply((ClusterWatchRequest.RequestId)_$5, (CorrelId)correlId, this.clusterConf.ownId(), event, clusterState, forceWhenUntaught), clusterWatchIdChangeAllowed, this.check$default$4()).map((Function1 & Serializable)_$6 -> _$6.map((Function1 & Serializable)_$7 -> Some$.MODULE$.apply(_$7)));
        }, IO$.MODULE$.asyncForIO());
    }

    public boolean applyEvent$default$3() {
        return false;
    }

    public boolean applyEvent$default$4() {
        return false;
    }

    private IO<Either<Problem, ClusterWatchConfirmation>> check(Option<ClusterWatchId> clusterWatchId, Function1<ClusterWatchRequest.RequestId, ClusterWatchRequest> toRequest, boolean clusterWatchIdChangeAllowed, boolean isHeartbeat) {
        if (!clusterWatchIdChangeAllowed && !clusterWatchId.isDefined()) {
            Logger LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("Due to !clusterWatchIdChangeAllowed: {}", (Object)ClusterWatchProblems$NoClusterWatchProblem$.MODULE$);
            }
            return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, ClusterWatchProblems$NoClusterWatchProblem$.MODULE$);
        }
        return IO$.MODULE$.defer(() -> this.check$$anonfun$1(toRequest, clusterWatchIdChangeAllowed, isHeartbeat, clusterWatchId));
    }

    private boolean check$default$4() {
        return false;
    }

    private IO<Either<Problem, ClusterWatchConfirmation>> check2(Option<ClusterWatchId> clusterWatchId, ClusterWatchRequest request, Requested requested) {
        return SyncDeadline$.MODULE$.now().flatMap((Function1 & Serializable)since -> IO$.MODULE$.defer(() -> this.check2$$anonfun$1$$anonfun$1(requested, request, clusterWatchId, since)));
    }

    public IO<Either<Problem, BoxedUnit>> executeClusterWatchConfirm(ClusterWatchingCommand.ClusterWatchConfirm confirm) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(IO$.MODULE$.apply(() -> this.executeClusterWatchConfirm$$anonfun$1(confirm)));
        IO iO2 = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$8 -> IO$.MODULE$.apply(() -> this.executeClusterWatchConfirm$$anonfun$2$$anonfun$1(confirm)), IO$.MODULE$.asyncForIO()));
        IO iO3 = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO2, (Function1 & Serializable)requested -> {
            Some some;
            Either<Problem, ClusterWatchConfirmation> confirmation = this.toConfirmation(confirm);
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(requested.request().maybeEvent(), confirmation);
            Option option = (Option)tuple2._1();
            Either either = (Either)tuple2._2();
            if (option instanceof Some && (some = (Some)option).value() instanceof ClusterEvent.ClusterPassiveLost) {
                Left left;
                Problem problem;
                ClusterEvent.ClusterPassiveLost clusterPassiveLost = (ClusterEvent.ClusterPassiveLost)some.value();
                if (either instanceof Left && (problem = (Problem)(left = (Left)either).value()).is(ClusterWatchProblems$ClusterNodeLossNotConfirmedProblem$.MODULE$)) {
                    this._requested.compareAndSet((Option<Requested>)None$.MODULE$, (Option<Requested>)Some$.MODULE$.apply(requested));
                    Logger LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger;
                    if (LoggerImpl_this.underlying().isWarnEnabled()) {
                        LoggerImpl_this.underlying().warn(problem.toString());
                    }
                    return CatsEffectExtensions$.MODULE$.inline$rightUnitIO();
                }
            }
            confirm.manualConfirmer().foreach((Function1)(JProcedure1 & Serializable)confirmer -> {
                Logger LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger;
                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("\u203c\ufe0f {} has MANUALLY BEEN CONFIRMED by '{}' \u203c\ufe0f", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{requested.request().maybeEvent().fold(ClusterWatchCounterpart::executeClusterWatchConfirm$$anonfun$3$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$9 -> {
                        ScalaUtils.syntax.RichJavaClass<?> RichJavaClass_this = ScalaUtils$syntax$.MODULE$.RichJavaClass(_$9.getClass());
                        return RichJavaClass_this.cachedSimpleScalaName();
                    }), confirmer}), Object.class));
                    return;
                }
            });
            return requested.confirm(confirmation);
        }, IO$.MODULE$.asyncForIO()));
        return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO3, (Function1 & Serializable)_$10 -> SyncDeadline$.MODULE$.usingNow((Function1 & Serializable)contextual$5 -> {
            this.currentClusterWatchId.foreach((Function1)(JProcedure1 & Serializable)o -> o.touch(confirm.clusterWatchId(), (SyncDeadline.Now)contextual$5));
            return Checked$.MODULE$.unit();
        }), IO$.MODULE$.asyncForIO());
    }

    private Either<Problem, ClusterWatchConfirmation> toConfirmation(ClusterWatchingCommand.ClusterWatchConfirm confirm) {
        return confirm.problem().toLeft(() -> ClusterWatchCounterpart.toConfirmation$$anonfun$1(confirm));
    }

    private Either<Problem, Requested> takeRequest(ClusterWatchingCommand.ClusterWatchConfirm confirm) {
        Option<Requested> option;
        block17: {
            Requested requested;
            Some value;
            do {
                if (None$.MODULE$.equals(option = this._requested.get())) {
                    Option<CurrentClusterWatchId> option2 = this.currentClusterWatchId;
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        CurrentClusterWatchId o = (CurrentClusterWatchId)some.value();
                        ClusterWatchId clusterWatchId = o.clusterWatchId();
                        ClusterWatchId clusterWatchId2 = confirm.clusterWatchId();
                        if (clusterWatchId == null ? clusterWatchId2 != null : !((Object)clusterWatchId).equals(clusterWatchId2)) {
                            ClusterWatchProblems.OtherClusterWatchStillAliveProblem problem = ClusterWatchProblems$OtherClusterWatchStillAliveProblem$.MODULE$.apply(confirm.clusterWatchId(), o.clusterWatchId());
                            Logger LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger;
                            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                                LoggerImpl_this.underlying().warn("\u2753 {} confirms without a request \u00b7 currentClusterWatchId={} => {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{confirm.clusterWatchId(), o, problem}), Object.class));
                            }
                            return scala.package$.MODULE$.Left().apply((Object)problem);
                        }
                    }
                    ClusterWatchProblems$ClusterWatchRequestDoesNotMatchProblem$ problem = ClusterWatchProblems$ClusterWatchRequestDoesNotMatchProblem$.MODULE$;
                    Logger LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger;
                    if (LoggerImpl_this.underlying().isWarnEnabled()) {
                        LoggerImpl_this.underlying().warn("\u2753 {} confirms without a request => {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{confirm.clusterWatchId(), problem}), Object.class));
                    }
                    return scala.package$.MODULE$.Left().apply((Object)problem);
                }
                if (!(option instanceof Some)) break block17;
                Some some = (Some)option;
                requested = (Requested)some.value();
                value = some;
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(requested.clusterWatchId(), this.currentClusterWatchId);
                Option option3 = (Option)tuple2._1();
                Option option4 = (Option)tuple2._2();
                if (option3 instanceof Some) {
                    ClusterWatchId o;
                    ClusterWatchId clusterWatchId;
                    Some some2 = (Some)option3;
                    ClusterWatchId o2 = clusterWatchId = (ClusterWatchId)some2.value();
                    if (option4 instanceof Some) {
                        Some some3 = (Some)option4;
                        CurrentClusterWatchId currentClusterWatchId = (CurrentClusterWatchId)some3.value();
                        ClusterWatchId clusterWatchId3 = o2;
                        ClusterWatchId clusterWatchId4 = confirm.clusterWatchId();
                        if ((clusterWatchId3 == null ? clusterWatchId4 != null : !((Object)clusterWatchId3).equals(clusterWatchId4)) && currentClusterWatchId.isStillAlive(SyncDeadline$Now$.MODULE$.given_Now(this.ioRuntime))) {
                            ClusterWatchProblems.OtherClusterWatchStillAliveProblem problem = ClusterWatchProblems$OtherClusterWatchStillAliveProblem$.MODULE$.apply(confirm.clusterWatchId(), o2);
                            Logger LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger;
                            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                                LoggerImpl_this.underlying().warn("{} left => {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(currentClusterWatchId.timeLeft(SyncDeadline$Now$.MODULE$.given_Now(this.ioRuntime)))), problem}), Object.class));
                            }
                            return scala.package$.MODULE$.Left().apply((Object)problem);
                        }
                    }
                    ClusterWatchId clusterWatchId5 = o = clusterWatchId;
                    ClusterWatchId clusterWatchId6 = confirm.clusterWatchId();
                    if ((clusterWatchId5 == null ? clusterWatchId6 != null : !((Object)clusterWatchId5).equals(clusterWatchId6)) && !confirm.manualConfirmer().isDefined() && !requested.clusterWatchIdChangeAllowed()) {
                        return scala.package$.MODULE$.Left().apply((Object)ClusterWatchProblems$ClusterWatchIdDoesNotMatchProblem$.MODULE$.apply(confirm.clusterWatchId(), o, requested.request()));
                    }
                }
                ClusterWatchRequest.RequestId requestId = confirm.requestId();
                ClusterWatchRequest.RequestId requestId2 = requested.id();
                if (!(requestId == null ? requestId2 != null : !((Object)requestId).equals(requestId2))) continue;
                ClusterWatchProblems$ClusterWatchRequestDoesNotMatchProblem$ problem = ClusterWatchProblems$ClusterWatchRequestDoesNotMatchProblem$.MODULE$;
                Logger LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger;
                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("\u26d4 {} id={} but _requested={}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{problem, confirm.requestId(), requested.id()}), Object.class));
                }
                return scala.package$.MODULE$.Left().apply((Object)problem);
            } while (!this._requested.compareAndSet((Option<Requested>)value, (Option<Requested>)None$.MODULE$));
            Option<ClusterWatchId> option5 = requested.clusterWatchId();
            if (None$.MODULE$.equals(option5)) {
                Logger LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger;
                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("{} will be registered", (Object)confirm.clusterWatchId());
                }
            } else if (option5 instanceof Some) {
                Logger LoggerImpl_this;
                Some some = (Some)option5;
                ClusterWatchId o = (ClusterWatchId)some.value();
                ClusterWatchId clusterWatchId = confirm.clusterWatchId();
                ClusterWatchId clusterWatchId7 = o;
                if ((clusterWatchId == null ? clusterWatchId7 != null : !((Object)clusterWatchId).equals(clusterWatchId7)) && (LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger).underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("{} will replace registered {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{confirm.clusterWatchId(), o}), Object.class));
                }
            }
            return scala.package$.MODULE$.Right().apply((Object)requested);
        }
        throw new MatchError(option);
    }

    public IO<BoxedUnit> onClusterWatchRegistered(ClusterWatchId clusterWatchId) {
        return SyncDeadline$.MODULE$.usingNow((JProcedure1 & Serializable)now -> {
            Logger LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger;
            if (LoggerImpl_this.underlying().isTraceEnabled()) {
                LoggerImpl_this.underlying().trace("onClusterWatchRegistered {}", (Object)clusterWatchId);
            }
            this.currentClusterWatchId = Some$.MODULE$.apply((Object)this.CurrentClusterWatchId().apply(clusterWatchId, (SyncDeadline.Now)now));
        });
    }

    public Stream<IO, ClusterWatchRequest> newStream() {
        return this.pubsub.newStream();
    }

    public String toString() {
        return "ClusterWatchCounterpart";
    }

    private final ClusterWatchCounterpart$CurrentClusterWatchId$ CurrentClusterWatchId() {
        return this.CurrentClusterWatchId$lzy1;
    }

    private static final String args$1$1$$anonfun$1() {
        return ",clusterWatchIdChangeAllowed=false";
    }

    private static final String args$1$1(ClusterWatchRequest request$3, boolean clusterWatchIdChangeAllowed$5) {
        return request$3 + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(!clusterWatchIdChangeAllowed$5), (Function0<String>)((Function0 & Serializable)ClusterWatchCounterpart::args$1$1$$anonfun$1));
    }

    private static final Object check$$anonfun$1$$anonfun$1(ClusterWatchRequest request$18, boolean clusterWatchIdChangeAllowed$6) {
        return ClusterWatchCounterpart.args$1$1(request$18, clusterWatchIdChangeAllowed$6);
    }

    private final IO check$$anonfun$1(Function1 toRequest$1, boolean clusterWatchIdChangeAllowed$4, boolean isHeartbeat$1, Option clusterWatchId$2) {
        ClusterWatchRequest.RequestId reqId = ClusterWatchRequest$RequestId$.MODULE$.apply(this.nextRequestId.getAndIncrement());
        ClusterWatchRequest request = (ClusterWatchRequest)toRequest$1.apply((Object)reqId);
        LogLevel logLevel = PekkoHttpClient$.MODULE$.logHeartbeat() ? LogLevel$.Trace : LogLevel$.None;
        Function1 & Serializable intersect = (Function1 & Serializable)a -> {
            if (isHeartbeat$1 && a.isRight()) {
                return "\ud83d\udc9a " + a;
            }
            return a;
        };
        IO<Either<Problem, ClusterWatchConfirmation>> iO = this.check2((Option<ClusterWatchId>)clusterWatchId$2, request, new Requested((Option<ClusterWatchId>)clusterWatchId$2, request, clusterWatchIdChangeAllowed$4));
        Marker marker = Logger$package$Logger$syntax$.MODULE$.logIOWithResult$default$6(ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger);
        return this.lock.lock(Logger$package$Logger$syntax$.MODULE$.logIOWithResult(ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger, logLevel, "check", (Function0<Object>)((Function0 & Serializable)() -> ClusterWatchCounterpart.check$$anonfun$1$$anonfun$1(request, clusterWatchIdChangeAllowed$4)), intersect, marker, iO), Enclosing$.MODULE$.apply("js7.cluster.ClusterWatchCounterpart#check"), ScalaSourceLocation$.MODULE$.apply("ClusterWatchCounterpart.scala", 134));
    }

    private static final String check2$$anonfun$1$$anonfun$1$$anonfun$1(ClusterWatchRequest request$6) {
        return "ClusterWatch.send(" + request$6 + ")";
    }

    private final void check2$$anonfun$1$$anonfun$1$$anonfun$2(ClusterWatchRequest request$7) {
        this.testEventPublisher.publish(ClusterWatchCounterpart$TestWaitingForConfirmation$.MODULE$.apply(request$7));
    }

    public static final String js7$cluster$ClusterWatchCounterpart$$anon$1$$_$message$proxy3$1$$anonfun$1() {
        return "any ClusterWatch";
    }

    public static final String js7$cluster$ClusterWatchCounterpart$$anon$1$$_$message$proxy3$1$$anonfun$2$$anonfun$1() {
        return " (or other)";
    }

    private final String message$proxy4$1(ClusterWatchRequest request$11, Problem problem$2, SyncDeadline.Now since$5) {
        return "\u26a0\ufe0f  " + request$11.toShortString() + " => " + problem$2 + " \u00b7 after " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(since$5.elapsed(SyncDeadline$Now$.MODULE$.given_Now(this.ioRuntime))));
    }

    private final String check2$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1(ClusterWatchRequest request$21, Problem problem$4, SyncDeadline.Now since$12) {
        return this.message$proxy4$1(request$21, problem$4, since$12);
    }

    private final void check2$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1(BlockingSymbol sym$3, ClusterWatchRequest request$10, Problem problem$1, SyncDeadline.Now since$4) {
        LogLevel level$proxy2 = (LogLevel)Ordering.Implicits$.MODULE$.infixOrderingOps((Object)sym$3.relievedLogLevel(), LogLevel$.MODULE$.given_Ordering_LogLevel()).min((Object)LogLevel$.Debug);
        Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger.underlying()), level$proxy2, (Function0<String>)((Function0 & Serializable)() -> this.check2$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1(request$10, problem$1, since$4)));
    }

    private static final void check2$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$2(ClusterWatchRequest request$12, Problem problem$3) {
        Logger LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger;
        if (LoggerImpl_this.underlying().isWarnEnabled()) {
            LoggerImpl_this.underlying().warn("\u26d4 ClusterWatch rejected {}: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{request$12.toShortString(), problem$3}), Object.class));
            return;
        }
    }

    private static final String message$proxy6$1(ClusterWatchConfirmation confirmation$3, ClusterWatchRequest request$14, SyncDeadline.Now since$7, SyncDeadline.Now contextual$2$1) {
        return "\ud83d\udfe2 " + confirmation$3.clusterWatchId() + " finally confirmed " + request$14.toShortString() + " after " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(since$7.elapsed(contextual$2$1)));
    }

    private static final String check2$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$3$$anonfun$1(ClusterWatchConfirmation confirmation$4, ClusterWatchRequest request$24, SyncDeadline.Now since$14, SyncDeadline.Now contextual$2$2) {
        return ClusterWatchCounterpart.message$proxy6$1(confirmation$4, request$24, since$14, contextual$2$2);
    }

    private final void check2$$anonfun$1$$anonfun$1$$anonfun$5() {
        this._requested.set((Option<Requested>)None$.MODULE$);
    }

    private final IO check2$$anonfun$1$$anonfun$1(Requested requested$2, ClusterWatchRequest request$5, Option clusterWatchId$4, SyncDeadline.Now since$1) {
        Some a$proxy1 = Some$.MODULE$.apply((Object)requested$2);
        this._requested.set((Option<Requested>)a$proxy1);
        BlockingSymbol sym = new BlockingSymbol();
        IO iO = this.pubsub.publish(request$5);
        return CatsEffectExtensions$.MODULE$.recoverFromProblemAndRetry(CatsUtils$syntax$.MODULE$.logWhenItTakesLonger(iO, (Function0<String>)((Function0 & Serializable)() -> ClusterWatchCounterpart.check2$$anonfun$1$$anonfun$1$$anonfun$1(request$5)), CatsUtils$syntax$.MODULE$.logWhenItTakesLonger$default$3(iO)).$times$greater(IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.check2$$anonfun$1$$anonfun$1$$anonfun$2(request$5);
            return BoxedUnit.UNIT;
        })).$times$greater(requested$2.untilConfirmed().timeoutTo((Duration)this.js7$cluster$ClusterWatchCounterpart$$timing.clusterWatchReactionTimeout(), CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$MyRequestTimeoutProblem))), BoxedUnit.UNIT, new Serializable(sym, clusterWatchId$4, requested$2, request$5, since$1, this){
            private final BlockingSymbol sym$1;
            private final Option clusterWatchId$5;
            private final Requested requested$3;
            private final ClusterWatchRequest request$8;
            private final SyncDeadline.Now since$2;
            private final /* synthetic */ ClusterWatchCounterpart $outer;
            {
                this.sym$1 = sym$6;
                this.clusterWatchId$5 = clusterWatchId$7;
                this.requested$3 = requested$5;
                this.request$8 = request$20;
                this.since$2 = since$11;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Tuple3 x2) {
                Tuple3 tuple3 = x2;
                Problem problem = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$MyRequestTimeoutProblem;
                Object object = tuple3._1();
                if (!(problem != null ? !((Object)problem).equals(object) : object != null)) {
                    Function1 retry = (Function1)tuple3._3();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Tuple3 x2, Function1 function1) {
                Tuple3 tuple3 = x2;
                Problem problem = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$MyRequestTimeoutProblem;
                Object object = tuple3._1();
                if (!(problem != null ? !((Object)problem).equals(object) : object != null)) {
                    Function1 retry = (Function1)tuple3._3();
                    return ((IO)this.$outer.js7$cluster$ClusterWatchCounterpart$$shuttingDown.tryGet()).flatMap((Function1 & Serializable)x$1 -> {
                        Option option = x$1;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            Object object = some.value();
                            if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                                return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problems$ClusterModuleShuttingDownProblem$.MODULE$);
                            }
                        }
                        if (None$.MODULE$.equals(option)) {
                            return SyncDeadline$.MODULE$.usingNow((JProcedure1 & Serializable)contextual$1 -> {
                                if (this.$outer.js7$cluster$ClusterWatchCounterpart$$hasConfirmedSomething.get()) {
                                    this.sym$1.escalate(LogLevel$.Warn, this.sym$1.escalate$default$2());
                                } else {
                                    this.sym$1.escalate();
                                }
                                LogLevel level$proxy1 = this.sym$1.logLevel();
                                Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger.underlying()), level$proxy1, (Function0<String>)((Function0 & Serializable)() -> this.applyOrElse$$anonfun$1$$anonfun$1$$anonfun$1(contextual$1)));
                            }).$times$greater((IO)retry.apply((Object)BoxedUnit.UNIT));
                        }
                        throw new MatchError((Object)option);
                    });
                }
                return function1.apply((Object)x2);
            }

            private final String message$proxy3$1(SyncDeadline.Now contextual$1$1) {
                return this.sym$1 + " Still trying to get a confirmation from " + this.clusterWatchId$5.fold(ClusterWatchCounterpart::js7$cluster$ClusterWatchCounterpart$$anon$1$$_$message$proxy3$1$$anonfun$1, (Function1 & Serializable)id -> id.toString() + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(this.requested$3.clusterWatchIdChangeAllowed()), (Function0<String>)((Function0 & Serializable)ClusterWatchCounterpart::js7$cluster$ClusterWatchCounterpart$$anon$1$$_$message$proxy3$1$$anonfun$2$$anonfun$1))) + " for " + this.request$8.toShortString() + " for " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(this.since$2.elapsed(contextual$1$1))) + "...";
            }

            private final String applyOrElse$$anonfun$1$$anonfun$1$$anonfun$1(SyncDeadline.Now contextual$1$2) {
                return this.message$proxy3$1(contextual$1$2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(scala.Function1 scala.Option ), js7$cluster$ClusterWatchCounterpart$$anon$1$$_$message$proxy3$1$$anonfun$2$$anonfun$1(), js7$cluster$ClusterWatchCounterpart$$anon$1$$_$message$proxy3$1$$anonfun$1(), message$proxy3$1$$anonfun$2(js7.data.cluster.ClusterWatchId ), applyOrElse$$anonfun$1$$anonfun$1$$anonfun$1(js7.base.catsutils.SyncDeadline$Now ), applyOrElse$$anonfun$1$$anonfun$1(js7.base.catsutils.SyncDeadline$Now )}, serializedLambda);
            }
        }).flatTap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                Problem problem = (Problem)left.value();
                if (((Object)Problems$ClusterModuleShuttingDownProblem$.MODULE$).equals(problem)) {
                    Problem problem2 = problem;
                    return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                        this.check2$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1(sym, request$5, problem2, since$1);
                        return BoxedUnit.UNIT;
                    });
                }
                Problem problem3 = problem;
                return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                    ClusterWatchCounterpart.check2$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$2(request$5, problem3);
                    return BoxedUnit.UNIT;
                });
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                ClusterWatchConfirmation confirmation = (ClusterWatchConfirmation)right.value();
                this.js7$cluster$ClusterWatchCounterpart$$hasConfirmedSomething.set(true);
                this.testEventPublisher.publish(ClusterWatchCounterpart$TestConfirmed$.MODULE$.apply(request$5, confirmation));
                return SyncDeadline$.MODULE$.usingNow((JProcedure1 & Serializable)contextual$2 -> {
                    LogLevel level$proxy3 = sym.relievedLogLevel();
                    Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger.underlying()), level$proxy3, (Function0<String>)((Function0 & Serializable)() -> ClusterWatchCounterpart.check2$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$3$$anonfun$1(confirmation, request$5, since$1, contextual$2)));
                });
            }
            throw new MatchError((Object)either);
        }).guaranteeCase((Function1 & Serializable)x$1 -> {
            Outcome outcome = x$1;
            if (outcome instanceof Outcome.Errored) {
                Throwable throwable;
                Outcome.Errored errored = (Outcome.Errored)outcome;
                package$.MODULE$.Outcome();
                Outcome.Errored errored2 = Outcome.Errored$.MODULE$.unapply(errored);
                Throwable t = throwable = (Throwable)errored2._1();
                if (sym.warnLogged()) {
                    return SyncDeadline$.MODULE$.usingNow((JProcedure1 & Serializable)contextual$3 -> {
                        Logger LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger;
                        if (LoggerImpl_this.underlying().isWarnEnabled()) {
                            Object[] objectArray = new Object[3];
                            objectArray[0] = request$5.toShortString();
                            Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                            objectArray[1] = ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable);
                            objectArray[2] = ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(since$1.elapsed((SyncDeadline.Now)contextual$3)));
                            LoggerImpl_this.underlying().warn("\ud83d\udca5 {} => {} \u00b7 after {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
                            return;
                        }
                    });
                }
            }
            if (outcome instanceof Outcome.Canceled) {
                Outcome.Canceled canceled = (Outcome.Canceled)outcome;
                package$.MODULE$.Outcome();
                if (Outcome.Canceled$.MODULE$.unapply(canceled) && sym.warnLogged()) {
                    return SyncDeadline$.MODULE$.usingNow((JProcedure1 & Serializable)contextual$4 -> {
                        Logger LoggerImpl_this = ClusterWatchCounterpart$.js7$cluster$ClusterWatchCounterpart$$$logger;
                        if (LoggerImpl_this.underlying().isInfoEnabled()) {
                            LoggerImpl_this.underlying().info("\u25fc\ufe0f {} => Canceled after {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{request$5.toShortString(), ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(since$1.elapsed((SyncDeadline.Now)contextual$4)))}), Object.class));
                            return;
                        }
                    });
                }
            }
            return IO$.MODULE$.unit();
        }).guarantee(IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.check2$$anonfun$1$$anonfun$1$$anonfun$5();
            return BoxedUnit.UNIT;
        }));
    }

    private final Either executeClusterWatchConfirm$$anonfun$1(ClusterWatchingCommand.ClusterWatchConfirm confirm$1) {
        return this.clusterWatchUniquenessChecker.check(confirm$1.clusterWatchId(), confirm$1.clusterWatchRunId());
    }

    private final Either executeClusterWatchConfirm$$anonfun$2$$anonfun$1(ClusterWatchingCommand.ClusterWatchConfirm confirm$3) {
        return this.takeRequest(confirm$3);
    }

    private static final String executeClusterWatchConfirm$$anonfun$3$$anonfun$1$$anonfun$1() {
        return "?";
    }

    private static final ClusterWatchConfirmation toConfirmation$$anonfun$1(ClusterWatchingCommand.ClusterWatchConfirm confirm$8) {
        return ClusterWatchConfirmation$.MODULE$.apply(confirm$8.requestId(), confirm$8.clusterWatchId(), confirm$8.clusterWatchRunId());
    }

    public class CurrentClusterWatchId
    implements Product,
    Serializable {
        private final ClusterWatchId clusterWatchId;
        private final SyncDeadline.Now initialNow;
        private SyncDeadline expires;
        private final /* synthetic */ ClusterWatchCounterpart $outer;

        public CurrentClusterWatchId(ClusterWatchCounterpart $outer, ClusterWatchId clusterWatchId, SyncDeadline.Now initialNow) {
            this.clusterWatchId = clusterWatchId;
            this.initialNow = initialNow;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.expires = initialNow.$plus($outer.js7$cluster$ClusterWatchCounterpart$$timing.clusterWatchIdTimeout());
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 2053735302, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            CurrentClusterWatchId currentClusterWatchId;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CurrentClusterWatchId)) return false;
            if (((CurrentClusterWatchId)object).js7$cluster$ClusterWatchCounterpart$CurrentClusterWatchId$$$outer() != this.$outer) return false;
            CurrentClusterWatchId currentClusterWatchId2 = currentClusterWatchId = (CurrentClusterWatchId)object;
            ClusterWatchId clusterWatchId = this.clusterWatchId();
            ClusterWatchId clusterWatchId2 = currentClusterWatchId2.clusterWatchId();
            if (clusterWatchId == null) {
                if (clusterWatchId2 != null) {
                    return false;
                }
            } else if (!((Object)clusterWatchId).equals(clusterWatchId2)) return false;
            SyncDeadline.Now now = this.initialNow();
            SyncDeadline.Now now2 = currentClusterWatchId2.initialNow();
            if (now == null) {
                if (now2 != null) {
                    return false;
                }
            } else if (!((Object)now).equals(now2)) return false;
            if (!currentClusterWatchId2.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof CurrentClusterWatchId;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "CurrentClusterWatchId";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "clusterWatchId";
            }
            if (1 == n2) {
                return "initialNow";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ClusterWatchId clusterWatchId() {
            return this.clusterWatchId;
        }

        public SyncDeadline.Now initialNow() {
            return this.initialNow;
        }

        public void touch(ClusterWatchId clusterWatchId, SyncDeadline.Now now) {
            ClusterWatchId clusterWatchId2 = clusterWatchId;
            ClusterWatchId clusterWatchId3 = this.clusterWatchId();
            if (!(clusterWatchId2 != null ? !((Object)clusterWatchId2).equals(clusterWatchId3) : clusterWatchId3 != null)) {
                this.expires = now.$plus(this.$outer.js7$cluster$ClusterWatchCounterpart$$timing.clusterWatchIdTimeout());
                return;
            }
        }

        public boolean isStillAlive(SyncDeadline.Now x$1) {
            return this.expires.hasTimeLeft(x$1);
        }

        public FiniteDuration timeLeft(SyncDeadline.Now x$1) {
            return this.expires.timeLeft(x$1);
        }

        public String toString() {
            return this.clusterWatchId().toString();
        }

        public CurrentClusterWatchId copy(ClusterWatchId clusterWatchId, SyncDeadline.Now initialNow) {
            return new CurrentClusterWatchId(this.$outer, clusterWatchId, initialNow);
        }

        public ClusterWatchId copy$default$1() {
            return this.clusterWatchId();
        }

        public SyncDeadline.Now copy$default$2() {
            return this.initialNow();
        }

        public ClusterWatchId _1() {
            return this.clusterWatchId();
        }

        public SyncDeadline.Now _2() {
            return this.initialNow();
        }

        public final /* synthetic */ ClusterWatchCounterpart js7$cluster$ClusterWatchCounterpart$CurrentClusterWatchId$$$outer() {
            return this.$outer;
        }
    }

    public static class RequestTimeoutException
    extends Exception {
    }

    public static final class Requested {
        private final Option<ClusterWatchId> clusterWatchId;
        private final ClusterWatchRequest request;
        private final boolean clusterWatchIdChangeAllowed;
        private final Deferred<IO, Either<Problem, ClusterWatchConfirmation>> confirmation;

        public Requested(Option<ClusterWatchId> clusterWatchId, ClusterWatchRequest request, boolean clusterWatchIdChangeAllowed) {
            this.clusterWatchId = clusterWatchId;
            this.request = request;
            this.clusterWatchIdChangeAllowed = clusterWatchIdChangeAllowed;
            this.confirmation = package$.MODULE$.Deferred().unsafe(IO$.MODULE$.asyncForIO());
        }

        public Option<ClusterWatchId> clusterWatchId() {
            return this.clusterWatchId;
        }

        public ClusterWatchRequest request() {
            return this.request;
        }

        public boolean clusterWatchIdChangeAllowed() {
            return this.clusterWatchIdChangeAllowed;
        }

        public ClusterWatchRequest.RequestId id() {
            return this.request().requestId();
        }

        public IO<Either<Problem, ClusterWatchConfirmation>> untilConfirmed() {
            return (IO)this.confirmation.get();
        }

        public IO<Either<Problem, BoxedUnit>> confirm(Either<Problem, ClusterWatchConfirmation> confirm) {
            return ((IO)this.confirmation.complete(confirm)).as(Checked$.MODULE$.unit());
        }

        public String toString() {
            return "Requested(" + this.id() + "," + this.clusterWatchId() + ",clusterWatchIdChangeAllowed=" + this.clusterWatchIdChangeAllowed() + ")";
        }
    }

    public static final class TestConfirmed
    implements Product,
    Serializable {
        private final ClusterWatchRequest request;
        private final ClusterWatchConfirmation confirmation;

        public static TestConfirmed apply(ClusterWatchRequest clusterWatchRequest, ClusterWatchConfirmation clusterWatchConfirmation) {
            return ClusterWatchCounterpart$TestConfirmed$.MODULE$.apply(clusterWatchRequest, clusterWatchConfirmation);
        }

        public static TestConfirmed fromProduct(Product product) {
            return ClusterWatchCounterpart$TestConfirmed$.MODULE$.fromProduct(product);
        }

        public static TestConfirmed unapply(TestConfirmed testConfirmed) {
            return ClusterWatchCounterpart$TestConfirmed$.MODULE$.unapply(testConfirmed);
        }

        public TestConfirmed(ClusterWatchRequest request, ClusterWatchConfirmation confirmation) {
            this.request = request;
            this.confirmation = confirmation;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 1127821370, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            TestConfirmed testConfirmed;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TestConfirmed)) return false;
            TestConfirmed testConfirmed2 = testConfirmed = (TestConfirmed)object;
            ClusterWatchRequest clusterWatchRequest = this.request();
            ClusterWatchRequest clusterWatchRequest2 = testConfirmed2.request();
            if (clusterWatchRequest == null) {
                if (clusterWatchRequest2 != null) {
                    return false;
                }
            } else if (!clusterWatchRequest.equals(clusterWatchRequest2)) return false;
            ClusterWatchConfirmation clusterWatchConfirmation = this.confirmation();
            ClusterWatchConfirmation clusterWatchConfirmation2 = testConfirmed2.confirmation();
            if (clusterWatchConfirmation == null) {
                if (clusterWatchConfirmation2 == null) return true;
                return false;
            } else {
                if (!((Object)clusterWatchConfirmation).equals(clusterWatchConfirmation2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TestConfirmed;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "TestConfirmed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "request";
            }
            if (1 == n2) {
                return "confirmation";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ClusterWatchRequest request() {
            return this.request;
        }

        public ClusterWatchConfirmation confirmation() {
            return this.confirmation;
        }

        public TestConfirmed copy(ClusterWatchRequest request, ClusterWatchConfirmation confirmation) {
            return new TestConfirmed(request, confirmation);
        }

        public ClusterWatchRequest copy$default$1() {
            return this.request();
        }

        public ClusterWatchConfirmation copy$default$2() {
            return this.confirmation();
        }

        public ClusterWatchRequest _1() {
            return this.request();
        }

        public ClusterWatchConfirmation _2() {
            return this.confirmation();
        }
    }

    public static final class TestWaitingForConfirmation
    implements Product,
    Serializable {
        private final ClusterWatchRequest request;

        public static TestWaitingForConfirmation apply(ClusterWatchRequest clusterWatchRequest) {
            return ClusterWatchCounterpart$TestWaitingForConfirmation$.MODULE$.apply(clusterWatchRequest);
        }

        public static TestWaitingForConfirmation fromProduct(Product product) {
            return ClusterWatchCounterpart$TestWaitingForConfirmation$.MODULE$.fromProduct(product);
        }

        public static TestWaitingForConfirmation unapply(TestWaitingForConfirmation testWaitingForConfirmation) {
            return ClusterWatchCounterpart$TestWaitingForConfirmation$.MODULE$.unapply(testWaitingForConfirmation);
        }

        public TestWaitingForConfirmation(ClusterWatchRequest request) {
            this.request = request;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 1277410324, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            TestWaitingForConfirmation testWaitingForConfirmation;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TestWaitingForConfirmation)) return false;
            TestWaitingForConfirmation testWaitingForConfirmation2 = testWaitingForConfirmation = (TestWaitingForConfirmation)object;
            ClusterWatchRequest clusterWatchRequest = this.request();
            ClusterWatchRequest clusterWatchRequest2 = testWaitingForConfirmation2.request();
            if (clusterWatchRequest != null) {
                if (!clusterWatchRequest.equals(clusterWatchRequest2)) return false;
                return true;
            }
            if (clusterWatchRequest2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TestWaitingForConfirmation;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "TestWaitingForConfirmation";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "request";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ClusterWatchRequest request() {
            return this.request;
        }

        public TestWaitingForConfirmation copy(ClusterWatchRequest request) {
            return new TestWaitingForConfirmation(request);
        }

        public ClusterWatchRequest copy$default$1() {
            return this.request();
        }

        public ClusterWatchRequest _1() {
            return this.request();
        }
    }
}

