/*
 * Decompiled with CFR 0.152.
 */
package js7.cluster.watch;

import cats.effect.IO;
import cats.effect.IO$;
import cats.kernel.Monoid;
import cats.kernel.Semigroup$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.catsutils.SyncDeadline;
import js7.base.catsutils.SyncDeadline$;
import js7.base.log.Logger$package$Logger$;
import js7.base.log.Logger$package$Logger$syntax$;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$CheckedOption$;
import js7.base.problem.Problem;
import js7.base.scalasource.ScalaSourceLocation$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.AsyncLock;
import js7.base.utils.AsyncLock$;
import js7.base.utils.ScalaUtils;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.cluster.watch.ClusterWatch$;
import js7.cluster.watch.ClusterWatch$Confirmed$;
import js7.cluster.watch.ClusterWatch$LossRejected$;
import js7.cluster.watch.ClusterWatch$State$;
import js7.data.cluster.ClusterEvent;
import js7.data.cluster.ClusterEvent$ClusterFailedOver$;
import js7.data.cluster.ClusterSetting;
import js7.data.cluster.ClusterState;
import js7.data.cluster.ClusterState$Coupled$;
import js7.data.cluster.ClusterState$PassiveLost$;
import js7.data.cluster.ClusterWatchProblems;
import js7.data.cluster.ClusterWatchProblems$ClusterFailOverWhilePassiveLostProblem$;
import js7.data.cluster.ClusterWatchProblems$ClusterNodeIsNotLostProblem$;
import js7.data.cluster.ClusterWatchProblems$ClusterNodeLossNotConfirmedProblem$;
import js7.data.cluster.ClusterWatchProblems$ClusterWatchEventMismatchProblem$;
import js7.data.cluster.ClusterWatchProblems$ClusterWatchInactiveNodeProblem$;
import js7.data.cluster.ClusterWatchProblems$UntaughtClusterWatchProblem$;
import js7.data.cluster.ClusterWatchRequest;
import js7.data.node.NodeId;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.View$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.hashing.MurmurHash3$;
import sourcecode.Enclosing$;

public final class ClusterWatch {
    private final Function1<ClusterState.HasNodes, BoxedUnit> onClusterStateChanged;
    private final boolean requireManualNodeLossConfirmation;
    private final Function1<ClusterState.HasNodes, IO<Either<Problem, BoxedUnit>>> checkActiveIsLost;
    private final Function1<Option<ClusterWatchProblems.ClusterNodeLossNotConfirmedProblem>, IO<BoxedUnit>> onUndecidableClusterNodeLoss;
    private final Logger logger;
    private final AsyncLock lock;
    private final Map<NodeId, LossRejected> _nodeToLossRejected;
    private Option<State> _state;

    public static String $lessinit$greater$default$1() {
        return ClusterWatch$.MODULE$.$lessinit$greater$default$1();
    }

    public static Function1<ClusterState.HasNodes, BoxedUnit> $lessinit$greater$default$2() {
        return ClusterWatch$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$3() {
        return ClusterWatch$.MODULE$.$lessinit$greater$default$3();
    }

    public static Function1<Option<ClusterWatchProblems.ClusterNodeLossNotConfirmedProblem>, IO<BoxedUnit>> $lessinit$greater$default$5() {
        return ClusterWatch$.MODULE$.$lessinit$greater$default$5();
    }

    public ClusterWatch(String label, Function1<ClusterState.HasNodes, BoxedUnit> onClusterStateChanged, boolean requireManualNodeLossConfirmation, Function1<ClusterState.HasNodes, IO<Either<Problem, BoxedUnit>>> checkActiveIsLost, Function1<Option<ClusterWatchProblems.ClusterNodeLossNotConfirmedProblem>, IO<BoxedUnit>> onUndecidableClusterNodeLoss) {
        this.onClusterStateChanged = onClusterStateChanged;
        this.requireManualNodeLossConfirmation = requireManualNodeLossConfirmation;
        this.checkActiveIsLost = checkActiveIsLost;
        this.onUndecidableClusterNodeLoss = onUndecidableClusterNodeLoss;
        this.logger = Logger$package$Logger$.MODULE$.withPrefix(label, ClassTag$.MODULE$.apply(ClusterWatch.class));
        this.lock = AsyncLock$.MODULE$.apply(Enclosing$.MODULE$.apply("js7.cluster.watch.ClusterWatch#lock"));
        this._nodeToLossRejected = (Map)Map$.MODULE$.empty();
        this._state = None$.MODULE$;
    }

    public IO<Either<Problem, Confirmed>> processRequest(ClusterWatchRequest request) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(IO$.MODULE$.pure(request.checked()));
        return Logger$package$Logger$syntax$.MODULE$.debugIOWithResult(this.logger, "processRequest", (Function0<Object>)((Function0 & Serializable)() -> ClusterWatch.processRequest$$anonfun$1(request)), this.lock.lock((IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$3 -> this.processRequest2(request), IO$.MODULE$.asyncForIO()), Enclosing$.MODULE$.apply("js7.cluster.watch.ClusterWatch#processRequest"), ScalaSourceLocation$.MODULE$.apply("ClusterWatch.scala", 41)));
    }

    private IO<Either<Problem, Confirmed>> processRequest2(ClusterWatchRequest request) {
        IO checkedClusterState = SyncDeadline$.MODULE$.now().flatMap((Function1 & Serializable)now -> {
            LazyRef lazyRef = new LazyRef();
            Logger LoggerImpl_this = this.logger;
            if (LoggerImpl_this.underlying().isTraceEnabled()) {
                LoggerImpl_this.underlying().trace("{}: {}{}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{request.from(), ClusterWatch.opString$5(lazyRef, request), this._state.fold(ClusterWatch::$anonfun$1$$anonfun$1, (Function1 & Serializable)o -> ", after " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(o.lastHeartbeat().elapsed((SyncDeadline.Now)now))))}), Object.class));
            }
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(this._state, request.maybeEvent());
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option)) {
                Logger LoggerImpl_this2;
                Some some;
                ClusterEvent clusterEvent;
                if (option2 instanceof Some && (clusterEvent = (ClusterEvent)(some = (Some)option2).value()) instanceof ClusterEvent.ClusterNodeLostEvent) {
                    ClusterEvent.ClusterNodeLostEvent clusterNodeLostEvent;
                    ClusterEvent.ClusterNodeLostEvent event2 = clusterNodeLostEvent = (ClusterEvent.ClusterNodeLostEvent)clusterEvent;
                    if (!request.forceWhenUntaught()) {
                        return IO$.MODULE$.apply(() -> this.$anonfun$1$$anonfun$3(event2, request));
                    }
                }
                if ((LoggerImpl_this2 = this.logger).underlying().isInfoEnabled()) {
                    LoggerImpl_this2.underlying().info("{} teaches clusterState={}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{request.from(), request.clusterState()}), Object.class));
                }
                None$ none$ = (None$)Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$);
                return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)none$, (Object)request.clusterState()));
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                State state = (State)some.value();
                return state.processRequest(request, (Function1<ClusterEvent.ClusterNodeLostEvent, Option<String>>)(Function1 & Serializable)event -> this.manuallyConfirmed((ClusterEvent.ClusterNodeLostEvent)event), this.checkActiveIsLost, (Function0<String>)((Function0 & Serializable)() -> ClusterWatch.$anonfun$1$$anonfun$5(lazyRef, request)), (SyncDeadline.Now)now);
            }
            throw new MatchError((Object)tuple2);
        });
        return checkedClusterState.flatMap((Function1 & Serializable)x$1 -> {
            Right right;
            Tuple2 tuple2;
            Either either = x$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                Problem problem = (Problem)left.value();
                if (problem instanceof ClusterWatchProblems.ClusterNodeLossNotConfirmedProblem) {
                    ClusterWatchProblems.ClusterNodeLossNotConfirmedProblem clusterNodeLossNotConfirmedProblem;
                    ClusterWatchProblems.ClusterNodeLossNotConfirmedProblem problem2 = clusterNodeLossNotConfirmedProblem = (ClusterWatchProblems.ClusterNodeLossNotConfirmedProblem)problem;
                    return SyncDeadline$.MODULE$.usingNow((JProcedure1 & Serializable)now -> {
                        this._nodeToLossRejected.update((Object)problem2.event().lostNodeId(), (Object)ClusterWatch$LossRejected$.MODULE$.apply(problem2.event(), ClusterWatch$LossRejected$.MODULE$.$lessinit$greater$default$2()));
                        this._state = this._state.map((Function1 & Serializable)state -> {
                            SyncDeadline syncDeadline = (SyncDeadline)Some$.MODULE$.apply(state).filter((Function1 & Serializable)_$4 -> {
                                NodeId nodeId = _$4.clusterState().activeId();
                                NodeId nodeId2 = request.from();
                                return nodeId == null ? nodeId2 != null : !((Object)nodeId).equals(nodeId2);
                            }).fold(() -> ClusterWatch.$anonfun$3(now), (Function1 & Serializable)_$5 -> _$5.lastHeartbeat());
                            Logger logger = state.copy$default$1();
                            ClusterState.HasNodes hasNodes = state.copy$default$2();
                            boolean bl = state.copy$default$4();
                            return state.copy(logger, hasNodes, syncDeadline, bl);
                        });
                    }).flatMap((Function1 & Serializable)_$6 -> ((IO)this.onUndecidableClusterNodeLoss.apply((Object)Some$.MODULE$.apply((Object)problem2))).as((Object)package$.MODULE$.Left().apply((Object)problem2)));
                }
                Problem problem3 = problem;
                this._nodeToLossRejected.clear();
                return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, problem3);
            }
            if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                Option option = (Option)tuple2._1();
                ClusterState.HasNodes hasNodes = (ClusterState.HasNodes)tuple2._2();
                Option maybeManualConfirmer = option;
                ClusterState.HasNodes updatedClusterState = hasNodes;
                return SyncDeadline$.MODULE$.now().flatMap((Function1 & Serializable)now -> {
                    this._nodeToLossRejected.clear();
                    boolean changed = !this._state.exists((Function1 & Serializable)_$7 -> {
                        ClusterState.HasNodes hasNodes = _$7.clusterState();
                        ClusterState.HasNodes hasNodes2 = updatedClusterState;
                        return !(hasNodes != null ? !hasNodes.equals(hasNodes2) : hasNodes2 != null);
                    });
                    this._state = Some$.MODULE$.apply((Object)ClusterWatch$State$.MODULE$.apply(this.logger, updatedClusterState, (SyncDeadline)now, this.requireManualNodeLossConfirmation));
                    if (changed) {
                        this.onClusterStateChanged.apply((Object)updatedClusterState);
                    }
                    return ((IO)ScalaUtils$syntax$.MODULE$.foldMap(maybeManualConfirmer, (Function1 & Serializable)x2 -> (IO)this.onUndecidableClusterNodeLoss.apply((Object)None$.MODULE$), IO$.MODULE$.monoidForIO((Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit()))).as((Object)package$.MODULE$.Right().apply((Object)ClusterWatch$Confirmed$.MODULE$.apply((Option<String>)maybeManualConfirmer)));
                });
            }
            throw new MatchError((Object)either);
        });
    }

    private Option<String> manuallyConfirmed(ClusterEvent.ClusterNodeLostEvent event) {
        return this._nodeToLossRejected.get((Object)event.lostNodeId()).flatMap((Function1 & Serializable)_$8 -> _$8.manuallyConfirmed(event));
    }

    public IO<Either<Problem, BoxedUnit>> manuallyConfirmNodeLoss(NodeId lostNodeId, String confirmer) {
        return Logger$package$Logger$syntax$.MODULE$.debugIO(this.logger, "manuallyConfirmNodeLoss", (Function0<Object>)((Function0 & Serializable)() -> ClusterWatch.manuallyConfirmNodeLoss$$anonfun$1(lostNodeId)), this.lock.lock(IO$.MODULE$.apply(() -> this.manuallyConfirmNodeLoss$$anonfun$2(lostNodeId, confirmer)), Enclosing$.MODULE$.apply("js7.cluster.watch.ClusterWatch#manuallyConfirmNodeLoss"), ScalaSourceLocation$.MODULE$.apply("ClusterWatch.scala", 118)));
    }

    private Either<Problem, LossRejected> matchRejectedNodeLostEvent(NodeId lostNodeId) {
        ClusterWatchProblems.ClusterNodeIsNotLostProblem problem;
        block6: {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)this._nodeToLossRejected.get((Object)lostNodeId), (Object)this._state.map((Function1 & Serializable)_$9 -> _$9.clusterState()));
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some;
                ClusterState.HasNodes hasNodes;
                LossRejected lossRejected;
                Some some2 = (Some)option;
                LossRejected lossRejected2 = lossRejected = (LossRejected)some2.value();
                if (None$.MODULE$.equals(option2)) {
                    NodeId nodeId = lossRejected2.event().lostNodeId();
                    NodeId nodeId2 = lostNodeId;
                    if (!(nodeId != null ? !((Object)nodeId).equals(nodeId2) : nodeId2 != null)) {
                        return package$.MODULE$.Right().apply((Object)lossRejected2);
                    }
                }
                LossRejected lossRejected3 = lossRejected;
                if (option2 instanceof Some && (hasNodes = (ClusterState.HasNodes)(some = (Some)option2).value()) instanceof ClusterState.Coupled) {
                    ClusterSetting clusterSetting;
                    ClusterState.Coupled coupled = (ClusterState.Coupled)hasNodes;
                    ClusterState.Coupled coupled2 = ClusterState$Coupled$.MODULE$.unapply(coupled);
                    ClusterSetting setting = clusterSetting = coupled2._1();
                    NodeId nodeId = lossRejected3.event().lostNodeId();
                    NodeId nodeId3 = lostNodeId;
                    if (!(nodeId != null ? !((Object)nodeId).equals(nodeId3) : nodeId3 != null)) {
                        NodeId nodeId4 = lostNodeId;
                        NodeId nodeId5 = setting.activeId();
                        if (!(nodeId4 != null ? !((Object)nodeId4).equals(nodeId5) : nodeId5 != null)) {
                            return package$.MODULE$.Right().apply((Object)lossRejected3);
                        }
                    }
                }
            }
            Option maybeLossRejected = option;
            Option maybeClusterState = option2;
            problem = ClusterWatchProblems$ClusterNodeIsNotLostProblem$.MODULE$.apply(lostNodeId);
            Logger LoggerImpl_this = this.logger;
            if (!LoggerImpl_this.underlying().isDebugEnabled()) break block6;
            LoggerImpl_this.underlying().debug("\u26a0\ufe0f  {} \u2502 {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{problem, ((IterableOnceOps)View$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{maybeLossRejected, maybeClusterState})).flatten(Predef$.MODULE$.$conforms())).mkString(" ")}), Object.class));
        }
        return package$.MODULE$.Left().apply((Object)problem);
    }

    public Option<ClusterEvent.ClusterNodeLostEvent> clusterNodeLossEventToBeConfirmed(NodeId lostNodeId) {
        return this._nodeToLossRejected.get((Object)lostNodeId).map((Function1 & Serializable)_$10 -> _$10.event());
    }

    public Either<Problem, Object> isActive(NodeId id) {
        return this.clusterState().map((Function1 & Serializable)_$11 -> {
            NodeId nodeId = _$11.activeId();
            NodeId nodeId2 = id;
            return !(nodeId != null ? !((Object)nodeId).equals(nodeId2) : nodeId2 != null);
        });
    }

    public Either<Problem, ClusterState.HasNodes> clusterState() {
        Option option = Checked$.MODULE$.CheckedOption(this._state);
        return Checked$CheckedOption$.MODULE$.toChecked$extension(option, (Function0<Problem>)((Function0 & Serializable)ClusterWatch::clusterState$$anonfun$1)).map((Function1 & Serializable)_$12 -> _$12.clusterState());
    }

    public String toString() {
        return "ClusterWatch(" + this._state.fold(ClusterWatch::toString$$anonfun$1, (Function1 & Serializable)state -> state.clusterState().toShortString()) + ")";
    }

    private static final Object processRequest$$anonfun$1(ClusterWatchRequest request$1) {
        return request$1;
    }

    private static final String opString$lzyINIT1$1$$anonfun$1() {
        return "";
    }

    private static final String opString$lzyINIT1$1(LazyRef opString$lzy1$1, ClusterWatchRequest request$3) {
        String string;
        LazyRef lazyRef = opString$lzy1$1;
        synchronized (lazyRef) {
            string = (String)(opString$lzy1$1.initialized() ? opString$lzy1$1.value() : opString$lzy1$1.initialize((Object)("" + request$3.maybeEvent().fold(ClusterWatch::opString$lzyINIT1$1$$anonfun$1, (Function1 & Serializable)o -> o + " --> ") + request$3.clusterState())));
        }
        return string;
    }

    private static final String opString$5(LazyRef opString$lzy1$2, ClusterWatchRequest request$5) {
        return (String)(opString$lzy1$2.initialized() ? opString$lzy1$2.value() : ClusterWatch.opString$lzyINIT1$1(opString$lzy1$2, request$5));
    }

    private static final String $anonfun$1$$anonfun$1() {
        return "";
    }

    private final Either $anonfun$1$$anonfun$3(ClusterEvent.ClusterNodeLostEvent event$2, ClusterWatchRequest request$6) {
        Option<String> option = this.manuallyConfirmed(event$2);
        if (None$.MODULE$.equals(option)) {
            ClusterWatchProblems.ClusterNodeLossNotConfirmedProblem problem = ClusterWatchProblems$ClusterNodeLossNotConfirmedProblem$.MODULE$.apply(request$6.from(), event$2);
            Logger LoggerImpl_this = this.logger;
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("ClusterWatch is untaught, therefore unable to confirm a node loss: {}", (Object)problem);
            }
            return package$.MODULE$.Left().apply((Object)problem);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String confirmer = (String)some.value();
            Logger LoggerImpl_this = this.logger;
            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = request$6.from();
                objectArray[1] = request$6.clusterState();
                ScalaUtils.syntax.RichJavaClass<?> RichJavaClass_this = ScalaUtils$syntax$.MODULE$.RichJavaClass(event$2.getClass());
                objectArray[2] = RichJavaClass_this.cachedSimpleScalaName();
                LoggerImpl_this.underlying().info("{} teaches clusterState={} after {} confirmation", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
            }
            Some some2 = (Some)Predef$.MODULE$.ArrowAssoc((Object)Some$.MODULE$.apply((Object)confirmer));
            return package$.MODULE$.Right().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)some2, (Object)request$6.clusterState()));
        }
        throw new MatchError(option);
    }

    private static final String $anonfun$1$$anonfun$5(LazyRef opString$lzy1$3, ClusterWatchRequest request$16) {
        return ClusterWatch.opString$5(opString$lzy1$3, request$16);
    }

    private static final SyncDeadline $anonfun$3(SyncDeadline.Now now$3) {
        return now$3;
    }

    private static final Object manuallyConfirmNodeLoss$$anonfun$1(NodeId lostNodeId$1) {
        return lostNodeId$1;
    }

    private final Either manuallyConfirmNodeLoss$$anonfun$2(NodeId lostNodeId$2, String confirmer$1) {
        return this.matchRejectedNodeLostEvent(lostNodeId$2).map((Function1)(JProcedure1 & Serializable)lossRejected -> {
            this._nodeToLossRejected.clear();
            this._nodeToLossRejected.update((Object)lostNodeId$2, (Object)lossRejected.copy(lossRejected.copy$default$1(), (Option<String>)Some$.MODULE$.apply((Object)confirmer$1)));
        });
    }

    private static final Problem clusterState$$anonfun$1() {
        return ClusterWatchProblems$UntaughtClusterWatchProblem$.MODULE$;
    }

    private static final String toString$$anonfun$1() {
        return "untaught";
    }

    public static final class Confirmed
    implements Product,
    Serializable {
        private final Option<String> manualConfirmer;

        public static Confirmed apply(Option<String> option) {
            return ClusterWatch$Confirmed$.MODULE$.apply(option);
        }

        public static Confirmed fromProduct(Product product) {
            return ClusterWatch$Confirmed$.MODULE$.fromProduct(product);
        }

        public static Confirmed unapply(Confirmed confirmed) {
            return ClusterWatch$Confirmed$.MODULE$.unapply(confirmed);
        }

        public static Option<String> $lessinit$greater$default$1() {
            return ClusterWatch$Confirmed$.MODULE$.$lessinit$greater$default$1();
        }

        public Confirmed(Option<String> manualConfirmer) {
            this.manualConfirmer = manualConfirmer;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 887884275, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            Confirmed confirmed;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Confirmed)) return false;
            Confirmed confirmed2 = confirmed = (Confirmed)object;
            Option<String> option = this.manualConfirmer();
            Option<String> option2 = confirmed2.manualConfirmer();
            if (option != null) {
                if (!option.equals(option2)) return false;
                return true;
            }
            if (option2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Confirmed;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Confirmed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "manualConfirmer";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<String> manualConfirmer() {
            return this.manualConfirmer;
        }

        public Confirmed copy(Option<String> manualConfirmer) {
            return new Confirmed(manualConfirmer);
        }

        public Option<String> copy$default$1() {
            return this.manualConfirmer();
        }

        public Option<String> _1() {
            return this.manualConfirmer();
        }
    }

    public static class LossRejected
    implements Product,
    Serializable {
        private final ClusterEvent.ClusterNodeLostEvent event;
        private final Option<String> manualConfirmer;

        public static LossRejected apply(ClusterEvent.ClusterNodeLostEvent clusterNodeLostEvent, Option<String> option) {
            return ClusterWatch$LossRejected$.MODULE$.apply(clusterNodeLostEvent, option);
        }

        public static LossRejected fromProduct(Product product) {
            return ClusterWatch$LossRejected$.MODULE$.fromProduct(product);
        }

        public static LossRejected unapply(LossRejected lossRejected) {
            return ClusterWatch$LossRejected$.MODULE$.unapply(lossRejected);
        }

        public static Option<String> $lessinit$greater$default$2() {
            return ClusterWatch$LossRejected$.MODULE$.$lessinit$greater$default$2();
        }

        public LossRejected(ClusterEvent.ClusterNodeLostEvent event, Option<String> manualConfirmer) {
            this.event = event;
            this.manualConfirmer = manualConfirmer;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 733081861, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            LossRejected lossRejected;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LossRejected)) return false;
            LossRejected lossRejected2 = lossRejected = (LossRejected)object;
            ClusterEvent.ClusterNodeLostEvent clusterNodeLostEvent = this.event();
            ClusterEvent.ClusterNodeLostEvent clusterNodeLostEvent2 = lossRejected2.event();
            if (clusterNodeLostEvent == null) {
                if (clusterNodeLostEvent2 != null) {
                    return false;
                }
            } else if (!clusterNodeLostEvent.equals(clusterNodeLostEvent2)) return false;
            Option<String> option = this.manualConfirmer();
            Option<String> option2 = lossRejected2.manualConfirmer();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!lossRejected2.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LossRejected;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "LossRejected";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "event";
            }
            if (1 == n2) {
                return "manualConfirmer";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ClusterEvent.ClusterNodeLostEvent event() {
            return this.event;
        }

        public Option<String> manualConfirmer() {
            return this.manualConfirmer;
        }

        public Option<String> manuallyConfirmed(ClusterEvent.ClusterNodeLostEvent event) {
            return this.manualConfirmer().filter((Function1 & Serializable)_$13 -> {
                ClusterEvent.ClusterNodeLostEvent clusterNodeLostEvent = event;
                ClusterEvent.ClusterNodeLostEvent clusterNodeLostEvent2 = this.event();
                return !(clusterNodeLostEvent != null ? !clusterNodeLostEvent.equals(clusterNodeLostEvent2) : clusterNodeLostEvent2 != null);
            });
        }

        public LossRejected copy(ClusterEvent.ClusterNodeLostEvent event, Option<String> manualConfirmer) {
            return new LossRejected(event, manualConfirmer);
        }

        public ClusterEvent.ClusterNodeLostEvent copy$default$1() {
            return this.event();
        }

        public Option<String> copy$default$2() {
            return this.manualConfirmer();
        }

        public ClusterEvent.ClusterNodeLostEvent _1() {
            return this.event();
        }

        public Option<String> _2() {
            return this.manualConfirmer();
        }
    }

    public static final class State
    implements Product,
    Serializable {
        private final Logger logger;
        private final ClusterState.HasNodes clusterState;
        private final SyncDeadline lastHeartbeat;
        private final boolean requireManualNodeLossConfirmation;

        public static State apply(Logger logger, ClusterState.HasNodes hasNodes, SyncDeadline syncDeadline, boolean bl) {
            return ClusterWatch$State$.MODULE$.apply(logger, hasNodes, syncDeadline, bl);
        }

        public static State fromProduct(Product product) {
            return ClusterWatch$State$.MODULE$.fromProduct(product);
        }

        public static State unapply(State state) {
            return ClusterWatch$State$.MODULE$.unapply(state);
        }

        public State(Logger logger, ClusterState.HasNodes clusterState, SyncDeadline lastHeartbeat, boolean requireManualNodeLossConfirmation) {
            this.logger = logger;
            this.clusterState = clusterState;
            this.lastHeartbeat = lastHeartbeat;
            this.requireManualNodeLossConfirmation = requireManualNodeLossConfirmation;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)80204913);
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.logger()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.clusterState()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.lastHeartbeat()));
            n = Statics.mix((int)n, (int)(this.requireManualNodeLossConfirmation() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            State state;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state2 = state = (State)object;
            if (this.requireManualNodeLossConfirmation() != state2.requireManualNodeLossConfirmation()) return false;
            Logger logger = this.logger();
            Logger logger2 = state2.logger();
            if (logger == null) {
                if (logger2 != null) {
                    return false;
                }
            } else if (!logger.equals(logger2)) return false;
            ClusterState.HasNodes hasNodes = this.clusterState();
            ClusterState.HasNodes hasNodes2 = state2.clusterState();
            if (hasNodes == null) {
                if (hasNodes2 != null) {
                    return false;
                }
            } else if (!hasNodes.equals(hasNodes2)) return false;
            SyncDeadline syncDeadline = this.lastHeartbeat();
            SyncDeadline syncDeadline2 = state2.lastHeartbeat();
            if (syncDeadline == null) {
                if (syncDeadline2 == null) return true;
                return false;
            } else {
                if (!((Object)syncDeadline).equals(syncDeadline2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean((boolean)this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "logger";
                }
                case 1: {
                    return "clusterState";
                }
                case 2: {
                    return "lastHeartbeat";
                }
                case 3: {
                    return "requireManualNodeLossConfirmation";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Logger logger() {
            return this.logger;
        }

        public ClusterState.HasNodes clusterState() {
            return this.clusterState;
        }

        public SyncDeadline lastHeartbeat() {
            return this.lastHeartbeat;
        }

        public boolean requireManualNodeLossConfirmation() {
            return this.requireManualNodeLossConfirmation;
        }

        /*
         * Unable to fully structure code
         */
        public IO<Either<Problem, Tuple2<Option<String>, ClusterState.HasNodes>>> processRequest(ClusterWatchRequest request, Function1<ClusterEvent.ClusterNodeLostEvent, Option<String>> manualConfirmed, Function1<ClusterState.HasNodes, IO<Either<Problem, BoxedUnit>>> checkActiveIsLost, Function0<String> opString, SyncDeadline.Now now) {
            block6: {
                block4: {
                    block5: {
                        maybeEvent = request.maybeEvent();
                        v0 = request.clusterState();
                        var7_7 = this.clusterState();
                        if (!(v0 != null ? v0.equals(var7_7) == false : var7_7 != null)) {
                            if (maybeEvent.nonEmpty() && (LoggerImpl_this = this.logger()).underlying().isDebugEnabled()) {
                                LoggerImpl_this.underlying().debug("{}: Ignore probably duplicate event for already reached clusterState={}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{request.from(), this.clusterState()}), Object.class));
                            }
                            var9_9 = (None$)Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$);
                            return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)var9_9, (Object)request.clusterState()));
                        }
                        var11_10 = maybeEvent;
                        if (!(var11_10 instanceof Some)) break block4;
                        var12_11 = (Some)var11_10;
                        var13_12 = (ClusterEvent)var12_11.value();
                        if (!(var13_12 instanceof ClusterEvent.ClusterSwitchedOver)) break block5;
                        var14_13 = (ClusterEvent.ClusterSwitchedOver)var13_12;
                        v1 = CatsEffectExtensions$.MODULE$.inline$rightUnitIO();
                        break block6;
                    }
                    if (!(var13_12 instanceof ClusterEvent.ClusterFailedOver)) break block4;
                    var15_14 = (ClusterEvent.ClusterFailedOver)var13_12;
                    var16_15 = ClusterEvent$ClusterFailedOver$.MODULE$.unapply(var15_14);
                    var17_16 = var16_15._1();
                    var18_17 = var16_15._2();
                    var19_18 = var16_15._3();
                    failedActiveId = var17_16;
                    var21_20 = this.clusterState();
                    if (!(var21_20 instanceof ClusterState.PassiveLost)) ** GOTO lbl-1000
                    var22_21 = (ClusterState.PassiveLost)var21_20;
                    var23_22 = ClusterState$PassiveLost$.MODULE$.unapply(var22_21);
                    setting = var24_23 = var23_22._1();
                    v2 = setting.activeId();
                    var26_25 = failedActiveId;
                    if (!(v2 != null ? v2.equals(var26_25) == false : var26_25 != null)) {
                        v1 = CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, ClusterWatchProblems$ClusterFailOverWhilePassiveLostProblem$.MODULE$);
                    } else lbl-1000:
                    // 2 sources

                    {
                        clusterState = var21_20;
                        v3 = request.from();
                        var29_27 = clusterState.passiveId();
                        var28_28 = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(IO$.MODULE$.pure(ScalaUtils$syntax$RichBoolean$.MODULE$.orLeft$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(!(v3 != null ? v3.equals(var29_27) == false : var29_27 != null) && this.isLastHeartbeatStillValid(now) == false), (Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, processRequest$$anonfun$3(js7.data.cluster.ClusterWatchRequest js7.base.catsutils.SyncDeadline$Now scala.Function0 ), ()Ljs7/data/cluster/ClusterWatchProblems$ClusterWatchInactiveNodeProblem;)((State)this, (ClusterWatchRequest)request, (SyncDeadline.Now)now, opString))));
                        v1 = (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(var28_28, (Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, js7$cluster$watch$ClusterWatch$State$$_$processRequest$$anonfun$4(scala.Function1 js7.data.cluster.ClusterState$HasNodes scala.runtime.BoxedUnit ), (Lscala/runtime/BoxedUnit;)Lcats/effect/IO;)(checkActiveIsLost, (ClusterState.HasNodes)clusterState), IO$.MODULE$.asyncForIO());
                    }
                    break block6;
                }
                v4 = request.from();
                var31_29 = this.clusterState().activeId();
                RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(!(v4 != null ? v4.equals(var31_29) == false : var31_29 != null));
                v1 = IO$.MODULE$.pure(ScalaUtils$syntax$RichBoolean$.MODULE$.orLeft$extension(RichBoolean_this, (Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, processRequest$$anonfun$5(js7.data.cluster.ClusterWatchRequest js7.base.catsutils.SyncDeadline$Now scala.Function0 ), ()Ljs7/data/cluster/ClusterWatchProblems$ClusterWatchInactiveNodeProblem;)((State)this, (ClusterWatchRequest)request, (SyncDeadline.Now)now, opString)));
            }
            var10_31 = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(v1);
            return ((IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(var10_31, (Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, processRequest$$anonfun$6(scala.Option js7.data.cluster.ClusterWatchRequest scala.Function1 js7.base.catsutils.SyncDeadline$Now scala.runtime.BoxedUnit ), (Lscala/runtime/BoxedUnit;)Lcats/effect/IO;)((State)this, maybeEvent, (ClusterWatchRequest)request, manualConfirmed, (SyncDeadline.Now)now), IO$.MODULE$.asyncForIO())).flatTap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, processRequest$$anonfun$7(js7.data.cluster.ClusterWatchRequest scala.util.Either ), (Lscala/util/Either;)Lcats/effect/IO;)((State)this, (ClusterWatchRequest)request));
        }

        private boolean isLastHeartbeatStillValid(SyncDeadline.Now x$1) {
            return this.lastHeartbeat().$plus(this.clusterState().timing().clusterWatchHeartbeatValidDuration()).hasTimeLeft(x$1);
        }

        public State copy(Logger logger, ClusterState.HasNodes clusterState, SyncDeadline lastHeartbeat, boolean requireManualNodeLossConfirmation) {
            return new State(logger, clusterState, lastHeartbeat, requireManualNodeLossConfirmation);
        }

        public Logger copy$default$1() {
            return this.logger();
        }

        public ClusterState.HasNodes copy$default$2() {
            return this.clusterState();
        }

        public SyncDeadline copy$default$3() {
            return this.lastHeartbeat();
        }

        public boolean copy$default$4() {
            return this.requireManualNodeLossConfirmation();
        }

        public Logger _1() {
            return this.logger();
        }

        public ClusterState.HasNodes _2() {
            return this.clusterState();
        }

        public SyncDeadline _3() {
            return this.lastHeartbeat();
        }

        public boolean _4() {
            return this.requireManualNodeLossConfirmation();
        }

        private final ClusterWatchProblems.ClusterWatchInactiveNodeProblem clusterWatchInactiveNodeProblem$1(ClusterWatchRequest request$11, SyncDeadline.Now now$4, Function0 opString$1) {
            return ClusterWatchProblems$ClusterWatchInactiveNodeProblem$.MODULE$.apply(request$11.from(), this.clusterState(), this.lastHeartbeat().elapsed(now$4), (String)opString$1.apply());
        }

        private final ClusterWatchProblems.ClusterWatchInactiveNodeProblem processRequest$$anonfun$3(ClusterWatchRequest request$17, SyncDeadline.Now now$6, Function0 opString$2) {
            return this.clusterWatchInactiveNodeProblem$1(request$17, now$6, opString$2);
        }

        private final ClusterWatchProblems.ClusterWatchInactiveNodeProblem left$proxy1$1(ClusterWatchRequest request$18, SyncDeadline.Now now$7, Function0 opString$3) {
            return this.clusterWatchInactiveNodeProblem$1(request$18, now$7, opString$3);
        }

        private final ClusterWatchProblems.ClusterWatchInactiveNodeProblem processRequest$$anonfun$5(ClusterWatchRequest request$19, SyncDeadline.Now now$8, Function0 opString$4) {
            return this.left$proxy1$1(request$19, now$8, opString$4);
        }

        private final /* synthetic */ IO processRequest$$anonfun$6(Option maybeEvent$1, ClusterWatchRequest request$12, Function1 manualConfirmed$1, SyncDeadline.Now now$5, BoxedUnit _$15) {
            Either either = this.clusterState().applyEvents(maybeEvent$1);
            if (either instanceof Left) {
                Left left = (Left)either;
                Problem problem = (Problem)left.value();
                Logger LoggerImpl_this = this.logger();
                if (LoggerImpl_this.underlying().isWarnEnabled()) {
                    LoggerImpl_this.underlying().warn("{}: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{request$12.from(), problem}), Object.class));
                }
                return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, ClusterWatchProblems$ClusterWatchEventMismatchProblem$.MODULE$.apply((Option<ClusterEvent>)maybeEvent$1, this.clusterState(), request$12.clusterState()));
            }
            if (either instanceof Right) {
                Some some;
                ClusterEvent clusterEvent;
                None$ none$;
                Some some2;
                ClusterEvent clusterEvent2;
                Right right = (Right)either;
                ClusterState updatedClusterState = (ClusterState)right.value();
                maybeEvent$1.foreach((Function1)(JProcedure1 & Serializable)event -> {
                    Logger LoggerImpl_this = this.logger();
                    if (LoggerImpl_this.underlying().isInfoEnabled()) {
                        LoggerImpl_this.underlying().info("{} {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{request$12.from(), event}), Object.class));
                        return;
                    }
                });
                Option option = maybeEvent$1;
                if (option instanceof Some && (clusterEvent2 = (ClusterEvent)(some2 = (Some)option).value()) instanceof ClusterEvent.ClusterNodeLostEvent) {
                    ClusterEvent.ClusterNodeLostEvent clusterNodeLostEvent;
                    ClusterEvent.ClusterNodeLostEvent event2 = clusterNodeLostEvent = (ClusterEvent.ClusterNodeLostEvent)clusterEvent2;
                    none$ = (Option)manualConfirmed$1.apply((Object)event2);
                } else {
                    none$ = None$.MODULE$;
                }
                None$ confirmer = none$;
                Option option2 = maybeEvent$1;
                if (option2 instanceof Some && (clusterEvent = (ClusterEvent)(some = (Some)option2).value()) instanceof ClusterEvent.ClusterNodeLostEvent) {
                    ClusterEvent.ClusterNodeLostEvent clusterNodeLostEvent;
                    ClusterEvent.ClusterNodeLostEvent event3 = clusterNodeLostEvent = (ClusterEvent.ClusterNodeLostEvent)clusterEvent;
                    if (this.requireManualNodeLossConfirmation() && !confirmer.isDefined()) {
                        return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, ClusterWatchProblems$ClusterNodeLossNotConfirmedProblem$.MODULE$.apply(request$12.from(), event3));
                    }
                }
                ClusterState clusterState = updatedClusterState;
                ClusterState.HasNodes hasNodes = request$12.clusterState();
                if (!(clusterState != null ? !clusterState.equals(hasNodes) : hasNodes != null)) {
                    Logger LoggerImpl_this = this.logger();
                    if (LoggerImpl_this.underlying().isInfoEnabled()) {
                        LoggerImpl_this.underlying().info("{} changes ClusterState to {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{request$12.from(), request$12.clusterState()}), Object.class));
                    }
                    Option option3 = (Option)Predef$.MODULE$.ArrowAssoc((Object)confirmer);
                    return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)option3, (Object)request$12.clusterState()));
                }
                String previouslyActive = this.clusterState().activeId().string();
                Logger LoggerImpl_this = this.logger();
                if (LoggerImpl_this.underlying().isWarnEnabled()) {
                    LoggerImpl_this.underlying().warn(request$12.from() + " forced ClusterState to " + request$12.clusterState() + " " + ("maybe because heartbeat of up to now active " + previouslyActive + " ") + ("is too long ago (" + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(this.lastHeartbeat().elapsed(now$5))) + ")"));
                }
                Option option4 = (Option)Predef$.MODULE$.ArrowAssoc((Object)confirmer);
                return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)option4, (Object)request$12.clusterState()));
            }
            throw new MatchError(either);
        }

        private final void processRequest$$anonfun$7$$anonfun$1(ClusterWatchRequest request$15, Problem problem$3) {
            Logger LoggerImpl_this = this.logger();
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("{}: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{request$15.from(), problem$3}), Object.class));
                return;
            }
        }

        private final /* synthetic */ IO processRequest$$anonfun$7(ClusterWatchRequest request$14, Either x$1) {
            Either either = x$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                Problem problem = (Problem)left.value();
                return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                    this.processRequest$$anonfun$7$$anonfun$1(request$14, problem);
                    return BoxedUnit.UNIT;
                });
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                return IO$.MODULE$.unit();
            }
            throw new MatchError((Object)either);
        }
    }
}

